/* webkit-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "WebKit", lower_case_cprefix = "webkit_")]
namespace WebKit {
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class NetworkRequest : GLib.Object {
		public unowned string get_uri ();
		[CCode (has_construct_function = false)]
		public NetworkRequest (string uri);
		public void set_uri (string uri);
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebBackForwardList : GLib.Object {
		public bool contains_item (WebKit.WebHistoryItem history_item);
		public unowned WebKit.WebHistoryItem get_back_item ();
		public int get_back_length ();
		public unowned GLib.List get_back_list_with_limit (int limit);
		public unowned WebKit.WebHistoryItem get_current_item ();
		public unowned WebKit.WebHistoryItem get_forward_item ();
		public int get_forward_length ();
		public unowned GLib.List get_forward_list_with_limit (int limit);
		public int get_limit ();
		public unowned WebKit.WebHistoryItem get_nth_item (int index);
		public void go_back ();
		public void go_forward ();
		public void go_to_item (WebKit.WebHistoryItem history_item);
		public void set_limit (int limit);
		[CCode (has_construct_function = false)]
		public WebBackForwardList.with_web_view (WebKit.WebView web_view);
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebPolicyDecision : GLib.Object {
		public void use ();
		public void ignore ();
		public void download ();
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebNavigationAction : GLib.Object {
		public int get_button ();
		public int get_modifier_state ();
		public string get_original_uri ();
		public WebKit.WebNavigationReason get_reason ();
		public void set_original_uri (string uri);
		public void set_reason (WebKit.WebNavigationReason reason);
		public string original_uri { get; set; }
		public WebKit.WebNavigationReason reason { get; set; }
		public int button { get; set; }
		public int modifier_state { get; set; }
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebFrame : GLib.Object {
		public unowned WebKit.WebFrame find_frame (string name);
		public unowned WebKit.Document get_dom_document ();
		public unowned WebKit.DOMWindow get_dom_window ();
		public unowned string get_name ();
		public unowned WebKit.WebFrame get_parent ();
		public unowned string get_title ();
		public unowned string get_uri ();
		public unowned WebKit.WebView get_web_view ();
		public unowned WebKit.XMLHttpRequest get_xml_http_request ();
		public void load_request (WebKit.NetworkRequest request);
		public void load_string (string content, string mime_type, string encoding, string base_uri);
		public void load_uri (string uri);
		[CCode (has_construct_function = false)]
		public WebFrame (WebKit.WebView web_view);
		public void reload ();
		public void stop_loading ();
		public string name { get; }
		public string title { get; }
		public string uri { get; }
		public virtual signal void cleared ();
		public virtual signal void hovering_over_link (string p0, string p1);
		public virtual signal void load_committed ();
		public virtual signal void load_done (bool p0);
		public virtual signal void title_changed (string p0);
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebDownload : GLib.Object {
		public void cancel ();
		public uint get_current_size ();
		public unowned string get_local_uri ();
		public unowned WebKit.NetworkRequest get_network_request ();
		public unowned string get_suggested_filename ();
		public WebKit.WebDownloadState get_state ();
		public uint get_total_size ();
		public unowned string get_uri ();
		[CCode (has_construct_function = false)]
		public WebDownload (string uri);
		[CCode (has_construct_function = false)]
		public WebDownload from_request (WebKit.NetworkRequest request);
		public void set_local_uri (string uri);
		public void set_suggested_filename (string filename);
		public void start ();
		public uint current_size { get; }
		public string local_uri { get; set; }
		public WebKit.NetworkRequest network_request { get; set; }
		public string suggested_filename { get; set; }
		public uint total_size { get; }
		public virtual signal void finished ();
		public virtual signal void started ();
		public virtual signal void progress_update (uint current_bytes, uint total_bytes);
		public virtual signal void error (int p1, WebKit.WebDownloadError error, string errormsg);
	}	
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebInspector : GLib.Object {
		public unowned string get_inspected_uri ();
		public unowned WebKit.WebView get_web_view ();
		[CCode (has_construct_function = false)]
		public WebInspector ();
		public WebKit.WebView web_view { get; }
		public string inspected_uri { get; }
		public virtual signal bool attach_window ();
		public virtual signal bool close_window ();
		public virtual signal bool detach_window ();
		public virtual signal void finished ();
		public virtual signal WebKit.WebView inspect_web_view (WebKit.WebView web_view);
		public virtual signal bool show_window ();
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebHistoryItem : GLib.Object {
		public unowned string get_alternate_title ();
		public double get_last_visited_time ();
		public unowned string get_original_uri ();
		public unowned string get_title ();
		public unowned string get_uri ();
		[CCode (has_construct_function = false)]
		public WebHistoryItem ();
		public void set_alternate_title (string title);
		[CCode (has_construct_function = false)]
		public WebHistoryItem.with_data (string uri, string title);
	}
	[CCode (cheader_filename = "webkit/webkit.h")]
	public class WebSettings : GLib.Object {
		public unowned WebKit.WebSettings copy ();
		[CCode (has_construct_function = false)]
		public WebSettings ();
		[NoAccessorMethod]
		public bool auto_load_images { get; set construct; }
		[NoAccessorMethod]
		public bool auto_shrink_images { get; set construct; }
		[NoAccessorMethod]
		public string cursive_font_family { owned get; set construct; }
		[NoAccessorMethod]
		public string default_encoding { owned get; set construct; }
		[NoAccessorMethod]
		public string default_font_family { owned get; set construct; }
		[NoAccessorMethod]
		public int default_font_size { get; set construct; }
		[NoAccessorMethod]
		public int default_monospace_font_size { get; set construct; }
		[NoAccessorMethod]
		public bool enable_plugins { get; set construct; }
		[NoAccessorMethod]
		public bool enable_scripts { get; set construct; }
		[NoAccessorMethod]
		public string fantasy_font_family { owned get; set construct; }
		[NoAccessorMethod]
		public int minimum_font_size { get; set construct; }
		[NoAccessorMethod]
		public int minimum_logical_font_size { get; set construct; }
		[NoAccessorMethod]
		public string monospace_font_family { owned get; set construct; }
		[NoAccessorMethod]
		public bool print_backgrounds { get; set construct; }
		[NoAccessorMethod]
		public bool resizable_text_areas { get; set construct; }
		[NoAccessorMethod]
		public string sans_serif_font_family { owned get; set construct; }
		[NoAccessorMethod]
		public string serif_font_family { owned get; set construct; }
		[NoAccessorMethod]
		public string user_stylesheet_uri { owned get; set construct; }
		[NoAccessorMethod]
		public string user_agent { owned get; set construct; }
		[NoAccessorMethod]
		public float zoom_step { owned get; set construct; }
		[NoAccessorMethod]
		public bool enable_developer_extras { owned get; set construct; }
	}
	[CCode (cheader_filename = "webkit/webkit.h", free_function = "webkit_web_view_dispose")]
	public class WebView : Gtk.Container, Atk.Implementor, Gtk.Buildable {
		public bool can_copy_clipboard ();
		public bool can_cut_clipboard ();
		public bool can_go_back ();
		public bool can_go_back_or_forward (int steps);
		public bool can_go_backward ();
		public bool can_go_forward ();
		public bool can_paste_clipboard ();
		[NoWrapper]
		public virtual unowned string choose_file (WebKit.WebFrame frame, string old_file);
		[NoWrapper]
		public void delete_selection ();
		public void execute_script (string script);
		public unowned WebKit.WebBackForwardList get_back_forward_list ();
		public unowned Gtk.TargetList get_copy_target_list ();
		public bool get_editable ();
		public unowned WebKit.WebFrame get_focused_frame ();
		public bool get_full_content_zoom ();
		public unowned WebKit.WebInspector get_inspector ();
		public unowned WebKit.WebFrame get_main_frame ();
		public unowned Gtk.TargetList get_paste_target_list ();
		public unowned WebKit.WebSettings get_settings ();
		public bool get_transparent ();
		public float get_zoom_level ();
		public void go_back ();
		public void go_back_or_forward (int steps);
		public void go_backward ();
		public void go_forward ();
		public bool go_to_back_forward_item (WebKit.WebHistoryItem item);
		public bool has_selection ();
		public void inspect ();
		public void load_html_string (string content, string base_uri);
		public void load_string (string content, string content_mime_type, string content_encoding, string base_uri);
		public uint mark_text_matches (string str, bool case_sensitive, uint limit);
		public void menu_popup ();
		[CCode (type = "GtkWidget*", has_construct_function = false)]
		public WebView ();
		public void open (string uri);
		public void reload ();
		public void reload_bypass_cache ();
		public bool search_text (string str, bool case_sensitive, bool forward, bool wrap);
		public void set_editable (bool flag);
		public void set_full_content_zoom (bool full_content_zoom);
		public void set_highlight_text_matches (bool highlight);
		public void set_maintains_back_forward_list (bool flag);
		public void set_settings (WebKit.WebSettings settings);
		public void set_transparent (bool flag);
		public void set_zoom_level (float zoom_level);
		public void stop_loading ();
		public void unmark_text_matches ();
		public void zoom_in ();
		public void zoom_out ();
		public Gtk.TargetList copy_target_list { get; }
		public bool editable { get; set; }
		public Gtk.TargetList paste_target_list { get; }
		public WebKit.WebInspector web_inspector { get; set; }
		public WebKit.WebSettings settings { get; set; }
		public bool transparent { get; set; }
		public float zoom_level { get; set; }
		public virtual signal bool console_message (string message, int line_number, string source_id);
		[HasEmitter]
		public virtual signal void copy_clipboard ();
		public virtual signal WebKit.WebView create_web_view (WebKit.WebFrame web_frame);
		[HasEmitter]
		public virtual signal void cut_clipboard ();
		[HasEmitter]
		public virtual signal bool download_created (WebKit.WebDownload download);
		public virtual signal void hovering_over_link (string? p0, string p1);
		public virtual signal void icon_loaded ();
		public virtual signal void load_committed (WebKit.WebFrame p0);
		public virtual signal void load_finished (WebKit.WebFrame p0);
		public virtual signal void load_progress_changed (int p0);
		public virtual signal void load_started (WebKit.WebFrame p0);
		public virtual signal int navigation_requested (WebKit.WebFrame frame, WebKit.NetworkRequest request);
		public virtual signal bool navigation_policy_decision_requested (WebKit.WebFrame frame, WebKit.NetworkRequest request, WebKit.WebNavigationAction action, WebKit.WebPolicyDecision decision);
		public virtual signal bool mime_type_policy_decision_requested (WebKit.WebFrame frame, WebKit.NetworkRequest request, string mime_type, WebKit.WebPolicyDecision decision);
		public virtual signal bool resource_policy_decision_requested (WebKit.WebFrame frame, string url, WebKit.NetworkRequest request);
		[HasEmitter]
		public virtual signal void paste_clipboard ();
		public virtual signal bool populate_popup (Gtk.Menu p0, string link, string text, string imageurl);
		public virtual signal bool script_alert (GLib.Object frame, string alert_message);
		public virtual signal bool script_confirm (GLib.Object frame, string confirm_message, bool did_confirm);
		public virtual signal bool script_prompt (GLib.Object frame, string message, string default_value, void* value);
		[HasEmitter]
		public virtual signal void select_all ();
		public virtual signal void selection_changed ();
		public virtual signal void set_scroll_adjustments (Gtk.Adjustment p0, Gtk.Adjustment p1);
		public virtual signal void status_bar_text_changed (string p0);
		public virtual signal void title_changed (WebKit.WebFrame p0, string p1);
		public virtual signal bool web_view_ready ();
		public virtual signal void window_object_cleared (WebKit.WebFrame frame, void* context, void* window_object);
	}
	[CCode (cprefix = "WEBKIT_WEB_NAVIGATION_REASON_", has_type_id = "0", cheader_filename = "webkit/webkit.h")]
	public enum WebNavigationReason {
    	LINK_CLICKED,
    	FORM_SUBMITTED,
    	BACK_FORWARD,
    	RELOAD,
    	FORM_RESUBMITTED,
    	OTHER,
	}
	[CCode (cprefix = "WEBKIT_NAVIGATION_RESPONSE_", has_type_id = "0", cheader_filename = "webkit/webkit.h")]
	public enum NavigationResponse {
		ACCEPT,
		IGNORE,
		DOWNLOAD
	}
	[CCode (cprefix = "WEBKIT_WEB_DOWNLOAD_STATE_", has_type_id = "0", cheader_filename = "webkit/webkit.h")]
	public enum WebDownloadState {
		ERROR,
		CREATED,
		STARTED,
		CANCELLED,
		FINISHED
	}
	[CCode (cprefix = "WEBKIT_WEB_DOWNLOAD_ERROR_", has_type_id = "0", cheader_filename = "webkit/webkit.h")]
	public enum WebDownloadError {
		CANCELLED_BY_USER,
		NETWORK
	}
	[CCode (cprefix = "WEBKIT_WEB_VIEW_TARGET_INFO_", has_type_id = "0", cheader_filename = "webkit/webkit.h")]
	public enum WebViewTargetInfo {
		HTML,
		TEXT
	}
	
	
	
	
	
	
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Attr {
		public weak WebKit.Node parent_instance;
		[CCode (cname = "webkit_attr_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_attr_get_owner_element")]
		public unowned WebKit.Element get_owner_element ();
		[CCode (cname = "webkit_attr_get_specified")]
		public bool get_specified ();
		[CCode (cname = "webkit_attr_get_style")]
		public unowned WebKit.CSSStyleDeclaration get_style ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class AttrClass {
		public weak WebKit.NodeClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class BarInfo {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_bar_info_get_visible")]
		public bool get_visible ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class BarInfoClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CDATASection {
		public weak WebKit.Text parent_instance;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CDATASectionClass {
		public weak WebKit.TextClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSCharsetRule {
		public weak WebKit.CSSRule parent_instance;
		[CCode (cname = "webkit_css_charset_rule_get_encoding")]
		public unowned string get_encoding ();
		[CCode (cname = "webkit_css_charset_rule_set_encoding")]
		public void set_encoding (string value) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSCharsetRuleClass {
		public weak WebKit.CSSRuleClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSFontFaceRule {
		public weak WebKit.CSSRule parent_instance;
		[CCode (cname = "webkit_css_font_face_rule_get_style")]
		public unowned WebKit.CSSStyleDeclaration get_style ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSFontFaceRuleClass {
		public weak WebKit.CSSRuleClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSImportRule {
		public weak WebKit.CSSRule parent_instance;
		[CCode (cname = "webkit_css_import_rule_get_href")]
		public unowned string get_href ();
		[CCode (cname = "webkit_css_import_rule_get_style_sheet")]
		public unowned WebKit.CSSStyleSheet get_style_sheet ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSImportRuleClass {
		public weak WebKit.CSSRuleClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSMediaRule {
		public weak WebKit.CSSRule parent_instance;
		[CCode (cname = "webkit_css_media_rule_delete_rule")]
		public void delete_rule (ulong index) throws GLib.Error;
		[CCode (cname = "webkit_css_media_rule_get_css_rules")]
		public unowned WebKit.CSSRuleList get_css_rules ();
		[CCode (cname = "webkit_css_media_rule_insert_rule")]
		public ulong insert_rule (string rule2, ulong index) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSMediaRuleClass {
		public weak WebKit.CSSRuleClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSPageRule {
		public weak WebKit.CSSRule parent_instance;
		[CCode (cname = "webkit_css_page_rule_get_selector_text")]
		public unowned string get_selector_text ();
		[CCode (cname = "webkit_css_page_rule_get_style")]
		public unowned WebKit.CSSStyleDeclaration get_style ();
		[CCode (cname = "webkit_css_page_rule_set_selector_text")]
		public void set_selector_text (string value) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSPageRuleClass {
		public weak WebKit.CSSRuleClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSPrimitiveValue {
		public weak WebKit.CSSValue parent_instance;
		[CCode (cname = "webkit_css_primitive_value_get_counter_value")]
		public unowned WebKit.Counter get_counter_value () throws GLib.Error;
		[CCode (cname = "webkit_css_primitive_value_get_float_value")]
		public float get_float_value (ushort unit_type) throws GLib.Error;
		[CCode (cname = "webkit_css_primitive_value_get_primitive_type")]
		public ushort get_primitive_type ();
		[CCode (cname = "webkit_css_primitive_value_get_rect_value")]
		public unowned WebKit.Rect get_rect_value () throws GLib.Error;
		[CCode (cname = "webkit_css_primitive_value_get_rgb_color_value")]
		public ulong get_rgb_color_value () throws GLib.Error;
		[CCode (cname = "webkit_css_primitive_value_get_string_value")]
		public unowned string get_string_value () throws GLib.Error;
		[CCode (cname = "webkit_css_primitive_value_set_float_value")]
		public void set_float_value (ushort unit_type, float float_value) throws GLib.Error;
		[CCode (cname = "webkit_css_primitive_value_set_string_value")]
		public void set_string_value (ushort string_type, string string_value) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSPrimitiveValueClass {
		public weak WebKit.CSSValueClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSRule {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_css_rule_get_css_text")]
		public unowned string get_css_text ();
		[CCode (cname = "webkit_css_rule_get_parent_rule")]
		public unowned WebKit.CSSRule get_parent_rule ();
		[CCode (cname = "webkit_css_rule_get_parent_style_sheet")]
		public unowned WebKit.CSSStyleSheet get_parent_style_sheet ();
		[CCode (cname = "webkit_css_rule_set_css_text")]
		public void set_css_text (string value) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSRuleClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSRuleList {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_css_rule_list_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_css_rule_list_item")]
		public unowned WebKit.CSSRule item (ulong index);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSRuleListClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSStyleDeclaration {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_css_style_declaration_get_css_text")]
		public unowned string get_css_text ();
		[CCode (cname = "webkit_css_style_declaration_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_css_style_declaration_get_parent_rule")]
		public unowned WebKit.CSSRule get_parent_rule ();
		[CCode (cname = "webkit_css_style_declaration_get_property_css_value")]
		public unowned WebKit.CSSValue get_property_css_value (string property_name);
		[CCode (cname = "webkit_css_style_declaration_get_property_priority")]
		public unowned string get_property_priority (string property_name);
		[CCode (cname = "webkit_css_style_declaration_get_property_shorthand")]
		public unowned string get_property_shorthand (string property_name);
		[CCode (cname = "webkit_css_style_declaration_get_property_value")]
		public unowned string get_property_value (string property_name);
		[CCode (cname = "webkit_css_style_declaration_is_property_implicit")]
		public bool is_property_implicit (string property_name);
		[CCode (cname = "webkit_css_style_declaration_item")]
		public unowned string item (ulong index);
		[CCode (cname = "webkit_css_style_declaration_remove_property")]
		public unowned string remove_property (string property_name) throws GLib.Error;
		[CCode (cname = "webkit_css_style_declaration_set_css_property")]
		public void set_css_property (string property_name, string value, string priority) throws GLib.Error;
		[CCode (cname = "webkit_css_style_declaration_set_css_text")]
		public void set_css_text (string value) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSStyleDeclarationClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSStyleRule {
		public weak WebKit.CSSRule parent_instance;
		[CCode (cname = "webkit_css_style_rule_get_selector_text")]
		public unowned string get_selector_text ();
		[CCode (cname = "webkit_css_style_rule_get_style")]
		public unowned WebKit.CSSStyleDeclaration get_style ();
		[CCode (cname = "webkit_css_style_rule_set_selector_text")]
		public void set_selector_text (string value) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSStyleRuleClass {
		public weak WebKit.CSSRuleClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSStyleSheet {
		public weak WebKit.StyleSheet parent_instance;
		[CCode (cname = "webkit_css_style_sheet_add_rule")]
		public long add_rule (string selector, string style, ulong index) throws GLib.Error;
		[CCode (cname = "webkit_css_style_sheet_delete_rule")]
		public void delete_rule (ulong index) throws GLib.Error;
		[CCode (cname = "webkit_css_style_sheet_get_css_rules")]
		public unowned WebKit.CSSRuleList get_css_rules ();
		[CCode (cname = "webkit_css_style_sheet_get_owner_rule")]
		public unowned WebKit.CSSRule get_owner_rule ();
		[CCode (cname = "webkit_css_style_sheet_get_rules")]
		public unowned WebKit.CSSRuleList get_rules ();
		[CCode (cname = "webkit_css_style_sheet_insert_rule")]
		public ulong insert_rule (string rule, ulong index) throws GLib.Error;
		[CCode (cname = "webkit_css_style_sheet_remove_rule")]
		public void remove_rule (ulong index) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSStyleSheetClass {
		public weak WebKit.StyleSheetClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSValue {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_css_value_get_css_text")]
		public unowned string get_css_text ();
		[CCode (cname = "webkit_css_value_get_css_value_type")]
		public ushort get_css_value_type ();
		[CCode (cname = "webkit_css_value_set_css_text")]
		public void set_css_text (string value2) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSValueClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSValueList {
		public weak WebKit.CSSValue parent_instance;
		[CCode (cname = "webkit_css_value_list_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_css_value_list_item")]
		public unowned WebKit.CSSValue item (ulong index);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSValueListClass {
		public weak WebKit.CSSValueClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSVariablesDeclaration {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_css_variables_declaration_get_css_text")]
		public unowned string get_css_text ();
		[CCode (cname = "webkit_css_variables_declaration_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_css_variables_declaration_get_parent_rule")]
		public unowned WebKit.CSSRule get_parent_rule ();
		[CCode (cname = "webkit_css_variables_declaration_get_variable_value")]
		public unowned string get_variable_value (string variable_name);
		[CCode (cname = "webkit_css_variables_declaration_item")]
		public unowned string item (ulong index);
		[CCode (cname = "webkit_css_variables_declaration_remove_variable")]
		public unowned string remove_variable (string variable_name) throws GLib.Error;
		[CCode (cname = "webkit_css_variables_declaration_set_css_text")]
		public void set_css_text (string value);
		[CCode (cname = "webkit_css_variables_declaration_set_variable")]
		public void set_variable (string variable_name, string value) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSVariablesDeclarationClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSVariablesRule {
		public weak WebKit.CSSRule parent_instance;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CSSVariablesRuleClass {
		public weak WebKit.CSSRuleClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CanvasGradient {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_canvas_gradient_add_color_stop")]
		public void add_color_stop (float offset, string color) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CanvasGradientClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CanvasPattern {
		public weak WebKit.DOMObject parent_instance;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CanvasPatternClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CanvasPixelArray {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_canvas_pixel_array_get_length")]
		public long get_length ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CanvasPixelArrayClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CanvasRenderingContext2D {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_canvas_rendering_context2d_arc")]
		public void arc (float x, float y, float radius, float start_angle, float end_angle, bool anticlockwise) throws GLib.Error;
		[CCode (cname = "webkit_canvas_rendering_context2d_arc_to")]
		public void arc_to (float x1, float y1, float x2, float y2, float radius) throws GLib.Error;
		[CCode (cname = "webkit_canvas_rendering_context2d_begin_path")]
		public void begin_path ();
		[CCode (cname = "webkit_canvas_rendering_context2d_bezier_curve_to")]
		public void bezier_curve_to (float cp1x, float cp1y, float cp2x, float cp2y, float x, float y);
		[CCode (cname = "webkit_canvas_rendering_context2d_clear_rect")]
		public void clear_rect (float x, float y, float width, float height);
		[CCode (cname = "webkit_canvas_rendering_context2d_clear_shadow")]
		public void clear_shadow ();
		[CCode (cname = "webkit_canvas_rendering_context2d_clip")]
		public void clip ();
		[CCode (cname = "webkit_canvas_rendering_context2d_close_path")]
		public void close_path ();
		[CCode (cname = "webkit_canvas_rendering_context2d_create_image_data")]
		public unowned WebKit.ImageData create_image_data (float sw, float sh);
		[CCode (cname = "webkit_canvas_rendering_context2d_create_linear_gradient")]
		public unowned WebKit.CanvasGradient create_linear_gradient (float x0, float y0, float x1, float y1) throws GLib.Error;
		[CCode (cname = "webkit_canvas_rendering_context2d_create_radial_gradient")]
		public unowned WebKit.CanvasGradient create_radial_gradient (float x0, float y0, float r0, float x1, float y1, float r1) throws GLib.Error;
		[CCode (cname = "webkit_canvas_rendering_context2d_fill")]
		public void fill ();
		[CCode (cname = "webkit_canvas_rendering_context2d_fill_rect")]
		public void fill_rect (float x, float y, float width, float height);
		[CCode (cname = "webkit_canvas_rendering_context2d_get_canvas")]
		public unowned WebKit.HTMLCanvasElement get_canvas ();
		[CCode (cname = "webkit_canvas_rendering_context2d_get_font")]
		public unowned string get_font ();
		[CCode (cname = "webkit_canvas_rendering_context2d_get_global_alpha")]
		public float get_global_alpha ();
		[CCode (cname = "webkit_canvas_rendering_context2d_get_global_composite_operation")]
		public unowned string get_global_composite_operation ();
		[CCode (cname = "webkit_canvas_rendering_context2d_get_image_data")]
		public unowned WebKit.ImageData get_image_data (float sx, float sy, float sw, float sh) throws GLib.Error;
		[CCode (cname = "webkit_canvas_rendering_context2d_get_shadow_blur")]
		public float get_shadow_blur ();
		[CCode (cname = "webkit_canvas_rendering_context2d_get_shadow_color")]
		public unowned string get_shadow_color ();
		[CCode (cname = "webkit_canvas_rendering_context2d_get_shadow_offset_x")]
		public float get_shadow_offset_x ();
		[CCode (cname = "webkit_canvas_rendering_context2d_get_shadow_offset_y")]
		public float get_shadow_offset_y ();
		[CCode (cname = "webkit_canvas_rendering_context2d_get_text_align")]
		public unowned string get_text_align ();
		[CCode (cname = "webkit_canvas_rendering_context2d_get_text_baseline")]
		public unowned string get_text_baseline ();
		[CCode (cname = "webkit_canvas_rendering_context2d_is_point_in_path")]
		public bool is_point_in_path (float x, float y);
		[CCode (cname = "webkit_canvas_rendering_context2d_line_to")]
		public void line_to (float x, float y);
		[CCode (cname = "webkit_canvas_rendering_context2d_measure_text")]
		public unowned WebKit.TextMetrics measure_text (string text);
		[CCode (cname = "webkit_canvas_rendering_context2d_move_to")]
		public void move_to (float x, float y);
		[CCode (cname = "webkit_canvas_rendering_context2d_quadratic_curve_to")]
		public void quadratic_curve_to (float cpx, float cpy, float x, float y);
		[CCode (cname = "webkit_canvas_rendering_context2d_rect")]
		public void rect (float x, float y, float width, float height);
		[CCode (cname = "webkit_canvas_rendering_context2d_restore")]
		public void restore ();
		[CCode (cname = "webkit_canvas_rendering_context2d_rotate")]
		public void rotate (float angle);
		[CCode (cname = "webkit_canvas_rendering_context2d_save")]
		public void save ();
		[CCode (cname = "webkit_canvas_rendering_context2d_scale")]
		public void scale (float sx, float sy);
		[CCode (cname = "webkit_canvas_rendering_context2d_set_alpha")]
		public void set_alpha (float alpha);
		[CCode (cname = "webkit_canvas_rendering_context2d_set_composite_operation")]
		public void set_composite_operation (string composite_operation);
		[CCode (cname = "webkit_canvas_rendering_context2d_set_font")]
		public void set_font (string value);
		[CCode (cname = "webkit_canvas_rendering_context2d_set_global_alpha")]
		public void set_global_alpha (float value);
		[CCode (cname = "webkit_canvas_rendering_context2d_set_global_composite_operation")]
		public void set_global_composite_operation (string value);
		[CCode (cname = "webkit_canvas_rendering_context2d_set_line_cap")]
		public void set_line_cap (string cap);
		[CCode (cname = "webkit_canvas_rendering_context2d_set_line_join")]
		public void set_line_join (string join);
		[CCode (cname = "webkit_canvas_rendering_context2d_set_line_width")]
		public void set_line_width (float width);
		[CCode (cname = "webkit_canvas_rendering_context2d_set_miter_limit")]
		public void set_miter_limit (float limit);
		[CCode (cname = "webkit_canvas_rendering_context2d_set_shadow_blur")]
		public void set_shadow_blur (float value);
		[CCode (cname = "webkit_canvas_rendering_context2d_set_shadow_color")]
		public void set_shadow_color (string value);
		[CCode (cname = "webkit_canvas_rendering_context2d_set_shadow_offset_x")]
		public void set_shadow_offset_x (float value);
		[CCode (cname = "webkit_canvas_rendering_context2d_set_shadow_offset_y")]
		public void set_shadow_offset_y (float value);
		[CCode (cname = "webkit_canvas_rendering_context2d_set_text_align")]
		public void set_text_align (string value);
		[CCode (cname = "webkit_canvas_rendering_context2d_set_text_baseline")]
		public void set_text_baseline (string value);
		[CCode (cname = "webkit_canvas_rendering_context2d_set_transform")]
		public void set_transform (float m11, float m12, float m21, float m22, float dx, float dy);
		[CCode (cname = "webkit_canvas_rendering_context2d_stroke")]
		public void stroke ();
		[CCode (cname = "webkit_canvas_rendering_context2d_transform")]
		public void transform (float m11, float m12, float m21, float m22, float dx, float dy);
		[CCode (cname = "webkit_canvas_rendering_context2d_translate")]
		public void translate (float tx, float ty);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CanvasRenderingContext2DClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CharacterData {
		public weak WebKit.Node parent_instance;
		[CCode (cname = "webkit_character_data_append_data")]
		public void append_data (string data2) throws GLib.Error;
		[CCode (cname = "webkit_character_data_delete_data")]
		public void delete_data (ulong offset, ulong length) throws GLib.Error;
		[CCode (cname = "webkit_character_data_get_data")]
		public unowned string get_data ();
		[CCode (cname = "webkit_character_data_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_character_data_insert_data")]
		public void insert_data (ulong offset, string data2) throws GLib.Error;
		[CCode (cname = "webkit_character_data_replace_data")]
		public void replace_data (ulong offset, ulong length, string data2) throws GLib.Error;
		[CCode (cname = "webkit_character_data_set_data")]
		public void set_data (string value) throws GLib.Error;
		[CCode (cname = "webkit_character_data_substring_data")]
		public unowned string substring_data (ulong offset, ulong length) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CharacterDataClass {
		public weak WebKit.NodeClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class ClientRect {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_client_rect_get_bottom")]
		public float get_bottom ();
		[CCode (cname = "webkit_client_rect_get_height")]
		public float get_height ();
		[CCode (cname = "webkit_client_rect_get_left")]
		public float get_left ();
		[CCode (cname = "webkit_client_rect_get_right")]
		public float get_right ();
		[CCode (cname = "webkit_client_rect_get_top")]
		public float get_top ();
		[CCode (cname = "webkit_client_rect_get_width")]
		public float get_width ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class ClientRectClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class ClientRectList {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_client_rect_list_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_client_rect_list_item")]
		public unowned WebKit.ClientRect item (ulong index);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class ClientRectListClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Clipboard {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_clipboard_get_drop_effect")]
		public unowned string get_drop_effect ();
		[CCode (cname = "webkit_clipboard_get_effect_allowed")]
		public unowned string get_effect_allowed ();
		[CCode (cname = "webkit_clipboard_set_drop_effect")]
		public void set_drop_effect (string value);
		[CCode (cname = "webkit_clipboard_set_effect_allowed")]
		public void set_effect_allowed (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class ClipboardClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Comment {
		public weak WebKit.CharacterData parent_instance;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CommentClass {
		public weak WebKit.CharacterDataClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Console {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_console_group_end")]
		public void group_end ();
		[CCode (cname = "webkit_console_time")]
		public void time (string title);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class ConsoleClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Counter {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_counter_get_identifier")]
		public unowned string get_identifier ();
		[CCode (cname = "webkit_counter_get_list_style")]
		public unowned string get_list_style ();
		[CCode (cname = "webkit_counter_get_separator")]
		public unowned string get_separator ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class CounterClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DOMApplicationCache {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_dom_application_cache_get_status")]
		public ushort get_status ();
		[CCode (cname = "webkit_dom_application_cache_swap_cache")]
		public void swap_cache () throws GLib.Error;
		[CCode (cname = "webkit_dom_application_cache_update")]
		public void update () throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DOMApplicationCacheClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DOMCoreException {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_dom_core_exception_get_code")]
		public ushort get_code ();
		[CCode (cname = "webkit_dom_core_exception_get_message")]
		public unowned string get_message ();
		[CCode (cname = "webkit_dom_core_exception_get_name")]
		public unowned string get_name ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DOMCoreExceptionClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DOMImplementation {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_dom_implementation_create_css_style_sheet")]
		public unowned WebKit.CSSStyleSheet create_css_style_sheet (string title, string media) throws GLib.Error;
		[CCode (cname = "webkit_dom_implementation_create_document")]
		public unowned WebKit.Document create_document (string namespace_uri, string qualified_name, WebKit.DocumentType doctype) throws GLib.Error;
		[CCode (cname = "webkit_dom_implementation_create_document_type")]
		public unowned WebKit.DocumentType create_document_type (string qualified_name, string public_id, string system_id) throws GLib.Error;
		[CCode (cname = "webkit_dom_implementation_create_html_document")]
		public unowned WebKit.HTMLDocument create_html_document (string title);
		[CCode (cname = "webkit_dom_implementation_has_feature")]
		public bool has_feature (string feature, string version);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DOMImplementationClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DOMObject {
		public void* coreObject;
		public weak GLib.Object parent_instance;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DOMObjectClass {
		public weak GLib.ObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DOMParser {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_dom_parser_parse_from_string")]
		public unowned WebKit.Document parse_from_string (string str, string content_type);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DOMParserClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DOMSelection {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_dom_selection_add_range")]
		public void add_range (WebKit.Range range);
		[CCode (cname = "webkit_dom_selection_collapse")]
		public void collapse (WebKit.Node node, long index) throws GLib.Error;
		[CCode (cname = "webkit_dom_selection_collapse_to_end")]
		public void collapse_to_end ();
		[CCode (cname = "webkit_dom_selection_collapse_to_start")]
		public void collapse_to_start ();
		[CCode (cname = "webkit_dom_selection_contains_node")]
		public bool contains_node (WebKit.Node node, bool allow_partial);
		[CCode (cname = "webkit_dom_selection_delete_from_document")]
		public void delete_from_document ();
		[CCode (cname = "webkit_dom_selection_empty")]
		public void empty ();
		[CCode (cname = "webkit_dom_selection_extend")]
		public void extend (WebKit.Node node, long offset) throws GLib.Error;
		[CCode (cname = "webkit_dom_selection_get_anchor_node")]
		public unowned WebKit.Node get_anchor_node ();
		[CCode (cname = "webkit_dom_selection_get_anchor_offset")]
		public long get_anchor_offset ();
		[CCode (cname = "webkit_dom_selection_get_base_node")]
		public unowned WebKit.Node get_base_node ();
		[CCode (cname = "webkit_dom_selection_get_base_offset")]
		public long get_base_offset ();
		[CCode (cname = "webkit_dom_selection_get_extent_node")]
		public unowned WebKit.Node get_extent_node ();
		[CCode (cname = "webkit_dom_selection_get_extent_offset")]
		public long get_extent_offset ();
		[CCode (cname = "webkit_dom_selection_get_focus_node")]
		public unowned WebKit.Node get_focus_node ();
		[CCode (cname = "webkit_dom_selection_get_focus_offset")]
		public long get_focus_offset ();
		[CCode (cname = "webkit_dom_selection_get_is_collapsed")]
		public bool get_is_collapsed ();
		[CCode (cname = "webkit_dom_selection_get_range_at")]
		public unowned WebKit.Range get_range_at (long index) throws GLib.Error;
		[CCode (cname = "webkit_dom_selection_get_range_count")]
		public long get_range_count ();
		[CCode (cname = "webkit_dom_selection_modify")]
		public void modify (string alter, string direction, string granularity);
		[CCode (cname = "webkit_dom_selection_remove_all_ranges")]
		public void remove_all_ranges ();
		[CCode (cname = "webkit_dom_selection_select_all_children")]
		public void select_all_children (WebKit.Node node) throws GLib.Error;
		[CCode (cname = "webkit_dom_selection_set_base_and_extent")]
		public void set_base_and_extent (WebKit.Node base_node, long base_offset, WebKit.Node extent_node, long extent_offset) throws GLib.Error;
		[CCode (cname = "webkit_dom_selection_set_position")]
		public void set_position (WebKit.Node node, long offset) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DOMSelectionClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DOMStringList {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_dom_string_list_contains")]
		public bool contains (string str);
		[CCode (cname = "webkit_dom_string_list_get_length")]
		public ulong get_length ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DOMStringListClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DOMWindow {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_dom_window_alert")]
		public void alert (string message);
		[CCode (cname = "webkit_dom_window_blur")]
		public void blur ();
		[CCode (cname = "webkit_dom_window_close")]
		public void close ();
		[CCode (cname = "webkit_dom_window_confirm")]
		public bool confirm (string message);
		[CCode (cname = "webkit_dom_window_find")]
		public bool find (string str, bool case_sensitive, bool backwards, bool wrap, bool whole_word, bool search_in_frames, bool show_dialog);
		[CCode (cname = "webkit_dom_window_focus")]
		public void focus ();
		[CCode (cname = "webkit_dom_window_get_application_cache")]
		public unowned WebKit.DOMApplicationCache get_application_cache ();
		[CCode (cname = "webkit_dom_window_get_client_information")]
		public unowned WebKit.Navigator get_client_information ();
		[CCode (cname = "webkit_dom_window_get_closed")]
		public bool get_closed ();
		[CCode (cname = "webkit_dom_window_get_computed_style")]
		public unowned WebKit.CSSStyleDeclaration get_computed_style (WebKit.Element element, string pseudo_element);
		[CCode (cname = "webkit_dom_window_get_console")]
		public unowned WebKit.Console get_console ();
		[CCode (cname = "webkit_dom_window_get_default_status")]
		public unowned string get_default_status ();
		[CCode (cname = "webkit_dom_window_get_device_pixel_ratio")]
		public double get_device_pixel_ratio ();
		[CCode (cname = "webkit_dom_window_get_document")]
		public unowned WebKit.Document get_document ();
		[CCode (cname = "webkit_dom_window_get_frame_element")]
		public unowned WebKit.Element get_frame_element ();
		[CCode (cname = "webkit_dom_window_get_frames")]
		public unowned WebKit.DOMWindow get_frames ();
		[CCode (cname = "webkit_dom_window_get_history")]
		public unowned WebKit.History get_history ();
		[CCode (cname = "webkit_dom_window_get_inner_height")]
		public long get_inner_height ();
		[CCode (cname = "webkit_dom_window_get_inner_width")]
		public long get_inner_width ();
		[CCode (cname = "webkit_dom_window_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_dom_window_get_local_storage")]
		public unowned WebKit.Storage get_local_storage ();
		[CCode (cname = "webkit_dom_window_get_locationbar")]
		public unowned WebKit.BarInfo get_locationbar ();
		[CCode (cname = "webkit_dom_window_get_matched_css_rules")]
		public unowned WebKit.CSSRuleList get_matched_css_rules (WebKit.Element element, string pseudo_element, bool author_only);
		[CCode (cname = "webkit_dom_window_get_menubar")]
		public unowned WebKit.BarInfo get_menubar ();
		[CCode (cname = "webkit_dom_window_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_dom_window_get_navigator")]
		public unowned WebKit.Navigator get_navigator ();
		[CCode (cname = "webkit_dom_window_get_offscreen_buffering")]
		public bool get_offscreen_buffering ();
		[CCode (cname = "webkit_dom_window_get_opener")]
		public unowned WebKit.DOMWindow get_opener ();
		[CCode (cname = "webkit_dom_window_get_outer_height")]
		public long get_outer_height ();
		[CCode (cname = "webkit_dom_window_get_outer_width")]
		public long get_outer_width ();
		[CCode (cname = "webkit_dom_window_get_page_x_offset")]
		public long get_page_x_offset ();
		[CCode (cname = "webkit_dom_window_get_page_y_offset")]
		public long get_page_y_offset ();
		[CCode (cname = "webkit_dom_window_get_parent")]
		public unowned WebKit.DOMWindow get_parent ();
		[CCode (cname = "webkit_dom_window_get_personalbar")]
		public unowned WebKit.BarInfo get_personalbar ();
		[CCode (cname = "webkit_dom_window_get_screen")]
		public unowned WebKit.Screen get_screen ();
		[CCode (cname = "webkit_dom_window_get_screen_left")]
		public long get_screen_left ();
		[CCode (cname = "webkit_dom_window_get_screen_top")]
		public long get_screen_top ();
		[CCode (cname = "webkit_dom_window_get_screen_x")]
		public long get_screen_x ();
		[CCode (cname = "webkit_dom_window_get_screen_y")]
		public long get_screen_y ();
		[CCode (cname = "webkit_dom_window_get_scroll_x")]
		public long get_scroll_x ();
		[CCode (cname = "webkit_dom_window_get_scroll_y")]
		public long get_scroll_y ();
		[CCode (cname = "webkit_dom_window_get_scrollbars")]
		public unowned WebKit.BarInfo get_scrollbars ();
		[CCode (cname = "webkit_dom_window_get_selection")]
		public unowned WebKit.DOMSelection get_selection ();
		[CCode (cname = "webkit_dom_window_get_self")]
		public unowned WebKit.DOMWindow get_self ();
		[CCode (cname = "webkit_dom_window_get_session_storage")]
		public unowned WebKit.Storage get_session_storage ();
		[CCode (cname = "webkit_dom_window_get_status")]
		public unowned string get_status ();
		[CCode (cname = "webkit_dom_window_get_statusbar")]
		public unowned WebKit.BarInfo get_statusbar ();
		[CCode (cname = "webkit_dom_window_get_toolbar")]
		public unowned WebKit.BarInfo get_toolbar ();
		[CCode (cname = "webkit_dom_window_get_top")]
		public unowned WebKit.DOMWindow get_top ();
		[CCode (cname = "webkit_dom_window_get_window")]
		public unowned WebKit.DOMWindow get_window ();
		[CCode (cname = "webkit_dom_window_move_by")]
		public void move_by (float x, float y);
		[CCode (cname = "webkit_dom_window_move_to")]
		public void move_to (float x, float y);
		[CCode (cname = "webkit_dom_window_open_database")]
		public unowned WebKit.Database open_database (string name, string version, string display_name, ulong estimated_size) throws GLib.Error;
		[CCode (cname = "webkit_dom_window_print")]
		public void print ();
		[CCode (cname = "webkit_dom_window_prompt")]
		public unowned string prompt (string message, string default_value);
		[CCode (cname = "webkit_dom_window_resize_by")]
		public void resize_by (float x, float y);
		[CCode (cname = "webkit_dom_window_resize_to")]
		public void resize_to (float width, float height);
		[CCode (cname = "webkit_dom_window_scroll")]
		public void scroll (long x, long y);
		[CCode (cname = "webkit_dom_window_scroll_by")]
		public void scroll_by (long x, long y);
		[CCode (cname = "webkit_dom_window_scroll_to")]
		public void scroll_to (long x, long y);
		[CCode (cname = "webkit_dom_window_set_default_status")]
		public void set_default_status (string value);
		[CCode (cname = "webkit_dom_window_set_name")]
		public void set_name (string value);
		[CCode (cname = "webkit_dom_window_set_status")]
		public void set_status (string value);
		[CCode (cname = "webkit_dom_window_stop")]
		public void stop ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DOMWindowClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Database {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_database_get_version")]
		public unowned string get_version ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DatabaseClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Document {
		public weak WebKit.Node parent_instance;
		[CCode (cname = "webkit_document_adopt_node")]
		public unowned WebKit.Node adopt_node (WebKit.Node source) throws GLib.Error;
		[CCode (cname = "webkit_document_create_attribute")]
		public unowned WebKit.Attr create_attribute (string name) throws GLib.Error;
		[CCode (cname = "webkit_document_create_attribute_ns")]
		public unowned WebKit.Attr create_attribute_ns (string namespace_uri, string qualified_name) throws GLib.Error;
		[CCode (cname = "webkit_document_create_cdata_section")]
		public unowned WebKit.CDATASection create_cdata_section (string data) throws GLib.Error;
		[CCode (cname = "webkit_document_create_comment")]
		public unowned WebKit.Comment create_comment (string data);
		[CCode (cname = "webkit_document_create_css_style_declaration")]
		public unowned WebKit.CSSStyleDeclaration create_css_style_declaration ();
		[CCode (cname = "webkit_document_create_document_fragment")]
		public unowned WebKit.DocumentFragment create_document_fragment ();
		[CCode (cname = "webkit_document_create_element")]
		public unowned WebKit.Element create_element (string tag_name) throws GLib.Error;
		[CCode (cname = "webkit_document_create_element_ns")]
		public unowned WebKit.Element create_element_ns (string namespace_uri, string qualified_name) throws GLib.Error;
		[CCode (cname = "webkit_document_create_entity_reference")]
		public unowned WebKit.EntityReference create_entity_reference (string name) throws GLib.Error;
		[CCode (cname = "webkit_document_create_expression")]
		public unowned WebKit.XPathExpression create_expression (string expression, WebKit.XPathNSResolver resolver) throws GLib.Error;
		[CCode (cname = "webkit_document_create_node_iterator")]
		public unowned WebKit.NodeIterator create_node_iterator (WebKit.Node root, ulong what_to_show, WebKit.NodeFilter filter, bool expand_entity_references) throws GLib.Error;
		[CCode (cname = "webkit_document_create_ns_resolver")]
		public unowned WebKit.XPathNSResolver create_ns_resolver (WebKit.Node node_resolver);
		[CCode (cname = "webkit_document_create_processing_instruction")]
		public unowned WebKit.ProcessingInstruction create_processing_instruction (string target, string data) throws GLib.Error;
		[CCode (cname = "webkit_document_create_range")]
		public unowned WebKit.Range create_range ();
		[CCode (cname = "webkit_document_create_text_node")]
		public unowned WebKit.Text create_text_node (string data);
		[CCode (cname = "webkit_document_create_tree_walker")]
		public unowned WebKit.TreeWalker create_tree_walker (WebKit.Node root, ulong what_to_show, WebKit.NodeFilter filter, bool expand_entity_references) throws GLib.Error;
		[CCode (cname = "webkit_document_element_from_point")]
		public unowned WebKit.Element element_from_point (long x, long y);
		[CCode (cname = "webkit_document_evaluate")]
		public unowned WebKit.XPathResult evaluate (string expression, WebKit.Node context_node, WebKit.XPathNSResolver resolver, ushort type, WebKit.XPathResult in_result) throws GLib.Error;
		[CCode (cname = "webkit_document_exec_command")]
		public bool exec_command (string command, bool user_interface, string value);
		[CCode (cname = "webkit_document_get_anchors")]
		public unowned WebKit.HTMLCollection get_anchors ();
		[CCode (cname = "webkit_document_get_applets")]
		public unowned WebKit.HTMLCollection get_applets ();
		[CCode (cname = "webkit_document_get_body")]
		public unowned WebKit.HTMLElement get_body ();
		[CCode (cname = "webkit_document_get_character_set")]
		public unowned string get_character_set ();
		[CCode (cname = "webkit_document_get_charset")]
		public unowned string get_charset ();
		[CCode (cname = "webkit_document_get_cookie")]
		public unowned string get_cookie ();
		[CCode (cname = "webkit_document_get_default_charset")]
		public unowned string get_default_charset ();
		[CCode (cname = "webkit_document_get_default_view")]
		public unowned WebKit.DOMWindow get_default_view ();
		[CCode (cname = "webkit_document_get_doctype")]
		public unowned WebKit.DocumentType get_doctype ();
		[CCode (cname = "webkit_document_get_document_element")]
		public unowned WebKit.Element get_document_element ();
		[CCode (cname = "webkit_document_get_document_uri")]
		public unowned string get_document_uri ();
		[CCode (cname = "webkit_document_get_domain")]
		public unowned string get_domain ();
		[CCode (cname = "webkit_document_get_element_by_id")]
		public unowned WebKit.Element get_element_by_id (string element_id);
		[CCode (cname = "webkit_document_get_elements_by_class_name")]
		public unowned WebKit.NodeList get_elements_by_class_name (string tagname);
		[CCode (cname = "webkit_document_get_elements_by_name")]
		public unowned WebKit.NodeList get_elements_by_name (string element_name);
		[CCode (cname = "webkit_document_get_elements_by_tag_name")]
		public unowned WebKit.NodeList get_elements_by_tag_name (string tagname);
		[CCode (cname = "webkit_document_get_elements_by_tag_name_ns")]
		public unowned WebKit.NodeList get_elements_by_tag_name_ns (string namespace_uri, string local_name);
		[CCode (cname = "webkit_document_get_forms")]
		public unowned WebKit.HTMLCollection get_forms ();
		[CCode (cname = "webkit_document_get_images")]
		public unowned WebKit.HTMLCollection get_images ();
		[CCode (cname = "webkit_document_get_implementation")]
		public unowned WebKit.DOMImplementation get_implementation ();
		[CCode (cname = "webkit_document_get_input_encoding")]
		public unowned string get_input_encoding ();
		[CCode (cname = "webkit_document_get_last_modified")]
		public unowned string get_last_modified ();
		[CCode (cname = "webkit_document_get_links")]
		public unowned WebKit.HTMLCollection get_links ();
		[CCode (cname = "webkit_document_get_override_style")]
		public unowned WebKit.CSSStyleDeclaration get_override_style (WebKit.Element element, string pseudo_element);
		[CCode (cname = "webkit_document_get_preferred_stylesheet_set")]
		public unowned string get_preferred_stylesheet_set ();
		[CCode (cname = "webkit_document_get_ready_state")]
		public unowned string get_ready_state ();
		[CCode (cname = "webkit_document_get_referrer")]
		public unowned string get_referrer ();
		[CCode (cname = "webkit_document_get_selected_stylesheet_set")]
		public unowned string get_selected_stylesheet_set ();
		[CCode (cname = "webkit_document_get_style_sheets")]
		public unowned WebKit.StyleSheetList get_style_sheets ();
		[CCode (cname = "webkit_document_get_title")]
		public unowned string get_title ();
		[CCode (cname = "webkit_document_get_xml_encoding")]
		public unowned string get_xml_encoding ();
		[CCode (cname = "webkit_document_get_xml_standalone")]
		public bool get_xml_standalone ();
		[CCode (cname = "webkit_document_get_xml_version")]
		public unowned string get_xml_version ();
		[CCode (cname = "webkit_document_import_node")]
		public unowned WebKit.Node import_node (WebKit.Node imported_node, bool deep) throws GLib.Error;
		[CCode (cname = "webkit_document_query_command_enabled")]
		public bool query_command_enabled (string command);
		[CCode (cname = "webkit_document_query_command_indeterm")]
		public bool query_command_indeterm (string command);
		[CCode (cname = "webkit_document_query_command_state")]
		public bool query_command_state (string command);
		[CCode (cname = "webkit_document_query_command_supported")]
		public bool query_command_supported (string command);
		[CCode (cname = "webkit_document_query_command_value")]
		public unowned string query_command_value (string command);
		[CCode (cname = "webkit_document_query_selector")]
		public unowned WebKit.Element query_selector (string selectors) throws GLib.Error;
		[CCode (cname = "webkit_document_query_selector_all")]
		public unowned WebKit.NodeList query_selector_all (string selectors) throws GLib.Error;
		[CCode (cname = "webkit_document_set_body")]
		public void set_body (WebKit.HTMLElement value) throws GLib.Error;
		[CCode (cname = "webkit_document_set_charset")]
		public void set_charset (string value);
		[CCode (cname = "webkit_document_set_cookie")]
		public void set_cookie (string value);
		[CCode (cname = "webkit_document_set_document_uri")]
		public void set_document_uri (string value);
		[CCode (cname = "webkit_document_set_selected_stylesheet_set")]
		public void set_selected_stylesheet_set (string value);
		[CCode (cname = "webkit_document_set_title")]
		public void set_title (string value);
		[CCode (cname = "webkit_document_set_xml_standalone")]
		public void set_xml_standalone (bool value) throws GLib.Error;
		[CCode (cname = "webkit_document_set_xml_version")]
		public void set_xml_version (string value) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DocumentClass {
		public weak WebKit.NodeClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DocumentFragment {
		public weak WebKit.Node parent_instance;
		[CCode (cname = "webkit_document_fragment_query_selector")]
		public unowned WebKit.Element query_selector (string selectors) throws GLib.Error;
		[CCode (cname = "webkit_document_fragment_query_selector_all")]
		public unowned WebKit.NodeList query_selector_all (string selectors) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DocumentFragmentClass {
		public weak WebKit.NodeClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DocumentType {
		public weak WebKit.Node parent_instance;
		[CCode (cname = "webkit_document_type_get_entities")]
		public unowned WebKit.NamedNodeMap get_entities ();
		[CCode (cname = "webkit_document_type_get_internal_subset")]
		public unowned string get_internal_subset ();
		[CCode (cname = "webkit_document_type_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_document_type_get_notations")]
		public unowned WebKit.NamedNodeMap get_notations ();
		[CCode (cname = "webkit_document_type_get_public_id")]
		public unowned string get_public_id ();
		[CCode (cname = "webkit_document_type_get_system_id")]
		public unowned string get_system_id ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class DocumentTypeClass {
		public weak WebKit.NodeClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Element {
		public weak WebKit.Node parent_instance;
		[CCode (cname = "webkit_element_blur")]
		public void blur ();
		[CCode (cname = "webkit_element_contains")]
		public bool contains (WebKit.Element element2);
		[CCode (cname = "webkit_element_focus")]
		public void focus ();
		[CCode (cname = "webkit_element_get_attribute")]
		public unowned string get_attribute (string name);
		[CCode (cname = "webkit_element_get_attribute_node")]
		public unowned WebKit.Attr get_attribute_node (string name);
		[CCode (cname = "webkit_element_get_attribute_node_ns")]
		public unowned WebKit.Attr get_attribute_node_ns (string namespace_uri, string local_name);
		[CCode (cname = "webkit_element_get_attribute_ns")]
		public unowned string get_attribute_ns (string namespace_uri, string local_name);
		[CCode (cname = "webkit_element_get_child_element_count")]
		public ulong get_child_element_count ();
		[CCode (cname = "webkit_element_get_client_height")]
		public long get_client_height ();
		[CCode (cname = "webkit_element_get_client_left")]
		public long get_client_left ();
		[CCode (cname = "webkit_element_get_client_top")]
		public long get_client_top ();
		[CCode (cname = "webkit_element_get_client_width")]
		public long get_client_width ();
		[CCode (cname = "webkit_element_get_elements_by_class_name")]
		public unowned WebKit.NodeList get_elements_by_class_name (string name);
		[CCode (cname = "webkit_element_get_elements_by_tag_name")]
		public unowned WebKit.NodeList get_elements_by_tag_name (string name);
		[CCode (cname = "webkit_element_get_elements_by_tag_name_ns")]
		public unowned WebKit.NodeList get_elements_by_tag_name_ns (string namespace_uri, string local_name);
		[CCode (cname = "webkit_element_get_first_element_child")]
		public unowned WebKit.Element get_first_element_child ();
		[CCode (cname = "webkit_element_get_last_element_child")]
		public unowned WebKit.Element get_last_element_child ();
		[CCode (cname = "webkit_element_get_next_element_sibling")]
		public unowned WebKit.Element get_next_element_sibling ();
		[CCode (cname = "webkit_element_get_offset_height")]
		public long get_offset_height ();
		[CCode (cname = "webkit_element_get_offset_left")]
		public long get_offset_left ();
		[CCode (cname = "webkit_element_get_offset_parent")]
		public unowned WebKit.Element get_offset_parent ();
		[CCode (cname = "webkit_element_get_offset_top")]
		public long get_offset_top ();
		[CCode (cname = "webkit_element_get_offset_width")]
		public long get_offset_width ();
		[CCode (cname = "webkit_element_get_previous_element_sibling")]
		public unowned WebKit.Element get_previous_element_sibling ();
		[CCode (cname = "webkit_element_get_scroll_height")]
		public long get_scroll_height ();
		[CCode (cname = "webkit_element_get_scroll_left")]
		public long get_scroll_left ();
		[CCode (cname = "webkit_element_get_scroll_top")]
		public long get_scroll_top ();
		[CCode (cname = "webkit_element_get_scroll_width")]
		public long get_scroll_width ();
		[CCode (cname = "webkit_element_get_style")]
		public unowned WebKit.CSSStyleDeclaration get_style ();
		[CCode (cname = "webkit_element_get_tag_name")]
		public unowned string get_tag_name ();
		[CCode (cname = "webkit_element_has_attribute")]
		public bool has_attribute (string name);
		[CCode (cname = "webkit_element_has_attribute_ns")]
		public bool has_attribute_ns (string namespace_uri, string local_name);
		[CCode (cname = "webkit_element_query_selector")]
		public unowned WebKit.Element query_selector (string selectors) throws GLib.Error;
		[CCode (cname = "webkit_element_query_selector_all")]
		public unowned WebKit.NodeList query_selector_all (string selectors) throws GLib.Error;
		[CCode (cname = "webkit_element_remove_attribute")]
		public void remove_attribute (string name) throws GLib.Error;
		[CCode (cname = "webkit_element_remove_attribute_node")]
		public unowned WebKit.Attr remove_attribute_node (WebKit.Attr old_attr) throws GLib.Error;
		[CCode (cname = "webkit_element_remove_attribute_ns")]
		public void remove_attribute_ns (string namespace_uri, string local_name) throws GLib.Error;
		[CCode (cname = "webkit_element_scroll_by_lines")]
		public void scroll_by_lines (long lines);
		[CCode (cname = "webkit_element_scroll_by_pages")]
		public void scroll_by_pages (long pages);
		[CCode (cname = "webkit_element_scroll_into_view")]
		public void scroll_into_view (bool align_with_top);
		[CCode (cname = "webkit_element_scroll_into_view_if_needed")]
		public void scroll_into_view_if_needed (bool center_if_needed);
		[CCode (cname = "webkit_element_set_attribute")]
		public void set_attribute (string name, string value) throws GLib.Error;
		[CCode (cname = "webkit_element_set_scroll_left")]
		public void set_scroll_left (long value);
		[CCode (cname = "webkit_element_set_scroll_top")]
		public void set_scroll_top (long value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class ElementClass {
		public weak WebKit.NodeClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Entity {
		public weak WebKit.Node parent_instance;
		[CCode (cname = "webkit_entity_get_notation_name")]
		public unowned string get_notation_name ();
		[CCode (cname = "webkit_entity_get_public_id")]
		public unowned string get_public_id ();
		[CCode (cname = "webkit_entity_get_system_id")]
		public unowned string get_system_id ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class EntityClass {
		public weak WebKit.NodeClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class EntityReference {
		public weak WebKit.Node parent_instance;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class EntityReferenceClass {
		public weak WebKit.NodeClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class File {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_file_get_file_name")]
		public unowned string get_file_name ();
		[CCode (cname = "webkit_file_get_file_size")]
		public uint64 get_file_size ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class FileClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class FileList {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_file_list_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_file_list_item")]
		public unowned WebKit.File item (ulong index);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class FileListClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Geolocation {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_geolocation_clear_watch")]
		public void clear_watch (long watch_id);
		[CCode (cname = "webkit_geolocation_get_last_position")]
		public unowned WebKit.Geoposition get_last_position ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class GeolocationClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Geoposition {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_geoposition_get_accuracy")]
		public double get_accuracy ();
		[CCode (cname = "webkit_geoposition_get_altitude")]
		public double get_altitude ();
		[CCode (cname = "webkit_geoposition_get_altitude_accuracy")]
		public double get_altitude_accuracy ();
		[CCode (cname = "webkit_geoposition_get_heading")]
		public double get_heading ();
		[CCode (cname = "webkit_geoposition_get_latitude")]
		public double get_latitude ();
		[CCode (cname = "webkit_geoposition_get_longitude")]
		public double get_longitude ();
		[CCode (cname = "webkit_geoposition_get_speed")]
		public double get_speed ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class GeopositionClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLAnchorElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_anchor_element_get_access_key")]
		public unowned string get_access_key ();
		[CCode (cname = "webkit_html_anchor_element_get_charset")]
		public unowned string get_charset ();
		[CCode (cname = "webkit_html_anchor_element_get_coords")]
		public unowned string get_coords ();
		[CCode (cname = "webkit_html_anchor_element_get_hash")]
		public unowned string get_hash ();
		[CCode (cname = "webkit_html_anchor_element_get_host")]
		public unowned string get_host ();
		[CCode (cname = "webkit_html_anchor_element_get_hostname")]
		public unowned string get_hostname ();
		[CCode (cname = "webkit_html_anchor_element_get_href")]
		public unowned string get_href ();
		[CCode (cname = "webkit_html_anchor_element_get_hreflang")]
		public unowned string get_hreflang ();
		[CCode (cname = "webkit_html_anchor_element_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_html_anchor_element_get_pathname")]
		public unowned string get_pathname ();
		[CCode (cname = "webkit_html_anchor_element_get_port")]
		public unowned string get_port ();
		[CCode (cname = "webkit_html_anchor_element_get_protocol")]
		public unowned string get_protocol ();
		[CCode (cname = "webkit_html_anchor_element_get_rel")]
		public unowned string get_rel ();
		[CCode (cname = "webkit_html_anchor_element_get_rev")]
		public unowned string get_rev ();
		[CCode (cname = "webkit_html_anchor_element_get_search")]
		public unowned string get_search ();
		[CCode (cname = "webkit_html_anchor_element_get_shape")]
		public unowned string get_shape ();
		[CCode (cname = "webkit_html_anchor_element_get_target")]
		public unowned string get_target ();
		[CCode (cname = "webkit_html_anchor_element_get_text")]
		public unowned string get_text ();
		[CCode (cname = "webkit_html_anchor_element_set_access_key")]
		public void set_access_key (string value);
		[CCode (cname = "webkit_html_anchor_element_set_charset")]
		public void set_charset (string value);
		[CCode (cname = "webkit_html_anchor_element_set_coords")]
		public void set_coords (string value);
		[CCode (cname = "webkit_html_anchor_element_set_href")]
		public void set_href (string value);
		[CCode (cname = "webkit_html_anchor_element_set_hreflang")]
		public void set_hreflang (string value);
		[CCode (cname = "webkit_html_anchor_element_set_name")]
		public void set_name (string value);
		[CCode (cname = "webkit_html_anchor_element_set_rel")]
		public void set_rel (string value);
		[CCode (cname = "webkit_html_anchor_element_set_rev")]
		public void set_rev (string value);
		[CCode (cname = "webkit_html_anchor_element_set_shape")]
		public void set_shape (string value);
		[CCode (cname = "webkit_html_anchor_element_set_target")]
		public void set_target (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLAnchorElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLAppletElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_applet_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_html_applet_element_get_alt")]
		public unowned string get_alt ();
		[CCode (cname = "webkit_html_applet_element_get_archive")]
		public unowned string get_archive ();
		[CCode (cname = "webkit_html_applet_element_get_code")]
		public unowned string get_code ();
		[CCode (cname = "webkit_html_applet_element_get_code_base")]
		public unowned string get_code_base ();
		[CCode (cname = "webkit_html_applet_element_get_height")]
		public unowned string get_height ();
		[CCode (cname = "webkit_html_applet_element_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_html_applet_element_get_object")]
		public unowned string get_object ();
		[CCode (cname = "webkit_html_applet_element_get_width")]
		public unowned string get_width ();
		[CCode (cname = "webkit_html_applet_element_set_align")]
		public void set_align (string value);
		[CCode (cname = "webkit_html_applet_element_set_alt")]
		public void set_alt (string value);
		[CCode (cname = "webkit_html_applet_element_set_archive")]
		public void set_archive (string value);
		[CCode (cname = "webkit_html_applet_element_set_code")]
		public void set_code (string value);
		[CCode (cname = "webkit_html_applet_element_set_code_base")]
		public void set_code_base (string value);
		[CCode (cname = "webkit_html_applet_element_set_height")]
		public void set_height (string value);
		[CCode (cname = "webkit_html_applet_element_set_name")]
		public void set_name (string value);
		[CCode (cname = "webkit_html_applet_element_set_object")]
		public void set_object (string value);
		[CCode (cname = "webkit_html_applet_element_set_width")]
		public void set_width (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLAppletElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLAreaElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_area_element_get_access_key")]
		public unowned string get_access_key ();
		[CCode (cname = "webkit_html_area_element_get_alt")]
		public unowned string get_alt ();
		[CCode (cname = "webkit_html_area_element_get_coords")]
		public unowned string get_coords ();
		[CCode (cname = "webkit_html_area_element_get_hash")]
		public unowned string get_hash ();
		[CCode (cname = "webkit_html_area_element_get_host")]
		public unowned string get_host ();
		[CCode (cname = "webkit_html_area_element_get_hostname")]
		public unowned string get_hostname ();
		[CCode (cname = "webkit_html_area_element_get_href")]
		public unowned string get_href ();
		[CCode (cname = "webkit_html_area_element_get_no_href")]
		public bool get_no_href ();
		[CCode (cname = "webkit_html_area_element_get_pathname")]
		public unowned string get_pathname ();
		[CCode (cname = "webkit_html_area_element_get_port")]
		public unowned string get_port ();
		[CCode (cname = "webkit_html_area_element_get_protocol")]
		public unowned string get_protocol ();
		[CCode (cname = "webkit_html_area_element_get_search")]
		public unowned string get_search ();
		[CCode (cname = "webkit_html_area_element_get_shape")]
		public unowned string get_shape ();
		[CCode (cname = "webkit_html_area_element_get_target")]
		public unowned string get_target ();
		[CCode (cname = "webkit_html_area_element_set_access_key")]
		public void set_access_key (string value);
		[CCode (cname = "webkit_html_area_element_set_alt")]
		public void set_alt (string value);
		[CCode (cname = "webkit_html_area_element_set_coords")]
		public void set_coords (string value);
		[CCode (cname = "webkit_html_area_element_set_href")]
		public void set_href (string value);
		[CCode (cname = "webkit_html_area_element_set_no_href")]
		public void set_no_href (bool value);
		[CCode (cname = "webkit_html_area_element_set_shape")]
		public void set_shape (string value);
		[CCode (cname = "webkit_html_area_element_set_target")]
		public void set_target (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLAreaElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLAudioElement {
		public weak WebKit.HTMLMediaElement parent_instance;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLAudioElementClass {
		public weak WebKit.HTMLMediaElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLBRElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_htmlbr_element_get_clear")]
		public unowned string get_clear ();
		[CCode (cname = "webkit_htmlbr_element_set_clear")]
		public void set_clear (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLBRElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLBaseElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_base_element_get_href")]
		public unowned string get_href ();
		[CCode (cname = "webkit_html_base_element_get_target")]
		public unowned string get_target ();
		[CCode (cname = "webkit_html_base_element_set_href")]
		public void set_href (string value);
		[CCode (cname = "webkit_html_base_element_set_target")]
		public void set_target (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLBaseElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLBaseFontElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_base_font_element_get_color")]
		public unowned string get_color ();
		[CCode (cname = "webkit_html_base_font_element_get_face")]
		public unowned string get_face ();
		[CCode (cname = "webkit_html_base_font_element_get_size")]
		public long get_size ();
		[CCode (cname = "webkit_html_base_font_element_set_color")]
		public void set_color (string value);
		[CCode (cname = "webkit_html_base_font_element_set_face")]
		public void set_face (string value);
		[CCode (cname = "webkit_html_base_font_element_set_size")]
		public void set_size (long value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLBaseFontElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLBlockquoteElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_blockquote_element_get_cite")]
		public unowned string get_cite ();
		[CCode (cname = "webkit_html_blockquote_element_set_cite")]
		public void set_cite (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLBlockquoteElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLBodyElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_body_element_get_a_link")]
		public unowned string get_a_link ();
		[CCode (cname = "webkit_html_body_element_get_background")]
		public unowned string get_background ();
		[CCode (cname = "webkit_html_body_element_get_bg_color")]
		public unowned string get_bg_color ();
		[CCode (cname = "webkit_html_body_element_get_link")]
		public unowned string get_link ();
		[CCode (cname = "webkit_html_body_element_get_scroll_height")]
		public long get_scroll_height ();
		[CCode (cname = "webkit_html_body_element_get_scroll_left")]
		public long get_scroll_left ();
		[CCode (cname = "webkit_html_body_element_get_scroll_top")]
		public long get_scroll_top ();
		[CCode (cname = "webkit_html_body_element_get_scroll_width")]
		public long get_scroll_width ();
		[CCode (cname = "webkit_html_body_element_get_text")]
		public unowned string get_text ();
		[CCode (cname = "webkit_html_body_element_get_v_link")]
		public unowned string get_v_link ();
		[CCode (cname = "webkit_html_body_element_set_a_link")]
		public void set_a_link (string value);
		[CCode (cname = "webkit_html_body_element_set_background")]
		public void set_background (string value);
		[CCode (cname = "webkit_html_body_element_set_bg_color")]
		public void set_bg_color (string value);
		[CCode (cname = "webkit_html_body_element_set_link")]
		public void set_link (string value);
		[CCode (cname = "webkit_html_body_element_set_scroll_left")]
		public void set_scroll_left (long value);
		[CCode (cname = "webkit_html_body_element_set_scroll_top")]
		public void set_scroll_top (long value);
		[CCode (cname = "webkit_html_body_element_set_text")]
		public void set_text (string value);
		[CCode (cname = "webkit_html_body_element_set_v_link")]
		public void set_v_link (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLBodyElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLButtonElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_button_element_click")]
		public void click ();
		[CCode (cname = "webkit_html_button_element_get_access_key")]
		public unowned string get_access_key ();
		[CCode (cname = "webkit_html_button_element_get_autofocus")]
		public bool get_autofocus ();
		[CCode (cname = "webkit_html_button_element_get_disabled")]
		public bool get_disabled ();
		[CCode (cname = "webkit_html_button_element_get_form")]
		public unowned WebKit.HTMLFormElement get_form ();
		[CCode (cname = "webkit_html_button_element_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_html_button_element_get_value")]
		public unowned string get_value ();
		[CCode (cname = "webkit_html_button_element_get_will_validate")]
		public bool get_will_validate ();
		[CCode (cname = "webkit_html_button_element_set_access_key")]
		public void set_access_key (string value);
		[CCode (cname = "webkit_html_button_element_set_autofocus")]
		public void set_autofocus (bool value);
		[CCode (cname = "webkit_html_button_element_set_disabled")]
		public void set_disabled (bool value);
		[CCode (cname = "webkit_html_button_element_set_name")]
		public void set_name (string value);
		[CCode (cname = "webkit_html_button_element_set_value")]
		public void set_value (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLButtonElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLCanvasElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_canvas_element_get_height")]
		public long get_height ();
		[CCode (cname = "webkit_html_canvas_element_get_width")]
		public long get_width ();
		[CCode (cname = "webkit_html_canvas_element_set_height")]
		public void set_height (long value);
		[CCode (cname = "webkit_html_canvas_element_set_width")]
		public void set_width (long value);
		[CCode (cname = "webkit_html_canvas_element_to_data_url")]
		public unowned string to_data_url (string type) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLCanvasElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLCollection {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_html_collection_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_html_collection_item")]
		public unowned WebKit.Node item (ulong index);
		[CCode (cname = "webkit_html_collection_named_item")]
		public unowned WebKit.Node named_item (string name);
		[CCode (cname = "webkit_html_collection_tags")]
		public unowned WebKit.NodeList tags (string name);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLCollectionClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLDListElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_htmld_list_element_get_compact")]
		public bool get_compact ();
		[CCode (cname = "webkit_htmld_list_element_set_compact")]
		public void set_compact (bool value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLDListElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLDirectoryElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_directory_element_get_compact")]
		public bool get_compact ();
		[CCode (cname = "webkit_html_directory_element_set_compact")]
		public void set_compact (bool value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLDirectoryElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLDivElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_div_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_html_div_element_set_align")]
		public void set_align (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLDivElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLDocument {
		public weak WebKit.Document parent_instance;
		[CCode (cname = "webkit_html_document_capture_events")]
		public void capture_events ();
		[CCode (cname = "webkit_html_document_clear")]
		public void clear ();
		[CCode (cname = "webkit_html_document_close")]
		public void close ();
		[CCode (cname = "webkit_html_document_get_active_element")]
		public unowned WebKit.Element get_active_element ();
		[CCode (cname = "webkit_html_document_get_alink_color")]
		public unowned string get_alink_color ();
		[CCode (cname = "webkit_html_document_get_bg_color")]
		public unowned string get_bg_color ();
		[CCode (cname = "webkit_html_document_get_compat_mode")]
		public unowned string get_compat_mode ();
		[CCode (cname = "webkit_html_document_get_design_mode")]
		public unowned string get_design_mode ();
		[CCode (cname = "webkit_html_document_get_dir")]
		public unowned string get_dir ();
		[CCode (cname = "webkit_html_document_get_embeds")]
		public unowned WebKit.HTMLCollection get_embeds ();
		[CCode (cname = "webkit_html_document_get_fg_color")]
		public unowned string get_fg_color ();
		[CCode (cname = "webkit_html_document_get_height")]
		public long get_height ();
		[CCode (cname = "webkit_html_document_get_link_color")]
		public unowned string get_link_color ();
		[CCode (cname = "webkit_html_document_get_plugins")]
		public unowned WebKit.HTMLCollection get_plugins ();
		[CCode (cname = "webkit_html_document_get_scripts")]
		public unowned WebKit.HTMLCollection get_scripts ();
		[CCode (cname = "webkit_html_document_get_vlink_color")]
		public unowned string get_vlink_color ();
		[CCode (cname = "webkit_html_document_get_width")]
		public long get_width ();
		[CCode (cname = "webkit_html_document_has_focus")]
		public bool has_focus ();
		[CCode (cname = "webkit_html_document_release_events")]
		public void release_events ();
		[CCode (cname = "webkit_html_document_set_alink_color")]
		public void set_alink_color (string value);
		[CCode (cname = "webkit_html_document_set_bg_color")]
		public void set_bg_color (string value);
		[CCode (cname = "webkit_html_document_set_design_mode")]
		public void set_design_mode (string value);
		[CCode (cname = "webkit_html_document_set_dir")]
		public void set_dir (string value);
		[CCode (cname = "webkit_html_document_set_fg_color")]
		public void set_fg_color (string value);
		[CCode (cname = "webkit_html_document_set_link_color")]
		public void set_link_color (string value);
		[CCode (cname = "webkit_html_document_set_vlink_color")]
		public void set_vlink_color (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLDocumentClass {
		public weak WebKit.DocumentClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLElement {
		public weak WebKit.Element parent_instance;
		[CCode (cname = "webkit_html_element_blur")]
		public void blur ();
		[CCode (cname = "webkit_html_element_focus")]
		public void focus ();
		[CCode (cname = "webkit_html_element_get_children")]
		public unowned WebKit.HTMLCollection get_children ();
		[CCode (cname = "webkit_html_element_get_class_name")]
		public unowned string get_class_name ();
		[CCode (cname = "webkit_html_element_get_content_editable")]
		public unowned string get_content_editable ();
		[CCode (cname = "webkit_html_element_get_dir")]
		public unowned string get_dir ();
		[CCode (cname = "webkit_html_element_get_id")]
		public unowned string get_id ();
		[CCode (cname = "webkit_html_element_get_inner_html")]
		public unowned string get_inner_html ();
		[CCode (cname = "webkit_html_element_get_inner_text")]
		public unowned string get_inner_text ();
		[CCode (cname = "webkit_html_element_get_is_content_editable")]
		public bool get_is_content_editable ();
		[CCode (cname = "webkit_html_element_get_lang")]
		public unowned string get_lang ();
		[CCode (cname = "webkit_html_element_get_outer_html")]
		public unowned string get_outer_html ();
		[CCode (cname = "webkit_html_element_get_outer_text")]
		public unowned string get_outer_text ();
		[CCode (cname = "webkit_html_element_get_tab_index")]
		public long get_tab_index ();
		[CCode (cname = "webkit_html_element_get_title")]
		public unowned string get_title ();
		[CCode (cname = "webkit_html_element_insert_adjacent_element")]
		public unowned WebKit.Element insert_adjacent_element (string where, WebKit.Element element2) throws GLib.Error;
		[CCode (cname = "webkit_html_element_insert_adjacent_html")]
		public void insert_adjacent_html (string where, string html) throws GLib.Error;
		[CCode (cname = "webkit_html_element_insert_adjacent_text")]
		public void insert_adjacent_text (string where, string text) throws GLib.Error;
		[CCode (cname = "webkit_html_element_set_class_name")]
		public void set_class_name (string value);
		[CCode (cname = "webkit_html_element_set_content_editable")]
		public void set_content_editable (string value);
		[CCode (cname = "webkit_html_element_set_dir")]
		public void set_dir (string value);
		[CCode (cname = "webkit_html_element_set_id")]
		public void set_id (string value);
		[CCode (cname = "webkit_html_element_set_inner_html")]
		public void set_inner_html (string value) throws GLib.Error;
		[CCode (cname = "webkit_html_element_set_inner_text")]
		public void set_inner_text (string value) throws GLib.Error;
		[CCode (cname = "webkit_html_element_set_lang")]
		public void set_lang (string value);
		[CCode (cname = "webkit_html_element_set_outer_html")]
		public void set_outer_html (string value) throws GLib.Error;
		[CCode (cname = "webkit_html_element_set_outer_text")]
		public void set_outer_text (string value) throws GLib.Error;
		[CCode (cname = "webkit_html_element_set_tab_index")]
		public void set_tab_index (long value);
		[CCode (cname = "webkit_html_element_set_title")]
		public void set_title (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLElementClass {
		public weak WebKit.ElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLEmbedElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_embed_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_html_embed_element_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_html_embed_element_get_src")]
		public unowned string get_src ();
		[CCode (cname = "webkit_html_embed_element_set_align")]
		public void set_align (string value);
		[CCode (cname = "webkit_html_embed_element_set_name")]
		public void set_name (string value);
		[CCode (cname = "webkit_html_embed_element_set_src")]
		public void set_src (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLEmbedElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLFieldSetElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_field_set_element_get_form")]
		public unowned WebKit.HTMLFormElement get_form ();
		[CCode (cname = "webkit_html_field_set_element_get_will_validate")]
		public bool get_will_validate ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLFieldSetElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLFontElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_font_element_get_color")]
		public unowned string get_color ();
		[CCode (cname = "webkit_html_font_element_get_face")]
		public unowned string get_face ();
		[CCode (cname = "webkit_html_font_element_get_size")]
		public unowned string get_size ();
		[CCode (cname = "webkit_html_font_element_set_color")]
		public void set_color (string value);
		[CCode (cname = "webkit_html_font_element_set_face")]
		public void set_face (string value);
		[CCode (cname = "webkit_html_font_element_set_size")]
		public void set_size (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLFontElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLFormElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_form_element_get_accept_charset")]
		public unowned string get_accept_charset ();
		[CCode (cname = "webkit_html_form_element_get_action")]
		public unowned string get_action ();
		[CCode (cname = "webkit_html_form_element_get_elements")]
		public unowned WebKit.HTMLCollection get_elements ();
		[CCode (cname = "webkit_html_form_element_get_encoding")]
		public unowned string get_encoding ();
		[CCode (cname = "webkit_html_form_element_get_enctype")]
		public unowned string get_enctype ();
		[CCode (cname = "webkit_html_form_element_get_length")]
		public long get_length ();
		[CCode (cname = "webkit_html_form_element_get_method")]
		public unowned string get_method ();
		[CCode (cname = "webkit_html_form_element_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_html_form_element_get_target")]
		public unowned string get_target ();
		[CCode (cname = "webkit_html_form_element_reset")]
		public void reset ();
		[CCode (cname = "webkit_html_form_element_set_accept_charset")]
		public void set_accept_charset (string value);
		[CCode (cname = "webkit_html_form_element_set_action")]
		public void set_action (string value);
		[CCode (cname = "webkit_html_form_element_set_encoding")]
		public void set_encoding (string value);
		[CCode (cname = "webkit_html_form_element_set_enctype")]
		public void set_enctype (string value);
		[CCode (cname = "webkit_html_form_element_set_method")]
		public void set_method (string value);
		[CCode (cname = "webkit_html_form_element_set_name")]
		public void set_name (string value);
		[CCode (cname = "webkit_html_form_element_set_target")]
		public void set_target (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLFormElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLFrameElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_frame_element_get_content_document")]
		public unowned WebKit.Document get_content_document ();
		[CCode (cname = "webkit_html_frame_element_get_content_window")]
		public unowned WebKit.DOMWindow get_content_window ();
		[CCode (cname = "webkit_html_frame_element_get_frame_border")]
		public unowned string get_frame_border ();
		[CCode (cname = "webkit_html_frame_element_get_height")]
		public long get_height ();
		[CCode (cname = "webkit_html_frame_element_get_long_desc")]
		public unowned string get_long_desc ();
		[CCode (cname = "webkit_html_frame_element_get_margin_height")]
		public unowned string get_margin_height ();
		[CCode (cname = "webkit_html_frame_element_get_margin_width")]
		public unowned string get_margin_width ();
		[CCode (cname = "webkit_html_frame_element_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_html_frame_element_get_no_resize")]
		public bool get_no_resize ();
		[CCode (cname = "webkit_html_frame_element_get_scrolling")]
		public unowned string get_scrolling ();
		[CCode (cname = "webkit_html_frame_element_get_width")]
		public long get_width ();
		[CCode (cname = "webkit_html_frame_element_set_frame_border")]
		public void set_frame_border (string value);
		[CCode (cname = "webkit_html_frame_element_set_long_desc")]
		public void set_long_desc (string value);
		[CCode (cname = "webkit_html_frame_element_set_margin_height")]
		public void set_margin_height (string value);
		[CCode (cname = "webkit_html_frame_element_set_margin_width")]
		public void set_margin_width (string value);
		[CCode (cname = "webkit_html_frame_element_set_name")]
		public void set_name (string value);
		[CCode (cname = "webkit_html_frame_element_set_no_resize")]
		public void set_no_resize (bool value);
		[CCode (cname = "webkit_html_frame_element_set_scrolling")]
		public void set_scrolling (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLFrameElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLFrameSetElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_frame_set_element_get_cols")]
		public unowned string get_cols ();
		[CCode (cname = "webkit_html_frame_set_element_get_rows")]
		public unowned string get_rows ();
		[CCode (cname = "webkit_html_frame_set_element_set_cols")]
		public void set_cols (string value);
		[CCode (cname = "webkit_html_frame_set_element_set_rows")]
		public void set_rows (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLFrameSetElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLHRElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_htmlhr_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_htmlhr_element_get_no_shade")]
		public bool get_no_shade ();
		[CCode (cname = "webkit_htmlhr_element_get_size")]
		public unowned string get_size ();
		[CCode (cname = "webkit_htmlhr_element_get_width")]
		public unowned string get_width ();
		[CCode (cname = "webkit_htmlhr_element_set_align")]
		public void set_align (string value);
		[CCode (cname = "webkit_htmlhr_element_set_no_shade")]
		public void set_no_shade (bool value);
		[CCode (cname = "webkit_htmlhr_element_set_size")]
		public void set_size (string value);
		[CCode (cname = "webkit_htmlhr_element_set_width")]
		public void set_width (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLHRElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLHeadElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_head_element_get_profile")]
		public unowned string get_profile ();
		[CCode (cname = "webkit_html_head_element_set_profile")]
		public void set_profile (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLHeadElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLHeadingElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_heading_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_html_heading_element_set_align")]
		public void set_align (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLHeadingElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLHtmlElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_html_element_get_version")]
		public unowned string get_version ();
		[CCode (cname = "webkit_html_html_element_set_version")]
		public void set_version (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLHtmlElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLIFrameElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_htmli_frame_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_htmli_frame_element_get_content_document")]
		public unowned WebKit.Document get_content_document ();
		[CCode (cname = "webkit_htmli_frame_element_get_content_window")]
		public unowned WebKit.DOMWindow get_content_window ();
		[CCode (cname = "webkit_htmli_frame_element_get_frame_border")]
		public unowned string get_frame_border ();
		[CCode (cname = "webkit_htmli_frame_element_get_height")]
		public unowned string get_height ();
		[CCode (cname = "webkit_htmli_frame_element_get_long_desc")]
		public unowned string get_long_desc ();
		[CCode (cname = "webkit_htmli_frame_element_get_margin_height")]
		public unowned string get_margin_height ();
		[CCode (cname = "webkit_htmli_frame_element_get_margin_width")]
		public unowned string get_margin_width ();
		[CCode (cname = "webkit_htmli_frame_element_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_htmli_frame_element_get_scrolling")]
		public unowned string get_scrolling ();
		[CCode (cname = "webkit_htmli_frame_element_get_width")]
		public unowned string get_width ();
		[CCode (cname = "webkit_htmli_frame_element_set_align")]
		public void set_align (string value);
		[CCode (cname = "webkit_htmli_frame_element_set_frame_border")]
		public void set_frame_border (string value);
		[CCode (cname = "webkit_htmli_frame_element_set_height")]
		public void set_height (string value);
		[CCode (cname = "webkit_htmli_frame_element_set_long_desc")]
		public void set_long_desc (string value);
		[CCode (cname = "webkit_htmli_frame_element_set_margin_height")]
		public void set_margin_height (string value);
		[CCode (cname = "webkit_htmli_frame_element_set_margin_width")]
		public void set_margin_width (string value);
		[CCode (cname = "webkit_htmli_frame_element_set_name")]
		public void set_name (string value);
		[CCode (cname = "webkit_htmli_frame_element_set_scrolling")]
		public void set_scrolling (string value);
		[CCode (cname = "webkit_htmli_frame_element_set_width")]
		public void set_width (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLIFrameElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLImageElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_image_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_html_image_element_get_alt")]
		public unowned string get_alt ();
		[CCode (cname = "webkit_html_image_element_get_border")]
		public unowned string get_border ();
		[CCode (cname = "webkit_html_image_element_get_complete")]
		public bool get_complete ();
		[CCode (cname = "webkit_html_image_element_get_height")]
		public long get_height ();
		[CCode (cname = "webkit_html_image_element_get_hspace")]
		public long get_hspace ();
		[CCode (cname = "webkit_html_image_element_get_is_map")]
		public bool get_is_map ();
		[CCode (cname = "webkit_html_image_element_get_long_desc")]
		public unowned string get_long_desc ();
		[CCode (cname = "webkit_html_image_element_get_lowsrc")]
		public unowned string get_lowsrc ();
		[CCode (cname = "webkit_html_image_element_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_html_image_element_get_natural_height")]
		public long get_natural_height ();
		[CCode (cname = "webkit_html_image_element_get_natural_width")]
		public long get_natural_width ();
		[CCode (cname = "webkit_html_image_element_get_src")]
		public unowned string get_src ();
		[CCode (cname = "webkit_html_image_element_get_use_map")]
		public unowned string get_use_map ();
		[CCode (cname = "webkit_html_image_element_get_vspace")]
		public long get_vspace ();
		[CCode (cname = "webkit_html_image_element_get_width")]
		public long get_width ();
		[CCode (cname = "webkit_html_image_element_get_x")]
		public long get_x ();
		[CCode (cname = "webkit_html_image_element_get_y")]
		public long get_y ();
		[CCode (cname = "webkit_html_image_element_set_align")]
		public void set_align (string value);
		[CCode (cname = "webkit_html_image_element_set_alt")]
		public void set_alt (string value);
		[CCode (cname = "webkit_html_image_element_set_border")]
		public void set_border (string value);
		[CCode (cname = "webkit_html_image_element_set_height")]
		public void set_height (long value);
		[CCode (cname = "webkit_html_image_element_set_hspace")]
		public void set_hspace (long value);
		[CCode (cname = "webkit_html_image_element_set_is_map")]
		public void set_is_map (bool value);
		[CCode (cname = "webkit_html_image_element_set_long_desc")]
		public void set_long_desc (string value);
		[CCode (cname = "webkit_html_image_element_set_lowsrc")]
		public void set_lowsrc (string value);
		[CCode (cname = "webkit_html_image_element_set_name")]
		public void set_name (string value);
		[CCode (cname = "webkit_html_image_element_set_src")]
		public void set_src (string value);
		[CCode (cname = "webkit_html_image_element_set_use_map")]
		public void set_use_map (string value);
		[CCode (cname = "webkit_html_image_element_set_vspace")]
		public void set_vspace (long value);
		[CCode (cname = "webkit_html_image_element_set_width")]
		public void set_width (long value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLImageElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLInputElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_input_element_click")]
		public void click ();
		[CCode (cname = "webkit_html_input_element_get_accept")]
		public unowned string get_accept ();
		[CCode (cname = "webkit_html_input_element_get_access_key")]
		public unowned string get_access_key ();
		[CCode (cname = "webkit_html_input_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_html_input_element_get_alt")]
		public unowned string get_alt ();
		[CCode (cname = "webkit_html_input_element_get_autofocus")]
		public bool get_autofocus ();
		[CCode (cname = "webkit_html_input_element_get_checked")]
		public bool get_checked ();
		[CCode (cname = "webkit_html_input_element_get_default_checked")]
		public bool get_default_checked ();
		[CCode (cname = "webkit_html_input_element_get_default_value")]
		public unowned string get_default_value ();
		[CCode (cname = "webkit_html_input_element_get_disabled")]
		public bool get_disabled ();
		[CCode (cname = "webkit_html_input_element_get_files")]
		public unowned WebKit.FileList get_files ();
		[CCode (cname = "webkit_html_input_element_get_form")]
		public unowned WebKit.HTMLFormElement get_form ();
		[CCode (cname = "webkit_html_input_element_get_indeterminate")]
		public bool get_indeterminate ();
		[CCode (cname = "webkit_html_input_element_get_max_length")]
		public long get_max_length ();
		[CCode (cname = "webkit_html_input_element_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_html_input_element_get_read_only")]
		public bool get_read_only ();
		[CCode (cname = "webkit_html_input_element_get_size")]
		public ulong get_size ();
		[CCode (cname = "webkit_html_input_element_get_src")]
		public unowned string get_src ();
		[CCode (cname = "webkit_html_input_element_get_use_map")]
		public unowned string get_use_map ();
		[CCode (cname = "webkit_html_input_element_get_value")]
		public unowned string get_value ();
		[CCode (cname = "webkit_html_input_element_get_will_validate")]
		public bool get_will_validate ();
		[CCode (cname = "webkit_html_input_element_select")]
		public void select ();
		[CCode (cname = "webkit_html_input_element_set_accept")]
		public void set_accept (string value);
		[CCode (cname = "webkit_html_input_element_set_access_key")]
		public void set_access_key (string value);
		[CCode (cname = "webkit_html_input_element_set_align")]
		public void set_align (string value);
		[CCode (cname = "webkit_html_input_element_set_alt")]
		public void set_alt (string value);
		[CCode (cname = "webkit_html_input_element_set_autofocus")]
		public void set_autofocus (bool value);
		[CCode (cname = "webkit_html_input_element_set_checked")]
		public void set_checked (bool value);
		[CCode (cname = "webkit_html_input_element_set_default_checked")]
		public void set_default_checked (bool value);
		[CCode (cname = "webkit_html_input_element_set_default_value")]
		public void set_default_value (string value);
		[CCode (cname = "webkit_html_input_element_set_disabled")]
		public void set_disabled (bool value);
		[CCode (cname = "webkit_html_input_element_set_indeterminate")]
		public void set_indeterminate (bool value);
		[CCode (cname = "webkit_html_input_element_set_max_length")]
		public void set_max_length (long value);
		[CCode (cname = "webkit_html_input_element_set_name")]
		public void set_name (string value);
		[CCode (cname = "webkit_html_input_element_set_read_only")]
		public void set_read_only (bool value);
		[CCode (cname = "webkit_html_input_element_set_size")]
		public void set_size (ulong value);
		[CCode (cname = "webkit_html_input_element_set_src")]
		public void set_src (string value);
		[CCode (cname = "webkit_html_input_element_set_use_map")]
		public void set_use_map (string value);
		[CCode (cname = "webkit_html_input_element_set_value")]
		public void set_value (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLInputElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLIsIndexElement {
		public weak WebKit.HTMLInputElement parent_instance;
		[CCode (cname = "webkit_html_is_index_element_get_form")]
		public unowned WebKit.HTMLFormElement get_form ();
		[CCode (cname = "webkit_html_is_index_element_get_prompt")]
		public unowned string get_prompt ();
		[CCode (cname = "webkit_html_is_index_element_set_prompt")]
		public void set_prompt (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLIsIndexElementClass {
		public weak WebKit.HTMLInputElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLLIElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_htmlli_element_get_value")]
		public long get_value ();
		[CCode (cname = "webkit_htmlli_element_set_value")]
		public void set_value (long value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLLIElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLLabelElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_label_element_get_access_key")]
		public unowned string get_access_key ();
		[CCode (cname = "webkit_html_label_element_get_form")]
		public unowned WebKit.HTMLFormElement get_form ();
		[CCode (cname = "webkit_html_label_element_get_html_for")]
		public unowned string get_html_for ();
		[CCode (cname = "webkit_html_label_element_set_access_key")]
		public void set_access_key (string value);
		[CCode (cname = "webkit_html_label_element_set_html_for")]
		public void set_html_for (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLLabelElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLLegendElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_legend_element_get_access_key")]
		public unowned string get_access_key ();
		[CCode (cname = "webkit_html_legend_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_html_legend_element_get_form")]
		public unowned WebKit.HTMLFormElement get_form ();
		[CCode (cname = "webkit_html_legend_element_set_access_key")]
		public void set_access_key (string value);
		[CCode (cname = "webkit_html_legend_element_set_align")]
		public void set_align (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLLegendElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLLinkElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_link_element_get_charset")]
		public unowned string get_charset ();
		[CCode (cname = "webkit_html_link_element_get_disabled")]
		public bool get_disabled ();
		[CCode (cname = "webkit_html_link_element_get_href")]
		public unowned string get_href ();
		[CCode (cname = "webkit_html_link_element_get_hreflang")]
		public unowned string get_hreflang ();
		[CCode (cname = "webkit_html_link_element_get_media")]
		public unowned string get_media ();
		[CCode (cname = "webkit_html_link_element_get_rel")]
		public unowned string get_rel ();
		[CCode (cname = "webkit_html_link_element_get_rev")]
		public unowned string get_rev ();
		[CCode (cname = "webkit_html_link_element_get_sheet")]
		public unowned WebKit.StyleSheet get_sheet ();
		[CCode (cname = "webkit_html_link_element_get_target")]
		public unowned string get_target ();
		[CCode (cname = "webkit_html_link_element_set_charset")]
		public void set_charset (string value);
		[CCode (cname = "webkit_html_link_element_set_disabled")]
		public void set_disabled (bool value);
		[CCode (cname = "webkit_html_link_element_set_href")]
		public void set_href (string value);
		[CCode (cname = "webkit_html_link_element_set_hreflang")]
		public void set_hreflang (string value);
		[CCode (cname = "webkit_html_link_element_set_media")]
		public void set_media (string value);
		[CCode (cname = "webkit_html_link_element_set_rel")]
		public void set_rel (string value);
		[CCode (cname = "webkit_html_link_element_set_rev")]
		public void set_rev (string value);
		[CCode (cname = "webkit_html_link_element_set_target")]
		public void set_target (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLLinkElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLMapElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_map_element_get_areas")]
		public unowned WebKit.HTMLCollection get_areas ();
		[CCode (cname = "webkit_html_map_element_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_html_map_element_set_name")]
		public void set_name (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLMapElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLMarqueeElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_marquee_element_start")]
		public void start ();
		[CCode (cname = "webkit_html_marquee_element_stop")]
		public void stop ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLMarqueeElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLMediaElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_media_element_get_autoplay")]
		public bool get_autoplay ();
		[CCode (cname = "webkit_html_media_element_get_buffered")]
		public unowned WebKit.TimeRanges get_buffered ();
		[CCode (cname = "webkit_html_media_element_get_buffering_rate")]
		public float get_buffering_rate ();
		[CCode (cname = "webkit_html_media_element_get_controls")]
		public bool get_controls ();
		[CCode (cname = "webkit_html_media_element_get_current_loop")]
		public ulong get_current_loop ();
		[CCode (cname = "webkit_html_media_element_get_current_src")]
		public unowned string get_current_src ();
		[CCode (cname = "webkit_html_media_element_get_current_time")]
		public float get_current_time ();
		[CCode (cname = "webkit_html_media_element_get_default_playback_rate")]
		public float get_default_playback_rate ();
		[CCode (cname = "webkit_html_media_element_get_duration")]
		public float get_duration ();
		[CCode (cname = "webkit_html_media_element_get_end")]
		public float get_end ();
		[CCode (cname = "webkit_html_media_element_get_ended")]
		public bool get_ended ();
		[CCode (cname = "webkit_html_media_element_get_error")]
		public unowned WebKit.MediaError get_error ();
		[CCode (cname = "webkit_html_media_element_get_loop_end")]
		public float get_loop_end ();
		[CCode (cname = "webkit_html_media_element_get_loop_start")]
		public float get_loop_start ();
		[CCode (cname = "webkit_html_media_element_get_muted")]
		public bool get_muted ();
		[CCode (cname = "webkit_html_media_element_get_network_state")]
		public ushort get_network_state ();
		[CCode (cname = "webkit_html_media_element_get_paused")]
		public bool get_paused ();
		[CCode (cname = "webkit_html_media_element_get_play_count")]
		public ulong get_play_count ();
		[CCode (cname = "webkit_html_media_element_get_playback_rate")]
		public float get_playback_rate ();
		[CCode (cname = "webkit_html_media_element_get_played")]
		public unowned WebKit.TimeRanges get_played ();
		[CCode (cname = "webkit_html_media_element_get_ready_state")]
		public ushort get_ready_state ();
		[CCode (cname = "webkit_html_media_element_get_seekable")]
		public unowned WebKit.TimeRanges get_seekable ();
		[CCode (cname = "webkit_html_media_element_get_seeking")]
		public bool get_seeking ();
		[CCode (cname = "webkit_html_media_element_get_src")]
		public unowned string get_src ();
		[CCode (cname = "webkit_html_media_element_get_start")]
		public float get_start ();
		[CCode (cname = "webkit_html_media_element_get_volume")]
		public float get_volume ();
		[CCode (cname = "webkit_html_media_element_load")]
		public void load () throws GLib.Error;
		[CCode (cname = "webkit_html_media_element_pause")]
		public void pause () throws GLib.Error;
		[CCode (cname = "webkit_html_media_element_play")]
		public void play () throws GLib.Error;
		[CCode (cname = "webkit_html_media_element_set_autoplay")]
		public void set_autoplay (bool value);
		[CCode (cname = "webkit_html_media_element_set_controls")]
		public void set_controls (bool value);
		[CCode (cname = "webkit_html_media_element_set_current_loop")]
		public void set_current_loop (ulong value);
		[CCode (cname = "webkit_html_media_element_set_current_time")]
		public void set_current_time (float value) throws GLib.Error;
		[CCode (cname = "webkit_html_media_element_set_default_playback_rate")]
		public void set_default_playback_rate (float value) throws GLib.Error;
		[CCode (cname = "webkit_html_media_element_set_end")]
		public void set_end (float value);
		[CCode (cname = "webkit_html_media_element_set_loop_end")]
		public void set_loop_end (float value);
		[CCode (cname = "webkit_html_media_element_set_loop_start")]
		public void set_loop_start (float value);
		[CCode (cname = "webkit_html_media_element_set_muted")]
		public void set_muted (bool value);
		[CCode (cname = "webkit_html_media_element_set_play_count")]
		public void set_play_count (ulong value) throws GLib.Error;
		[CCode (cname = "webkit_html_media_element_set_playback_rate")]
		public void set_playback_rate (float value) throws GLib.Error;
		[CCode (cname = "webkit_html_media_element_set_src")]
		public void set_src (string value);
		[CCode (cname = "webkit_html_media_element_set_start")]
		public void set_start (float value);
		[CCode (cname = "webkit_html_media_element_set_volume")]
		public void set_volume (float value) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLMediaElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLMenuElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_menu_element_get_compact")]
		public bool get_compact ();
		[CCode (cname = "webkit_html_menu_element_set_compact")]
		public void set_compact (bool value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLMenuElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLMetaElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_meta_element_get_content")]
		public unowned string get_content ();
		[CCode (cname = "webkit_html_meta_element_get_http_equiv")]
		public unowned string get_http_equiv ();
		[CCode (cname = "webkit_html_meta_element_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_html_meta_element_get_scheme")]
		public unowned string get_scheme ();
		[CCode (cname = "webkit_html_meta_element_set_content")]
		public void set_content (string value);
		[CCode (cname = "webkit_html_meta_element_set_http_equiv")]
		public void set_http_equiv (string value);
		[CCode (cname = "webkit_html_meta_element_set_name")]
		public void set_name (string value);
		[CCode (cname = "webkit_html_meta_element_set_scheme")]
		public void set_scheme (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLMetaElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLModElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_mod_element_get_cite")]
		public unowned string get_cite ();
		[CCode (cname = "webkit_html_mod_element_get_date_time")]
		public unowned string get_date_time ();
		[CCode (cname = "webkit_html_mod_element_set_cite")]
		public void set_cite (string value);
		[CCode (cname = "webkit_html_mod_element_set_date_time")]
		public void set_date_time (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLModElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLOListElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_htmlo_list_element_get_compact")]
		public bool get_compact ();
		[CCode (cname = "webkit_htmlo_list_element_get_start")]
		public long get_start ();
		[CCode (cname = "webkit_htmlo_list_element_set_compact")]
		public void set_compact (bool value);
		[CCode (cname = "webkit_htmlo_list_element_set_start")]
		public void set_start (long value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLOListElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLObjectElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_object_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_html_object_element_get_archive")]
		public unowned string get_archive ();
		[CCode (cname = "webkit_html_object_element_get_border")]
		public unowned string get_border ();
		[CCode (cname = "webkit_html_object_element_get_code")]
		public unowned string get_code ();
		[CCode (cname = "webkit_html_object_element_get_code_base")]
		public unowned string get_code_base ();
		[CCode (cname = "webkit_html_object_element_get_code_type")]
		public unowned string get_code_type ();
		[CCode (cname = "webkit_html_object_element_get_content_document")]
		public unowned WebKit.Document get_content_document ();
		[CCode (cname = "webkit_html_object_element_get_data")]
		public unowned string get_data ();
		[CCode (cname = "webkit_html_object_element_get_declare")]
		public bool get_declare ();
		[CCode (cname = "webkit_html_object_element_get_form")]
		public unowned WebKit.HTMLFormElement get_form ();
		[CCode (cname = "webkit_html_object_element_get_height")]
		public unowned string get_height ();
		[CCode (cname = "webkit_html_object_element_get_hspace")]
		public long get_hspace ();
		[CCode (cname = "webkit_html_object_element_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_html_object_element_get_standby")]
		public unowned string get_standby ();
		[CCode (cname = "webkit_html_object_element_get_use_map")]
		public unowned string get_use_map ();
		[CCode (cname = "webkit_html_object_element_get_vspace")]
		public long get_vspace ();
		[CCode (cname = "webkit_html_object_element_get_width")]
		public unowned string get_width ();
		[CCode (cname = "webkit_html_object_element_set_align")]
		public void set_align (string value);
		[CCode (cname = "webkit_html_object_element_set_archive")]
		public void set_archive (string value);
		[CCode (cname = "webkit_html_object_element_set_border")]
		public void set_border (string value);
		[CCode (cname = "webkit_html_object_element_set_code")]
		public void set_code (string value);
		[CCode (cname = "webkit_html_object_element_set_code_base")]
		public void set_code_base (string value);
		[CCode (cname = "webkit_html_object_element_set_code_type")]
		public void set_code_type (string value);
		[CCode (cname = "webkit_html_object_element_set_data")]
		public void set_data (string value);
		[CCode (cname = "webkit_html_object_element_set_declare")]
		public void set_declare (bool value);
		[CCode (cname = "webkit_html_object_element_set_height")]
		public void set_height (string value);
		[CCode (cname = "webkit_html_object_element_set_hspace")]
		public void set_hspace (long value);
		[CCode (cname = "webkit_html_object_element_set_name")]
		public void set_name (string value);
		[CCode (cname = "webkit_html_object_element_set_standby")]
		public void set_standby (string value);
		[CCode (cname = "webkit_html_object_element_set_use_map")]
		public void set_use_map (string value);
		[CCode (cname = "webkit_html_object_element_set_vspace")]
		public void set_vspace (long value);
		[CCode (cname = "webkit_html_object_element_set_width")]
		public void set_width (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLObjectElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLOptGroupElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_opt_group_element_get_disabled")]
		public bool get_disabled ();
		[CCode (cname = "webkit_html_opt_group_element_get_label")]
		public unowned string get_label ();
		[CCode (cname = "webkit_html_opt_group_element_set_disabled")]
		public void set_disabled (bool value);
		[CCode (cname = "webkit_html_opt_group_element_set_label")]
		public void set_label (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLOptGroupElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLOptionElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_option_element_get_default_selected")]
		public bool get_default_selected ();
		[CCode (cname = "webkit_html_option_element_get_disabled")]
		public bool get_disabled ();
		[CCode (cname = "webkit_html_option_element_get_form")]
		public unowned WebKit.HTMLFormElement get_form ();
		[CCode (cname = "webkit_html_option_element_get_index")]
		public long get_index ();
		[CCode (cname = "webkit_html_option_element_get_label")]
		public unowned string get_label ();
		[CCode (cname = "webkit_html_option_element_get_selected")]
		public bool get_selected ();
		[CCode (cname = "webkit_html_option_element_get_text")]
		public unowned string get_text ();
		[CCode (cname = "webkit_html_option_element_get_value")]
		public unowned string get_value ();
		[CCode (cname = "webkit_html_option_element_set_default_selected")]
		public void set_default_selected (bool value);
		[CCode (cname = "webkit_html_option_element_set_disabled")]
		public void set_disabled (bool value);
		[CCode (cname = "webkit_html_option_element_set_label")]
		public void set_label (string value);
		[CCode (cname = "webkit_html_option_element_set_selected")]
		public void set_selected (bool value);
		[CCode (cname = "webkit_html_option_element_set_value")]
		public void set_value (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLOptionElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLOptionsCollection {
		public weak WebKit.HTMLCollection parent_instance;
		[CCode (cname = "webkit_html_options_collection_get_selected_index")]
		public long get_selected_index ();
		[CCode (cname = "webkit_html_options_collection_item")]
		public unowned WebKit.Node item (ulong index);
		[CCode (cname = "webkit_html_options_collection_named_item")]
		public unowned WebKit.Node named_item (string name);
		[CCode (cname = "webkit_html_options_collection_set_selected_index")]
		public void set_selected_index (long value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLOptionsCollectionClass {
		public weak WebKit.HTMLCollectionClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLParagraphElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_paragraph_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_html_paragraph_element_set_align")]
		public void set_align (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLParagraphElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLParamElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_param_element_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_html_param_element_get_value")]
		public unowned string get_value ();
		[CCode (cname = "webkit_html_param_element_get_value_type")]
		public unowned string get_value_type ();
		[CCode (cname = "webkit_html_param_element_set_name")]
		public void set_name (string value);
		[CCode (cname = "webkit_html_param_element_set_value")]
		public void set_value (string value);
		[CCode (cname = "webkit_html_param_element_set_value_type")]
		public void set_value_type (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLParamElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLPreElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_pre_element_get_width")]
		public long get_width ();
		[CCode (cname = "webkit_html_pre_element_get_wrap")]
		public bool get_wrap ();
		[CCode (cname = "webkit_html_pre_element_set_width")]
		public void set_width (long value);
		[CCode (cname = "webkit_html_pre_element_set_wrap")]
		public void set_wrap (bool value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLPreElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLQuoteElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_quote_element_get_cite")]
		public unowned string get_cite ();
		[CCode (cname = "webkit_html_quote_element_set_cite")]
		public void set_cite (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLQuoteElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLScriptElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_script_element_get_charset")]
		public unowned string get_charset ();
		[CCode (cname = "webkit_html_script_element_get_defer")]
		public bool get_defer ();
		[CCode (cname = "webkit_html_script_element_get_event")]
		public unowned string get_event ();
		[CCode (cname = "webkit_html_script_element_get_html_for")]
		public unowned string get_html_for ();
		[CCode (cname = "webkit_html_script_element_get_src")]
		public unowned string get_src ();
		[CCode (cname = "webkit_html_script_element_get_text")]
		public unowned string get_text ();
		[CCode (cname = "webkit_html_script_element_set_charset")]
		public void set_charset (string value);
		[CCode (cname = "webkit_html_script_element_set_defer")]
		public void set_defer (bool value);
		[CCode (cname = "webkit_html_script_element_set_event")]
		public void set_event (string value);
		[CCode (cname = "webkit_html_script_element_set_html_for")]
		public void set_html_for (string value);
		[CCode (cname = "webkit_html_script_element_set_src")]
		public void set_src (string value);
		[CCode (cname = "webkit_html_script_element_set_text")]
		public void set_text (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLScriptElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLSelectElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_select_element_add")]
		public void add (WebKit.HTMLElement element2, WebKit.HTMLElement before) throws GLib.Error;
		[CCode (cname = "webkit_html_select_element_get_autofocus")]
		public bool get_autofocus ();
		[CCode (cname = "webkit_html_select_element_get_disabled")]
		public bool get_disabled ();
		[CCode (cname = "webkit_html_select_element_get_form")]
		public unowned WebKit.HTMLFormElement get_form ();
		[CCode (cname = "webkit_html_select_element_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_html_select_element_get_multiple")]
		public bool get_multiple ();
		[CCode (cname = "webkit_html_select_element_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_html_select_element_get_options")]
		public unowned WebKit.HTMLOptionsCollection get_options ();
		[CCode (cname = "webkit_html_select_element_get_selected_index")]
		public long get_selected_index ();
		[CCode (cname = "webkit_html_select_element_get_size")]
		public long get_size ();
		[CCode (cname = "webkit_html_select_element_get_value")]
		public unowned string get_value ();
		[CCode (cname = "webkit_html_select_element_get_will_validate")]
		public bool get_will_validate ();
		[CCode (cname = "webkit_html_select_element_item")]
		public unowned WebKit.Node item (ulong index);
		[CCode (cname = "webkit_html_select_element_named_item")]
		public unowned WebKit.Node named_item (string name);
		[CCode (cname = "webkit_html_select_element_remove")]
		public void remove (long index);
		[CCode (cname = "webkit_html_select_element_set_autofocus")]
		public void set_autofocus (bool value);
		[CCode (cname = "webkit_html_select_element_set_disabled")]
		public void set_disabled (bool value);
		[CCode (cname = "webkit_html_select_element_set_length")]
		public void set_length (ulong value) throws GLib.Error;
		[CCode (cname = "webkit_html_select_element_set_multiple")]
		public void set_multiple (bool value);
		[CCode (cname = "webkit_html_select_element_set_name")]
		public void set_name (string value);
		[CCode (cname = "webkit_html_select_element_set_selected_index")]
		public void set_selected_index (long value);
		[CCode (cname = "webkit_html_select_element_set_size")]
		public void set_size (long value);
		[CCode (cname = "webkit_html_select_element_set_value")]
		public void set_value (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLSelectElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLSourceElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_source_element_get_media")]
		public unowned string get_media ();
		[CCode (cname = "webkit_html_source_element_get_src")]
		public unowned string get_src ();
		[CCode (cname = "webkit_html_source_element_set_media")]
		public void set_media (string value);
		[CCode (cname = "webkit_html_source_element_set_src")]
		public void set_src (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLSourceElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLStyleElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_style_element_get_disabled")]
		public bool get_disabled ();
		[CCode (cname = "webkit_html_style_element_get_media")]
		public unowned string get_media ();
		[CCode (cname = "webkit_html_style_element_get_sheet")]
		public unowned WebKit.StyleSheet get_sheet ();
		[CCode (cname = "webkit_html_style_element_set_disabled")]
		public void set_disabled (bool value);
		[CCode (cname = "webkit_html_style_element_set_media")]
		public void set_media (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLStyleElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLTableCaptionElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_table_caption_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_html_table_caption_element_set_align")]
		public void set_align (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLTableCaptionElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLTableCellElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_table_cell_element_get_abbr")]
		public unowned string get_abbr ();
		[CCode (cname = "webkit_html_table_cell_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_html_table_cell_element_get_axis")]
		public unowned string get_axis ();
		[CCode (cname = "webkit_html_table_cell_element_get_bg_color")]
		public unowned string get_bg_color ();
		[CCode (cname = "webkit_html_table_cell_element_get_cell_index")]
		public long get_cell_index ();
		[CCode (cname = "webkit_html_table_cell_element_get_ch")]
		public unowned string get_ch ();
		[CCode (cname = "webkit_html_table_cell_element_get_ch_off")]
		public unowned string get_ch_off ();
		[CCode (cname = "webkit_html_table_cell_element_get_col_span")]
		public long get_col_span ();
		[CCode (cname = "webkit_html_table_cell_element_get_headers")]
		public unowned string get_headers ();
		[CCode (cname = "webkit_html_table_cell_element_get_height")]
		public unowned string get_height ();
		[CCode (cname = "webkit_html_table_cell_element_get_no_wrap")]
		public bool get_no_wrap ();
		[CCode (cname = "webkit_html_table_cell_element_get_row_span")]
		public long get_row_span ();
		[CCode (cname = "webkit_html_table_cell_element_get_scope")]
		public unowned string get_scope ();
		[CCode (cname = "webkit_html_table_cell_element_get_v_align")]
		public unowned string get_v_align ();
		[CCode (cname = "webkit_html_table_cell_element_get_width")]
		public unowned string get_width ();
		[CCode (cname = "webkit_html_table_cell_element_set_abbr")]
		public void set_abbr (string value);
		[CCode (cname = "webkit_html_table_cell_element_set_align")]
		public void set_align (string value);
		[CCode (cname = "webkit_html_table_cell_element_set_axis")]
		public void set_axis (string value);
		[CCode (cname = "webkit_html_table_cell_element_set_bg_color")]
		public void set_bg_color (string value);
		[CCode (cname = "webkit_html_table_cell_element_set_ch")]
		public void set_ch (string value);
		[CCode (cname = "webkit_html_table_cell_element_set_ch_off")]
		public void set_ch_off (string value);
		[CCode (cname = "webkit_html_table_cell_element_set_col_span")]
		public void set_col_span (long value);
		[CCode (cname = "webkit_html_table_cell_element_set_headers")]
		public void set_headers (string value);
		[CCode (cname = "webkit_html_table_cell_element_set_height")]
		public void set_height (string value);
		[CCode (cname = "webkit_html_table_cell_element_set_no_wrap")]
		public void set_no_wrap (bool value);
		[CCode (cname = "webkit_html_table_cell_element_set_row_span")]
		public void set_row_span (long value);
		[CCode (cname = "webkit_html_table_cell_element_set_scope")]
		public void set_scope (string value);
		[CCode (cname = "webkit_html_table_cell_element_set_v_align")]
		public void set_v_align (string value);
		[CCode (cname = "webkit_html_table_cell_element_set_width")]
		public void set_width (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLTableCellElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLTableColElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_table_col_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_html_table_col_element_get_ch")]
		public unowned string get_ch ();
		[CCode (cname = "webkit_html_table_col_element_get_ch_off")]
		public unowned string get_ch_off ();
		[CCode (cname = "webkit_html_table_col_element_get_span")]
		public long get_span ();
		[CCode (cname = "webkit_html_table_col_element_get_v_align")]
		public unowned string get_v_align ();
		[CCode (cname = "webkit_html_table_col_element_get_width")]
		public unowned string get_width ();
		[CCode (cname = "webkit_html_table_col_element_set_align")]
		public void set_align (string value);
		[CCode (cname = "webkit_html_table_col_element_set_ch")]
		public void set_ch (string value);
		[CCode (cname = "webkit_html_table_col_element_set_ch_off")]
		public void set_ch_off (string value);
		[CCode (cname = "webkit_html_table_col_element_set_span")]
		public void set_span (long value);
		[CCode (cname = "webkit_html_table_col_element_set_v_align")]
		public void set_v_align (string value);
		[CCode (cname = "webkit_html_table_col_element_set_width")]
		public void set_width (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLTableColElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLTableElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_table_element_create_caption")]
		public unowned WebKit.HTMLElement create_caption ();
		[CCode (cname = "webkit_html_table_element_create_t_foot")]
		public unowned WebKit.HTMLElement create_t_foot ();
		[CCode (cname = "webkit_html_table_element_create_t_head")]
		public unowned WebKit.HTMLElement create_t_head ();
		[CCode (cname = "webkit_html_table_element_delete_caption")]
		public void delete_caption ();
		[CCode (cname = "webkit_html_table_element_delete_row")]
		public void delete_row (long index) throws GLib.Error;
		[CCode (cname = "webkit_html_table_element_delete_t_foot")]
		public void delete_t_foot ();
		[CCode (cname = "webkit_html_table_element_delete_t_head")]
		public void delete_t_head ();
		[CCode (cname = "webkit_html_table_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_html_table_element_get_bg_color")]
		public unowned string get_bg_color ();
		[CCode (cname = "webkit_html_table_element_get_border")]
		public unowned string get_border ();
		[CCode (cname = "webkit_html_table_element_get_caption")]
		public unowned WebKit.HTMLTableCaptionElement get_caption ();
		[CCode (cname = "webkit_html_table_element_get_cell_padding")]
		public unowned string get_cell_padding ();
		[CCode (cname = "webkit_html_table_element_get_cell_spacing")]
		public unowned string get_cell_spacing ();
		[CCode (cname = "webkit_html_table_element_get_frame")]
		public unowned string get_frame ();
		[CCode (cname = "webkit_html_table_element_get_rows")]
		public unowned WebKit.HTMLCollection get_rows ();
		[CCode (cname = "webkit_html_table_element_get_rules")]
		public unowned string get_rules ();
		[CCode (cname = "webkit_html_table_element_get_summary")]
		public unowned string get_summary ();
		[CCode (cname = "webkit_html_table_element_get_t_bodies")]
		public unowned WebKit.HTMLCollection get_t_bodies ();
		[CCode (cname = "webkit_html_table_element_get_t_foot")]
		public unowned WebKit.HTMLTableSectionElement get_t_foot ();
		[CCode (cname = "webkit_html_table_element_get_t_head")]
		public unowned WebKit.HTMLTableSectionElement get_t_head ();
		[CCode (cname = "webkit_html_table_element_get_width")]
		public unowned string get_width ();
		[CCode (cname = "webkit_html_table_element_insert_row")]
		public unowned WebKit.HTMLElement insert_row (long index) throws GLib.Error;
		[CCode (cname = "webkit_html_table_element_set_align")]
		public void set_align (string value);
		[CCode (cname = "webkit_html_table_element_set_bg_color")]
		public void set_bg_color (string value);
		[CCode (cname = "webkit_html_table_element_set_border")]
		public void set_border (string value);
		[CCode (cname = "webkit_html_table_element_set_caption")]
		public void set_caption (WebKit.HTMLTableCaptionElement value) throws GLib.Error;
		[CCode (cname = "webkit_html_table_element_set_cell_padding")]
		public void set_cell_padding (string value);
		[CCode (cname = "webkit_html_table_element_set_cell_spacing")]
		public void set_cell_spacing (string value);
		[CCode (cname = "webkit_html_table_element_set_frame")]
		public void set_frame (string value);
		[CCode (cname = "webkit_html_table_element_set_rules")]
		public void set_rules (string value);
		[CCode (cname = "webkit_html_table_element_set_summary")]
		public void set_summary (string value);
		[CCode (cname = "webkit_html_table_element_set_t_foot")]
		public void set_t_foot (WebKit.HTMLTableSectionElement value) throws GLib.Error;
		[CCode (cname = "webkit_html_table_element_set_t_head")]
		public void set_t_head (WebKit.HTMLTableSectionElement value) throws GLib.Error;
		[CCode (cname = "webkit_html_table_element_set_width")]
		public void set_width (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLTableElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLTableRowElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_table_row_element_delete_cell")]
		public void delete_cell (long index) throws GLib.Error;
		[CCode (cname = "webkit_html_table_row_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_html_table_row_element_get_bg_color")]
		public unowned string get_bg_color ();
		[CCode (cname = "webkit_html_table_row_element_get_cells")]
		public unowned WebKit.HTMLCollection get_cells ();
		[CCode (cname = "webkit_html_table_row_element_get_ch")]
		public unowned string get_ch ();
		[CCode (cname = "webkit_html_table_row_element_get_ch_off")]
		public unowned string get_ch_off ();
		[CCode (cname = "webkit_html_table_row_element_get_row_index")]
		public long get_row_index ();
		[CCode (cname = "webkit_html_table_row_element_get_section_row_index")]
		public long get_section_row_index ();
		[CCode (cname = "webkit_html_table_row_element_get_v_align")]
		public unowned string get_v_align ();
		[CCode (cname = "webkit_html_table_row_element_insert_cell")]
		public unowned WebKit.HTMLElement insert_cell (long index) throws GLib.Error;
		[CCode (cname = "webkit_html_table_row_element_set_align")]
		public void set_align (string value);
		[CCode (cname = "webkit_html_table_row_element_set_bg_color")]
		public void set_bg_color (string value);
		[CCode (cname = "webkit_html_table_row_element_set_ch")]
		public void set_ch (string value);
		[CCode (cname = "webkit_html_table_row_element_set_ch_off")]
		public void set_ch_off (string value);
		[CCode (cname = "webkit_html_table_row_element_set_v_align")]
		public void set_v_align (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLTableRowElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLTableSectionElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_table_section_element_delete_row")]
		public void delete_row (long index) throws GLib.Error;
		[CCode (cname = "webkit_html_table_section_element_get_align")]
		public unowned string get_align ();
		[CCode (cname = "webkit_html_table_section_element_get_ch")]
		public unowned string get_ch ();
		[CCode (cname = "webkit_html_table_section_element_get_ch_off")]
		public unowned string get_ch_off ();
		[CCode (cname = "webkit_html_table_section_element_get_rows")]
		public unowned WebKit.HTMLCollection get_rows ();
		[CCode (cname = "webkit_html_table_section_element_get_v_align")]
		public unowned string get_v_align ();
		[CCode (cname = "webkit_html_table_section_element_insert_row")]
		public unowned WebKit.HTMLElement insert_row (long index) throws GLib.Error;
		[CCode (cname = "webkit_html_table_section_element_set_align")]
		public void set_align (string value);
		[CCode (cname = "webkit_html_table_section_element_set_ch")]
		public void set_ch (string value);
		[CCode (cname = "webkit_html_table_section_element_set_ch_off")]
		public void set_ch_off (string value);
		[CCode (cname = "webkit_html_table_section_element_set_v_align")]
		public void set_v_align (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLTableSectionElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLTextAreaElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_text_area_element_get_access_key")]
		public unowned string get_access_key ();
		[CCode (cname = "webkit_html_text_area_element_get_autofocus")]
		public bool get_autofocus ();
		[CCode (cname = "webkit_html_text_area_element_get_cols")]
		public long get_cols ();
		[CCode (cname = "webkit_html_text_area_element_get_default_value")]
		public unowned string get_default_value ();
		[CCode (cname = "webkit_html_text_area_element_get_disabled")]
		public bool get_disabled ();
		[CCode (cname = "webkit_html_text_area_element_get_form")]
		public unowned WebKit.HTMLFormElement get_form ();
		[CCode (cname = "webkit_html_text_area_element_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_html_text_area_element_get_read_only")]
		public bool get_read_only ();
		[CCode (cname = "webkit_html_text_area_element_get_rows")]
		public long get_rows ();
		[CCode (cname = "webkit_html_text_area_element_get_selection_end")]
		public long get_selection_end ();
		[CCode (cname = "webkit_html_text_area_element_get_selection_start")]
		public long get_selection_start ();
		[CCode (cname = "webkit_html_text_area_element_get_value")]
		public unowned string get_value ();
		[CCode (cname = "webkit_html_text_area_element_get_will_validate")]
		public bool get_will_validate ();
		[CCode (cname = "webkit_html_text_area_element_select")]
		public void select ();
		[CCode (cname = "webkit_html_text_area_element_set_access_key")]
		public void set_access_key (string value);
		[CCode (cname = "webkit_html_text_area_element_set_autofocus")]
		public void set_autofocus (bool value);
		[CCode (cname = "webkit_html_text_area_element_set_cols")]
		public void set_cols (long value);
		[CCode (cname = "webkit_html_text_area_element_set_default_value")]
		public void set_default_value (string value);
		[CCode (cname = "webkit_html_text_area_element_set_disabled")]
		public void set_disabled (bool value);
		[CCode (cname = "webkit_html_text_area_element_set_name")]
		public void set_name (string value);
		[CCode (cname = "webkit_html_text_area_element_set_read_only")]
		public void set_read_only (bool value);
		[CCode (cname = "webkit_html_text_area_element_set_rows")]
		public void set_rows (long value);
		[CCode (cname = "webkit_html_text_area_element_set_selection_end")]
		public void set_selection_end (long value);
		[CCode (cname = "webkit_html_text_area_element_set_selection_range")]
		public void set_selection_range (long start, long end);
		[CCode (cname = "webkit_html_text_area_element_set_selection_start")]
		public void set_selection_start (long value);
		[CCode (cname = "webkit_html_text_area_element_set_value")]
		public void set_value (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLTextAreaElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLTitleElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_html_title_element_get_text")]
		public unowned string get_text ();
		[CCode (cname = "webkit_html_title_element_set_text")]
		public void set_text (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLTitleElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLUListElement {
		public weak WebKit.HTMLElement parent_instance;
		[CCode (cname = "webkit_htmlu_list_element_get_compact")]
		public bool get_compact ();
		[CCode (cname = "webkit_htmlu_list_element_set_compact")]
		public void set_compact (bool value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLUListElementClass {
		public weak WebKit.HTMLElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLVideoElement {
		public weak WebKit.HTMLMediaElement parent_instance;
		[CCode (cname = "webkit_html_video_element_get_height")]
		public ulong get_height ();
		[CCode (cname = "webkit_html_video_element_get_poster")]
		public unowned string get_poster ();
		[CCode (cname = "webkit_html_video_element_get_video_height")]
		public ulong get_video_height ();
		[CCode (cname = "webkit_html_video_element_get_video_width")]
		public ulong get_video_width ();
		[CCode (cname = "webkit_html_video_element_get_width")]
		public ulong get_width ();
		[CCode (cname = "webkit_html_video_element_set_height")]
		public void set_height (ulong value);
		[CCode (cname = "webkit_html_video_element_set_poster")]
		public void set_poster (string value);
		[CCode (cname = "webkit_html_video_element_set_width")]
		public void set_width (ulong value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HTMLVideoElementClass {
		public weak WebKit.HTMLMediaElementClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class History {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_history_back")]
		public void back ();
		[CCode (cname = "webkit_history_forward")]
		public void forward ();
		[CCode (cname = "webkit_history_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_history_go")]
		public void go (long distance);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class HistoryClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class ImageData {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_image_data_get_data")]
		public unowned WebKit.CanvasPixelArray get_data ();
		[CCode (cname = "webkit_image_data_get_height")]
		public long get_height ();
		[CCode (cname = "webkit_image_data_get_width")]
		public long get_width ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class ImageDataClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class JavaScriptCallFrame {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_java_script_call_frame_get_caller")]
		public unowned WebKit.JavaScriptCallFrame get_caller ();
		[CCode (cname = "webkit_java_script_call_frame_get_function_name")]
		public unowned string get_function_name ();
		[CCode (cname = "webkit_java_script_call_frame_get_line")]
		public long get_line ();
		[CCode (cname = "webkit_java_script_call_frame_get_source_id")]
		public long get_source_id ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class JavaScriptCallFrameClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Location {
		public weak WebKit.DOMObject parent_instance;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class LocationClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class MediaError {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_media_error_get_code")]
		public ushort get_code ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class MediaErrorClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class MediaList {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_media_list_append_medium")]
		public void append_medium (string new_medium) throws GLib.Error;
		[CCode (cname = "webkit_media_list_delete_medium")]
		public void delete_medium (string old_medium) throws GLib.Error;
		[CCode (cname = "webkit_media_list_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_media_list_get_media_text")]
		public unowned string get_media_text ();
		[CCode (cname = "webkit_media_list_item")]
		public unowned string item (ulong index);
		[CCode (cname = "webkit_media_list_set_media_text")]
		public void set_media_text (string value) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class MediaListClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class MessageChannel {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_message_channel_get_port1")]
		public unowned WebKit.MessagePort get_port1 ();
		[CCode (cname = "webkit_message_channel_get_port2")]
		public unowned WebKit.MessagePort get_port2 ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class MessageChannelClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class MessagePort {
		public weak WebKit.DOMObject parent_instance;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class MessagePortClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class MimeType {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_mime_type_get_description")]
		public unowned string get_description ();
		[CCode (cname = "webkit_mime_type_get_enabled_plugin")]
		public unowned WebKit.Plugin get_enabled_plugin ();
		[CCode (cname = "webkit_mime_type_get_suffixes")]
		public unowned string get_suffixes ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class MimeTypeArray {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_mime_type_array_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_mime_type_array_item")]
		public unowned WebKit.MimeType item (ulong index);
		[CCode (cname = "webkit_mime_type_array_named_item")]
		public unowned WebKit.MimeType named_item (string name);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class MimeTypeArrayClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class MimeTypeClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class NamedNodeMap {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_named_node_map_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_named_node_map_get_named_item")]
		public unowned WebKit.Node get_named_item (string name);
		[CCode (cname = "webkit_named_node_map_get_named_item_ns")]
		public unowned WebKit.Node get_named_item_ns (string namespace_uri, string local_name);
		[CCode (cname = "webkit_named_node_map_item")]
		public unowned WebKit.Node item (ulong index);
		[CCode (cname = "webkit_named_node_map_remove_named_item")]
		public unowned WebKit.Node remove_named_item (string name) throws GLib.Error;
		[CCode (cname = "webkit_named_node_map_remove_named_item_ns")]
		public unowned WebKit.Node remove_named_item_ns (string namespace_uri, string local_name) throws GLib.Error;
		[CCode (cname = "webkit_named_node_map_set_named_item")]
		public unowned WebKit.Node set_named_item (WebKit.Node node) throws GLib.Error;
		[CCode (cname = "webkit_named_node_map_set_named_item_ns")]
		public unowned WebKit.Node set_named_item_ns (WebKit.Node node) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class NamedNodeMapClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Navigator {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_navigator_get_app_code_name")]
		public unowned string get_app_code_name ();
		[CCode (cname = "webkit_navigator_get_app_name")]
		public unowned string get_app_name ();
		[CCode (cname = "webkit_navigator_get_cookie_enabled")]
		public bool get_cookie_enabled ();
		[CCode (cname = "webkit_navigator_get_language")]
		public unowned string get_language ();
		[CCode (cname = "webkit_navigator_get_mime_types")]
		public unowned WebKit.MimeTypeArray get_mime_types ();
		[CCode (cname = "webkit_navigator_get_on_line")]
		public bool get_on_line ();
		[CCode (cname = "webkit_navigator_get_platform")]
		public unowned string get_platform ();
		[CCode (cname = "webkit_navigator_get_plugins")]
		public unowned WebKit.PluginArray get_plugins ();
		[CCode (cname = "webkit_navigator_get_product")]
		public unowned string get_product ();
		[CCode (cname = "webkit_navigator_get_product_sub")]
		public unowned string get_product_sub ();
		[CCode (cname = "webkit_navigator_get_user_agent")]
		public unowned string get_user_agent ();
		[CCode (cname = "webkit_navigator_get_vendor")]
		public unowned string get_vendor ();
		[CCode (cname = "webkit_navigator_get_vendor_sub")]
		public unowned string get_vendor_sub ();
		[CCode (cname = "webkit_navigator_java_enabled")]
		public bool java_enabled ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class NavigatorClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Node {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_node_append_child")]
		public unowned WebKit.Node append_child (WebKit.Node new_child) throws GLib.Error;
		[CCode (cname = "webkit_node_clone_node")]
		public unowned WebKit.Node clone_node (bool deep);
		[CCode (cname = "webkit_node_compare_document_position")]
		public ushort compare_document_position (WebKit.Node other);
		[CCode (cname = "webkit_node_get_attributes")]
		public unowned WebKit.NamedNodeMap get_attributes ();
		[CCode (cname = "webkit_node_get_base_uri")]
		public unowned string get_base_uri ();
		[CCode (cname = "webkit_node_get_child_nodes")]
		public unowned WebKit.NodeList get_child_nodes ();
		[CCode (cname = "webkit_node_get_first_child")]
		public unowned WebKit.Node get_first_child ();
		[CCode (cname = "webkit_node_get_last_child")]
		public unowned WebKit.Node get_last_child ();
		[CCode (cname = "webkit_node_get_local_name")]
		public unowned string get_local_name ();
		[CCode (cname = "webkit_node_get_namespace_uri")]
		public unowned string get_namespace_uri ();
		[CCode (cname = "webkit_node_get_next_sibling")]
		public unowned WebKit.Node get_next_sibling ();
		[CCode (cname = "webkit_node_get_node_name")]
		public unowned string get_node_name ();
		[CCode (cname = "webkit_node_get_node_type")]
		public ushort get_node_type ();
		[CCode (cname = "webkit_node_get_node_value")]
		public unowned string get_node_value ();
		[CCode (cname = "webkit_node_get_owner_document")]
		public unowned WebKit.Document get_owner_document ();
		[CCode (cname = "webkit_node_get_parent_element")]
		public unowned WebKit.Node get_parent_element ();
		[CCode (cname = "webkit_node_get_parent_node")]
		public unowned WebKit.Node get_parent_node ();
		[CCode (cname = "webkit_node_get_prefix")]
		public unowned string get_prefix ();
		[CCode (cname = "webkit_node_get_previous_sibling")]
		public unowned WebKit.Node get_previous_sibling ();
		[CCode (cname = "webkit_node_get_text_content")]
		public unowned string get_text_content ();
		[CCode (cname = "webkit_node_has_attributes")]
		public bool has_attributes ();
		[CCode (cname = "webkit_node_has_child_nodes")]
		public bool has_child_nodes ();
		[CCode (cname = "webkit_node_insert_before")]
		public unowned WebKit.Node insert_before (WebKit.Node new_child, WebKit.Node ref_child) throws GLib.Error;
		[CCode (cname = "webkit_node_is_default_namespace")]
		public bool is_default_namespace (string namespace_uri);
		[CCode (cname = "webkit_node_is_equal_node")]
		public bool is_equal_node (WebKit.Node other);
		[CCode (cname = "webkit_node_is_same_node")]
		public bool is_same_node (WebKit.Node other);
		[CCode (cname = "webkit_node_is_supported")]
		public bool is_supported (string feature, string version);
		[CCode (cname = "webkit_node_lookup_namespace_uri")]
		public unowned string lookup_namespace_uri (string prefix);
		[CCode (cname = "webkit_node_lookup_prefix")]
		public unowned string lookup_prefix (string namespace_uri);
		[CCode (cname = "webkit_node_normalize")]
		public void normalize ();
		[CCode (cname = "webkit_node_remove_child")]
		public unowned WebKit.Node remove_child (WebKit.Node old_child) throws GLib.Error;
		[CCode (cname = "webkit_node_replace_child")]
		public unowned WebKit.Node replace_child (WebKit.Node new_child, WebKit.Node old_child) throws GLib.Error;
		[CCode (cname = "webkit_node_set_node_value")]
		public void set_node_value (string value) throws GLib.Error;
		[CCode (cname = "webkit_node_set_prefix")]
		public void set_prefix (string value) throws GLib.Error;
		[CCode (cname = "webkit_node_set_text_content")]
		public void set_text_content (string value) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class NodeClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class NodeFilter {
		public weak WebKit.DOMObject parent_instance;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class NodeFilterClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class NodeIterator {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_node_iterator_detach")]
		public void detach ();
		[CCode (cname = "webkit_node_iterator_get_expand_entity_references")]
		public bool get_expand_entity_references ();
		[CCode (cname = "webkit_node_iterator_get_filter")]
		public unowned WebKit.NodeFilter get_filter ();
		[CCode (cname = "webkit_node_iterator_get_pointer_before_reference_node")]
		public bool get_pointer_before_reference_node ();
		[CCode (cname = "webkit_node_iterator_get_reference_node")]
		public unowned WebKit.Node get_reference_node ();
		[CCode (cname = "webkit_node_iterator_get_root")]
		public unowned WebKit.Node get_root ();
		[CCode (cname = "webkit_node_iterator_get_what_to_show")]
		public ulong get_what_to_show ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class NodeIteratorClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class NodeList {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_node_list_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_node_list_item")]
		public unowned WebKit.Node item (ulong index);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class NodeListClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Notation {
		public weak WebKit.Node parent_instance;
		[CCode (cname = "webkit_notation_get_public_id")]
		public unowned string get_public_id ();
		[CCode (cname = "webkit_notation_get_system_id")]
		public unowned string get_system_id ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class NotationClass {
		public weak WebKit.NodeClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Plugin {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_plugin_get_description")]
		public unowned string get_description ();
		[CCode (cname = "webkit_plugin_get_filename")]
		public unowned string get_filename ();
		[CCode (cname = "webkit_plugin_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_plugin_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_plugin_item")]
		public unowned WebKit.MimeType item (ulong index);
		[CCode (cname = "webkit_plugin_named_item")]
		public unowned WebKit.MimeType named_item (string name);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class PluginArray {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_plugin_array_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_plugin_array_item")]
		public unowned WebKit.Plugin item (ulong index);
		[CCode (cname = "webkit_plugin_array_named_item")]
		public unowned WebKit.Plugin named_item (string name);
		[CCode (cname = "webkit_plugin_array_refresh")]
		public void refresh (bool reload);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class PluginArrayClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class PluginClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class PositionError {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_position_error_get_code")]
		public ushort get_code ();
		[CCode (cname = "webkit_position_error_get_message")]
		public unowned string get_message ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class PositionErrorClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class ProcessingInstruction {
		public weak WebKit.Node parent_instance;
		[CCode (cname = "webkit_processing_instruction_get_data")]
		public unowned string get_data ();
		[CCode (cname = "webkit_processing_instruction_get_sheet")]
		public unowned WebKit.StyleSheet get_sheet ();
		[CCode (cname = "webkit_processing_instruction_get_target")]
		public unowned string get_target ();
		[CCode (cname = "webkit_processing_instruction_set_data")]
		public void set_data (string value) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class ProcessingInstructionClass {
		public weak WebKit.NodeClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Range {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_range_clone_contents")]
		public unowned WebKit.DocumentFragment clone_contents () throws GLib.Error;
		[CCode (cname = "webkit_range_clone_range")]
		public unowned WebKit.Range clone_range () throws GLib.Error;
		[CCode (cname = "webkit_range_collapse")]
		public void collapse (bool to_start) throws GLib.Error;
		[CCode (cname = "webkit_range_compare_node")]
		public short compare_node (WebKit.Node ref_node) throws GLib.Error;
		[CCode (cname = "webkit_range_compare_point")]
		public short compare_point (WebKit.Node ref_node, long offset) throws GLib.Error;
		[CCode (cname = "webkit_range_create_contextual_fragment")]
		public unowned WebKit.DocumentFragment create_contextual_fragment (string html) throws GLib.Error;
		[CCode (cname = "webkit_range_delete_contents")]
		public void delete_contents () throws GLib.Error;
		[CCode (cname = "webkit_range_detach")]
		public void detach () throws GLib.Error;
		[CCode (cname = "webkit_range_extract_contents")]
		public unowned WebKit.DocumentFragment extract_contents () throws GLib.Error;
		[CCode (cname = "webkit_range_get_collapsed")]
		public bool get_collapsed () throws GLib.Error;
		[CCode (cname = "webkit_range_get_common_ancestor_container")]
		public unowned WebKit.Node get_common_ancestor_container () throws GLib.Error;
		[CCode (cname = "webkit_range_get_end_container")]
		public unowned WebKit.Node get_end_container () throws GLib.Error;
		[CCode (cname = "webkit_range_get_end_offset")]
		public long get_end_offset () throws GLib.Error;
		[CCode (cname = "webkit_range_get_start_container")]
		public unowned WebKit.Node get_start_container () throws GLib.Error;
		[CCode (cname = "webkit_range_get_start_offset")]
		public long get_start_offset () throws GLib.Error;
		[CCode (cname = "webkit_range_get_text")]
		public unowned string get_text ();
		[CCode (cname = "webkit_range_insert_node")]
		public void insert_node (WebKit.Node new_node) throws GLib.Error;
		[CCode (cname = "webkit_range_intersects_node")]
		public bool intersects_node (WebKit.Node ref_node) throws GLib.Error;
		[CCode (cname = "webkit_range_is_point_in_range")]
		public bool is_point_in_range (WebKit.Node ref_node, long offset) throws GLib.Error;
		[CCode (cname = "webkit_range_select_node")]
		public void select_node (WebKit.Node ref_node) throws GLib.Error;
		[CCode (cname = "webkit_range_select_node_contents")]
		public void select_node_contents (WebKit.Node ref_node) throws GLib.Error;
		[CCode (cname = "webkit_range_set_end")]
		public void set_end (WebKit.Node ref_node, long offset) throws GLib.Error;
		[CCode (cname = "webkit_range_set_end_after")]
		public void set_end_after (WebKit.Node ref_node) throws GLib.Error;
		[CCode (cname = "webkit_range_set_end_before")]
		public void set_end_before (WebKit.Node ref_node) throws GLib.Error;
		[CCode (cname = "webkit_range_set_start")]
		public void set_start (WebKit.Node ref_node, long offset) throws GLib.Error;
		[CCode (cname = "webkit_range_set_start_after")]
		public void set_start_after (WebKit.Node ref_node) throws GLib.Error;
		[CCode (cname = "webkit_range_set_start_before")]
		public void set_start_before (WebKit.Node ref_node) throws GLib.Error;
		[CCode (cname = "webkit_range_surround_contents")]
		public void surround_contents (WebKit.Node new_parent) throws GLib.Error;
		[CCode (cname = "webkit_range_to_string")]
		public unowned string to_string () throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class RangeClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class RangeException {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_range_exception_get_code")]
		public ushort get_code ();
		[CCode (cname = "webkit_range_exception_get_message")]
		public unowned string get_message ();
		[CCode (cname = "webkit_range_exception_get_name")]
		public unowned string get_name ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class RangeExceptionClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Rect {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_rect_get_bottom")]
		public unowned WebKit.CSSPrimitiveValue get_bottom ();
		[CCode (cname = "webkit_rect_get_left")]
		public unowned WebKit.CSSPrimitiveValue get_left ();
		[CCode (cname = "webkit_rect_get_right")]
		public unowned WebKit.CSSPrimitiveValue get_right ();
		[CCode (cname = "webkit_rect_get_top")]
		public unowned WebKit.CSSPrimitiveValue get_top ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class RectClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class SQLError {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_sql_error_get_code")]
		public ulong get_code ();
		[CCode (cname = "webkit_sql_error_get_message")]
		public unowned string get_message ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class SQLErrorClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class SQLResultSet {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_sql_result_set_get_insert_id")]
		public long get_insert_id () throws GLib.Error;
		[CCode (cname = "webkit_sql_result_set_get_rows")]
		public unowned WebKit.SQLResultSetRowList get_rows ();
		[CCode (cname = "webkit_sql_result_set_get_rows_affected")]
		public long get_rows_affected ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class SQLResultSetClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class SQLResultSetRowList {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_sql_result_set_row_list_get_length")]
		public ulong get_length ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class SQLResultSetRowListClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class SQLTransaction {
		public weak WebKit.DOMObject parent_instance;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class SQLTransactionClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Screen {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_screen_get_avail_height")]
		public ulong get_avail_height ();
		[CCode (cname = "webkit_screen_get_avail_left")]
		public ulong get_avail_left ();
		[CCode (cname = "webkit_screen_get_avail_top")]
		public ulong get_avail_top ();
		[CCode (cname = "webkit_screen_get_avail_width")]
		public ulong get_avail_width ();
		[CCode (cname = "webkit_screen_get_color_depth")]
		public ulong get_color_depth ();
		[CCode (cname = "webkit_screen_get_height")]
		public ulong get_height ();
		[CCode (cname = "webkit_screen_get_pixel_depth")]
		public ulong get_pixel_depth ();
		[CCode (cname = "webkit_screen_get_width")]
		public ulong get_width ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class ScreenClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Storage {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_storage_clear")]
		public void clear ();
		[CCode (cname = "webkit_storage_get_item")]
		public unowned string get_item (string key);
		[CCode (cname = "webkit_storage_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_storage_key")]
		public unowned string key (ulong index) throws GLib.Error;
		[CCode (cname = "webkit_storage_remove_item")]
		public void remove_item (string key);
		[CCode (cname = "webkit_storage_set_item")]
		public void set_item (string key, string data) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class StorageClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class StyleSheet {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_style_sheet_get_disabled")]
		public bool get_disabled ();
		[CCode (cname = "webkit_style_sheet_get_href")]
		public unowned string get_href ();
		[CCode (cname = "webkit_style_sheet_get_media")]
		public unowned WebKit.MediaList get_media ();
		[CCode (cname = "webkit_style_sheet_get_owner_node")]
		public unowned WebKit.Node get_owner_node ();
		[CCode (cname = "webkit_style_sheet_get_parent_style_sheet")]
		public unowned WebKit.StyleSheet get_parent_style_sheet ();
		[CCode (cname = "webkit_style_sheet_get_title")]
		public unowned string get_title ();
		[CCode (cname = "webkit_style_sheet_set_disabled")]
		public void set_disabled (bool value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class StyleSheetClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class StyleSheetList {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_style_sheet_list_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_style_sheet_list_item")]
		public unowned WebKit.StyleSheet item (ulong index);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class StyleSheetListClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Text {
		public weak WebKit.CharacterData parent_instance;
		[CCode (cname = "webkit_text_get_whole_text")]
		public unowned string get_whole_text ();
		[CCode (cname = "webkit_text_replace_whole_text")]
		public unowned WebKit.Text replace_whole_text (string content) throws GLib.Error;
		[CCode (cname = "webkit_text_split_text")]
		public unowned WebKit.Text split_text (ulong offset) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class TextClass {
		public weak WebKit.CharacterDataClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class TextMetrics {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_text_metrics_get_width")]
		public float get_width ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class TextMetricsClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class TimeRanges {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_time_ranges_end")]
		public float end (ulong index) throws GLib.Error;
		[CCode (cname = "webkit_time_ranges_get_length")]
		public ulong get_length ();
		[CCode (cname = "webkit_time_ranges_start")]
		public float start (ulong index) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class TimeRangesClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class TreeWalker {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_tree_walker_get_current_node")]
		public unowned WebKit.Node get_current_node ();
		[CCode (cname = "webkit_tree_walker_get_expand_entity_references")]
		public bool get_expand_entity_references ();
		[CCode (cname = "webkit_tree_walker_get_filter")]
		public unowned WebKit.NodeFilter get_filter ();
		[CCode (cname = "webkit_tree_walker_get_root")]
		public unowned WebKit.Node get_root ();
		[CCode (cname = "webkit_tree_walker_get_what_to_show")]
		public ulong get_what_to_show ();
		[CCode (cname = "webkit_tree_walker_set_current_node")]
		public void set_current_node (WebKit.Node value) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class TreeWalkerClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class VoidCallback {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_void_callback_handle_event")]
		public void handle_event ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class VoidCallbackClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WebKitCSSKeyframeRule {
		public weak WebKit.CSSRule parent_instance;
		[CCode (cname = "webkit_web_kit_css_keyframe_rule_get_key_text")]
		public unowned string get_key_text ();
		[CCode (cname = "webkit_web_kit_css_keyframe_rule_get_style")]
		public unowned WebKit.CSSStyleDeclaration get_style ();
		[CCode (cname = "webkit_web_kit_css_keyframe_rule_set_key_text")]
		public void set_key_text (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WebKitCSSKeyframeRuleClass {
		public weak WebKit.CSSRuleClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WebKitCSSKeyframesRule {
		public weak WebKit.CSSRule parent_instance;
		[CCode (cname = "webkit_web_kit_css_keyframes_rule_delete_rule")]
		public void delete_rule (string key);
		[CCode (cname = "webkit_web_kit_css_keyframes_rule_find_rule")]
		public unowned WebKit.WebKitCSSKeyframeRule find_rule (string key);
		[CCode (cname = "webkit_web_kit_css_keyframes_rule_get_css_rules")]
		public unowned WebKit.CSSRuleList get_css_rules ();
		[CCode (cname = "webkit_web_kit_css_keyframes_rule_get_name")]
		public unowned string get_name ();
		[CCode (cname = "webkit_web_kit_css_keyframes_rule_insert_rule")]
		public void insert_rule (string rule2);
		[CCode (cname = "webkit_web_kit_css_keyframes_rule_set_name")]
		public void set_name (string value);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WebKitCSSKeyframesRuleClass {
		public weak WebKit.CSSRuleClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WebKitCSSMatrix {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_web_kit_css_matrix_get_a")]
		public double get_a ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_b")]
		public double get_b ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_c")]
		public double get_c ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_d")]
		public double get_d ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_e")]
		public double get_e ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_f")]
		public double get_f ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_m11")]
		public double get_m11 ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_m12")]
		public double get_m12 ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_m13")]
		public double get_m13 ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_m14")]
		public double get_m14 ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_m21")]
		public double get_m21 ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_m22")]
		public double get_m22 ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_m23")]
		public double get_m23 ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_m24")]
		public double get_m24 ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_m31")]
		public double get_m31 ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_m32")]
		public double get_m32 ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_m33")]
		public double get_m33 ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_m34")]
		public double get_m34 ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_m41")]
		public double get_m41 ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_m42")]
		public double get_m42 ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_m43")]
		public double get_m43 ();
		[CCode (cname = "webkit_web_kit_css_matrix_get_m44")]
		public double get_m44 ();
		[CCode (cname = "webkit_web_kit_css_matrix_inverse")]
		public unowned WebKit.WebKitCSSMatrix inverse () throws GLib.Error;
		[CCode (cname = "webkit_web_kit_css_matrix_multiply")]
		public unowned WebKit.WebKitCSSMatrix multiply (WebKit.WebKitCSSMatrix second_matrix);
		[CCode (cname = "webkit_web_kit_css_matrix_rotate")]
		public unowned WebKit.WebKitCSSMatrix rotate (double rot_x, double rot_y, double rot_z);
		[CCode (cname = "webkit_web_kit_css_matrix_rotate_axis_angle")]
		public unowned WebKit.WebKitCSSMatrix rotate_axis_angle (double x, double y, double z, double angle);
		[CCode (cname = "webkit_web_kit_css_matrix_scale")]
		public unowned WebKit.WebKitCSSMatrix scale (double scale_x, double scale_y, double scale_z);
		[CCode (cname = "webkit_web_kit_css_matrix_set_a")]
		public void set_a (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_b")]
		public void set_b (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_c")]
		public void set_c (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_d")]
		public void set_d (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_e")]
		public void set_e (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_f")]
		public void set_f (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_m11")]
		public void set_m11 (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_m12")]
		public void set_m12 (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_m13")]
		public void set_m13 (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_m14")]
		public void set_m14 (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_m21")]
		public void set_m21 (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_m22")]
		public void set_m22 (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_m23")]
		public void set_m23 (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_m24")]
		public void set_m24 (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_m31")]
		public void set_m31 (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_m32")]
		public void set_m32 (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_m33")]
		public void set_m33 (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_m34")]
		public void set_m34 (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_m41")]
		public void set_m41 (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_m42")]
		public void set_m42 (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_m43")]
		public void set_m43 (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_m44")]
		public void set_m44 (double value);
		[CCode (cname = "webkit_web_kit_css_matrix_set_matrix_value")]
		public void set_matrix_value (string str) throws GLib.Error;
		[CCode (cname = "webkit_web_kit_css_matrix_to_string")]
		public unowned string to_string ();
		[CCode (cname = "webkit_web_kit_css_matrix_translate")]
		public unowned WebKit.WebKitCSSMatrix translate (double x, double y, double z);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WebKitCSSMatrixClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WebKitCSSTransformValue {
		public weak WebKit.CSSValueList parent_instance;
		[CCode (cname = "webkit_web_kit_css_transform_value_get_operation_type")]
		public ushort get_operation_type ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WebKitCSSTransformValueClass {
		public weak WebKit.CSSValueListClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WebWindowFeatures {
		public weak GLib.Object parent_instance;
		[CCode (cname = "webkit_web_window_features_equal")]
		public bool equal (WebKit.WebWindowFeatures features2);
		[CCode (cname = "webkit_web_window_features_new", has_construct_function = false)]
		public WebWindowFeatures ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WebWindowFeaturesClass {
		public weak GLib.ObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class Worker {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_worker_post_message")]
		public void post_message (string message);
		[CCode (cname = "webkit_worker_terminate")]
		public void terminate ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WorkerClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WorkerContext {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_worker_context_get_location")]
		public unowned WebKit.WorkerLocation get_location ();
		[CCode (cname = "webkit_worker_context_get_navigator")]
		public unowned WebKit.WorkerNavigator get_navigator ();
		[CCode (cname = "webkit_worker_context_post_message")]
		public void post_message (string message);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WorkerContextClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WorkerLocation {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_worker_location_get_hash")]
		public unowned string get_hash ();
		[CCode (cname = "webkit_worker_location_get_host")]
		public unowned string get_host ();
		[CCode (cname = "webkit_worker_location_get_hostname")]
		public unowned string get_hostname ();
		[CCode (cname = "webkit_worker_location_get_href")]
		public unowned string get_href ();
		[CCode (cname = "webkit_worker_location_get_pathname")]
		public unowned string get_pathname ();
		[CCode (cname = "webkit_worker_location_get_port")]
		public unowned string get_port ();
		[CCode (cname = "webkit_worker_location_get_protocol")]
		public unowned string get_protocol ();
		[CCode (cname = "webkit_worker_location_get_search")]
		public unowned string get_search ();
		[CCode (cname = "webkit_worker_location_to_string")]
		public unowned string to_string ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WorkerLocationClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WorkerNavigator {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_worker_navigator_get_app_name")]
		public unowned string get_app_name ();
		[CCode (cname = "webkit_worker_navigator_get_app_version")]
		public unowned string get_app_version ();
		[CCode (cname = "webkit_worker_navigator_get_on_line")]
		public bool get_on_line ();
		[CCode (cname = "webkit_worker_navigator_get_platform")]
		public unowned string get_platform ();
		[CCode (cname = "webkit_worker_navigator_get_user_agent")]
		public unowned string get_user_agent ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class WorkerNavigatorClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XMLHttpRequest {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_xml_http_request_abort")]
		public void abort ();
		[CCode (cname = "webkit_xml_http_request_get_all_response_headers")]
		public unowned string get_all_response_headers () throws GLib.Error;
		[CCode (cname = "webkit_xml_http_request_get_ready_state")]
		public ushort get_ready_state ();
		[CCode (cname = "webkit_xml_http_request_get_response_header")]
		public unowned string get_response_header (string header) throws GLib.Error;
		[CCode (cname = "webkit_xml_http_request_get_response_xml")]
		public unowned WebKit.Document get_response_xml ();
		[CCode (cname = "webkit_xml_http_request_get_status")]
		public ushort get_status () throws GLib.Error;
		[CCode (cname = "webkit_xml_http_request_get_status_text")]
		public unowned string get_status_text () throws GLib.Error;
		[CCode (cname = "webkit_xml_http_request_get_upload")]
		public unowned WebKit.XMLHttpRequestUpload get_upload ();
		[CCode (cname = "webkit_xml_http_request_open")]
		public void open (string method, string url, bool async, string user, string password) throws GLib.Error;
		[CCode (cname = "webkit_xml_http_request_override_mime_type")]
		public void override_mime_type (string override);
		[CCode (cname = "webkit_xml_http_request_send")]
		public void send (WebKit.Document data) throws GLib.Error;
		[CCode (cname = "webkit_xml_http_request_set_request_header")]
		public void set_request_header (string header, string value) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XMLHttpRequestClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XMLHttpRequestException {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_xml_http_request_exception_get_code")]
		public ushort get_code ();
		[CCode (cname = "webkit_xml_http_request_exception_get_message")]
		public unowned string get_message ();
		[CCode (cname = "webkit_xml_http_request_exception_get_name")]
		public unowned string get_name ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XMLHttpRequestExceptionClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XMLHttpRequestUpload {
		public weak WebKit.DOMObject parent_instance;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XMLHttpRequestUploadClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XMLSerializer {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_xml_serializer_serialize_to_string")]
		public unowned string serialize_to_string (WebKit.Node node) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XMLSerializerClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XPathEvaluator {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_x_path_evaluator_create_expression")]
		public unowned WebKit.XPathExpression create_expression (string expression, WebKit.XPathNSResolver resolver) throws GLib.Error;
		[CCode (cname = "webkit_x_path_evaluator_create_ns_resolver")]
		public unowned WebKit.XPathNSResolver create_ns_resolver (WebKit.Node node_resolver);
		[CCode (cname = "webkit_x_path_evaluator_evaluate")]
		public unowned WebKit.XPathResult evaluate (string expression, WebKit.Node context_node, WebKit.XPathNSResolver resolver, ushort type, WebKit.XPathResult in_result) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XPathEvaluatorClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XPathException {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_x_path_exception_get_code")]
		public ushort get_code ();
		[CCode (cname = "webkit_x_path_exception_get_message")]
		public unowned string get_message ();
		[CCode (cname = "webkit_x_path_exception_get_name")]
		public unowned string get_name ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XPathExceptionClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XPathExpression {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_x_path_expression_evaluate")]
		public unowned WebKit.XPathResult evaluate (WebKit.Node context_node, ushort type, WebKit.XPathResult in_result) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XPathExpressionClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XPathNSResolver {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_x_path_ns_resolver_lookup_namespace_uri")]
		public unowned string lookup_namespace_uri (string prefix);
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XPathNSResolverClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XPathResult {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_x_path_result_get_boolean_value")]
		public bool get_boolean_value () throws GLib.Error;
		[CCode (cname = "webkit_x_path_result_get_invalid_iterator_state")]
		public bool get_invalid_iterator_state ();
		[CCode (cname = "webkit_x_path_result_get_number_value")]
		public double get_number_value () throws GLib.Error;
		[CCode (cname = "webkit_x_path_result_get_result_type")]
		public ushort get_result_type ();
		[CCode (cname = "webkit_x_path_result_get_single_node_value")]
		public unowned WebKit.Node get_single_node_value () throws GLib.Error;
		[CCode (cname = "webkit_x_path_result_get_snapshot_length")]
		public ulong get_snapshot_length () throws GLib.Error;
		[CCode (cname = "webkit_x_path_result_get_string_value")]
		public unowned string get_string_value () throws GLib.Error;
		[CCode (cname = "webkit_x_path_result_iterate_next")]
		public unowned WebKit.Node iterate_next () throws GLib.Error;
		[CCode (cname = "webkit_x_path_result_snapshot_item")]
		public unowned WebKit.Node snapshot_item (ulong index) throws GLib.Error;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XPathResultClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XSLTProcessor {
		public weak WebKit.DOMObject parent_instance;
		[CCode (cname = "webkit_xslt_processor_clear_parameters")]
		public void clear_parameters ();
		[CCode (cname = "webkit_xslt_processor_reset")]
		public void reset ();
	}
	[Compact]
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public class XSLTProcessorClass {
		public weak WebKit.DOMObjectClass parent_class;
	}
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public const int MAJOR_VERSION;
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public const int MICRO_VERSION;
	[CCode (cheader_filename = "webkit/webkitdom.h")]
	public const int MINOR_VERSION;
	[CCode (cname = "webkit_check_version", cheader_filename = "webkit/webkitdom.h")]
	public static bool check_version (uint major, uint minor, uint micro);
	[CCode (cname = "webkit_major_version", cheader_filename = "webkit/webkitdom.h")]
	public static uint major_version ();
	[CCode (cname = "webkit_micro_version", cheader_filename = "webkit/webkitdom.h")]
	public static uint micro_version ();
	[CCode (cname = "webkit_minor_version", cheader_filename = "webkit/webkitdom.h")]
	public static uint minor_version ();
	[CCode (cname = "webkit_navigation_response_get_type", cheader_filename = "webkit/webkitdom.h")]
	public static GLib.Type navigation_response_get_type ();
	[CCode (cname = "webkit_titanium_set_inspector_path", cheader_filename = "webkit/webkitdom.h")]
	public static void titanium_set_inspector_path (string path);
	[CCode (cname = "webkit_web_navigation_reason_get_type", cheader_filename = "webkit/webkitdom.h")]
	public static GLib.Type web_navigation_reason_get_type ();
}
