#!/usr/bin/env python
# -*- coding: utf-8 -*-
""" 
 @file: TreeMessage.py
  File is a part of Scribo Project
  Module implements viewing tree of comments from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 23.06.2010
"""
import sys
from PyQt4 import QtCore
from PyQt4 import QtGui
from PyQt4.QtWebKit import *

from MainWindow import *
from ToolbarWindow import ToolbarWindow
from ldm.Message import *

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.2 $"
__date__ = "$Date: 2010/06/23 $"
__copyright__ = ""
__license__ = "GPLv2"

class TreeMessage(MainWindow):
    """
    class for draw tree of comments window
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    @todo  all handlers
    """
    def __init__(self, parent=None, msg="default"):
        """ 
        initialization "tree of messages" window
        @return
        """
        super(TreeMessage, self).__init__(parent)
        self.parent = parent
        self.centr_widg = QtGui.QWidget(self)
        self.msg = msg
        self.cur_com = None
        #self.refresh_all_comments()
        #self.get_msg_comment(msg)
        self.tree_view = self.tree_view_com(msg)
        self.create_actions()
        toolbar = self.create_toolbar()
        sec_toolbar = self.create_toolbar_second()
        self.hbox = QtGui.QHBoxLayout()
        self.hbox.addWidget(toolbar)
        #self.hbox.addSpacing(5)
        self.hbox.addWidget(self.tree_view)
        #self.hbox.addSpacing(5)
        self.hbox.addWidget(sec_toolbar)
        self.centr_widg.setLayout(self.hbox)
        self.setCentralWidget(self.centr_widg)
        self.show()

    def tree_view_com(self, msg):
        """ 
        fill tree of comments                                                   
        @param                                          
        @return
        """
        tree_view = ComTree(self, msg = msg)
        return tree_view

    def create_toolbar(self):
        """
        create profile for "add profile" window
        @return
        """
        file_tool_bar = ToolbarWindow(parent=self.centr_widg)
        file_tool_bar.addWidget(self.refresh_act)
        self.connect(file_tool_bar.home_act, QtCore.SIGNAL("clicked()"),
                             self.home_window)

        return file_tool_bar

    def create_toolbar_second(self):
        """
        create profile for "add profile" window
        @return
        """
        second_tool_bar = ToolbarWindow(parent=self.centr_widg, right=True)
        second_tool_bar.addWidget(self.incr_act)
        second_tool_bar.addWidget(self.decr_act)
        return second_tool_bar

    def create_actions(self):
        """
        create buttons for toolbar
        @return
        """

        self.refresh_act = QtGui.QToolButton(self.centr_widg)
        self.refresh_act.setIcon(QtGui.QIcon(self.tr("../data/en/refresh.png")))
        self.refresh_act.setText(self.tr("Refresh"))
        self.refresh_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.refresh_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.refresh_act, QtCore.SIGNAL("clicked()"),
                     self.reload_window)

        self.decr_act = QtGui.QToolButton(self.centr_widg)
        self.decr_act.setIcon(QtGui.QIcon(self.tr("../data/en/decrease_font.png")))
        self.decr_act.setText(self.tr("Decrease"))
        self.decr_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.decr_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.decr_act, QtCore.SIGNAL("clicked()"),
                     self.decr_font)

        self.incr_act = QtGui.QToolButton(self.centr_widg)
        self.incr_act.setIcon(QtGui.QIcon(self.tr("../data/en/increase_font.png")))
        self.incr_act.setText(self.tr("Increase"))
        self.incr_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.incr_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.incr_act, QtCore.SIGNAL("clicked()"),
                     self.incr_font)

    def incr_font(self):
        zoom = self.tree_view.zoomFactor()
        self.tree_view.setZoomFactor(zoom + 0.1)

    def decr_font(self):
        zoom = self.tree_view.zoomFactor()
        self.tree_view.setZoomFactor(zoom - 0.1)        

    def view_message(self):
        """  
        view choosing message
        @return
        """
        list_com = self.cur_com.parent.comments
        view_widg = ViewMessage(self, list_com, self.cur_com)
        

    def reload_window(self):
        """ 
        refresh tree                                                                     
        @param 
        @return
        """
        from ListMyPosts import MyProgress
        self.progress = MyProgress(self)
        self.refresh_all_comments()
        self.progress.close()
           

    def end_refresh(self):
        """
        update list messages from database
        """
        comments = self.tree_view.get_post_html(self.msg)
        self.tree_view.setHtml(comments)
        self.tree_view.update()

    def callback(self):
        """
        update toolbar
        """
        self.progress.setValue(100 * (self.progress.value_progress / (self.progress.value_progress + 4.5)))
        self.progress.value_progress = self.progress.value_progress + 1.1
        QtCore.QCoreApplication.processEvents()

    def get_msg_comment(self, msg):
        list_comments = msg.comments
        if list_comments:
            for com in list_comments:
                #print "text = "+com.text+" title = "+ com.title
                self.get_msg_comment(com)
        else:
            return


    def refresh_all_comments(self):
        for acc in main_prof.accounts:
            acc.refresh_comments(self.callback)

class ComTree(QWebView):
    """
    class fill tree of comments
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    @todo  what's method's really needed?
     """
    def __init__(self, parent=None, msg=None):
        """ 
        initialization "tree of messages"
        @param parent = tree_view,
        @param msg   = viewing message
        @return
        """
        QWebView.__init__(self, parent)
        self.parent_window = parent

        try:
            QWebSettings.globalSettings().setAttribute(QWebSettings.LocalStorageEnabled,
                                                       True)
        except AttributeError:
            pass
            
        #connect plugins for video
        QWebSettings.globalSettings().setAttribute(QWebSettings.PluginsEnabled,
                                                   True)
                                                   
        self.page().setLinkDelegationPolicy(QWebPage.DelegateAllLinks)
        #proxy settings
        from ConfigDriver import config
        sett = config.get('Main', 'proxy')
        if sett:
            list1 = sett.split(":")
            l = list1[1]
            port = QtCore.QString(list1[1]).toInt()[0]
            from PyQt4.QtNetwork import QNetworkProxy
            proxy = QNetworkProxy(QNetworkProxy.HttpProxy, list1[0], port)
            QNetworkProxy.setApplicationProxy(proxy)


        self.view_mes = msg
        comments_html = self.get_post_html(msg)
        #print comments_html
        self.setHtml(comments_html, QtCore.QUrl.fromLocalFile("."))
        self.show()

    def get_post_html(self, msg):
        title = msg.title
        text = msg.text
        user = msg.poster
        date = msg.date
        
        if user:
            author = user.username
        if not author:
            author = ""

        if not title:
            title = self.tr("no subject")
        if not text:
            text = ""
        if not date:
            date = ""
        else:
            import time
            print date
            #correct different format date in post and comments
            try:
                datetime = time.strptime(date, "%Y-%m-%d %H:%M:%S")
                date = time.strftime("%Y-%m-%d  %H:%M", datetime)
            except ValueError, ex:
                datetime = time.strptime(date, "%Y-%m-%dT%H:%M:%SZ")
                date = time.strftime("%Y-%m-%d  %H:%M", datetime)
        
        #userpick = msg.path_to_ava
        userpick = user.path_to_ava
        if not userpick:
            userpick = "../data/en/no_photo_64.png"

        from ConfigDriver import config
        font = QtGui.QFont()
        str_font = None
        style_font = ""
        try:
            str_font = config.get('UI', 'font')
        except:
            config.set('UI', 'font', None)
            if str_font:
                ok = font.fromString(str_font)
                if font and ok:
                    style_font = "font:"+self.parse_font(font)+";"
                else:
                    style_font = ""

        header_comment = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\
                          <html xmlns="http://www.w3.org/1999/xhtml">\
                          <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>\
                          <style type="text/css">\
                          HTML, BODY {padding:0; margin:0; border:0; overflow:hidden; }\
                          .scribo_stl {%s}\
                          DIV {min-height: 30px; padding-left: 0px; background-repeat: no-repeat;}\
                          div.hide {background-image: url(\'../../data/en/plus.png\');display: block;}\
                          li.scribo { list-style-type: none; }\
                          .tags {font: 10pt; color: red; text-decoration:underline;}\
                          .toolbar {font: 10pt \'Times New Roman\';}\
                          .date {font-variant:small-caps; color: #e81f37;left: -12px;}\
                          .author {font-weight: 600; color: #e81f37; padding: 0px 12px; background: #d7d7d7; max-width: 500px;}\
                          .title {font: 16pt;}\
                          </style>\
                          <script type="text/javascript">\
                          function showHide(id){\
                          if(document.getElementById(id+\'ul\').style.display === \'block\') {\
			              document.getElementById(id+\'ul\').style.display = \'none\';\
			              document.getElementById(id).style.backgroundImage = "url(\'../../data/en/minus.png\')";}\
			              else {\
			              document.getElementById(id+\'ul\').style.display = \'block\';\
			              document.getElementById(id).style.backgroundImage = "url(\'../../data/en/plus.png\')";}}\
			              </script></head><body style="-moz-user-select: none;\
                                      -khtml-user-select: none; user-select: none;">' %(style_font)
	
        #fill parent data
        self.comment_html = '<h3><div class="title"><a href = "scribo://%s">%s</a></div></h3>' % (str(msg.id), title)+\
                            '<div class="author"><img src="%s" width="32px" height = "32px"/> %s</div>' % (userpick, author)\
                            + '<div class="date">%s</div>' % (date) +\
                            '<div class="scribo_stl"> %s </div>' % (unicode(text))
        
        self.get_html_tree(msg)
        self.connect(self, QtCore.SIGNAL("linkClicked(const QUrl&)"),self.linkClicked)
        return header_comment+ self.comment_html+'</body></html>'
        
    def get_html_tree(self, msg):
        """
        fill children item for parent item
        @param msg = comment, from which we get information
        @param parent = root item for next filling
        @return 
        """
        comment_list = msg.comments
        if comment_list:
            self.comment_html+='<ul id = \''+str(msg.id)+'ul\' style="display: block;">'
            for com in comment_list:
                poster = com.poster
                userpick = com.poster.path_to_ava

                date = com.date
                import time
                try:
                    datetime = time.strptime(date, "%Y-%m-%d %H:%M:%S")
                    date = time.strftime("%Y-%m-%d  %H:%M", datetime)
                except ValueError:
                    datetime = time.strptime(date, "%Y-%m-%dT%H:%M:%SZ")
                    date = time.strftime("%Y-%m-%d  %H:%M", datetime)

	        if not userpick:
                    userpick = "../../data/en/no_photo_64.png"
                self.comment_html+='<li class="scribo">'
                data_comment = '<div class = "author"> <img src="%s" width="32px" height = "32px"/>\
                               %s, %s</div>'%(userpick, unicode(poster.username), date.decode('utf8'))+\
                               '<div class = "title"><a href = "scribo://%s">%s</a></div>'%(str(com.id), unicode(com.title))+\
                               '<div class = "scribo_stl">%s</div>'%(unicode(com.text))
                #'<div class = "toolbar"><a href="scribodel://%s">%s</a></div>'%(str(com.id)," (" + self.tr("Delete") + ") ")
                if com.comments:
                    self.comment_html+='<div id = "%s" class = "hide" onclick = "showHide(\'%s\')">'%(com.id, com.id)+data_comment+'</div>'
                else:
                    self.comment_html+=data_comment                
                self.get_html_tree(com)
                self.comment_html+='</li>'
            self.comment_html+='</ul>'
        else:
            return
            
    def linkClicked(self, url):
        """
        overload handler on clicked link
        @param url - url from clicked link
        """
        if url.scheme() == "scribodel":
            id = url.host()
            mes = Message(id)
            owner = mes.journal
            owner.del_comment(mes)
            self.parent_window.reload_window()
        elif url.scheme() == "scribo":
            id = url.host()
            mes = Message(id)
            if mes.type == COMMENT:
                list_com = mes.parent.comments
            else:
                #TO DO get commnets for friends on their accounts
                list_com = main_prof.get_posts()
            view_widg = ViewMessage(self.parent_window, list_com, mes)
        else:
            return

    def parse_font(self, font):
        family = font.family()
        bold = font.bold()
        italic = font.italic()
        overline = font.overline()
        point_size = font.pointSize()
        pixel_size = font.pixelSize()
        style = font.style()
        style_hint = font.styleHint()
        disp_font = ""
        if bold:
            disp_font += " bold"
        if italic:
            disp_font += " italic"
        if overline:
            disp_font += " overline"
        if style == QtGui.QFont.StyleNormal:
            disp_font += " normal"
        elif style == QtGui.QFont.StyleItalic:
            disp_font += " italic"
        elif style == QtGui.QFont.StyleOblique:
            disp_font += " oblique"
        if point_size <> -1:
            disp_font += " " + str(point_size)+"pt"
        elif pixel_size <> -1:
            disp_font += " "+ str(pixel_size)+"pt"
        if style_hint == QtGui.QFont.SansSerif or style_hint == QtGui.QFont.Helvetica:
            disp_font += " sans-serif"
        if style_hint == QtGui.QFont.Serif or style_hint == QtGui.QFont.Times:
            disp_font += " serif"
        if style_hint == QtGui.QFont.TypeWriter or style_hint == QtGui.QFont.Courier:
            disp_font += " monospace"
        if style_hint == QtGui.QFont.OldEnglish or style_hint == QtGui.QFont.Decorative:
            disp_font += " fantasy"
        return disp_font



 
from ViewMessage import *
