#!/usr/bin/env python
"""
 @file: ViewMessage.py
  File is a part of Scribo Project
  Module implements viewing post or comment for user
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 06.01.2010
"""
import sys

from PyQt4 import QtCore
from PyQt4 import QtGui
from PyQt4.QtWebKit import *

from MainWindow import *
from ToolbarWindow import ToolbarWindow

from ldm.Message import Message
#from ldm.Profile import main_prof
from ldm.Account import Account

from ScriboExc import WarningExc

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2010/01/06 $"
__copyright__ = ""
__license__ = "GPLv2"

class ViewMessage(MainWindow):
    """
    class for drawing window viewing post or comments
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    @todo  all hanglers
    """
    def __init__(self, parent, list, msg):
        """ 
        initialization viewing window
        @return
        """
        super(ViewMessage, self).__init__(parent)
        self.parent = parent
        self.msg = msg
        msg.read = True
        self.centr_widg = QtGui.QWidget(self)
        self.create_actions()
        toolbar = self.create_toolbar()
        sec_toolbar = self.create_toolbar_second()
        self.list = list
        self.hbox = QtGui.QHBoxLayout()

        key = self.list.index(self.msg)
        if key < 1:
            self.up_act.setDisabled(True)
        if key > len(self.list) - 2:
            self.down_act.setDisabled(True)
        #check out JS scripts
        #QWebSettings.globalSettings().setAttribute(QWebSettings.JavascriptEnabled,
        #                                           False)
        #cache settings
        try:
            QWebSettings.globalSettings().setAttribute(QWebSettings.LocalStorageEnabled,
                                                       True)
        except AttributeError:
            pass
            
        #connect plugins for video
        QWebSettings.globalSettings().setAttribute(QWebSettings.PluginsEnabled,
                                                   True)

        #proxy settings
        from ConfigDriver import config
        sett = config.get('Main', 'proxy')
        if sett:
            list1 = sett.split(":")
            l = list1[1]
            port = QtCore.QString(list1[1]).toInt()[0]
            from PyQt4.QtNetwork import QNetworkProxy
            proxy = QNetworkProxy(QNetworkProxy.HttpProxy, list1[0], port)
            QNetworkProxy.setApplicationProxy(proxy)

        self.view_mes_widget = QWebView(self.centr_widg)
        self.hbox.addWidget(toolbar)
        self.hbox.addSpacing(5)
        self.hbox.addWidget(self.view_mes_widget)
        self.hbox.addSpacing(5)
        self.hbox.addWidget(sec_toolbar)
        self.centr_widg.setLayout(self.hbox)
        self.setCentralWidget(self.centr_widg)
        self.show()
        self.view_mes(msg)
        self.view_mes_widget.show()


    def view_mes(self, msg):
        """ 
        fill webkit widget                                                   
        @param msg - id message for viewing                                         
        @return web_mes_widg - webkit widget with title, date, text message
        and its parent message 
        """
        title = msg.title
        text = msg.text
        #print "text do tidylib"+text
        user = msg.poster
        date = msg.date
        parent = msg.parent
        tags = msg.tags

        if user:
            author = user.username
        if not author:
            author = ""

        if not title:
            title = self.tr("no subject")
        if not tags:
            tags = ""
        if not text:
            text = ""
        if not date:
            date = ""
        if not msg.read:
            msg.read = True

        #import tidylib
        #text = tidylib.tidy_fragment(text)[0]

        parent_text = ""
        if parent:
            parent_text = parent.text
        if not parent_text:
            parent_text = ""
        #text = self.text_br(text)
        #print text
        header_html = '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">\
                       <html xmlns="http://www.w3.org/1999/xhtml">\
                       <head><meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>\
                       <title>iframe</title>\
                       <style type="text/css">HTML, BODY { background:transparent; padding:0; margin:0; border:0; overflow:hidden; }\
                       .scrib_stl {font: 14pt sans-serif;}\
                       .tags {font: 12pt; color: red; text-decoration:underline}\
                       .date {font-variant:small-caps; color: red;left: -12px;}\
                       .author {font-weight: 600;}\
                       </style></head>'

        code_html =  header_html + '<body style="-moz-user-select: none; -khtml-user-select: none; user-select: none;">'\
        + '<h3><div class="title">%s</div></h3>' % (title)+'<br/><div class="author">%s</div>' % (author)\
        + '<div class="date">%s</div>' % (date) + '<br/><div class="scribo_stl"> %s </div>' % (unicode(text))\
        + '<br/><div class="tags">%s</div></body></html>' % (unicode(tags))
        #print code_html 
        """
        #version with comment
        self.view_mes_widget.setHtml("<head><meta http-equiv=\"Content-Type\" \
                    content=\"text/html; charset=utf-8\" /> "
                    + str(css) + "</head><body><h3><a href = \"scribo://parent\">"+
                    self.tr("Parrent:</a></h3>") + parent_text +
                    "<h3><font color=\"green\">"+
                    self.tr("Comment:</font> </h3><b>Title: </b>") + title +
                    self.tr("<br/> <b> Author: </b>") + author +
                    self.tr("<br/><b> Date: </b>") + date + self.tr("<br/><b> Tags: </b>")
                    + tags + self.tr("<br/>" "<b> Text:\
                    </b><br />") + text + "<br/>")
        """
        self.view_mes_widget.setHtml(code_html)
        del(title)
        del(text)
        del(user)
        del(date)
        del(parent)



    def text_escape(self, text):
        """
        check on javascript injection    
        @param text = text which is checked
        @return text = escaped text(if it is need)
        """
        js = QtCore.QRegExp("(<script>|javascript:|<script)")
        js.setCaseSensitivity(QtCore.Qt.CaseInsensitive)
        pos = js.indexIn(unicode(text))
        cap = js.capturedTexts()
        for i in xrange(cap.count()):
            if cap[i] <> "":
                import cgi
                return cgi.escape(unicode(text))
        return text

    def text_br(self, text):
        str = QtCore.QString(text)
        str.replace("\n", "<br />")
        return str


    def create_toolbar(self):
        """
        create profile for "add profile" window
        @return
        """
        file_tool_bar = ToolbarWindow(parent=self.centr_widg)
        file_tool_bar.addWidget(self.edit_act)
        #file_tool_bar.addWidget(self.comment_act)
        #file_tool_bar.addWidget(self.tree_act)
        self.connect(file_tool_bar.home_act, QtCore.SIGNAL("clicked()"),
                             self.home_window)

        if not self.msg.is_editable():
            self.edit_act.setDisabled(True)
        return file_tool_bar

    def create_toolbar_second(self):
        """
        create profile for "add profile" window
        @return
        """
        second_tool_bar = ToolbarWindow(parent=self.centr_widg, right=True)
        second_tool_bar.addWidget(self.up_act)
        second_tool_bar.addWidget(self.down_act)
        second_tool_bar.addWidget(self.incr_act)
        second_tool_bar.addWidget(self.decr_act)
        return second_tool_bar

    def create_actions(self):
        """
        create buttons for toolbar
        @return
        """
        """
        self.refresh_act = QtGui.QToolButton(self)
        self.refresh_act.setText(self.tr("Refresh"))
        self.refresh_act.setIcon(QtGui.QIcon("../data/refresh.png"))
        self.refresh_act.setToolButtonStyle(QtCore.Qt.QToolButtonTextUnderIcon)
        self.refresh_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)      
        self.connect(self.refresh_act, QtCore.SIGNAL("clicked()"),
                     self.refresh_mes)
        """
        self.up_act = QtGui.QToolButton(self.centr_widg)
        self.up_act.setIcon(QtGui.QIcon(self.tr("../data/en/post_prev.png")))
        self.up_act.setText(self.tr("Previous"))
        self.up_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.up_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)        
        self.connect(self.up_act, QtCore.SIGNAL("clicked()"),
                     self.view_prev_message)

        self.down_act = QtGui.QToolButton(self.centr_widg)
        self.down_act.setIcon(QtGui.QIcon(self.tr("../data/en/post_next.png")))
        self.down_act.setText(self.tr("Next"))
        self.down_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.down_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.down_act, QtCore.SIGNAL("clicked()"),
                     self.view_next_message)
        
        self.decr_act = QtGui.QToolButton(self.centr_widg)
        self.decr_act.setIcon(QtGui.QIcon(self.tr("../data/en/decrease_font.png")))
        self.decr_act.setText(self.tr("Decrease"))
        self.decr_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.decr_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.decr_act, QtCore.SIGNAL("clicked()"),
                     self.decr_font)

        self.incr_act = QtGui.QToolButton(self.centr_widg)
        self.incr_act.setIcon(QtGui.QIcon(self.tr("../data/en/increase_font.png")))
        self.incr_act.setText(self.tr("Increase"))
        self.incr_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.incr_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.incr_act, QtCore.SIGNAL("clicked()"),
                     self.incr_font)
        """
        self.comment_act = QtGui.QToolButton(self.centr_widg)
        self.comment_act.setIcon(QtGui.QIcon("../data/add_post.png"))
        self.comment_act.setText(self.tr("Write comment"))
        self.comment_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.comment_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.comment_act, QtCore.SIGNAL("clicked()"),
                     self.write_comment)
        """
        self.edit_act = QtGui.QToolButton(self.centr_widg)
        self.edit_act.setIcon(QtGui.QIcon(self.tr("../data/en/post_edit.png")))
        self.edit_act.setText(self.tr("Edit"))
        self.edit_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.edit_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.edit_act, QtCore.SIGNAL("clicked()"),
                     self.edit_post)
        """
        self.tree_act = QtGui.QToolButton(self.centr_widg)
        #self.tree_act.setIcon(QtGui.QIcon("../data/tree.png"))
        self.tree_act.setText(self.tr("Tree of comments"))
        self.tree_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.tree_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.tree_act, QtCore.SIGNAL("clicked()"),
                     self.tree_comments)
        """

    def view_prev_message(self):
        """
        change viewing message on prev
        @param
        @return                                              
        """
        key = self.list.index(self.msg)
        if key <= 1:
            self.up_act.setDisabled(True)
        if key > 0:
            self.down_act.setDisabled(False)
            self.msg = self.list[key - 1]
            if not self.msg.is_editable():
                self.edit_act.setDisabled(True)
            else:
                self.edit_act.setDisabled(False)
            self.reload_window()


    def view_next_message(self):
        """
        change viewing message on next
        @param
        @return                                            
        """
        key = self.list.index(self.msg)
        if key >= len(self.list) - 2:
            self.down_act.setDisabled(True)
        if key < len(self.list) - 1:
            self.up_act.setDisabled(False)
            self.msg = self.list[key + 1]
            if not self.msg.is_editable():
                self.edit_act.setDisabled(True)
            else:
                self.edit_act.setDisabled(False)
            self.reload_window()

    def incr_font(self):
        zoom = self.view_mes_widget.textSizeMultiplier()
        self.view_mes_widget.setTextSizeMultiplier(zoom + 0.1)

    def decr_font(self):
        zoom = self.view_mes_widget.textSizeMultiplier()
        self.view_mes_widget.setTextSizeMultiplier(zoom - 0.1)
 
    def write_comment(self):
        """
        window with field for writing comment
        @param
        @return                                          
        """
        comment_widget = AddCommentWindow(parent = self, msg = self.msg)
        pass

    def edit_post(self):
        """
        window with field for editing post
        @param
        @return                                          
        """
        edit_widg = AddPostWindow(parent=self, msg=self.msg)
    


    def tree_comments(self):
        """
        window with tree message
        @param
        @return                                                      
        """
        tree_widg = TreeMessage(self, self.msg)
    


    def reload_window(self):
        """
        reload window with current message
        @param
        @return                                                                  
        """
        self.msg.read = True
        self.view_mes(self.msg)
        self.view_mes_widget.update()

    def refresh_mes(self):
        """
        reload message
        @param
        @return                                                                  
        """
        acc = self.msg.journal
        try:
            acc.refresh_posts(self.callback)
        except WarningExc, exc:
            super(ViewMessage, self).show_warning(exc)
        else:
            self.reload_window()

    def callback(self):
        print "!!!"


from TreeMessage import *
from AddPost import *
from AddComment import *
