/*
 *  scout Maemo 5 calendar, contact and conversations search tool
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "time-frame-selection.h"
#include <libintl.h>
#include <locale.h>
#include <clockd/libtime.h>

struct _time_frame_buttons_t
{
  GtkWidget* start_time_picker;
  GtkWidget* end_time_picker;
};
typedef _time_frame_buttons_t time_frame_buttons_t;

static 
void 
_update_time_picker_active_state(HildonPickerButton* button,
				 gpointer user_data)
{
  time_frame_buttons_t* time_frame_buttons = (time_frame_buttons_t*)user_data;
  HildonTouchSelector* selector = hildon_picker_button_get_selector(button);
  gint type = hildon_touch_selector_get_active(selector, 0);
  gtk_widget_set_sensitive(time_frame_buttons->start_time_picker,
			   type==SEARCH_UPTO_TODAY ||
			   type==SEARCH_CUSTOM_INTERVAL);
  gtk_widget_set_sensitive(time_frame_buttons->end_time_picker,
			   type==SEARCH_CUSTOM_INTERVAL);

}

gchar*
time_frame_value_str(search_time_settings_t* time_settings)
{
  if(time_settings->search_type == SEARCH_ALL)
  {
    return g_strdup(dgettext("scout", "all"));
  }
  if(time_settings->search_type == SEARCH_THIS_DAY)
  {
    return g_strdup(dgettext("scout", "one day"));
  }
  if(time_settings->search_type == SEARCH_THIS_WEEK)
  {
    return g_strdup(dgettext("scout", "one week"));
  }
  if(time_settings->search_type == SEARCH_THIS_MONTH)
  {
    return g_strdup(dgettext("scout", "one month"));
  }
  if(time_settings->search_type == SEARCH_THIS_YEAR)
  {
    return g_strdup(dgettext("scout", "one year"));
  }
  if(time_settings->search_type == SEARCH_UPTO_TODAY)
  {
    gchar from[255];
    strftime(from, 255, dgettext("hildon-libs","wdgt_va_date"), localtime(&time_settings->start_time));
    return g_strdup_printf("%s - ", from);
  }
  if(time_settings->search_type == SEARCH_CUSTOM_INTERVAL)
  {
    gchar from[255];
    gchar to[255];
    strftime(from, 255, dgettext("hildon-libs","wdgt_va_date"), localtime(&time_settings->start_time));
    strftime(to, 255, dgettext("hildon-libs","wdgt_va_date"), localtime(&time_settings->end_time));    
    return g_strdup_printf("%s - %s", from, to);
  }
  return NULL;
}

void
show_time_selection_dialog(GtkButton* button, gpointer user_data)
{
  search_time_settings_t* search_time_settings = (search_time_settings_t*)user_data;
  GtkWidget* dialog;
  dialog = gtk_dialog_new_with_buttons(dgettext("scout", "Interval"),
				       NULL,
				       GTK_DIALOG_NO_SEPARATOR,
				       dgettext("hildon-libs", "wdgt_bd_done"),
				       GTK_RESPONSE_ACCEPT,
				       NULL);
  GtkWidget* time_frame_button = hildon_picker_button_new(HILDON_SIZE_FINGER_HEIGHT,
							  HILDON_BUTTON_ARRANGEMENT_VERTICAL);
  hildon_button_set_title(HILDON_BUTTON(time_frame_button),
			  dgettext("scout", "Interval"));
  
  GtkWidget* time_search_option_selector = hildon_touch_selector_new_text();
  time_frame_buttons_t* time_frame_buttons = g_new0(time_frame_buttons_t,1);
  
  time_frame_buttons->start_time_picker = hildon_date_button_new(HILDON_SIZE_FINGER_HEIGHT,
								 HILDON_BUTTON_ARRANGEMENT_VERTICAL);
  time_frame_buttons->end_time_picker = hildon_date_button_new(HILDON_SIZE_FINGER_HEIGHT,
							       HILDON_BUTTON_ARRANGEMENT_VERTICAL);
  struct tm* tt;
  if(search_time_settings->start_time>0)
    tt = localtime(&search_time_settings->start_time);
  else
  {
    time_t now = time_get_time();
    tt = localtime(&now);
  }
  hildon_date_button_set_date(HILDON_DATE_BUTTON(time_frame_buttons->start_time_picker),
			      tt->tm_year+1900,
			      tt->tm_mon,
			      tt->tm_mday);
  
  if(search_time_settings->end_time>0)
    tt = localtime(&search_time_settings->end_time);
  else
  {
    time_t now = time_get_time();
    tt = localtime(&now);
  }
  hildon_date_button_set_date(HILDON_DATE_BUTTON(time_frame_buttons->end_time_picker),
			      tt->tm_year+1900,
			      tt->tm_mon,
			      tt->tm_mday);

  gtk_widget_set_sensitive(time_frame_buttons->start_time_picker, FALSE);
  gtk_widget_set_sensitive(time_frame_buttons->end_time_picker, FALSE);
  g_signal_connect(time_frame_button, "value-changed", G_CALLBACK(_update_time_picker_active_state), time_frame_buttons);
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(time_search_option_selector),
				    "All");
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(time_search_option_selector),
				    dgettext("scout", "one day"));
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(time_search_option_selector),
				    dgettext("scout", "one week"));
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(time_search_option_selector),
				    dgettext("scout", "one month"));
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(time_search_option_selector),
				    dgettext("scout", "one year"));
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(time_search_option_selector),
				    dgettext("scout", "from"));
  hildon_touch_selector_append_text(HILDON_TOUCH_SELECTOR(time_search_option_selector),
				    dgettext("scout", "between"));
  hildon_picker_button_set_selector(HILDON_PICKER_BUTTON(time_frame_button),
				    HILDON_TOUCH_SELECTOR(time_search_option_selector));

  hildon_touch_selector_set_active(HILDON_TOUCH_SELECTOR(time_search_option_selector),
				   0, search_time_settings->search_type);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), time_frame_button, TRUE, TRUE, 3);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), time_frame_buttons->start_time_picker, TRUE, TRUE, 3);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), time_frame_buttons->end_time_picker, TRUE, TRUE, 3);
  gtk_widget_show_all(dialog);
  int result = gtk_dialog_run(GTK_DIALOG(dialog));

  if(result == GTK_RESPONSE_ACCEPT)
  {
    search_time_settings->search_type = 
      hildon_touch_selector_get_active(HILDON_TOUCH_SELECTOR(time_search_option_selector),
				       0);
    if(search_time_settings->search_type == SEARCH_UPTO_TODAY ||
       search_time_settings->search_type == SEARCH_CUSTOM_INTERVAL)
    {
      struct tm now;
      now.tm_sec = now.tm_min = now.tm_hour = 0;
      guint year, month, day;
      hildon_date_button_get_date(HILDON_DATE_BUTTON(time_frame_buttons->start_time_picker),
				  &year,
				  &month,
				  &day);
      now.tm_year = year-1900;
      now.tm_mon = month;
      now.tm_mday = day;
      search_time_settings->start_time = mktime(&now);
    }
    if(search_time_settings->search_type == SEARCH_CUSTOM_INTERVAL)
    {
      struct tm now;
      now.tm_sec = now.tm_min = now.tm_hour = 0;

      guint year, month, day;
      hildon_date_button_get_date(HILDON_DATE_BUTTON(time_frame_buttons->end_time_picker),
				  &year,
				  &month,
				  &day);
      now.tm_year = year-1900;
      now.tm_mon = month;
      now.tm_mday = day;
      search_time_settings->end_time = mktime(&now);
    }
    gchar* time_frame_value = time_frame_value_str(search_time_settings);
    hildon_button_set_value(HILDON_BUTTON(button),
			    time_frame_value);
    g_free(time_frame_value);
  }
  gtk_widget_destroy(dialog);
}
