/*
 *  scout Maemo 5 calendar, contact and conversations search tool
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <gtk/gtk.h>
#include <CComponent.h>
#include <CCalendar.h>
#include <CJournal.h>
#include <Common.h>
#include <CTodo.h>
#include <CEvent.h>
#include <hildon/hildon.h>
#include <libintl.h>
#include <locale.h>
#include <gconf/gconf-client.h>	
#include <CalInterface.h>

#include "calendar-event-preview.h"
#include "calendar-recurrence-editor.h"

#define GCONF_TIME_FORMAT_PATH "/apps/clock/time-format"


void
_open_calendar(GtkButton* button, gpointer user_data)
{
  calendar_open_data* data = (calendar_open_data*)user_data;
  int type = 3;
  const char* text = "DUMMY";  
  osso_rpc_run(data->osso,
	       CALENDAR_SERVICE, 
	       CALENDAR_PATH, 
	       CALENDAR_INTERFACE,
	       CALENDAR_LAUNCH_METHOD,
	       NULL,
	       DBUS_TYPE_UINT32, type,
	       DBUS_TYPE_INT32, data->time_stamp, 
	       DBUS_TYPE_STRING, text,
	       DBUS_TYPE_INVALID);
}

static void
delete_cal_open_data(GtkWidget* widget,
		     gpointer user_data)
{
  g_free(user_data);
}

static void
_delete_cal_open_data(GtkWidget* widget,
		      gpointer user_data)
{
  g_free(user_data);
}

void
calendar_add_open_calendar_button_menu(GtkWidget* window, osso_context_t* osso, time_t time_stamp)
{
  HildonAppMenu* menu;
  GtkWidget* open_calendar_button;
  calendar_open_data* cal_open_data = g_new0(calendar_open_data,1);

  cal_open_data->osso = osso;
  cal_open_data->time_stamp = time_stamp;

  menu = HILDON_APP_MENU(hildon_app_menu_new());
  open_calendar_button = hildon_button_new_with_text(HILDON_SIZE_FINGER_HEIGHT,
						     HILDON_BUTTON_ARRANGEMENT_VERTICAL,
						     dgettext("calendar", "cal_ap_name"), 
						     NULL);

  hildon_app_menu_append(menu, GTK_BUTTON(open_calendar_button));
  g_signal_connect(open_calendar_button, "clicked", G_CALLBACK(_open_calendar), cal_open_data);
  gtk_widget_show_all(GTK_WIDGET(menu));
  g_signal_connect(window, "hide", G_CALLBACK(_delete_cal_open_data), cal_open_data);
  hildon_window_set_app_menu(HILDON_WINDOW(window), menu);
}

gboolean
_has_24hr_timeformat()
{
  GConfClient* client = NULL;
  gboolean is24Format = TRUE;
  client = gconf_client_get_default();
  if(!GCONF_IS_CLIENT(client)) 
    return is24Format;

  is24Format =   gconf_client_get_bool(client, GCONF_TIME_FORMAT_PATH, NULL);
  g_object_unref(client);
  return is24Format;
}


gchar*
_format_time_stamp(time_t ttime_stamp)
{
  gchar* time_string = (gchar*)g_malloc0(256);
  struct tm* time_stamp;
  time_stamp = localtime(&ttime_stamp);
  if(_has_24hr_timeformat())
  {
    gchar* full_time_format = g_strdup_printf("%s", 
					      dgettext("hildon-libs", "wdgt_va_24h_time"));
    strftime(time_string, 256, full_time_format, time_stamp);
    g_free(full_time_format);
  }
  else
  {
    gchar* full_time_format = g_strdup_printf("%s", 
					      (time_stamp->tm_hour > 11) ? 
					      dgettext("hildon-libs", "wdgt_va_12h_time_pm") :
					      dgettext("hildon-libs", "wdgt_va_12h_time_am"));
    strftime(time_string, 256, full_time_format, time_stamp);    
    g_free(full_time_format);
  }
  return time_string;
}

gchar*
_format_date_time_stamp(time_t ttime_stamp)
{
  gchar* time_string = (gchar*)g_malloc0(256);
  struct tm* time_stamp;
  time_stamp = localtime(&ttime_stamp);
  if(_has_24hr_timeformat())
  {
    gchar* full_time_format = g_strdup_printf("%s | %s", 
					      dgettext("hildon-libs", "wdgt_va_date"),
					      dgettext("hildon-libs", "wdgt_va_24h_time"));
    strftime(time_string, 256, full_time_format, time_stamp);
    g_free(full_time_format);
  }
  else
  {
    gchar* full_time_format = g_strdup_printf("%s | %s", 
					      dgettext("hildon-libs", "wdgt_va_date"),
					      (time_stamp->tm_hour > 11) ? 
					      dgettext("hildon-libs", "wdgt_va_12h_time_pm") :
					      dgettext("hildon-libs", "wdgt_va_12h_time_am"));
    strftime(time_string, 256, full_time_format, time_stamp);    
    g_free(full_time_format);
  }
  return time_string;
}
