/*
 *  scout Maemo 5 calendar, contact and conversations search tool
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include "config.h"
#include "conversations-search-settings.h"
#include <hildon/hildon.h>
#include <libintl.h>
#include <locale.h>
#include "time-frame-selection.h"

#define GC_ROOT "/apps/maemo/" PACKAGE 
#define GCONF_CONVERSATIONS_SEARCH_SETTINGS GC_ROOT "/conversations_search_settings"

#define GCONF_CONVERSATIONS_SETTINGS_SEARCH_SMS GCONF_CONVERSATIONS_SEARCH_SETTINGS "/search_sms"
#define GCONF_CONVERSATIONS_SETTINGS_SEARCH_IM GCONF_CONVERSATIONS_SEARCH_SETTINGS "/search_im"
#define GCONF_CONVERSATIONS_SETTINGS_SEARCH_TYPE GCONF_CONVERSATIONS_SEARCH_SETTINGS "/search_type"
#define GCONF_CONVERSATIONS_SETTINGS_SEARCH_START_TIME GCONF_CONVERSATIONS_SEARCH_SETTINGS "/search_start_time"
#define GCONF_CONVERSATIONS_SETTINGS_SEARCH_END_TIME GCONF_CONVERSATIONS_SEARCH_SETTINGS "/search_end_time"


static void
_store_conversations_search_settings(conversations_search_settings_t* conversations_search_settings)
{
  GConfClient* client = NULL;
  client = gconf_client_get_default();
  g_return_if_fail(GCONF_IS_CLIENT(client));
  gconf_client_set_bool(client, 
			GCONF_CONVERSATIONS_SETTINGS_SEARCH_SMS, 
			conversations_search_settings->search_sms, 
			NULL);

  gconf_client_set_bool(client, 
			GCONF_CONVERSATIONS_SETTINGS_SEARCH_IM, 
			conversations_search_settings->search_im,
			NULL);
  gconf_client_set_int(client, GCONF_CONVERSATIONS_SETTINGS_SEARCH_TYPE, 
		       conversations_search_settings->search_type, 
		       NULL);
  
  gconf_client_set_int(client, GCONF_CONVERSATIONS_SETTINGS_SEARCH_START_TIME, 
		       conversations_search_settings->start_time, 
		       NULL);
  
  gconf_client_set_int(client, GCONF_CONVERSATIONS_SETTINGS_SEARCH_END_TIME, 
		       conversations_search_settings->end_time, 
		       NULL);
  g_object_unref(client);  
}

void
show_conversations_search_settings_dlg(GtkButton* button, gpointer user_data)
{

  conversations_search_settings_t* conversations_search_settings = (conversations_search_settings_t*)user_data;
  GtkWidget* dialog;
  dialog = gtk_dialog_new_with_buttons("Conversation Search Settings",
				       NULL,
				       GTK_DIALOG_NO_SEPARATOR,
				       dgettext("hildon-libs", "wdgt_bd_save"),
				       GTK_RESPONSE_ACCEPT, 
				       dgettext("hildon-libs", "wdgt_bd_done"),
				       GTK_RESPONSE_OK, 
				       NULL);
  GtkWidget* search_sms_button = hildon_gtk_toggle_button_new(HILDON_SIZE_FINGER_HEIGHT);
  GtkWidget* search_im_button = hildon_gtk_toggle_button_new(HILDON_SIZE_FINGER_HEIGHT);
  
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(search_sms_button),
			       conversations_search_settings->search_sms);
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(search_im_button),
			       conversations_search_settings->search_im);
  GtkWidget* enable_time_frame_search_button = hildon_button_new(HILDON_SIZE_FINGER_HEIGHT,
								 HILDON_BUTTON_ARRANGEMENT_VERTICAL);
  hildon_button_set_title(HILDON_BUTTON(enable_time_frame_search_button),
			  gettext("Period"));
  search_time_settings_t* search_time_settings = g_new0(search_time_settings_t,1);
  search_time_settings->search_type = conversations_search_settings->search_type;
  search_time_settings->start_time = conversations_search_settings->start_time;
  search_time_settings->end_time = conversations_search_settings->end_time;
  gchar* time_frame_value = time_frame_value_str(search_time_settings);
  hildon_button_set_value(HILDON_BUTTON(enable_time_frame_search_button),
			  time_frame_value);
  g_free(time_frame_value);

  g_signal_connect(enable_time_frame_search_button, "clicked", G_CALLBACK(show_time_selection_dialog), search_time_settings);

  
  gtk_button_set_image(GTK_BUTTON(search_sms_button),
		       gtk_image_new_from_icon_name("general_sms",
						    GtkIconSize(HILDON_ICON_SIZE_FINGER)));
  
  gtk_button_set_image(GTK_BUTTON(search_im_button),
		       gtk_image_new_from_icon_name("general_chat",
						    GtkIconSize(HILDON_ICON_SIZE_FINGER)));
  
  GtkWidget* chat_type_box = gtk_hbox_new(TRUE, 3);
  gtk_box_pack_start(GTK_BOX(chat_type_box), search_sms_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(chat_type_box), search_im_button, TRUE, TRUE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), chat_type_box, FALSE, FALSE, 0);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), enable_time_frame_search_button, TRUE, TRUE, 0);
  gtk_widget_show_all(dialog);
  int result = gtk_dialog_run(GTK_DIALOG(dialog));
  if(result == GTK_RESPONSE_ACCEPT ||
     result == GTK_RESPONSE_OK)
  {
    conversations_search_settings->search_sms = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(search_sms_button));
    conversations_search_settings->search_im = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(search_im_button));
    conversations_search_settings->search_type = search_time_settings->search_type;
    conversations_search_settings->start_time = search_time_settings->start_time;
    conversations_search_settings->end_time = search_time_settings->end_time;
    if(result == GTK_RESPONSE_ACCEPT)
    {
      _store_conversations_search_settings(conversations_search_settings);
    }
  }
  g_free(search_time_settings);
  gtk_widget_destroy(dialog);
}

void
conversations_search_settings_read(GConfClient* client, conversations_search_settings_t* conversations_search_settings)
{
  if(gconf_client_dir_exists(client, GCONF_CONVERSATIONS_SEARCH_SETTINGS, NULL))
  {
    conversations_search_settings->search_sms = 
      gconf_client_get_bool(client, GCONF_CONVERSATIONS_SETTINGS_SEARCH_SMS, NULL);
    conversations_search_settings->search_im = 
      gconf_client_get_bool(client, GCONF_CONVERSATIONS_SETTINGS_SEARCH_IM, NULL);
    conversations_search_settings->search_type = 
      gconf_client_get_int(client, GCONF_CONVERSATIONS_SETTINGS_SEARCH_TYPE, NULL);
    conversations_search_settings->start_time = 
      gconf_client_get_int(client, GCONF_CONVERSATIONS_SETTINGS_SEARCH_START_TIME, NULL);
    conversations_search_settings->end_time = 
      gconf_client_get_int(client, GCONF_CONVERSATIONS_SETTINGS_SEARCH_END_TIME, NULL);
  }
  else
  {
    conversations_search_settings->search_sms = TRUE;
    conversations_search_settings->search_im = TRUE;
    conversations_search_settings->search_type = SEARCH_ALL;
    conversations_search_settings->start_time = 0;
    conversations_search_settings->end_time = 0;
  }
}
