/*
 *  scout Maemo 5 calendar, contact and conversations search tool
 *  Copyright (C) 2010 Nicolai Hess
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _SCOUT_WINDOW_H_
#define _SCOUT_WINDOW_H_

#include <hildon/hildon.h>
#include <libosso.h>
#include <libosso-abook/osso-abook.h>

G_BEGIN_DECLS

#define SCOUT_TYPE_WINDOW (scout_window_get_type())
#define SCOUT_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCOUT_TYPE_WINDOW, ScoutWindow))
#define SCOUT_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SCOUT_TYPE_WINDOW, ScoutWindowClass))
#define IS_SCOUT_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCOUT_TYPE_WINDOW))
#define IS_SCOUT_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((obj), SCOUT_TYPE_WINDOW))
#define SCOUT_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SCOUT_TYPE_WINDOW, ScoutWindowClass))

typedef struct _ScoutWindow ScoutWindow;
typedef struct _ScoutWindowClass ScoutWindowClass;
typedef struct _ScoutWindowPrivate ScoutWindowPrivate;

struct _ScoutWindowClass
{
  HildonStackableWindowClass parent_class;
};

struct _ScoutWindow
{
  HildonStackableWindow parent;
  
  ScoutWindowPrivate *priv;
};

GType scout_window_get_type(void);

ScoutWindow* scout_window_new(osso_context_t* osso);
void scout_window_set_abook(ScoutWindow* window, 
			    OssoABookAggregator* abook); 

void scout_window_set_account_manager(ScoutWindow* window, 
				      OssoABookAccountManager* acc_manger); 
G_END_DECLS
#endif
