#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include "sabconnector.h"
#include "historydetails.h"
#include <QtGui>

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();
    void uploadFileCommand(char*);

private:
    Ui::MainWindow *ui;
    SabConnector sc;
    QString ucfirst(const QString);
    QMap<int ,QMap<QString,QString > > historyitemcache;

private slots:
    void on_lstHistory_itemClicked(QTreeWidgetItem* item, int column);
    void on_pbStatus_clicked();
    void on_pbHistory_clicked();
    void on_pbAdd_clicked();
    void on_pbRefresh_clicked();
    void showAbout();
    void showSettings();

public slots:
    void updateLabel(QString, QString);
    void updateDownloadList(QMap<QString,QMap<QString,QString > > );
    void updateHistoryList(QMap<QString,QMap<QString,QString > > );
    void showError(QString);
};

#endif // MAINWINDOW_H

