#include "mainwindow.h"
#include "ui_mainwindow.h"
#include "downloadviewdelegate.h"
#include "settingsdialog.h"
#include <QDebug>
#include <QFileDialog>
#include <QDateTime>
#include <QMaemo5InformationBox>
#include <QtGui>

MainWindow::MainWindow(QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::MainWindow)
{
    ui->setupUi(this);
    ui->lstHistory->hide();
    connect(&sc,SIGNAL(updateLabelReady(QString, QString)),this,SLOT(updateLabel(QString , QString)));
    connect(&sc,SIGNAL(downloadListReady(QMap<QString,QMap<QString,QString > >)),this,SLOT(updateDownloadList(QMap<QString,QMap<QString,QString > >)));
    connect(&sc,SIGNAL(historyListReady(QMap<QString,QMap<QString,QString > >)),this,SLOT(updateHistoryList(QMap<QString,QMap<QString,QString > >)));
    connect(&sc,SIGNAL(errorOccured(QString)),this,SLOT(showError(QString)));

    DownloadviewDelegate* dg = new DownloadviewDelegate(this);
    ui->lstDownloads->setItemDelegate(dg);

    QStringList header;
    header << "Name" << "Size" << "Progress" << "Downloaded" << "Time left";
    ui->lstDownloads->setHeaderLabels(header);

    header.clear();
    header << "Name" << "Size" << "Status" << "Completed";
    ui->lstHistory->setHeaderLabels(header);

    setAttribute(Qt::WA_Maemo5AutoOrientation, true);
    //add menubar items
    QAction *settingsAction = new QAction(tr("Settings"), this);
    menuBar()->addAction(settingsAction);
    connect(settingsAction,SIGNAL(triggered(bool)),this,SLOT(showSettings()));

    QAction *aboutAction = new QAction(tr("About"), this);
    menuBar()->addAction(aboutAction);
    connect(aboutAction,SIGNAL(triggered(bool)),this,SLOT(showAbout()));
}

MainWindow::~MainWindow()
{
    delete ui;
}

void MainWindow::on_pbRefresh_clicked()
{
    sc.refreshDownloads();
}

void MainWindow::updateLabel(QString label, QString value)
{
    qDebug() << "updateLabel: "+label+":"+value;

    if(label=="mbleft") {
        double rounded=static_cast<double>(static_cast<int>(value.toDouble()*100+0.5))/100.0;
        ui->lblMBLeft->setText( QString::number (rounded) .append("MB Left"));
    } else if (label=="speed") {
        ui->lblSpeed->setText(value.trimmed().append(" KB/s"));
    } else if (label=="state" || label=="status") {
        ui->lblStatus->setText(ucfirst(value));
    } else {
        qDebug() << "Unknown label: "+label+":"+value;
    }
}

void MainWindow::updateDownloadList(QMap<QString,QMap<QString,QString > > downloads)
{
    ui->lstHistory->hide();
    ui->lstDownloads->show();
    ui->lstDownloads->clear();
    QMapIterator<QString, QMap<QString,QString> > i(downloads);
    while (i.hasNext()) {
        i.next();
        QMap<QString,QString> download = i.value();
        QTreeWidgetItem* item = new QTreeWidgetItem(ui->lstDownloads,ui->lstDownloads->columnCount());
        item->setText(0,download["filename"]);
        item->setText(1,QString::number(static_cast<double>(static_cast<int>(download["mb"].toDouble()*100+0.5))/100.0));
        double perc = download["mbleft"].toDouble()*100/download["mb"].toDouble();
        qDebug() <<  "Perc: "+QString::number(perc);
        item->setText(2,QString::number((100-(int)perc)));
        item->setText(3,QString::number(static_cast<double>(static_cast<int>(download["mbleft"].toDouble()*100+0.5))/100.0));
        item->setText(4,download["timeleft"]);
        qDebug() <<  "Hmm: "+download["filename"];
    }
    for(int i = 0; i< ui->lstDownloads->columnCount(); i++)
    {
        if(i!=2)
            ui->lstDownloads->resizeColumnToContents(i);
    }

}

void MainWindow::on_pbAdd_clicked()
{
    qDebug() << "pbAdd_clicked";

    QString filename = QFileDialog::getOpenFileName(this, tr("Select NZB"), QDir::homePath(), tr("SabNZBd Compatible files (*.zip *.rar *.nzb)"), 0);

    if( !filename.isNull() )
        sc.addNZB(filename);
}

void MainWindow::showSettings()
{
    SettingsDialog sd(this);
    sd.setModal(true);
    sd.exec();
}

void MainWindow::showAbout()
{
    QMessageBox::information(this,"About SabGUI","<b>SabGUI</b><br>By Ted van den Brink<br><a href=\"mailto:ted@digistate.nl\">ted@digistate.nl</a>");
}

void MainWindow::on_pbHistory_clicked()
{
    qDebug() << "pbHistory_clicked";
    sc.refreshHistory();
}

void MainWindow::showError(QString error)
{
    QMaemo5InformationBox::information(this, error, QMaemo5InformationBox::DefaultTimeout);
}

void MainWindow::updateHistoryList(QMap<QString,QMap<QString,QString > > historyitems)
{
    qDebug() << "updateHistoryList";
    ui->lstHistory->show();
    ui->lstDownloads->hide();

    ui->lstHistory->clear();

    QDateTime timestamp;
    QMapIterator<QString, QMap<QString,QString> > i(historyitems);

    while (i.hasNext()) {
        i.next();
        QMap<QString,QString> download = i.value();
        //qDebug() << download[""];
        QTreeWidgetItem* item = new QTreeWidgetItem(ui->lstHistory,ui->lstHistory->columnCount());

        timestamp.setTime_t(download["completed"].toUInt());
        //qDebug() << timestamp.toString(Qt::SystemLocaleDate);

        item->setText(0,download["nzb_name"]);
        item->setText(1,download["size"]);
        item->setText(2,download["status"]);
        item->setText(3,timestamp.toString(Qt::SystemLocaleDate));
    }
    for(int i = 0; i< ui->lstHistory->columnCount(); i++)
        ui->lstHistory->resizeColumnToContents(i);
}

QString MainWindow::ucfirst(const QString str) {
        if (str.size() < 1) {
        return "";
        }

        QStringList tokens = str.split(" ");
        QList<QString>::iterator tokItr = tokens.begin();

        for (tokItr = tokens.begin(); tokItr != tokens.end(); ++tokItr) {
        (*tokItr) = (*tokItr).at(0).toUpper() + (*tokItr).mid(1);
        }

        return tokens.join(" ");
}
