
/*
    This file belongs to rs (Remote security) package for Nokia N900
    Copyright (C) 2009  Pavan Patale <pavan.patale@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


/* Includes */
#include <hildon/hildon.h>




gchar* rs_ui_create_get_pw_dialog(GtkWidget *parent, gchar *msg)
{
    GtkWidget *pw = NULL;
    gchar *pwd = NULL;
    gint response = -1;

    pw = hildon_get_password_dialog_new(GTK_WINDOW(parent), FALSE);

    hildon_get_password_dialog_set_message(HILDON_GET_PASSWORD_DIALOG(pw), msg);

    response = gtk_dialog_run(GTK_DIALOG(pw));

    if(response == GTK_RESPONSE_OK)
    {
        pwd = g_strdup((gchar *)hildon_get_password_dialog_get_password(HILDON_GET_PASSWORD_DIALOG(pw)));
    }
    gtk_widget_destroy(pw);
    return pwd;
}


gchar *rs_ui_create_set_pw_dialog(GtkWidget *parent, const gchar *message)
{
    GtkWidget *dialog = NULL;	
    const gchar *pass = NULL;
    gchar *p = NULL;
    gint response = -1;

    dialog = GTK_WIDGET(hildon_set_password_dialog_new(GTK_WINDOW(parent), FALSE));
    hildon_set_password_dialog_set_message(HILDON_SET_PASSWORD_DIALOG(dialog), message);
    response = gtk_dialog_run(GTK_DIALOG(dialog));
    if(response == GTK_RESPONSE_OK) 
    {
	//TODO: Is pass newly allocated?
	pass = (const gchar *)hildon_set_password_dialog_get_password(HILDON_SET_PASSWORD_DIALOG(dialog));
        p = g_strdup(pass);
    }
    gtk_widget_destroy(dialog);
    return p;
}

gint rs_ui_create_confirmation_note(GtkWidget *parent, gchar *msg, gchar *text1, gchar *text2)
{
    GtkWidget *note = NULL;	
    gint response = 0;

    note = GTK_WIDGET(hildon_note_new_confirmation(GTK_WINDOW(parent), msg));
    if(text1 && text2)
    {
        hildon_note_set_button_texts(HILDON_NOTE(note), text1, text2);
    }
    response = gtk_dialog_run(GTK_DIALOG(note));
    gtk_widget_destroy(note);
    return response;
}

void rs_ui_create_information_note(GtkWidget *parent, gchar *msg)
{
    GtkWidget *note = NULL;	
    note = GTK_WIDGET(hildon_note_new_information(GTK_WINDOW(parent), msg)); 
    gtk_dialog_run(GTK_DIALOG(note));
    gtk_widget_destroy(note);
}

void rs_ui_create_information_banner(GtkWidget *parent, gchar *msg)
{
    hildon_banner_show_information(GTK_WIDGET(parent), NULL, msg);
}
