/*
    This file belongs to rs (Remote security) package for Nokia N900
    Copyright (C) 2009  Pavan Patale <pavan.patale@gmail.com>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/


#include <glib.h>

enum {
    UNKNOWN = 0,
    LOCK,
    UNLOCK,
    PLAY,
    LAST
};

enum {
    ACTIVE=1,
    PASSIVE
};    

gboolean rs_registry_set_passphrase(const gchar *passphrase);

gboolean rs_registry_set_lockcmd(const gchar *lock);

gboolean rs_registry_set_unlockcmd(const gchar *unlock);

gboolean rs_registry_set_remote_enabled(gboolean val);

gint rs_registry_compare_cmd(gchar *str);

gboolean rs_registry_compare_passphrase(gchar *str);

gboolean rs_registry_remote_enabled();

gboolean rs_registry_init();

gchar* rs_registry_get_last_imsi();

void rs_registry_set_current_imsi(const gchar *);

gboolean rs_registry_lock_device();
gboolean rs_registry_unlock_device();

gboolean rs_registry_set_rs_choice(int choice);
gint rs_registry_get_rs_choice();

void rs_registry_watch_remote_lock(gchar *msg);
