/*
 * Copyright (C) 2010 Collabora Ltd.
 *   @author Marco Barisione <marco.barisione@collabora.co.uk>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef RINGTONED_IS_COMPILING_APP
#error "Don't include this file directly, use ringtoned/plugin.h instead"
#endif


#ifndef __RINGTONED_CALL_H__
#define __RINGTONED_CALL_H__

#include <telepathy-glib/channel.h>
#include <libosso-abook/osso-abook.h>


G_BEGIN_DECLS
 
#define RINGTONED_TYPE_CALL             (ringtoned_call_get_type ())
#define RINGTONED_CALL(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), RINGTONED_TYPE_CALL, RingtonedCall))
#define RINGTONED_CALL_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), RINGTONED_TYPE_CALL, RingtonedCallClass))
#define RINGTONED_IS_CALL(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RINGTONED_TYPE_CALL))
#define RINGTONED_IS_CALL_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), RINGTONED_TYPE_CALL))
#define RINGTONED_CALL_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), RINGTONED_TYPE_CALL, RingtonedCallClass))

typedef enum
{
    RINGTONED_CALL_STATUS_RINGING,
    RINGTONED_CALL_STATUS_ACTIVE,
    RINGTONED_CALL_STATUS_CLOSED
} RingtonedCallStatus;

typedef struct _RingtonedCall        RingtonedCall;
typedef struct _RingtonedCallClass   RingtonedCallClass;
typedef struct _RingtonedCallPrivate RingtonedCallPrivate;

struct _RingtonedCall
{
    GObject parent;

    /*< private >*/
    RingtonedCallPrivate *priv;
};

struct _RingtonedCallClass
{
    GObjectClass parent_class;
};

GType               ringtoned_call_get_type             (void) G_GNUC_CONST;

void                ringtoned_call_play_ringtone        (RingtonedCall  *self);


#define RINGTONED_TYPE_CONTACTS_LIST    (ringtoned_contacts_list_get_type ())

GType               ringtoned_contacts_list_get_type    (void) G_GNUC_CONST;
void                ringtoned_contacts_list_free        (GList      *contacts);
GList *             ringtoned_contacts_list_copy        (GList      *contacts);

G_END_DECLS

#endif /* __RINGTONED_CALL_H__ */
