/*************************************************************************}
{ spinnumber.cpp - number display with inc/dec buttons                    }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 31 May 2012                                              }
{*************************************************************************/

#include "spinnumber.h"
#include "mainwindow.h"

SpinNumber::SpinNumber(QWidget *parent) :
    QWidget(parent)
{
    label = new Label(this);
    label->setAlignment(Qt::AlignCenter);
    label->move(0, 0);

    btnUp = new Button(this);
    btnUp->setIcon(SKIN.icoUp);
    connect(btnUp, SIGNAL(clicked()), SLOT(onBtnUpClick()));

    btnDown = new Button(this);
    btnDown->setIcon(SKIN.icoDown);
    connect(btnDown, SIGNAL(clicked()), SLOT(onBtnDownClick()));

    minValue = 0;
    maxValue = 9;
    step = 1;
    cycled = true;
    value = 0;

    resize(btnUp->width(), btnUp->height()*4);
    updateDisplay();
}

SpinNumber::~SpinNumber()
{
    delete label;
    delete btnUp;
    delete btnDown;
}

int SpinNumber::setValue(int newValue)
{
    value = newValue;
    if(value < minValue)
    {
        value = minValue;
    }
    else
    {
        if(value > maxValue)
            value = maxValue;
    }
    updateDisplay();
    return value;
}

void SpinNumber::resizeEvent(QResizeEvent *event)
{
    int h = event->size().height();
    label->resize(event->size().width(), event->size().height() - (btnUp->height() + CONTROLBUTTON_PUSHOFFSET)*2);
    int bx = (label->width()-btnUp->width())/2;
    btnUp->move(bx, label->height());
    btnDown->move(bx, h - btnUp->height() - CONTROLBUTTON_PUSHOFFSET);
    QString s;
    s.setNum(label->height());
    label->setStyleSheet(QString("font-size:")+s+"px;");
}

void SpinNumber::updateDisplay()
{
    QString s;
    s.setNum(value);
    label->setText(s);
}

void SpinNumber::cycleValue(int valueStep)
{
    value = value + valueStep;
    if(value > maxValue)
    {
        if(cycled)
            value = minValue;
        else
            value = maxValue;
    }
    else
    {
        if(value < minValue)
        {
            if(cycled)
                value = maxValue;
            else
                value = minValue;
        }
    }
    updateDisplay();
}

void SpinNumber::onBtnUpClick()
{
    cycleValue(step);
}

void SpinNumber::onBtnDownClick()
{
    cycleValue(-step);
}
