/*************************************************************************}
{ skin.cpp - skin loader                                                  }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 21 Mar 2012                                              }
{*************************************************************************/

#include "skin.h"
#include "mainwindow.h"

Skin::Skin()
{
    QPixmap px(ICON_SIZE, ICON_SIZE);
    px.fill(Qt::transparent);
    icoNone = QIcon(px);
    skinRoot = APP_DIR+"skins/";
}

bool Skin::loadIcon(QIcon* ico, const QString& filename)
{
    if(!QFile::exists(filename))
        return false;
    QIcon i;
    i.addFile(filename);
    *ico = i;
    return true;
}

bool Skin::load(const QString& skinName)
{
    QString skinDir = skinRoot + skinName;

    QDir dir(skinDir);
    if(!dir.exists())
        return false;
    QString curDir = QDir::currentPath();
    QDir::setCurrent(skinDir);

    if(!loadIcon(&icoFile, "file.png")) return false;
    if(!loadIcon(&icoFilePause, "file_pause.png")) return false;
    if(!loadIcon(&icoFilePlay, "file_play.png")) return false;
    if(!loadIcon(&icoFileStop, "file_stop.png")) return false;
    if(!loadIcon(&icoFolder, "folder.png")) return false;
    if(!loadIcon(&icoFolderPlay, "folder_play.png")) return false;
    if(!loadIcon(&icoNext, "next.png")) return false;
    if(!loadIcon(&icoPause, "pause.png")) return false;
    if(!loadIcon(&icoPlay, "play.png")) return false;
    if(!loadIcon(&icoPrev, "prev.png")) return false;
    if(!loadIcon(&icoStop, "stop.png")) return false;
    if(!loadIcon(&icoParent, "parent.png")) return false;
    if(!loadIcon(&icoUp, "up.png")) return false;
    if(!loadIcon(&icoDown, "down.png")) return false;
    if(!loadIcon(&icoCheck, "check.png")) return false;
    if(!loadIcon(&icoUncheck, "uncheck.png")) return false;
    if(!loadIcon(&icoItemNew, "item_new.png")) return false;
    if(!loadIcon(&icoItemDelete, "item_delete.png")) return false;
    if(!loadIcon(&icoItemSave, "item_save.png")) return false;
    if(!loadIcon(&icoItemRename, "item_rename.png")) return false;

    QSettings ini(SKIN_INI_FILENAME, QSettings::IniFormat);
    ini.setIniCodec("UTF-8");

    ini.beginGroup("css");
    cssNormal = ini.value("normalItem", "color:white;border:0px;font-weight:bold;font-size:24px;").toString();
    cssActive = ini.value("activeItem", "color:red;border:0px;font-weight:bold;font-size:24px;").toString();
    cssCommon = ini.value("common", "background:black;color:white;font-family:Arial;").toString();
    cssCommonWindows = ini.value("windows", "").toString();
    cssCommonControls = ini.value("controls", "background:transparent;").toString();
    ini.endGroup();
    if(cssNormal.indexOf("}") >= 0)
        return false;
    if(cssActive.indexOf("}") >= 0)
        return false;
    if(cssCommon.indexOf("}") >= 0)
        return false;
    if(cssCommonWindows.indexOf("}") >= 0)
        return false;
    if(cssCommonControls.indexOf("}") >= 0)
        return false;

    // transform relative urls to absolute
    QRegExp rx("url\\(\\'([^\\']+)\\'\\)");
    QString after(QString("url('")+skinDir+"/\\1')");
    cssNormal.replace(rx, after);
    cssActive.replace(rx, after);
    cssCommon.replace(rx, after);
    cssCommonWindows.replace(rx, after);
    cssCommonControls.replace(rx, after);

    QDir::setCurrent(curDir);

    currentSkinName = skinName;

    return true;
}

void Skin::initKineticWidget(QKineticWidget* kinetic) const
{
    kinetic->setCssActive(cssActive);
    kinetic->setCssNormal(cssNormal);
}

QStringList Skin::getAvailableSkins() const
{
    QDir root(skinRoot);
    QStringList dirs = root.entryList(
                QDir::AllDirs | QDir::NoDotAndDotDot |
                QDir::Readable | QDir::Executable |
                QDir::Hidden,
                QDir::Name | QDir::IgnoreCase);
    QStringList skins;
    foreach(QString skinName, dirs)
        if(QFile::exists(skinRoot+skinName+"/"+SKIN_INI_FILENAME))
            skins.append(skinName);
    return skins;
}
