/*************************************************************************}
{ optionswindow.cpp - options window                                      }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 21 Apr 2012                                              }
{*************************************************************************/

#include "optionswindow.h"

OptionsWindow::OptionsWindow(QWidget *parent) :
    ContainerDialog(parent)
{
    initGui();
    reposition(size());
    fillOptions();
}

OptionsWindow::~OptionsWindow()
{
    deinitGui();
}

int OptionsWindow::showDialog()
{
    bool hideHiddenFolders = options.hideHiddenFolders;
    bool showUserFolders = options.showUserFolders;
    bool hideHiddenFiles = options.hideHiddenFiles;
    bool useFileFilters = options.useFileFilters;
    updateSkin();
    ContainerDialog::showDialog();
    fillOptions();
    return
        (hideHiddenFolders != options.hideHiddenFiles)
            ||
        (showUserFolders != options.showUserFolders)
            ||
        (hideHiddenFiles != options.hideHiddenFiles)
            ||
        (useFileFilters != options.useFileFilters);
}

void OptionsWindow::initGui()
{
    ContainerDialog::initGui();
    setWindowTitle(tr("Options"));

    QStringList playModes;
    playModes.append(tr("Playlist once", "playMode"));
    playModes.append(tr("Loop playlist", "playMode"));
    playModes.append(tr("Random", "playMode"));
    playModes.append(tr("One track once", "playMode"));
    playModes.append(tr("Loop one track", "playMode"));

    QStringList breakActions;
    breakActions.append(tr("Pause", "breakAction"));
    breakActions.append(tr("Stop", "breakAction"));
    breakActions.append(tr("Do nothing", "breakAction"));

    QStringList screenOrientations;
    screenOrientations.append(tr("Portrait", "screenOrientation"));
    screenOrientations.append(tr("Landscape", "screenOrientation"));
    screenOrientations.append(tr("Auto", "screenOrientation"));

    opt_playMode = OptionItem::create(itemsContainer, oit_SelectInt, "playMode", pmo_playlistOnce, tr("Play mode"), playModes);
    opt_screenOrientation = OptionItem::create(itemsContainer, oit_SelectInt, "screenOrientation", soo_Portrait, tr("Screen orientation"), screenOrientations);
    opt_clearPlaylist = OptionItem::create(itemsContainer, oit_Check, "clearPlaylist", true, tr("Clear playlist when manually selecting a file"));
    opt_restorePlaylist = OptionItem::create(itemsContainer, oit_Check, "restorePlaylist", false, tr("Restore playlist on startup"));
    opt_hideHiddenFolders = OptionItem::create(itemsContainer, oit_Check, "hideHiddenFolders", true, tr("Hide hidden folders"));
    opt_showUserFolders = OptionItem::create(itemsContainer, oit_Check, "showUserFolders", true, tr("Always show user folders"));
    opt_hideHiddenFiles = OptionItem::create(itemsContainer, oit_Check, "hideHiddenFiles", true, tr("Hide hidden files"));
    opt_useFileFilters = OptionItem::create(itemsContainer, oit_Check, "useFileFilters", true, tr("Show only files with selected extensions"));
    opt_headsetUnplugAction = OptionItem::create(itemsContainer, oit_SelectInt, "headsetUnplugAction", bao_Pause, tr("Headest unplug action"), breakActions);
    opt_resumeOnPlugin = OptionItem::create(itemsContainer, oit_Check, "resumeOnPlugin", true, tr("Resume if headset has been plugged in"));
    opt_incomingCallAction = OptionItem::create(itemsContainer, oit_SelectInt, "incomingCallAction", bao_Pause, tr("Incoming call action"), breakActions);
    opt_resumeOnHangup = OptionItem::create(itemsContainer, oit_Check, "resumeOnHangup", true, tr("Resume when hang up"));
    opt_popupTrackTitles = OptionItem::create(itemsContainer, oit_Check, "popupTrackTitles", false, tr("Pop up track titles"));
    opt_letTrackEnd = OptionItem::create(itemsContainer, oit_Check, "letTrackEnd", false, tr("Let a current track to end before a stop by the timer"));
    opt_buttonsCancelTimer = OptionItem::create(itemsContainer, oit_Check, "buttonsCancelTimer", false, tr("Pushing a button or a file cancels the timer"));
    opt_skinName = OptionItem::create(itemsContainer, oit_SelectString, "skinName", DEFAULT_SKIN_NAME, tr("Skin"), SKIN.getAvailableSkins());
}

void OptionsWindow::deinitGui()
{
    foreach(QObject* child, itemsContainer->children())
        ((OptionItem*)child)->save();
    ContainerDialog::deinitGui();
}

void OptionsWindow::fillOptions()
{
    options.clearPlaylist = opt_clearPlaylist->getBool();
    options.restorePlaylist = opt_restorePlaylist->getBool();
    options.hideHiddenFolders = opt_hideHiddenFolders->getBool();
    options.showUserFolders = opt_showUserFolders->getBool();
    options.hideHiddenFiles = opt_hideHiddenFiles->getBool();
    options.useFileFilters = opt_useFileFilters->getBool();
    options.playMode = (PlayModeOption)(opt_playMode->getInt());
    options.headsetUnplugAction = (BreakActionOption)(opt_headsetUnplugAction->getInt());
    options.resumeOnPlugin = opt_resumeOnPlugin->getBool();
    options.incomingCallAction = (BreakActionOption)(opt_incomingCallAction->getInt());
    options.resumeOnHangup = opt_resumeOnHangup->getBool();
    options.popupTrackTitles = opt_popupTrackTitles->getBool();
    options.screenOrientation = (ScreenOrientationOption)(opt_screenOrientation->getInt());
    options.letTrackEnd = opt_letTrackEnd->getBool();
    options.buttonsCancelTimer = opt_buttonsCancelTimer->getBool();
    options.skinName = opt_skinName->getString();
}

void OptionsWindow::updateSkin()
{
    foreach(QObject* child, itemsContainer->children())
        ((OptionItem*)child)->updateIcon();
    SKIN.initKineticWidget(itemsContainer);
}

void OptionsWindow::reposition(const QSize &sz, int rows)
{
    //ContainerDialog::reposition(sz, rows);
    itemsContainer->resize(sz);

    foreach(QObject* child, itemsContainer->children())
        ((OptionItem*)child)->updateLabel();
    itemsContainer->repositionChildrenV(ITEM_HEIGHT+5, rows); // considering multiline text leading
}

void OptionsWindow::onItemClick(QWidget* item)
{
    OptionItem* theItem = (OptionItem*)item;
    theItem->click();
    if(theItem == opt_skinName)
    {
        QString skinName = theItem->getString();
        if(SKIN.currentSkinName != skinName)
        {
            MAINWINDOW->changeSkin(skinName);
            updateSkin();
        }
    }
}
