/*************************************************************************}
{ typeswindow.h - dialog with a list of supported/enabled extensions      }
{                                                                         }
{ This file is a part of the project                                      }
{   Rhapsodie - Music player for N900                                     }
{                                                                         }
{ (c) Alexey Parfenov, 2012                                               }
{                                                                         }
{ e-mail: zxed@alkatrazstudio.net                                         }
{                                                                         }
{ This program is free software; you can redistribute it and/or           }
{ modify it under the terms of the GNU General Public License             }
{ as published by the Free Software Foundation; either version 3 of       }
{ the License, or (at your option) any later version.                     }
{                                                                         }
{ This program is distributed in the hope that it will be useful,         }
{ but WITHOUT ANY WARRANTY; without even the implied warranty of          }
{ MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU        }
{ General Public License for more details.                                }
{                                                                         }
{ You may read GNU General Public License at:                             }
{   http://www.gnu.org/copyleft/gpl.html                                  }
{                                                                         }
{ last modified: 21 Mar 2012                                              }
{*************************************************************************/

#ifndef TYPESWINDOW_H
#define TYPESWINDOW_H

#include "containerdialog.h"
#include "mainwindow.h"

class TypesWindow : public ContainerDialog
{
    Q_OBJECT
public:
    explicit TypesWindow(QWidget *parent = 0);
    ~TypesWindow();

    static QStringList getSupportedTypes();
    static QStringList showTypesDialog();

    virtual void reposition(const QSize &sz, int rows = 1);

protected:
    void buildList();
    void initGui();

    QStringList showModal();

protected slots:
    void onItemClick(QWidget* item);

};

#endif // TYPESWINDOW_H
