/*
 * QThumbnailCreator.h
 *
 *  Created on: Jul 25, 2010
 *      Author: alexr
 */

#ifndef QTHUMBNAILCREATOR_H_
#define QTHUMBNAILCREATOR_H_

#include <QWebView>
#include <QPixmap>
#include "QEnmlReader.h"
#include <QDebug>

class QThumbnailCreator : public QObject
{
	Q_OBJECT

public:
	QThumbnailCreator(Guid guid) : m_bAutoclean(true) {
		QObject::connect(&webView, SIGNAL(loadFinished(bool)), this, SLOT(setNoteSnapshot()));
		QObject::connect(&webView, SIGNAL(loadProgress(int)), this, SLOT(updateLoadProgress(int)));
		webView.settings()->setAttribute(QWebSettings::LocalContentCanAccessRemoteUrls, false);
		note.guid = guid;
		QvernoteStorage::Instance()->getShallowNote(note, guid);
		QvernoteAPI::Instance()->getNoteContent(note);

		start();
	}

	QThumbnailCreator(Guid guid, bool autoclean) : m_bAutoclean(autoclean) {
		QObject::connect(&webView, SIGNAL(loadFinished(bool)), this, SLOT(setNoteSnapshot()));
		QObject::connect(&webView, SIGNAL(loadProgress(int)), this, SLOT(updateLoadProgress(int)));
		webView.settings()->setAttribute(QWebSettings::LocalContentCanAccessRemoteUrls, false);
		note.guid = guid;
		QvernoteStorage::Instance()->getShallowNote(note, guid);
		QvernoteAPI::Instance()->getNoteContent(note);
	}

	void start() {
		QEnmlReader	reader(note);

		reader.parse(1000000);
		webView.setHtml(reader.getHtml());
	}

	QPixmap& getThumbnail() { return snapshot; }

public slots:
	void setNoteSnapshot() {

		QByteArray 	ba;
		QBuffer 	buf(&ba);

		snapshot = QPixmap::grabWidget(&webView);
		snapshot = snapshot.scaled(QSize(180,150), Qt::KeepAspectRatioByExpanding, Qt::SmoothTransformation);

		//setPixmap(snapshotImage);
		buf.open(QIODevice::WriteOnly);
		snapshot.save(&buf, "PNG");
		QvernoteStorage::Instance()->setNoteThumbnail(note, ba);

		emit snapshotReady();

		if(m_bAutoclean)
			delete this;
   	}

	void updateLoadProgress(int p) {
		emit loadProgress(p);
	}

signals:
	void loadProgress(int);
	void snapshotReady();

private:
	bool		m_bAutoclean;
	QWebView	webView;
	QPixmap 	snapshot;
	Note 		note;
};

#endif /* QTHUMBNAILCREATOR_H_ */
