/*
	quick-launch control-panel applet
	
	@author	Daniele Maio (b0unc3) 
	@date	16/02/2010
	@ver	0.3
	
*/
#include <hildon-cp-plugin/hildon-cp-plugin-interface.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <glib.h>
#include <string.h>
#include <libintl.h>
#include <locale.h>
#include <stdio.h>
#include <stdlib.h>
#include <gconf/gconf-client.h>


#include "quick-launch.h"



gint
sort_iter_compare_func (GtkTreeModel *model,
                        GtkTreeIter  *a,
                        GtkTreeIter  *b,
                        gpointer      userdata)
{
	gchar *name1, *name2;
	gint ret = 0;


        gtk_tree_model_get(model, a, 0, &name1, -1);
        gtk_tree_model_get(model, b, 0, &name2, -1);

        if (name1 == NULL || name2 == NULL)
        {
          if (name1 == NULL && name2 == NULL)
              ret = 0;

          ret = (name1 == NULL) ? -1 : 1;
        }
        else
        {
          ret = g_utf8_collate(name1,name2);
        }

        g_free(name1);
        g_free(name2);

        return ret;
}

gchar *
g_strreplace (gchar * string, gchar * search, gchar * replace)
{
        gchar **sp;
        gchar *ret;

        sp = g_strsplit(string,search,-1);
        ret =  (g_strjoinv (replace, sp)); //g_strsplit (string, search, -1)));

        g_strfreev(sp);

        return ret;
}


void
save_info(GtkWidget *wid, gpointer user_data)
{
	GtkIconTheme	*it;
        GtkIconInfo	*info;
        GConfClient* client;
        int i;
        
        it = gtk_icon_theme_new();
       	client = GCONF_CLIENT(user_data);
	GSList  *lst = NULL;
	GError  *error;

        for(i=0;i<4;i++) {
		        
		lst = g_slist_append (lst, names[i]);
		info = gtk_icon_theme_lookup_icon (it, g_strdup_printf(icons[i]), 64, 0);
		if (info)
			icons[i] = g_strdup (gtk_icon_info_get_filename (info));
		
		lst = g_slist_append (lst, icons[i]);
		lst = g_slist_append (lst, ossos[i]);
		lst = g_slist_append (lst, bins[i]);        

		gconf_client_set_list ( client, g_strdup_printf("%s%s",APP_GCONF_KEY,group_name[i]), GCONF_VALUE_STRING, lst, &error);
		lst = NULL;
	}
	
	gtk_widget_set_sensitive ( GTK_WIDGET(confirm), FALSE );
	
	gtk_widget_destroy ( GTK_WIDGET(window) );

}

void
parse_settings(GConfClient* client)
{
	GError *err;
	GtkWidget *icoim;
	int i;
	GSList *lst = NULL;
	gpointer *nm,*in,*o,*b;
	
	for(i=0;i<4;i++) {
		if (gconf_entry_get_value (g_strdup_printf("%s%s",APP_GCONF_KEY,group_name[i])) != NULL) {
			lst = gconf_client_get_list (GCONF_CLIENT(client),g_strdup_printf("%s%s",APP_GCONF_KEY,group_name[i]), GCONF_VALUE_STRING, &err);
			if ( lst != NULL ) {
				nm = g_slist_nth_data (lst, 0);
				in = g_slist_nth_data (lst, 1);
				o =  g_slist_nth_data (lst, 2);
				b =  g_slist_nth_data (lst, 3);
				names[i] = (gchar *)nm;
				icons[i] = (gchar *)in;
				ossos[i] = (gchar *)o;
				bins[i] = (gchar *)b;
				icoim = gtk_image_new_from_file( (gchar *)in );
				hildon_button_set_image ( HILDON_BUTTON(btns[i]), icoim );
				hildon_button_set_text ( HILDON_BUTTON(btns[i]), g_strreplace((gchar *)nm," ","\n")  , "Tap to set");
			}
		}
	}
		
}

gboolean
set_shortcut ( HildonTouchSelector * selector, gint column, gpointer user_data )
{
	//load icon from selected application
	gchar *current_selection = NULL;
	gint	pos;
 
   	current_selection = hildon_touch_selector_get_current_text (HILDON_TOUCH_SELECTOR(selector));
   	GDir		*d;
   	gchar 		*ico;
   	GtkIconTheme	*it;
   	GtkWidget 	*icoim;
   	GKeyFile 	*dsk;
   	GError		*error;

	pos = (gint)user_data;
	it = gtk_icon_theme_new();
	d = g_dir_open(APPS_DIR,0,NULL);
	if ( d ) {
		setlocale( LC_ALL, "" );
                const gchar *file;
                while ( (file=g_dir_read_name(d)) ) {
                        if ( g_strrstr(file,".desktop") != NULL ) {
                                /* Add item to the column */
//      
                                
				dsk = g_key_file_new();
				gchar *n,*oss,*bin;
				n = NULL;
				
				if ( g_key_file_load_from_file ( dsk, g_strdup_printf("%s%s",APPS_DIR,file), G_KEY_FILE_KEEP_COMMENTS, &error ) ){
					if ( g_key_file_has_key ( dsk, "Desktop Entry", "X-Text-Domain", &error ) ) {
					//get name from gettext

//						bindtextdomain( "osso-sketch", LOCALES_DIR );//"/usr/share/locale" );
						textdomain( g_key_file_get_value( dsk, "Desktop Entry", "X-Text-Domain", &error ) );//"osso-sketch" );
						n = gettext( g_key_file_get_value ( dsk, "Desktop Entry", "Name", &error ) );//"sket_ap_sketch_title" ) );
					} else if ( g_key_file_has_key ( dsk, "Desktop Entry", "Name", &error ) ) {
						//get name from entry
						n = g_key_file_get_value ( dsk, "Desktop Entry", "Name", &error );
					}
					
					if ( g_key_file_has_key ( dsk, "Desktop Entry", "X-Osso-Service", &error ) ) 
						oss = g_key_file_get_value ( dsk, "Desktop Entry", "X-Osso-Service", &error );
					else oss = "";
					
					if ( g_key_file_has_key ( dsk, "Desktop Entry", "Exec", &error ) ) 
						bin = g_key_file_get_value ( dsk, "Desktop Entry", "Exec", &error );
					else bin = "";
					
		                        if ( n != NULL && g_strrstr(n,"_") == NULL && g_ascii_strncasecmp (n,current_selection,-1) == 0 ) {
		                        	//get icon
		                        	if ( g_key_file_has_key ( dsk, "Desktop Entry", "Icon", &error ) ) {
		                        		ico = g_key_file_get_value ( dsk, "Desktop Entry", "Icon", &error );
		                        		icoim = gtk_image_new_from_icon_name ( ico, GTK_ICON_SIZE_LARGE_TOOLBAR );
							hildon_button_set_image ( HILDON_BUTTON(btns[(gint)pos]), icoim );
							hildon_button_set_text ( HILDON_BUTTON(btns[(gint)pos]), g_strreplace(n," ","\n"), "Tap to set" );
							names[pos] = n;
							icons[pos] = ico;
							ossos[pos] = oss;
							bins[pos] = bin;
							gtk_widget_set_sensitive ( GTK_WIDGET(confirm), TRUE );
		                        	}
					}
				}
				
				g_key_file_free (dsk);
                        }
                }
        }
        g_dir_close(d);
        
        return FALSE;
}


void 
add_apps( HildonTouchSelector *btn)
{
	//load all available applications
	GDir	*d;
	GKeyFile *dsk;
	GError *error;
	
	
	d = g_dir_open(APPS_DIR,0,NULL);
	if ( d ) {
		setlocale( LC_ALL, "" );
                const gchar *file;
                while ( (file=g_dir_read_name(d)) ) {
                        if ( g_strrstr(file,".desktop") != NULL ) {
                                /* Add item to the column */
//      
                                
				dsk = g_key_file_new();
				gchar *n;
				n = NULL;
				
				if ( g_key_file_load_from_file ( dsk, g_strdup_printf("%s%s",APPS_DIR,file), G_KEY_FILE_KEEP_COMMENTS, &error ) ){
					if ( g_key_file_has_key ( dsk, "Desktop Entry", "X-Text-Domain", &error ) ) {
					//getname from gettext

//						bindtextdomain( "osso-sketch", LOCALES_DIR );//"/usr/share/locale" );
						textdomain( g_key_file_get_value( dsk, "Desktop Entry", "X-Text-Domain", &error ) );//"osso-sketch" );
						n = gettext( g_key_file_get_value ( dsk, "Desktop Entry", "Name", &error ) );//"sket_ap_sketch_title" ) );
					} else if ( g_key_file_has_key ( dsk, "Desktop Entry", "Name", &error ) ) {
						n = g_key_file_get_value ( dsk, "Desktop Entry", "Name", &error );
					}
					
		                        if ( n != NULL && g_strrstr(n,"_") == NULL ) hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (btn), n); 
				}
				
				g_key_file_free (dsk);
                        }
                }
        }
        g_dir_close(d);
        

//        hildon_touch_selector_append_text (HILDON_TOUCH_SELECTOR (btn), "--- None ---"); 
 
 	GtkTreeModel *m;
 	GtkTreeSortable *sortable;
 	       
        m = hildon_touch_selector_get_model (HILDON_TOUCH_SELECTOR(btn),0);
        sortable = GTK_TREE_SORTABLE(m);
	gtk_tree_sortable_set_sort_func(sortable, NULL, sort_iter_compare_func, NULL,NULL );
	gtk_tree_sortable_set_sort_column_id(GTK_TREE_SORTABLE(sortable), 0, GTK_SORT_ASCENDING);
	hildon_touch_selector_set_model ( HILDON_TOUCH_SELECTOR(btn), 0, GTK_TREE_MODEL(sortable) );
	
        
            
}

osso_return_t execute(osso_context_t *osso, gpointer data, gboolean user_activated)
{
	HildonProgram   *program;
	GtkWidget 	*main_box;
	GtkWidget	*conf_box;
	GtkWidget	*action_box;

	GtkWidget	*sel1,*sel2,*sel3,*sel4;
	GConfClient	*client;


	program = HILDON_PROGRAM(hildon_program_get_instance());
	g_set_application_name("Quick Launch - Configuration");

	window = HILDON_WINDOW(hildon_window_new());
	hildon_program_add_window(program, HILDON_WINDOW(window));

	client = gconf_client_get_default();
	
	main_box = gtk_vbox_new ( FALSE,2 );
	conf_box = gtk_hbox_new ( FALSE,0 );
	action_box = gtk_hbox_new ( FALSE,0 );
	btns[0] = hildon_picker_button_new(HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	btns[1] = hildon_picker_button_new(HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	btns[2] = hildon_picker_button_new(HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	btns[3] = hildon_picker_button_new(HILDON_SIZE_AUTO_WIDTH, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	hildon_button_set_text ( HILDON_BUTTON(btns[0]), "Tap to set", "" );
	hildon_button_set_text ( HILDON_BUTTON(btns[1]), "Tap to set", "" );
	hildon_button_set_text ( HILDON_BUTTON(btns[2]), "Tap to set", "" );
	hildon_button_set_text ( HILDON_BUTTON(btns[3]), "Tap to set", "" );
	gtk_widget_set_size_request ( GTK_WIDGET(btns[0]), 200,200 );
	gtk_widget_set_size_request ( GTK_WIDGET(btns[1]), 200,200 );
	gtk_widget_set_size_request ( GTK_WIDGET(btns[2]), 200,200 );
	gtk_widget_set_size_request ( GTK_WIDGET(btns[3]), 200,200 );
		
	sel1 = hildon_touch_selector_new_text();
	sel2 = hildon_touch_selector_new_text();
	sel3 = hildon_touch_selector_new_text();
	sel4 = hildon_touch_selector_new_text();
	add_apps(HILDON_TOUCH_SELECTOR(sel1));
	add_apps(HILDON_TOUCH_SELECTOR(sel2));
	add_apps(HILDON_TOUCH_SELECTOR(sel3));
	add_apps(HILDON_TOUCH_SELECTOR(sel4));	
	hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR(sel1), 0, -1);
        hildon_touch_selector_unselect_all (HILDON_TOUCH_SELECTOR(sel1), 0);
	hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR(sel2), 0, -1);
        hildon_touch_selector_unselect_all (HILDON_TOUCH_SELECTOR(sel2), 0);
	hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR(sel3), 0, -1);
        hildon_touch_selector_unselect_all (HILDON_TOUCH_SELECTOR(sel3), 0);
	hildon_touch_selector_set_active (HILDON_TOUCH_SELECTOR(sel4), 0, -1);
        hildon_touch_selector_unselect_all (HILDON_TOUCH_SELECTOR(sel4), 0);

	
	hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (btns[0]), HILDON_TOUCH_SELECTOR (sel1));
	hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (btns[1]), HILDON_TOUCH_SELECTOR (sel2));
	hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (btns[2]), HILDON_TOUCH_SELECTOR (sel3));
	hildon_picker_button_set_selector (HILDON_PICKER_BUTTON (btns[3]), HILDON_TOUCH_SELECTOR (sel4));
	
	gtk_box_pack_start(GTK_BOX(conf_box), btns[0], FALSE, TRUE, 1);
	gtk_box_pack_start(GTK_BOX(conf_box), btns[1], FALSE, TRUE, 1);
	gtk_box_pack_start(GTK_BOX(conf_box), btns[2], FALSE, TRUE, 1);
	gtk_box_pack_start(GTK_BOX(conf_box), btns[3], FALSE, TRUE, 1);



	confirm = hildon_button_new(HILDON_SIZE_AUTO, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	hildon_button_set_text ( HILDON_BUTTON(confirm), "Ok", NULL );
	hildon_button_set_image ( HILDON_BUTTON(confirm), gtk_image_new_from_stock(GTK_STOCK_APPLY, GTK_ICON_SIZE_BUTTON) );
	
	gtk_box_pack_start ( GTK_BOX(action_box), confirm, FALSE,FALSE,0 );

	gtk_box_pack_start ( GTK_BOX(main_box), conf_box, TRUE, TRUE, 1 );
	gtk_box_pack_start ( GTK_BOX(main_box), action_box, TRUE, FALSE, 1 );

	gtk_container_add ( GTK_CONTAINER(window), main_box );


	gconf_client_add_dir(client,
                       g_strdup_printf("%s%s",GCONF_DIR,APP_NAME),
                       GCONF_CLIENT_PRELOAD_NONE,
                       NULL);
	g_signal_connect ( G_OBJECT(sel1), "changed", G_CALLBACK(set_shortcut), (gpointer)0 );
	g_signal_connect ( G_OBJECT(sel2), "changed", G_CALLBACK(set_shortcut), (gpointer)1 );	
	g_signal_connect ( G_OBJECT(sel3), "changed", G_CALLBACK(set_shortcut), (gpointer)2 );
	g_signal_connect ( G_OBJECT(sel4), "changed", G_CALLBACK(set_shortcut), (gpointer)3 );
	g_signal_connect ( G_OBJECT(confirm), "clicked", G_CALLBACK(save_info), client );
	
	gtk_widget_set_sensitive ( GTK_WIDGET(confirm), FALSE );
	
	gtk_widget_show_all ( GTK_WIDGET(window) );
	
	parse_settings(client);
	
	
	return OSSO_OK;
}

osso_return_t save_state(osso_context_t *osso, gpointer data)
{
	/* ... save state ... */

	return OSSO_OK;
}

