/*
 * This file is a part of Queen Beecon Widget
 * queen-beecon-settings-manager: Utility for QBW Settings Management
 *
 * http://talk.maemo.org/showthread.php?t=45388
 *
 * Copyright (c) 2010 No!No!No!Yes! (Alessandro Peralma)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version. or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef QUEEN_BEECON_SETTINGS_MANAGER_H
#define QUEEN_BEECON_SETTINGS_MANAGER_H

// Configuration file management functions
void queen_beecon_read_settings ( QueenBeecon *self, gboolean needInstanceSettings, gboolean isImportFromADB, gchar *importData);
void queen_beecon_write_settings (QueenBeecon *self, gboolean needInstanceSettings);
gchar *queen_beecon_g_key_file_get_string(GKeyFile *key_file, const gchar *group_name, const gchar *key, gchar *defaultValue);
gboolean queen_beecon_g_key_file_get_boolean(GKeyFile *key_file, const gchar *group_name, const gchar *key, gboolean defaultValue);
gint queen_beecon_g_key_file_get_integer(GKeyFile *key_file, const gchar *group_name, const gchar *key, gint defaultValue);
gdouble queen_beecon_g_key_file_get_double(GKeyFile *key_file, const gchar *group_name, const gchar *key, gdouble defaultValue);
gboolean write_settings_have_key(const gchar *group_name, const gchar *key, void *value, char keyType);
gchar *read_settings_have_key (const gchar *group_name, const gchar *key);
void queen_beecon_config_file_housekeeping(gpointer data);

#endif /* QUEEN_BEECON_SETTINGS_MANAGER_H */

