#include "stackedwindow.h"
#include <QPropertyAnimation>
#include "ui_stackedwindow.h"
#include "mainwindow.h"


StackedWindow::StackedWindow(QString& latlong, QString& wfo, QString& zcode,
							 QString& offset, QPixmap &dayIcon, QString& dayURL,
							 QPixmap &nightIcon, QString& nightURL, QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::StackedWindow)
{
    ui->setupUi(this);

	QString tempTitle("<b>Temperature and Wind Chill:"), precipTitle("<b>Precipitation and Humidity ");
	QString rainTitle("<b>Rain Accumulation:</b>"), snowTitle("<b>Snow Accumulation:</b>");
	QPixmap tempPix(1600, 220);
	/*delete this after we find out what the deal is with the zcode
	  for now we just hard code maine because it works for some reason*/
	QString zc("MEZ015");
	this->zcode = &zc;// delete this line once we find a way to get the zcode

	/*init block*/
	bool needDay = false;
	bool needNight = false;
	this->latlong = new QString(latlong);
	this->wfo = new QString(wfo);
	this->offset = new QString(offset);
//	this->zcode = new QString(zcode);
	manager = new QNetworkAccessManager(this);
	mapper = new QSignalMapper(this);
	tempFrame = new GraphFrame(tempTitle, tempPix);
	precipFrame = new GraphFrame(precipTitle, tempPix);
	rainFrame = 0;
	snowFrame = 0;
	QString* tempSearch = new QString("http://forecast.weather.gov/wtf/meteograms/Plotter.php?" + *this->latlong + "&wfo=" + *this->wfo + "&zcode=" + *this->zcode + "&gset=20&gdiff=10&unit=0&tinfo=EY5&ahour=" + *this->offset +"&pcmd=100100000000000000000000000000000000000000000000&lg=en&indu=1!1!1&dd=0&bw=0&hrspan=48&pqpfhr=6");
	QString* precipSearch = new QString("http://forecast.weather.gov/wtf/meteograms/Plotter.php?" + *this->latlong + "&wfo=" + *this->wfo + "&zcode=" + *this->zcode + "&gset=20&gdiff=10&unit=0&tinfo=EY5&ahour=" + *this->offset +"&pcmd=000000110000000000000000000000000000000000000000&lg=en&indu=1!1!1&dd=0&bw=0&hrspan=48&pqpfhr=6");
	QString* searchParams[4] = {tempSearch, precipSearch, &dayURL, &nightURL};

	/*add the layouts to the ui*/
	QVBoxLayout* layout = qobject_cast<QVBoxLayout*>(ui->frame->layout());
	layout->addLayout(tempFrame->getLayout());
	layout->addLayout(precipFrame->getLayout());
    connect(mapper, SIGNAL(mapped(int)), this, SLOT(setIcons(int)));



	if(!dayIcon.isNull()){
		ui->dayIcon->setPixmap(dayIcon);
	}else{
		needDay = true;
		ui->dayIcon->setPixmap(QPixmap(":/loading.png"));
	}

	if(!nightIcon.isNull()){
		ui->nightIcon->setPixmap(nightIcon);
    }else{
        needNight = true;
        ui->nightIcon->setPixmap(QPixmap(":/loading.png"));
    }

    //send the icon requests and map them so they end up
    //in the right place
    for(int i = 0; i < 4; i++){
        if(i < 2 || needDay & i==2 || needNight & i==3){
            QNetworkReply* reply = manager->get(QNetworkRequest(QUrl(*searchParams[i])));
            connect(reply, SIGNAL(finished()), mapper, SLOT(map()));
            mapper->setMapping(reply, i);
        }

    }


}

StackedWindow::~StackedWindow()
{
    delete ui;
    delete manager;
    delete mapper;
	delete rainFrame;
	delete snowFrame;
	delete tempFrame;
	delete precipFrame;

	delete latlong;
	delete wfo;
	delete offset;
//	delete zcode;
}


void StackedWindow::setIcons(int mapping){
    QSignalMapper* sm = qobject_cast<QSignalMapper*>(sender());
    QNetworkReply* reply = qobject_cast<QNetworkReply*>(sm->mapping(mapping));
	reply->deleteLater();
    QPixmap pix;
    pix.loadFromData(reply->readAll());

    switch(mapping){
	case 0: tempFrame->setPix(pix);break;
	case 1: precipFrame->setPix(pix);break;
	case 2: ui->dayIcon->setPixmap(pix);break;
	case 3: ui->nightIcon->setPixmap(pix);break;
    }
}


void StackedWindow::setInfo(QString &day, QString &hi, QString &lo, QString &precip, QString &dayFor, QString &nightFor){
    ui->day->setText(day);
    ui->hi->setText(hi);
    ui->lo->setText(lo);
    ui->precip->setText(precip);
    ui->dayForecast->setText(dayFor);
    ui->nightForecast->setText(nightFor);
	MainWindow::colorize(ui->label_3);

	if(dayFor.contains("ain") || nightFor.contains("ain")){
		QNetworkReply* reply = manager->get(QNetworkRequest(QUrl("http://forecast.weather.gov/wtf/meteograms/Plotter.php?" + *latlong + "&wfo=" + *wfo + "&zcode=MEZ015&gset=20&gdiff=10&unit=0&tinfo=EY5&ahour=" + *offset +"&pcmd=000000000100000000000000000000000000000000000000&lg=en&indu=1!1!1&dd=0&bw=0&hrspan=48&pqpfhr=6")));
		connect(reply, SIGNAL(finished()), this, SLOT(addRainGraph()));
	}

	if(dayFor.contains("now") || nightFor.contains("now")){
		QNetworkReply* reply = manager->get(QNetworkRequest(QUrl("http://forecast.weather.gov/wtf/meteograms/Plotter.php?" + *latlong + "&wfo=" + *wfo + "&zcode=MEZ015&gset=20&gdiff=10&unit=0&tinfo=EY5&ahour=" + *offset +"&pcmd=000000000010000000000000000000000000000000000000&lg=en&indu=1!1!1&dd=0&bw=0&hrspan=48&pqpfhr=6")));
		connect(reply, SIGNAL(finished()), this, SLOT(addSnowGraph()));
	}

}

/**
  Slot to add the snow graph to this window.
  Called only if the forecast includes snow
  */
void StackedWindow::addSnowGraph(){
	QNetworkReply* reply = qobject_cast<QNetworkReply*>(sender());
	reply->deleteLater();
	QPixmap pix; pix.loadFromData(reply->readAll());
	QString str("<b>Snow Accumulation:</b>");
	snowFrame = new GraphFrame(str, pix);

	QVBoxLayout* layout = qobject_cast<QVBoxLayout*>(ui->frame->layout());
	layout->addLayout(snowFrame->getLayout());
}

/**
  Slot to add the rain graph to this window.
  Called only if the forecast includes rain
  */
void StackedWindow::addRainGraph(){
	QNetworkReply* reply = qobject_cast<QNetworkReply*>(sender());
	reply->deleteLater();
	QPixmap pix; pix.loadFromData(reply->readAll());
	QString str("<b>Rain Accumulation:</b>");
	rainFrame = new GraphFrame(str, pix);

	QVBoxLayout* layout = qobject_cast<QVBoxLayout*>(ui->frame->layout());
	layout->addLayout(rainFrame->getLayout());
}



void StackedWindow::resizeEvent(QResizeEvent *event){
    if(event->oldSize().width() > event->size().width()){
		ui->frame->setMinimumWidth(100);
    }else{
		ui->frame->setMinimumWidth(720);
    }

}

