/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 */
#include "utils.h"

#include "eWallet.h"
#include "Constants.h"
#include "DatabaseManager.h"
#include <Qt>
#include <QtGui>
#include <QFile>
#include <QDesktopServices>
#include <QListView>
#include "OptionsDialog.h"


OptionsDialog::OptionsDialog(QWidget *parent): QDialog(parent) {
	setWindowTitle("Wallet");

	setContextMenuPolicy(Qt::NoContextMenu);
	QHBoxLayout * layout = new QHBoxLayout(this);

	layout->setMargin(0);
	layout->setSpacing(0);

	layout->setSpacing(10);
	layout->setMargin(10);

	QDialogButtonBox* dlgBtnBox = new QDialogButtonBox(this);
	dlgBtnBox->setOrientation(Qt::Vertical);

//	QPushButton * closeButton = new QPushButton(tr("Save && Close"), this);
//	//closeButton->setFixedHeight(70);
//	closeButton->setContextMenuPolicy(Qt::NoContextMenu);
//	closeButton->setFocusPolicy(Qt::NoFocus);
//	closeButton->setIconSize(QSize(48, 48));
//	QObject::connect(closeButton, SIGNAL(clicked()), this, SLOT(save()));
//	dlgBtnBox->addButton(closeButton, QDialogButtonBox::ActionRole);

	QGridLayout * componentLayout = new QGridLayout ();
	componentLayout->setContentsMargins(15, 0, 15, 0);
	componentLayout->setSpacing(5);


	phoneChars = new QCheckBox(tr("Phone fields with characters"), this);
	phoneChars->setContextMenuPolicy(Qt::NoContextMenu);
	phoneChars->setChecked(settings.value("hints/phoneNumber/supportCharacters", false).toBool());
	QObject::connect(phoneChars, SIGNAL(clicked()), this, SLOT(changePhoneChars()));
	componentLayout->addWidget(phoneChars, 0, 1, 1, 1);

	// Name label
//	nameLabel = new QLabel(, this);
//	nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
//	//nameLabel->setAlignment(Qt::AlignTop);
//	componentLayout->addWidget(nameLabel, 2, 1, 2, 2);

	fixImageSize = new QCheckBox(tr("Limit image size"), this);
	fixImageSize->setContextMenuPolicy(Qt::NoContextMenu);
	fixImageSize->setChecked(settings.value("internalImage/scale", true).toBool());
	QObject::connect(fixImageSize, SIGNAL(clicked()), this, SLOT(changeFix()));
	componentLayout->addWidget(fixImageSize, 0, 2, 1, 1);

	QLabel * nameLabel;

	nameLabel = new QLabel(tr("Max image width"), this);
	nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
	componentLayout->addWidget(nameLabel, 1, 1, 1, 1);

	maxWidth = new QSpinBox (this);
	maxWidth->setMaximum(1024);
	maxWidth->setMinimum(1);
	maxWidth->setValue(settings.value("internalImage/WIDTH", _INTERNAL_WIDTH).toInt());
	QObject::connect(maxWidth, SIGNAL(valueChanged(int)), this, SLOT(valueChangedW(int)));
	componentLayout->addWidget(maxWidth, 1, 2, 1, 2);

	nameLabel = new QLabel(tr("Max image height"), this);
	nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
	componentLayout->addWidget(nameLabel, 2, 1, 1, 1);

	maxHeigh = new QSpinBox (this);
	maxHeigh->setMaximum(1024);
	maxHeigh->setMinimum(1);
	maxHeigh->setValue(settings.value("internalImage/HEIGH", _INTERNAL_HEIGH).toInt());
	QObject::connect(maxHeigh, SIGNAL(valueChanged(int)), this, SLOT(valueChangedH(int)));
	componentLayout->addWidget(maxHeigh, 2, 2, 1, 2);

	maxWidth->setEnabled(fixImageSize->isChecked());
	maxHeigh->setEnabled(fixImageSize->isChecked());

	nameLabel = new QLabel(tr("Language"), this);
	nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
	componentLayout->addWidget(nameLabel, 3, 1, 1, 1);

	language = new QComboBox (this);
	language->addItem(tr("English"), "en");
	language->addItem(tr("German"), "de");
	language->addItem(tr("Spanish"), "es");
	language->addItem(tr("Finnish"), "fi");
	language->addItem(tr("French"), "fr");
	language->addItem(tr("Italian"), "it");
	language->addItem(tr("Dutch"), "nl");
	language->addItem(tr("Swedish"), "sv_SE");

	QString lang = QLocale::system().name();
	lang = settings.value("application/language", lang).toString();

	int iLang = language->findData(lang);
	if (iLang >= 0) {
		language->setCurrentIndex(iLang);
	}
	else
		language->setCurrentIndex(0);

    connect(language, SIGNAL(activated(int)), this, SLOT(emitCommitData(int)));
	componentLayout->addWidget(language, 3, 2, 1, 2);

	layout->addLayout(componentLayout);
	layout->setAlignment(componentLayout, Qt::AlignVCenter);

	layout->addWidget(dlgBtnBox);
	layout->setAlignment(dlgBtnBox, Qt::AlignBottom);

	setLayout(layout);
}

void OptionsDialog::emitCommitData (int a) {
	qDebug () << "selecting " << language->itemData(a);
#ifdef Q_WS_MAEMO_5
	show_banner (this, tr("Language change will take effect after restart application"));
#endif
	settings.setValue("application/language", language->itemData(a));
}

OptionsDialog::~OptionsDialog() {

}
void OptionsDialog::changeFix () {
	settings.setValue("internalImage/scale", fixImageSize->isChecked());

	maxWidth->setEnabled(fixImageSize->isChecked());
	maxHeigh->setEnabled(fixImageSize->isChecked());
}
void OptionsDialog::changePhoneChars () {
	settings.setValue("hints/phoneNumber/supportCharacters", phoneChars->isChecked());
}
void OptionsDialog::valueChangedW (int i) {
	settings.setValue("internalImage/WIDTH", i);

	maxHeigh->setValue(i * 5398 / 8660);
}
void OptionsDialog::valueChangedH (int i) {
	settings.setValue("internalImage/HEIGH", i);
}
