/*
 * Copyright (c) 2010 David Galindo <nowheremanmail@gmail.com>
 *
 *
 */
#include <Qt>
#include "utils.h"
#include "eWallet.h"
#include "Constants.h"
#include "DetailedWindow.h"
#include "CreateFieldDialog.h"

#ifdef Q_WS_MAEMO_5
#include <QDBusInterface>
#include <QDBusConnection>
#endif
#include <QDesktopServices>


CreateFieldDialog::CreateFieldDialog(Target * target, FieldsHelper *paTarget, QWidget * parent) :
		QDialog(parent)
{
	setWindowTitle("Wallet");

	pos = 0;

	//qDebug () << " 1";
	this->target = target;
	//qDebug () << " 2";
	this->parent = paTarget;

	_fieldsChanged = false;
	//qDebug () << " 3";

	// COPY FIELDS
	for (int i = 0; i < this->target->fields.size(); i++) {
		TargetField * item = new TargetField(this->target->fields.at(i));
		fields.append(item);

		qDebug () << "copy original field " << i; // << " -> " << item->value;
	}

	setContextMenuPolicy(Qt::NoContextMenu);

	// Create dialog main layout

	QHBoxLayout * layout = new QHBoxLayout(this);

	layout->setMargin(0);
	layout->setSpacing(0);

	layout->setSpacing(10);
	layout->setMargin(10);

	QDialogButtonBox* dlgBtnBox = new QDialogButtonBox(this);
	dlgBtnBox->setOrientation(Qt::Vertical);

	previousButton = new QPushButton(QIcon(":/resources/icon_previous.png"), "", this);
	//previousButton->setFixedHeight(70);
	previousButton->setContextMenuPolicy(Qt::NoContextMenu);
	previousButton->setFocusPolicy(Qt::NoFocus);
	previousButton->setIconSize(QSize(48, 48));
	QObject::connect(previousButton, SIGNAL(clicked()), this, SLOT(previous()));
	dlgBtnBox->addButton(previousButton, QDialogButtonBox::ActionRole);

	nextButton = new QPushButton(QIcon(":/resources/icon_next.png"), "", this);
	//nextButton->setFixedHeight(70);
	nextButton->setContextMenuPolicy(Qt::NoContextMenu);
	nextButton->setFocusPolicy(Qt::NoFocus);
	nextButton->setIconSize(QSize(48, 48));
	QObject::connect(nextButton, SIGNAL(clicked()), this, SLOT(next()));
	dlgBtnBox->addButton(nextButton, QDialogButtonBox::ActionRole);

	deleteButton = new QPushButton(QIcon(":/resources/icon_delete.png"), "", this);
	//deleteButton->setFixedHeight(70);
	deleteButton->setContextMenuPolicy(Qt::NoContextMenu);
	deleteButton->setFocusPolicy(Qt::NoFocus);
	deleteButton->setIconSize(QSize(48, 48));
	QObject::connect(deleteButton, SIGNAL(clicked()), this, SLOT(deleteCurrent()));
	dlgBtnBox->addButton(deleteButton, QDialogButtonBox::ActionRole);

	QPushButton * newButton = new QPushButton(QIcon(":/resources/icon_add_new.png"), "", this);
	//newButton->setFixedHeight(70);
	newButton->setContextMenuPolicy(Qt::NoContextMenu);
	newButton->setFocusPolicy(Qt::NoFocus);
	newButton->setIconSize(QSize(48, 48));
	QObject::connect(newButton, SIGNAL(clicked()), this, SLOT(addNew()));
	dlgBtnBox->addButton(newButton, QDialogButtonBox::ActionRole);

	QPushButton * closeButton = new QPushButton("Save && Close", this);
	//closeButton->setFixedHeight(70);
	closeButton->setContextMenuPolicy(Qt::NoContextMenu);
	closeButton->setFocusPolicy(Qt::NoFocus);
	closeButton->setIconSize(QSize(48, 48));
	QObject::connect(closeButton, SIGNAL(clicked()), this, SLOT(save()));
	dlgBtnBox->addButton(closeButton, QDialogButtonBox::ActionRole);

	QGridLayout * componentLayout = new QGridLayout ();
	componentLayout->setContentsMargins(15, 0, 15, 0);
	componentLayout->setSpacing(5);

	// Name label
	QLabel * nameLabel = new QLabel(tr("Name"), this);
	nameLabel->setContextMenuPolicy(Qt::NoContextMenu);
	//nameLabel->setAlignment(Qt::AlignTop);
	componentLayout->addWidget(nameLabel, 1, 1, 1, 2);

// Name line edit
	nameLineEdit = new QLineEdit(this);
	nameLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
	//nameLineEdit->setAlignment(Qt::AlignTop);

	componentLayout->addWidget(nameLineEdit, 1, 3, 1, 4);

	// type label
	QLabel * typeLabel = new QLabel(tr("Type"), this);
	typeLabel->setContextMenuPolicy(Qt::NoContextMenu);
	//typeLabel->setAlignment(Qt::AlignTop);
	componentLayout->addWidget(typeLabel, 2, 1, 1, 2);

	// type line edit
	typeLineEdit = new QComboBox(this);
	typeLineEdit->setContextMenuPolicy(Qt::NoContextMenu);
	//typeLineEdit->setAlignment(Qt::AlignTop);

	typeLineEdit->addItem (tr("String"), QVariant(TYPE_STRING));
	typeLineEdit->addItem (tr("Text"), QVariant(TYPE_TEXT));
	typeLineEdit->addItem (tr("Date"), QVariant(TYPE_DATE));
	typeLineEdit->addItem (tr("Number"), QVariant(TYPE_INTEGER));
	typeLineEdit->addItem (tr("Phone Number"), QVariant(TYPE_PHONE_NUMBER));
	typeLineEdit->addItem (tr("Password"), QVariant(TYPE_PASSWORD));
	typeLineEdit->addItem (tr("URL"), QVariant(TYPE_URL));
	typeLineEdit->addItem (tr("Image"), QVariant(TYPE_IMAGE));

	componentLayout->addWidget(typeLineEdit, 2, 3, 1, 4);

	// Name label
	QLabel * orderLabel = new QLabel(tr("Order"), this);
	orderLabel->setContextMenuPolicy(Qt::NoContextMenu);
	//nameLabel->setAlignment(Qt::AlignTop);
	componentLayout->addWidget(orderLabel, 3, 1, 1, 2);

// Name line edit
	orderEdit = new QLineEdit(this);
	orderEdit->setContextMenuPolicy(Qt::NoContextMenu);
	orderEdit->setInputMethodHints(Qt::ImhDigitsOnly);
	orderEdit->setValidator(new QIntValidator (1, 100, this));

	componentLayout->addWidget(orderEdit, 3, 3, 1, 4);

	layout->addLayout(componentLayout);
	layout->setAlignment(componentLayout, Qt::AlignVCenter);

	layout->addWidget(dlgBtnBox);
	layout->setAlignment(dlgBtnBox, Qt::AlignBottom);

	setLayout(layout);

	showField ();
}

void CreateFieldDialog::update () {
	if (pos < fields.length()) {
		int type = typeLineEdit->itemData(typeLineEdit->currentIndex()).toInt();
		if (orderEdit->isModified() || nameLineEdit->isModified() || type != fields[pos]->type) {
			int order = QVariant (orderEdit->text()).toInt();
			fields[pos]->name = nameLineEdit->text();
			fields[pos]->type = type;
			fields[pos]->order = order;
			_fieldsChanged = true;
		}
	}
}

void CreateFieldDialog::previous () {
	if (pos > 0) {
		update ();
		pos--;
		showField ();
	}
}
void CreateFieldDialog::addNew () {
	_fieldsChanged = true;

	update ();
	pos = fields.length();
	fields.append(new TargetField ("", TYPE_STRING, true, 100));

	showField ();
}
void CreateFieldDialog::next () {
	if ((pos + 1) < fields.length()) {
		update ();
		pos++;
		showField ();
	}
}
void CreateFieldDialog::deleteCurrent () {
	if (pos >= 0 && pos < fields.length()) {
		_fieldsChanged = true;

		update ();
		fields.removeAt(pos);
		if (pos >= fields.length()) {
			pos--;
			if (pos < 0) pos = 0;
		}
		showField ();
	}
	else {
		nameLineEdit->hide ();
		typeLineEdit->hide ();
		orderEdit->hide ();
	}
}

void CreateFieldDialog::showField () {
	if (pos < fields.length()) {
		if (!nameLineEdit->isEnabled()) {
			nameLineEdit->setDisabled(false);
			typeLineEdit->setDisabled(false);
			orderEdit->setDisabled(false);
		}
	}
	else {
		if (nameLineEdit->isEnabled()) {
			nameLineEdit->setText("");
			orderEdit->setText("");

			nameLineEdit->setDisabled(true);
			typeLineEdit->setDisabled(true);
			orderEdit->setDisabled(true);
		}
	}

	if (pos == 0) {
		previousButton->setDisabled(true);
	}
	else {
		previousButton->setDisabled(false);
	}
	if ((pos + 1) >= fields.length()) {
		nextButton->setDisabled(true);
	}
	else {
		nextButton->setDisabled(false);
	}
	if (pos >= 0 && pos < fields.length()) {
		deleteButton->setDisabled(false);
	}
	else {
		deleteButton->setDisabled(true);
	}
	if (pos < fields.length()) {
		nameLineEdit->setText(fields[pos]->name);
		int i = typeLineEdit->findData(QVariant (fields[pos]->type));
		typeLineEdit->setCurrentIndex(i);
		orderEdit->setText(QString::number(fields[pos]->order));
	}
}

void CreateFieldDialog::save () {
	update ();

	if (_fieldsChanged) {
		// REMOVE PREVIOUS
		for (int i = 0; i < this->target->fields.size(); i++) {
			TargetField * item = this->target->fields.at(i);

			delete item;
		}
		this->target->fields.clear();

		// RECOVER FIELDS
		for (int i = 0; i < fields.size(); i++) {
			TargetField * item = new TargetField(fields.at(i));
			this->target->fields.append(item);

			//qDebug () << "field " << i << " -> " << item->value;
		}

		parent->fieldsChanged = _fieldsChanged;
	}

	done(QDialog::Accepted);
}

CreateFieldDialog::~CreateFieldDialog() {
	for (int i = 0; i < fields.size(); i++) {
		TargetField * item = fields.at(i);
		delete item;
	}

	fields.clear();
}
