/*
    QtCartoonizer - A cartoon creation application
    Copyright (C) 2009  Ixonos Plc. Authors:

	Yi Zheng - yi.zheng@ixonos.com
        Jari Koski - jari.koski@ixonos.com
        Tero Ojala - tero.ojala@ixonos.com
        Terhi Öljymäki - terhi.oljymaki@ixonos.com

    QtCartoonizer is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    QtCartoonizer is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with QtCartoonizer; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301,
    USA.
*/
#ifndef CAMERA_H
#define CAMERA_H
#include <gst/gst.h>
#include <gst/interfaces/xoverlay.h>
/* Define structure for variables that
 * are needed thruout the apeplication */
#include <QX11EmbedContainer>
class QObject;
class QWidget;
class QImage;

//! Camera mode
enum cameraMode {photo, video};

//! QCamera encapslate all gstreamer api for camera operation
class QCamera : public QObject
{
	Q_OBJECT
signals:
    /*! Signal emit when photo ready
     * \param image The photo image
     * \return none
     */
    void photoReady (QImage* image);

    /*! Signal emit when video stream state change
     * \param ready If video stream ready it is true
     * \return none
     */
    void videoStreamReady (bool ready);

public:
    //! Constructor
    QCamera ();

    //!Destructor
    ~QCamera ();

    /*! Set X-Window id for g_x_overlay object
     * \param id The x-window id
     * \return  none
     */
    void setXWindowId (WId id);

    //! Take a photo. When photo ready, it emit the photoReady signal
    void takePhoto ();

    //! Return the buffer id
    guint bufferId () { return m_bufferCbId;};

    /*! it is called by static call back function to emit the photoReady signal
     * \param image The photo image
     * \return None
     */
    void photoTaked (QImage* image) ;

    //! Start video stream
    void play ();

    //! Stop video
    void stop ();

    //! Return the camera mode
    cameraMode mode();

    //! Set camera mode
    void setMode(cameraMode);

    //! Emit videoSrtamReady (true) signal
    void streamReady ();

    //! Callback function to take the photo
friend  gboolean buffer_probe_callback(
		GstElement *image_sink,
		GstBuffer *buffer, GstPad *pad, QCamera *camera);
protected:
    //! Create image from a buffer
    void createJpeg(unsigned char *buffer);
    
public slots:

private:
    //! Init gstreamer pipe line
    bool initialize_pipeline ();

    //! destroy gstreamer pipe line
    void destroy_pipeline();

private:

    //! Gstreamer pipe line
	GstElement *m_pipeline;

    //! Callback bufferId
	guint m_bufferCbId;

    //! Video sink
    GstElement *m_videoSink;

    //! Stream ready flag
    bool m_streamReady;

    //! WinId
    WId m_winid;

    //! Camera Mode
    cameraMode m_mode;

    //! QImage for photo
    QImage m_image;

};
#endif
