#ifndef CENTRALWIDGET_H
#define CENTRALWIDGET_H

#include <QWidget>
#include <QtNetwork/QTcpSocket>

#include "reversigame.h"
#include "qthellosettings.h"
#include "score.h"

enum P2PSTATE {WAIT_SERVER_VERSION, WAIT_CLIENT_VERSION, WAIT_SERVER_NEW_GAME, RUNNING, SERVER_PAUSED, CLIENT_PAUSED};

class QGridLayout;
class QPushButton;
class QVBoxLayout;
class QTcpServer;
class QTcpSocket;
class FieldView;
class InfoPanel;
class ModePanel;
class ScorePanel;

class CentralWidget : public QWidget
{
    Q_OBJECT
public:
    explicit CentralWidget(QWidget *parent, ReversiGame &reversiGame);
    ~CentralWidget();
    void showInfoPanels();

private:
    bool newGameP2PServer();
    bool newGameP2PClient();
    void readSettings();
    void saveSettings();

private:
    QGridLayout *layout_;
    QVBoxLayout *infoLayout_;
    QPushButton *btUndo_;
    QTcpServer *gameServer_;
    QTcpSocket  *gameClient_;
    QTcpSocket  *gameConnection_;
    FieldView *fieldView_;
    InfoPanel *infoPanel_;
    ModePanel *modePanel_;
    ScorePanel *scorePanel_;
    int gameMode_;
    P2PSTATE P2PState_;
    int strength_;
    bool isNetworkGame_;

    ReversiGame &reversiGame_;
    Score       score_;

    QthelloSettings settings_;

public slots:
    /**
     * @brief Starts new game
     */
    void newGame();
    void slotGameOver();
    void slotPlayerStep(int x, int y);
    void slotOptions();
    void slotResetScore();

private slots:
    void stepUnavailable();
    void slotOrientationChanged();
    void slotReadNetworkData();
    void displayP2PError(QAbstractSocket::SocketError socketError);
    void slotEnableUndo(bool);
};

#endif // CENTRALWIDGET_H
