#include <QGridLayout>
#include <QLabel>

#include "scorepanel.h"

ScorePanel::ScorePanel(QWidget *parent) :
    QWidget(parent)
{
    QGridLayout *topLayout = new QGridLayout(this);
    QLabel *lb = new QLabel(tr("Won"), this);
    topLayout->addWidget(lb, 0, 0);
    lb = new QLabel(tr("Lost"), this);
    topLayout->addWidget(lb, 0, 1);
    lb = new QLabel(tr("Drawn"), this);
    topLayout->addWidget(lb, 0, 2);

    lbWon_ = new QLabel(this);
    topLayout->addWidget(lbWon_, 1, 0);
    lbLost_ = new QLabel(this);
    topLayout->addWidget(lbLost_, 1, 1);
    lbDrawn_ = new QLabel(this);
    topLayout->addWidget(lbDrawn_, 1, 2);
}

void ScorePanel::setScore(unsigned won, unsigned lost, unsigned drawn)
{
    lbWon_->setNum(int(won));
    lbWon_->update();
    lbLost_->setNum(int(lost));
    lbLost_->update();
    lbDrawn_->setNum(int(drawn));
    lbDrawn_->update();
}
