#include "reversiitem.h"

#include "pixmaps/EmptyCell.xpm"
#include "pixmaps/WhiteCell.xpm"
#include "pixmaps/BlackCell.xpm"
#include "pixmaps/c01.xpm"
#include "pixmaps/c02.xpm"
#include "pixmaps/c03.xpm"
#include "pixmaps/c04.xpm"
#include "pixmaps/c05.xpm"
#include "pixmaps/c06.xpm"
#include "pixmaps/c07.xpm"
#include "pixmaps/c08.xpm"
#include "pixmaps/c09.xpm"
#include "pixmaps/c10.xpm"

PixmapsFactory::PixmapsFactory()
{
    chipPixmaps_[White] = new QPixmap(WhiteCell_xpm);
    chipPixmaps_[Black] = new QPixmap(BlackCell_xpm);
    chipPixmaps_[Empty] = new QPixmap(EmptyCell_xpm);
    chipPixmaps_[3] = new QPixmap(c01_xpm);
    chipPixmaps_[4] = new QPixmap(c02_xpm);
    chipPixmaps_[5] = new QPixmap(c03_xpm);
    chipPixmaps_[6] = new QPixmap(c04_xpm);
    chipPixmaps_[7] = new QPixmap(c05_xpm);
    chipPixmaps_[8] = new QPixmap(c06_xpm);
    chipPixmaps_[9] = new QPixmap(c07_xpm);
    chipPixmaps_[10] = new QPixmap(c08_xpm);
    chipPixmaps_[11] = new QPixmap(c09_xpm);
    chipPixmaps_[12] = new QPixmap(c10_xpm);
}

PixmapsFactory::~PixmapsFactory()
{
    for(int i = 0; i < 13; ++i)
    {
        delete chipPixmaps_[i];
    }
}

ReversiItem::ReversiItem(QGraphicsScene *scene, PixmapsFactory *pixmapsFactory):
        QGraphicsPixmapItem(), //0, scene),
        pixmapsFactory_(pixmapsFactory)
{
    setColor(Empty);
}

void ReversiItem::setColor(int c)
{
    setPixmap(*pixmapsFactory_->chipPixmaps_[c]);
}
