#include <QVBoxLayout>
#include <QGridLayout>
#include <QLabel>
#include <QComboBox>

#include "modepanel.h"

ModePanel::ModePanel(QWidget *parent) :
    QWidget(parent)
{
    QVBoxLayout *layout = new QVBoxLayout(this);

    QGridLayout *hlayout = new QGridLayout();

    QLabel *lbMode = new QLabel(tr("Mode: "), this);
    hlayout->addWidget(lbMode, 0, 0);
    QLabel *lbStrength = new QLabel(tr("AI level: "), this);
    hlayout->addWidget(lbStrength, 1, 0);

    cbMode_ = new QComboBox(this);
    cbMode_->addItem(tr("Human vs human"));
    cbMode_->addItem(tr("Human vs computer"));
    cbMode_->addItem(tr("Computer vs human"));
    cbMode_->addItem(tr("Net (server)"));
    cbMode_->addItem(tr("Net (client)"));
    cbMode_->setCurrentIndex(1);
    hlayout->addWidget(cbMode_, 0, 1);

    cbStrength_ = new QComboBox(this);
    //cbStrength_->addItem(tr("Very easy"));
    cbStrength_->addItem(tr("Easy"));
    cbStrength_->addItem(tr("Medium"));
    cbStrength_->addItem(tr("Hard"));
    //cbStrength_->addItem(tr("Very hard"));
    //cbStrength_->addItem(tr("Extremely hard"));
    //cbStrength_->addItem(tr("Impossible"));
    cbStrength_->addItem(tr("Expert"));
    cbStrength_->setCurrentIndex(1);
    hlayout->addWidget(cbStrength_, 1, 1);

    layout->addItem(hlayout);
    setLayout(layout);
}

QPair<int, int>
ModePanel::mode() const
{
    return QPair<int, int>(cbMode_->currentIndex(), cbStrength_->currentIndex());
}
