#include "randomnumbers.h"
#include <Qt>

int RandomNumbers::randInt(int low, int high) {
    // Random number between low and high
    return qrand() % ((high + 1) - low) + low;
}

//int( random() / (RAND_MAX + 1.0) * (max + 1 - min) + min )

RandomNumbers::RandomNumbers()
{
	if (!settings.contains("PARAMS/product")) {
		settings.setValue("PARAMS/product", false);
		settings.setValue("PARAMS/product/0", false);
		settings.setValue("PARAMS/product/1", false);
		settings.setValue("PARAMS/product/2", true);
	}
	if (!settings.contains("PARAMS/sum")) {
		settings.setValue("PARAMS/sum", true);
		settings.setValue("PARAMS/sum/0", false);
		settings.setValue("PARAMS/sum/1", false);
		settings.setValue("PARAMS/sum/2", true);
	}
	if (!settings.contains("PARAMS/minus")) {
		settings.setValue("PARAMS/minus", true);
		settings.setValue("PARAMS/minus/0", false);
		settings.setValue("PARAMS/minus/1", false);
		settings.setValue("PARAMS/minus/2", true);
	}

    // INIT RANDOM
    QTime time = QTime::currentTime();
    qsrand((uint)time.msec());
    // INIT RANDOM

    prepare ();
}

void RandomNumbers::prepare(bool reset) {
	numbers.clear ();

    for (int o = 2; o >= 0; o--) {
        for (int i = 0; i <= 19; i++) {
            for (int j = 0; j <= 10; j++) {
                Item * tmp;

                if (i <= 10) {
                	if (settings.value("PARAMS/product").toBool()) {
						if (!(i == 0 || j == 0)) {
		                	if ((o == 0 && settings.value("PARAMS/product/0").toBool())
		                		|| (o == 1 && settings.value("PARAMS/product/1").toBool())
		                		|| (o == 2 && settings.value("PARAMS/product/2").toBool())) {

		                		if ((i == 1 && settings.value("PARAMS/product/number/1").toBool())
		                			|| (i == 2 && settings.value("PARAMS/product/number/2").toBool())
		                			|| (i == 3 && settings.value("PARAMS/product/number/3").toBool())
		                			|| (i == 4 && settings.value("PARAMS/product/number/4").toBool())
		                			|| (i == 5 && settings.value("PARAMS/product/number/5").toBool())
		                			|| (i == 6 && settings.value("PARAMS/product/number/6").toBool())
		                			|| (i == 7 && settings.value("PARAMS/product/number/7").toBool())
		                			|| (i == 8 && settings.value("PARAMS/product/number/8").toBool())
		                			|| (i == 9 && settings.value("PARAMS/product/number/9").toBool())
		                			|| (i == 10 && settings.value("PARAMS/product/number/10").toBool())) {

									tmp = new Item;
									tmp->num1 = i;
									tmp->num0 = j;
									tmp->operation = PRODUCT;
									tmp->mode = o;
									tmp->result = i * j;

									if (reset)
										tmp->frec = 0;
									else {
										QString n = QString ("STATS/%1-%2-%3/M/%4").arg(tmp->num1).arg(tmp->operation).arg(tmp->num0).arg(tmp->mode);
										tmp->frec = settings.value(n, 0).toInt();
									}
									numbers.append(tmp);
		                		}
		                	}
						}
                	}

                	if (settings.value("PARAMS/sum").toBool()) {
						if (!((j >= 10 && i < 10) || i == 0 || j == 0)) {
		                	if ((o == 0 && settings.value("PARAMS/sum/0").toBool())
		                		|| (o == 1 && settings.value("PARAMS/sum/1").toBool())
		                		|| (o == 2 && settings.value("PARAMS/sum/2").toBool())) {
								tmp = new Item;
								tmp->num1 = i;
								tmp->num0 = j;
								tmp->operation = SUM;
								tmp->mode = o;
								tmp->result = i + j;

								if (reset)
									tmp->frec = 0;
								else {
									QString n = QString ("STATS/%1-%2-%3/M/%4").arg(tmp->num1).arg(tmp->operation).arg(tmp->num0).arg(tmp->mode);
									tmp->frec = settings.value(n, 0).toInt();
								}
								numbers.append(tmp);
		                	}
						}
                	}
                }

            	if (settings.value("PARAMS/minus").toBool()) {
					if (j <= i && !(i == 0 || j == 0)) {
	                	if ((o == 0 && settings.value("PARAMS/minus/0").toBool())
	                		|| (o == 1 && settings.value("PARAMS/minus/1").toBool())
	                		|| (o == 2 && settings.value("PARAMS/minus/2").toBool())) {
							tmp = new Item;
							tmp->num1 = i;
							tmp->num0 = j;
							tmp->operation = MINUS;
							tmp->mode = o;
							tmp->result = i - j;

							if (reset)
								tmp->frec = 0;
							else {
								QString n = QString ("STATS/%1-%2-%3/M/%4").arg(tmp->num1).arg(tmp->operation).arg(tmp->num0).arg(tmp->mode);
								tmp->frec = settings.value(n, 0).toInt();
							}
							numbers.append(tmp);
	                	}
					}
            	}
            }
        }
    }

    recalcul ();
}

void RandomNumbers::recalcul () {
    long total = 0;

    for (int i = 0; i < numbers.length(); i++) {
        Item * tmp = numbers.at(i);
        total += tmp->frec;
        tmp->check = 0;
    }

    if (total == 0) {
        for (int i = 0; i < numbers.length(); i++) {
            Item * tmp = numbers.at(i);
            tmp->frec = 1;
            total += tmp->frec;
        }
    }

    Item * tmp = numbers.at(0);
    tmp->frecuency = (double)tmp->frec / (double)total;
    //qDebug () << "0:" << tmp->frecuency;
    for (int i = 1; i < numbers.length(); i++) {
        Item * tmpC = numbers.at(i);
        tmpC->frecuency = tmp->frecuency + (double)tmpC->frec / (double)total;

        //qDebug () << i << ":" << tmpC->frecuency;

        tmp = tmpC;
    }
}

Item * RandomNumbers::next () {
//    int u = randInt(0, numbers.length() - 1);
//    return numbers.at(u);

    double n = (double)qrand() / (double)RAND_MAX;

    //qDebug () << " " << n;

    Item * tmp = numbers.at(0);

    if (n <= tmp->frecuency) {
        //qDebug () << "0 " << n << " " << tmp->frecuency;
        tmp->check++;
        return tmp;
    }

    for (int i = 1; i < numbers.length(); i++) {
        Item * tmpC = numbers.at(i);
        //qDebug () << i << " " << n << " " << tmp->frecuency << " " << tmpC->frecuency;
        if (tmp->frecuency < n && n <= tmpC->frecuency) {
            tmpC->check++;
            return tmpC;
        }
        tmp = tmpC;
    }

    tmp->check++;
    return tmp;
}

void RandomNumbers::update (Item * it, int failures, int time) {
    if (failures <= 0) {
    	// TODO time
//        for (int i = 0; i < numbers.length(); i++) {
//            Item * tmp = numbers.at(i);
//            if (tmp != it) {
//                tmp->frec++;

//		QString n = QString ("STATS/%1-%2-%3/M/%4").arg(tmp->num1).arg(tmp->operation).arg(tmp->num0).arg(tmp->mode);
//		settings.setValue(n, (int)tmp->frec);

//            }
//        }
    }
    else {
    	// TODO failures & time
        it->frec++;

        QString n = QString ("STATS/%1-%2-%3/M/%4").arg(it->num1).arg(it->operation).arg(it->num0).arg(it->mode);
        settings.setValue(n, (int)it->frec);
    }
    recalcul ();
}




