#include "dialogpreferences.h"
#include "ui_dialogpreferences.h"



DialogPreferences::DialogPreferences(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::DialogPreferences)
{
    ui->setupUi(this);

    ui->sum->setChecked(settings.value("PARAMS/sum").toBool());
    ui->minus->setChecked(settings.value("PARAMS/minus").toBool());
    ui->product->setChecked(settings.value("PARAMS/product").toBool());
    ui->checkBox1->setChecked(settings.value("PARAMS/product/number/1").toBool());
    ui->checkBox2->setChecked(settings.value("PARAMS/product/number/2").toBool());
    ui->checkBox3->setChecked(settings.value("PARAMS/product/number/3").toBool());
    ui->checkBox4->setChecked(settings.value("PARAMS/product/number/4").toBool());
    ui->checkBox5->setChecked(settings.value("PARAMS/product/number/5").toBool());
    ui->checkBox6->setChecked(settings.value("PARAMS/product/number/6").toBool());
    ui->checkBox7->setChecked(settings.value("PARAMS/product/number/7").toBool());
    ui->checkBox8->setChecked(settings.value("PARAMS/product/number/8").toBool());
    ui->checkBox9->setChecked(settings.value("PARAMS/product/number/9").toBool());
    ui->checkBox10->setChecked(settings.value("PARAMS/product/number/10").toBool());

    if (settings.value("PARAMS/sum/1").toBool ()) {
    	ui->level3->setChecked (true);
    }
    else
    if (settings.value("PARAMS/sum/0").toBool ()) {
    	ui->level2->setChecked (true);
    }
    else
    if (settings.value("PARAMS/sum/2").toBool ()) {
    	ui->level1->setChecked (true);
    }
}

DialogPreferences::~DialogPreferences()
{
	settings.sync ();

    delete ui;
}

void DialogPreferences::on_sum_clicked()
{
    settings.setValue("PARAMS/sum", ui->sum->isChecked());
}

void DialogPreferences::on_minus_clicked()
{
    settings.setValue("PARAMS/minus", ui->minus->isChecked());
}

void DialogPreferences::on_product_clicked()
{
    settings.setValue("PARAMS/product", ui->product->isChecked());
}

void DialogPreferences::on_checkBox1_clicked()
{
	settings.setValue("PARAMS/product/number/1", ui->checkBox1->isChecked());
}

void DialogPreferences::on_checkBox6_clicked()
{
	settings.setValue("PARAMS/product/number/6", ui->checkBox6->isChecked());
}

void DialogPreferences::on_checkBox2_clicked()
{
	settings.setValue("PARAMS/product/number/2", ui->checkBox2->isChecked());
}

void DialogPreferences::on_checkBox7_clicked()
{
	settings.setValue("PARAMS/product/number/7", ui->checkBox7->isChecked());
}

void DialogPreferences::on_checkBox3_clicked()
{
	settings.setValue("PARAMS/product/number/3", ui->checkBox3->isChecked());

}

void DialogPreferences::on_checkBox8_clicked()
{
	settings.setValue("PARAMS/product/number/8", ui->checkBox8->isChecked());

}

void DialogPreferences::on_checkBox4_clicked()
{
	settings.setValue("PARAMS/product/number/4", ui->checkBox4->isChecked());

}

void DialogPreferences::on_checkBox9_clicked()
{
	settings.setValue("PARAMS/product/number/9", ui->checkBox9->isChecked());

}

void DialogPreferences::on_checkBox5_clicked()
{
	settings.setValue("PARAMS/product/number/5", ui->checkBox5->isChecked());

}

void DialogPreferences::on_checkBox10_clicked()
{
	settings.setValue("PARAMS/product/number/10", ui->checkBox10->isChecked());

}

void DialogPreferences::on_level1_clicked()
{
	settings.setValue("PARAMS/product/0", false);
	settings.setValue("PARAMS/product/1", false);
	settings.setValue("PARAMS/product/2", true);
	settings.setValue("PARAMS/sum/0", false);
	settings.setValue("PARAMS/sum/1", false);
	settings.setValue("PARAMS/sum/2", true);
	settings.setValue("PARAMS/minus/0", false);
	settings.setValue("PARAMS/minus/1", false);
	settings.setValue("PARAMS/minus/2", true);
}

void DialogPreferences::on_level2_clicked()
{
	settings.setValue("PARAMS/product/0", true);
	settings.setValue("PARAMS/product/1", false);
	settings.setValue("PARAMS/product/2", true);
	settings.setValue("PARAMS/sum/0", true);
	settings.setValue("PARAMS/sum/1", false);
	settings.setValue("PARAMS/sum/2", true);
	settings.setValue("PARAMS/minus/0", true);
	settings.setValue("PARAMS/minus/1", false);
	settings.setValue("PARAMS/minus/2", true);
}

void DialogPreferences::on_level3_clicked()
{
	settings.setValue("PARAMS/product/0", true);
	settings.setValue("PARAMS/product/1", true);
	settings.setValue("PARAMS/product/2", true);
	settings.setValue("PARAMS/sum/0", true);
	settings.setValue("PARAMS/sum/1", true);
	settings.setValue("PARAMS/sum/2", true);
	settings.setValue("PARAMS/minus/0", true);
	settings.setValue("PARAMS/minus/1", true);
	settings.setValue("PARAMS/minus/2", true);
}
