//OssoWrapper.h: Implementation of C++ wrapper class for OSSO related operations (e.g., loading of control panel plugins)

#ifndef OSSOWRAPPER_H
#define OSSOWRAPPER_H

#include <QObject>
#include <QDebug>
//#ifdef Q_WS_MAEMO_5
    #include <dbus-1.0/dbus/dbus.h>
    #include <libosso.h>
    #include <libplayback-1/libplayback/playback.h>
//#endif

class OssoWrapper : public QObject
{
    Q_OBJECT

public:

    OssoWrapper(const QString& strAppName, const QString& strAppVersion, QObject* parent = 0); //default constructor
    ~OssoWrapper(); //default destructor

#ifdef Q_WS_MAEMO_5

    bool executePlugin(const QString& strPluginName); //load and execute specified plugin (so) module

    bool initOssoPlayback(const QString& audioStream);

    void requestPlaybackStateChange(enum pb_state_e pb_new_state); //request to change playback state to pb_new_state

    static OssoWrapper* m_pStaticOssoWrapper; //static pointer to current wrapper instance

    //methods used for mapping libplayback callbacks to corresponding signals

    void playbackStateRequestHandlerCallback(enum pb_state_e requestedState); //handler called when state request received via libplayback
    void playbackStateReplyCallback(enum pb_state_e grantedState, const char* reason); //handler called when state change reply received via libplayback


private:

    osso_context_t* m_pOssoContext; //libosso context

    pb_playback_t *m_pPlayback; //playback object pointer (returned when declaring new playback using libplayback)

signals:

    void playbackStateChangeRequest(enum pb_state_e); //signal emitted upon libplayback state change request
    void playbackStateReply(enum pb_state_e, QString); //signal emitted upon libplayback state reply received

#endif

};

#endif // OSSOWRAPPER_H
