#!/usr/bin/python

import sys, time
from PyQt4 import QtGui, QtCore

class WProgress(QtGui.QLabel):
   def __init__(self, parent):
      QtGui.QLabel.__init__(self, parent)
      self.setMinimumSize(1, 10)
      self.parent = parent
      self.setRange(0, 100)
      self.value = 0
      self.currentValue = 0
      self.showRules = True
      self.ytop = 35
      self.height = 33

   def setYTop(self, val):
      self.ytop = val
      
   def setShowRules(self, show):
      self.showRules = show
      
   def setRange(self, min, max):
      self.min = min
      self.max = max
      self.num = [min, (min+max)/2, max]
         
   def setValue(self, value):
      self.value = value
      if self.value<self.min:
         self.value = self.min
         
      if self.value>self.max:
         self.value = self.max
      
   def paintEvent(self, event):
      paint = QtGui.QPainter()
      paint.begin(self)

      font = QtGui.QFont('Serif', 12, QtGui.QFont.DemiBold)
      font.setStyleStrategy(QtGui.QFont.PreferAntialias)
      paint.setFont(font)

      size = self.size()
      x0 = int(size.width()*0.15)
      w = size.width()-2*x0
      
      self.currentValue = self.value
      
      # if self.currentValue<self.value:
         # self.currentValue = (self.currentValue + 0.02*self.value)
         # time.sleep(0.01)

      if self.max-self.min>0:
         pcVal = float(self.currentValue-self.min)/float(self.max-self.min)
         pcVal = min(pcVal, 1.0)
         pcPixWidth = int(w*pcVal)
         step = int(round(w / 2.0))

         # draw progess bar
         paint.setPen(QtGui.QColor(255, 192, 123))
         paint.setBrush(QtGui.QColor(255, 192, 123))
         paint.drawRect(x0, self.ytop, pcPixWidth, -self.height/3+1)

         # draw contour
         pen = QtGui.QPen(QtGui.QColor(20, 20, 20), 1, QtCore.Qt.SolidLine)
         paint.setPen(pen)
         paint.setBrush(QtCore.Qt.NoBrush)
         paint.drawRect(x0, self.ytop, w, -self.height/3)

         j = 0

         if self.showRules:
            # draw text
            for i in range(0, 3*step, step):
               paint.setPen(pen)
               paint.drawLine(x0+i, self.ytop-self.height/3, x0+i, self.ytop)
               metrics = paint.fontMetrics()
               fw = metrics.width(str(self.num[j]))
               paint.setPen(QtGui.QColor(38,156,202))
               paint.drawText(x0+i-fw/2, self.ytop-self.height/2, str(self.num[j]))
               j = j + 1

      # if self.currentValue<self.value:
         # self.update()
         
      paint.end()
