#include "ktruckers.h"
#include "ui_ktruckers.h"

#include <QtCore/QCoreApplication>
#include <QShortcut>

Ktruckers::Ktruckers(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Ktruckers)
{
    ui->setupUi(this);

    //Set Window
    this->setWindowTitle(tr("Trucker's Hitch"));
    this->setAttribute(Qt::WA_Maemo5StackedWindow);
    this->setWindowFlags(Qt::Window);

    //Set Image
    imgScene = new QGraphicsScene(ui->img);
    QGraphicsPixmapItem *item;
    QPixmap mImg("/opt/qnotted/images/ktruckers.jpg");
    ui->img->setScene(imgScene);
    mImg = mImg.scaled(QSize(180, 180), Qt::KeepAspectRatio);
    item = new QGraphicsPixmapItem(mImg);
    imgScene->addItem(item);

    //Set Large Image
    imgSceneLarge = new QGraphicsScene(ui->imgLarge);
    QGraphicsPixmapItem *itemLarge;
    QPixmap mImgLarge("/opt/qnotted/images/ktruckers.jpg");
    ui->imgLarge->setScene(imgSceneLarge);
    mImgLarge = mImgLarge.scaled(QSize(440, 440), Qt::KeepAspectRatio);
    itemLarge = new QGraphicsPixmapItem(mImgLarge);
    imgSceneLarge->addItem(itemLarge);

    //Button Text
    ui->pushButton_Up->setText("");
    ui->pushButton_Down->setText("");
    ui->pushButton_Reset->setText("");


    // Set Button Icons
    ui->pushButton_Up->setIcon(QPixmap("/opt/qnotted/icons/br_up_icon&48.png"));
    ui->pushButton_Down->setIcon(QPixmap("/opt/qnotted/icons/br_down_icon&48.png"));
    ui->pushButton_Reset->setIcon(QPixmap("/opt/qnotted/icons/dash.png"));

    //Hide On Draw
    ui->pushButton_Reset->hide();
    ui->imgLarge->hide();


    //Set Text
    ui->textBrowser->setText(tr("\
        <b><u>Trucker's Hitch</u></b> <br> \
        <b>Notes</b> <br> \
        This knot can be tied in many ways and is formed by a combination of knots. <br> \
        The knot starts with a Mid-Loop Knot, this could be a Directional Figure 8 Knot, Slip Knot or Bowline on a Bight. <br> \
        However, the image shown is using an Alpine Butterfly Loop, which is an essential Mid-Loop Knot. <br> \
        The knot finishes with a Hitch around the bight taking the load, here a Clove Hitch is used. <br> \
        <b>Tying</b> <br> \
        Tie an Alpine Butterfly Loop in the rope, leaving enough length to complete the knot. <br> \
        Pass the working end through the anchor point and then through the loop you formed. <br> \
        At this point you can pull on the working end to tighten the standing part of the rope; securing the load. <br> \
        Finally to complete the hitch pass the working end over and around the bight in the rope and under itself, do this twice. <br> \
        Therefore, forming a Clove Hitch around the bight made underneath the Alpine Butterfly Loop. <br> \
                                "));

    // For Connecting Keyboard Buttons
              connectSignals();
}

Ktruckers::~Ktruckers()
{
    delete ui;
}

// Keyboard Button Signals - remember to include QShortcut
void Ktruckers::connectSignals()
{

// Keyboard Key Signals

        connect(new QShortcut(QKeySequence(Qt::Key_Backspace), this), SIGNAL(activated()), this, SLOT(close()));
     connect(new QShortcut(QKeySequence(Qt::Key_Up), this), SIGNAL(activated()), this, SLOT(on_pushButton_Up_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Down), this), SIGNAL(activated()), this, SLOT(on_pushButton_Down_pressed()));
     connect(new QShortcut(QKeySequence(Qt::Key_Space), this), SIGNAL(activated()), this, SLOT(on_pushButton_Reset_pressed()));
}

// End of Keyboard Signals


//Push Buttons

void Ktruckers::on_pushButton_Up_pressed()
{
    ui->img->hide();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->hide();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->show();
}

void Ktruckers::on_pushButton_Reset_pressed()
{
    ui->img->show();
    ui->imgLarge->hide();
    ui->textBrowser->show();
    ui->pushButton_Up->show();
    ui->pushButton_Down->show();
    ui->pushButton_Reset->hide();
}

void Ktruckers::on_pushButton_Down_pressed()
{
    ui->img->hide();
    ui->imgLarge->show();
    ui->textBrowser->hide();
    ui->pushButton_Up->show();
    ui->pushButton_Down->hide();
    ui->pushButton_Reset->show();
}
