#include "qnitconverter.h"
#include "converter.h"
#include "ui_gui.h"

#include <QStringList>
#include <QDoubleValidator>

#ifdef Q_WS_HILDON
	// includes for portrait mode support
	#include <X11/Xlib.h>
	#include <X11/Xatom.h>
	#include <QtGui/QX11Info>
#endif

QNitConverter::QNitConverter(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::QNitConverterClass)
{
    // create converter class
    engine = new Converter();
    engine->add_file("/opt/QNitConverter/conversions.data");

#ifdef Q_WS_HILDON
    int value = 1;
	Atom portraitSupport = XInternAtom(QX11Info::display(), "_HILDON_PORTRAIT_MODE_SUPPORT", false);
	Atom portraitRequest = XInternAtom(QX11Info::display(), "_HILDON_PORTRAIT_MODE_REQUEST", false);
	XChangeProperty(QX11Info::display(), winId(), portraitSupport, XA_CARDINAL, 32, PropModeReplace, (uchar *)&value, 1);
//	XChangeProperty(QX11Info::display(), winId(), portraitRequest, XA_CARDINAL, 32, PropModeReplace, (uchar *)&value, 1);
#endif

    // setup ui
    ui->setupUi(this);
	iv = new QDoubleValidator(ui->data_f);
	ui->data_f->setValidator(iv);

	// add list of types
	QStringList list = engine->get_order("_TYPES_");
	ui->types->addItems(list);
}

QNitConverter::~QNitConverter()
{
    delete ui;
}

void QNitConverter::on_btn_ok_clicked()
{
	// abort if the types are changing
	if (changing) {
		return;
	}

	// get the unit type
	QString type = ui->types->currentText();

	// get the 'from' and 'to' types
	QString old_unit = ui->conv_f->currentText();
	QString new_unit = ui->conv_t->currentText();

	// get the value
	QString val = ui->data_f->text();

	// convert and update result field
    ui->data_t->setText(engine->convert(type, old_unit, new_unit, val));
}

void QNitConverter::on_conv_f_currentIndexChanged(int index)
{
	on_btn_ok_clicked();
}

void QNitConverter::on_conv_t_currentIndexChanged(int index)
{
	on_btn_ok_clicked();
}

void QNitConverter::on_types_currentIndexChanged(QString item)
{
	// keep changing QChoiceBox-es from activating
	changing = true;

	// get the choices
	QStringList list = engine->get_order(item);

	// update 'from'
	ui->conv_f->clear();
	ui->conv_f->addItems(list);
	ui->conv_f->setCurrentIndex(0);

	// update 'to'
	ui->conv_t->clear();
	ui->conv_t->addItems(list);
	ui->conv_t->setCurrentIndex(1);

	// re-enable QChoiceBox-es and perform a conversion
	changing = false;
	on_btn_ok_clicked();
}
