#!/usr/bin/env python
# -*- coding: utf-8 -*-

# THANKS !!!
# Pictures and widget_play.png, widget_stop.png and source code class CustomButton, 
# taken from the application "Pedometer Home Widget".
# The author(Andrei Mirestean) of this application, thanks !!!

import gtk
import cairo
import gobject
import gconf

from sys import path
path.extend(['/opt/qnetman/'])
path.extend(['/home/tolik/develop/qnetman'])

from pysrc import gettraff
from pysrc import QNMDBusClient

import hildondesktop
import hildon

from math import pi
from socket import socket, SOCK_DGRAM, AF_INET, inet_ntoa
from fcntl import ioctl
from struct import pack

import time
from string import split


VERSION = "0.6.0"
##############################################

MODE_MONITOR = 0
MODE_COUNT = 1

import dbus
from dbus.mainloop.glib import DBusGMainLoop
DBusGMainLoop(set_as_default=True)


ICONSPATH = "/opt/qnetman/pysrc/pictures/"

class SingleObject(object):
	_instance = None
	_references = 0
	def __new__(cls, *args, **kwargs):
		cls._references += 1
		if not cls._instance:
			cls._instance = super(SingleObject, cls).__new__( cls, *args, **kwargs )
		return cls._instance




class Config(SingleObject):
	path="/apps/qnetmanwidget"
	path_refr_int = path + "/refresh_interval"
	path_vis_net_iface = path + "/network_interfaces"
	path_show_ip = path + "/show_ip"
	path_show_rec = path + "/show_rec_button"
	path_mode = path + "/mode"
	
	observers = []

	def __init__(self):
		if self._references > 1:
			return
		self.client = gconf.client_get_default()
		self.client.add_dir( '/apps/qnetmanwidget', gconf.CLIENT_PRELOAD_RECURSIVE )
		self.notify_id = self.client.notify_add( '/apps/qnetmanwidget', self.gconf_changed )

	def add_observer(self, func):
		try:
			self.observers.index(func)
		except:
			self.observers.append(func)
			func()

	def remove_observer(self, func):
		self.observers.remove(func)

	def gconf_changed(self, client, *args, **kargs):
		self.notify()

	def notify(self):
		#t1 = time.time()
		for func in self.observers:
			func()
		#t2 = time.time()
		#print "Update took: %f seconds" % (t2-t1)
	
	#интервал обновления
	def set_refresh_interval(self, value):
		self.client.set_int( self.path_refr_int, value )
	
	def get_refresh_interval(self):
		return self.client.get_int( self.path_refr_int )

	#список отображаемых сетевых интерфейсов
	def set_show_iface(self,value):
		self.client.set_list( self.path_vis_net_iface, gconf.VALUE_STRING, value )
	
	def get_show_iface( self ):
		return self.client.get_list( self.path_vis_net_iface, gconf.VALUE_STRING )

	#скрыть/показать IP адрес
	def set_show_ip(self, value):
		self.client.set_bool( self.path_show_ip, value )
	
	def get_show_ip(self):
		return self.client.get_bool( self.path_show_ip )

	# показать/отключить кнопки записи
	def set_show_rec(self, value):
		self.client.set_bool( self.path_show_rec, value )
	
	def get_show_rec(self):
		return self.client.get_bool( self.path_show_rec )

	# счетчик по каждому сетевому интерфейсу
	def set_value_count(self, key, value):
		#print "%s => %s"%(key, value)
		key = self.path + key
		self.client.set_string( key, "%s"%value )

	def get_value_count(self, key):
		key = self.path + key
		val = self.client.get_string( key )
		if val == None:
			val = 0
		else:
			try:
				val = long( "%s"%val, 10 )
			except:
				pass
		return val
	
	#режим виджета (0-монитор; 1-счетчик)
	def set_mode_widget(self, value):
		self.client.set_int( self.path_mode, value )
	
	def get_mode_widget(self):
		return self.client.get_int( self.path_mode )




class CustomButton(hildon.Button):
    def __init__(self, icon):
        hildon.Button.__init__(self, gtk.HILDON_SIZE_AUTO_WIDTH, hildon.BUTTON_ARRANGEMENT_VERTICAL)
        self.icon = icon
        self.set_size_request(int(32 * 1.4), int(30 * 1.0))
        self.retval = self.connect("expose_event", self.expose)

    def set_icon(self, icon):
        self.icon = icon

    def expose(self, widget, event):
        self.context = widget.window.cairo_create()
        self.context.rectangle(event.area.x, event.area.y, event.area.width, event.area.height)

        self.context.clip()
        rect = self.get_allocation()
        self.context.rectangle(rect.x, rect.y, rect.width, rect.height)
        self.context.set_source_rgba(1, 1, 1, 0)

        style = self.rc_get_style()
        color = style.lookup_color("DefaultBackgroundColor")
        if self.state == gtk.STATE_ACTIVE:
            style = self.rc_get_style()
            color = style.lookup_color("SelectionColor")
            self.context.set_source_rgba (color.red / 65535.0, color.green / 65335.0, color.blue / 65535.0, 0.75);
        self.context.fill()

        #img = cairo.ImageSurface.create_from_png(self.icon)

        #self.context.set_source_surface(img)
        #self.context.set_source_surface(img, rect.width/2 - img.get_width() /2, 0)
        img = gtk.Image()
        img.set_from_file(self.icon)
        buf = img.get_pixbuf()
        buf = buf.scale_simple(int(30 * 1.5), int(30 * 1.5), gtk.gdk.INTERP_BILINEAR)

        self.context.set_source_pixbuf(buf, rect.x + (event.area.width / 2 - 15) - 8, rect.y + 1)
        self.context.scale(200, 200)
        self.context.paint()

        return self.retval




class CustomEventBox(gtk.EventBox):
	def __init__(self):
		gtk.EventBox.__init__(self)
    
	def fail_do_expose_event(self, e):
		self.cr = self.window.cairo_create()

		self.cr.rectangle( e.area.x, e.area.y, e.area.width, e.area.height )
		self.cr.clip()
		rect = self.get_allocation()
		self.cr.rectangle(rect.x, rect.y, rect.width, rect.height)

		style = self.rc_get_style()
		if self.state == gtk.STATE_ACTIVE:
			color = style.lookup_color("SelectionColor")
			self.cr.set_source_rgba (color.red / 65535.0, color.green / 65335.0, color.blue / 65535.0, 0.3)
		else:
			color = style.lookup_color("DefaultBackgroundColor")
			self.cr.set_source_rgba (color.red / 65535.0, color.green / 65335.0, color.blue / 65535.0, 0.6)

		#style = self.rc_get_style()
		#color = style.lookup_color("DefaultBackgroundColor")
		#self.cr.set_source_rgba (color.red / 65535.0, color.green / 65335.0, color.blue / 65535.0, 0.5)
		self.cr.fill()
		hildondesktop.HomePluginItem.do_expose_event(self,e)





class QNetManHomePlugin(hildondesktop.HomePluginItem):
	bufLabelTraff = {}

	myconfig = None
	
	listShowIface = []
	refresh_interval_seconds = 0
	showIP = True
	showButtonRec = True

	widgetConnectedWithQNetManDaemon = False

	def __init__(self):
		hildondesktop.HomePluginItem.__init__( self )
		
		gobject.type_register(CustomEventBox)

		self.myconfig = Config()

		# --- gconf: config widget --- #
		self.refresh_interval_seconds = self.myconfig.get_refresh_interval()
		self.showIP = self.myconfig.get_show_ip()
		self.showButtonRec = self.myconfig.get_show_rec()
		self.listShowIface = self.myconfig.get_show_iface()
		self.mode = self.myconfig.get_mode_widget()
		
		#--- параметры для счетчика ---#
		self.rx0 = 0
		self.tx0 = 0
		self.title_button_reset = "Reset the counter of bytes on "

		self.listIface = []
		self.listIface.append("gprs0")
		self.listIface.append("wlan0")
		self.listIface.append("eth0")
		self.listIface.append("usb0")
		self.listIface.append("pan0")
		self.listIface.append("ppp0")


		#self.num_show_ifaces = 0
		if len(self.listShowIface) == 0:
			self.listShowIface.append("gprs0")
			self.myconfig.set_show_iface( self.listShowIface )
			#self.num_show_ifaces = 1


		self.listModeWidget = []
		self.listModeWidget.append("Monitoring mode")
		self.listModeWidget.append("Counter mode")
		

		self.listRefreshInterval = []
		self.listRefreshInterval.append(0)    # on click
		self.listRefreshInterval.append(2)    # 2 sec
		self.listRefreshInterval.append(5)    # 5 sec
		self.listRefreshInterval.append(10)   # 10 sec
		self.listRefreshInterval.append(30)   # 30 sec
		self.listRefreshInterval.append(60)   # 1 min
		self.listRefreshInterval.append(180)  # 3 min
		self.listRefreshInterval.append(300)  # 5 min
		
		self.listShowIfaceTemp = list( self.listShowIface )
		
		# --- try connect to dbus --- #
		self.qnetman_dbus_client = None
		self.widgetConnectedWithQNetManDaemon = self.initConnectionDBus()

		self.id_timeout = None
		self.initHomescreenWidget()

		self.set_settings(True)
		self.connect("show-settings", self.show_settings)
		self.dialog = None

	
	# инициализация соединения с демоном через dbus
	def initConnectionDBus(self):
		ret = False
		self.qnetman_dbus_client = QNMDBusClient.QNMDBusClient()
		if self.qnetman_dbus_client.connectDBus() == False:
			self.showButtonRec = False
		else:
			self.session_bus = dbus.SessionBus( )
			self.session_bus.add_signal_receiver( self.dbusSignalReceiver_recStarted, dbus_interface=None, signal_name="recStarted", bus_name="com.qnetman.Daemon", path="/QNetManDBus")
			self.session_bus.add_signal_receiver( self.dbusSignalReceiver_recStoped, dbus_interface=None, signal_name="recStoped", bus_name="com.qnetman.Daemon", path="/QNetManDBus")
			ret = True
		return ret

	
	# --- функции-приемники сигналов от демона через dbus --- #
	def dbusSignalReceiver_recStarted(self, iface):
		key = "%s_button_rec"%iface
		#print "dbusSignalReceiver_recStarted(%s); key=%s"%(iface, key)
		if self.bufLabelTraff.has_key( key ):
			self.initHomescreenWidget()
	

	def dbusSignalReceiver_recStoped(self, iface):
		key = "%s_button_rec"%iface
		#print "dbusSignalReceiver_recStoped(%s); key=%s"%(iface,key)
		if self.bufLabelTraff.has_key( key ):
			self.initHomescreenWidget()
	#---------------------------------------------------------#
		
	
	# функция, формирующая виджет из кусков, и привязка всех сигналов
	def initHomescreenWidget(self):
		
		listChildreWidget = self.get_children()
		for child in listChildreWidget:
			self.remove( child )

		vbox = gtk.VBox( False, 0 )
		for iface in self.listShowIface:
			hw = self.addIfaceWidget(iface)
			vbox.pack_start(hw, True, True, 0)
			#vbox.show_all()

		eventBox = CustomEventBox()
		eventBox.set_visible_window(False)
		eventBox.connect("button-press-event", self.eventBox_clicked)
		eventBox.connect("button-release-event", self.eventBox_clicked_release)
		eventBox.add(vbox)
		eventBox.show_all()
        
		self.add(eventBox)
		
		self.updateMyWidget()
		

    
	#--- перехватчики событий кликов на виджете ---#
	def eventBox_clicked(self, widget, data=None):
		widget.set_state(gtk.STATE_ACTIVE)
		if self.refresh_interval_seconds == 0:
			self.updateMyWidget()

	def eventBox_clicked_release(self, widget, data=None):
		widget.set_state(gtk.STATE_NORMAL)
	#----------------------------------------------#

	
	#--- вспомогательные функции для отрисовки ---#
	def my_label_small(self, title=""):
		l = gtk.Label(title)
		hildon.hildon_helper_set_logical_font(l, "SmallSystemFont")
		return l
	
	def my_label_color_small(self, title=""):
		l = gtk.Label(title)
		hildon.hildon_helper_set_logical_font(l, "SmallSystemFont")
		hildon.hildon_helper_set_logical_color(l, gtk.RC_FG, gtk.STATE_NORMAL, "ActiveTextColor")
		return l
	
	def my_label(self, title=""):
		l = gtk.Label(title)
		hildon.hildon_helper_set_logical_font(l, "SystemFont")
		hildon.hildon_helper_set_logical_color(l, gtk.RC_FG, gtk.STATE_NORMAL, "ActiveTextColor")
		return l
	#----------------------------------------------#
	

	# функция, возвращающая ip-адрес указанного сетевого интерфейса
	def getip_iface( self, ifname ):
		ret = " undefined "
		try:
			s = socket(AF_INET, SOCK_DGRAM)
			ret = inet_ntoa( ioctl ( s.fileno(), 0x8915, pack('256s', ifname[:15]) )[20:24])
		except:
			pass
		return ret
	

	#добавление сетевого интерфейса на виджет
	def addIfaceWidget(self, iface):
		hbox = gtk.HBox(False,0)

		img_iface = self.pictureIface( iface )
		hbox.pack_start(img_iface, False, True, 0)

		img_rx = gtk.Image()
		img_rx.set_from_file( "/usr/share/icons/hicolor/24x24/hildon/general_received.png" )
		img_tx = gtk.Image()
		img_tx.set_from_file( "/usr/share/icons/hicolor/24x24/hildon/general_sent.png" )
		
		l = gtk.Label(" ")
		hbox.pack_start( l, False, True, 0 )
		
		if self.showIP:
			label_rx = self.my_label_color_small()
			label_tx = self.my_label_color_small()
		
			self.bufLabelTraff[ iface+"_label_rx" ] = label_rx
			self.bufLabelTraff[ iface+"_label_tx" ] = label_tx

			hbox_ip_up = gtk.HBox(False, 0)
			hbox_ip_down = gtk.HBox(False, 0)
			v_ip = gtk.VBox(False, 0)

			ip_addr = self.getip_iface( iface )
			label_ip = self.my_label_small( ip_addr )
			hbox_ip_down.pack_start(label_ip, True, False, 0)
			
			self.bufLabelTraff[ iface+"_label_ip" ] = label_ip
			
			hbox_ip_up.pack_start( img_rx, False, True, 0 )
			hbox_ip_up.pack_start(label_rx, True, False, 0) #!
			hbox_ip_up.pack_start( img_tx, False, True, 0 )
			hbox_ip_up.pack_start(label_tx, True, False, 0) #!

			v_ip.pack_start(hbox_ip_up, True, False, 0)
			v_ip.pack_start(hbox_ip_down, True, False, 0)
		
			hbox.pack_start(v_ip, True, False, 0) #!
		else:
			label_rx = self.my_label()
			label_tx = self.my_label()
		
			self.bufLabelTraff[ iface+"_label_rx" ] = label_rx
			self.bufLabelTraff[ iface+"_label_tx" ] = label_tx

			hbox.pack_start( img_rx, False, True, 0 )
			hbox.pack_start(label_rx, True, False, 0) #!
			hbox.pack_start( img_tx, False, True, 0 )
			hbox.pack_start(label_tx, True, False, 0) #!

		self.bufLabelTraff[ iface+"_image_rx" ] = img_rx
		self.bufLabelTraff[ iface+"_image_tx" ] = img_tx
		
		self.bufLabelTraff[ iface+"_rx_curr" ] = 0
		self.bufLabelTraff[ iface+"_tx_curr" ] = 0
		self.bufLabelTraff[ iface+"_rx_prev" ] = 0
		self.bufLabelTraff[ iface+"_tx_prev" ] = 0

		try:
			status_record_iface = self.qnetman_dbus_client.recStatus( iface )
			if self.showButtonRec:
				buttonRecord = CustomButton(ICONSPATH + "widget_play.png")
				buttonRecord.connect("clicked", self.buttonRecord_clicked)

				self.bufLabelTraff[ iface + "_button_rec" ] = buttonRecord
				if status_record_iface:
					buttonRecord.set_icon(ICONSPATH + "widget_stop.png")
				else:
					buttonRecord.set_icon(ICONSPATH + "widget_play.png")

				hbox.pack_start(buttonRecord, False, True, 0) #!
		except:
			self.showButtonRec = False

		return hbox


	# --- cairo function --- #
	def do_expose_event(self, e):
		cr = self.window.cairo_create()

		#corner_radius = 18.0
		#aspect = (1.0*e.area.width)/(e.area.height*1.0) #

		##radius = corner_radius / aspect
		degrees = pi / 180.0
		radius = 10.0

		#cr.rectangle( e.area.x, e.area.y, e.area.width, e.area.height )
		#cr.clip()
		
		rect = self.get_allocation()
		x = rect.x
		y = rect.y
		width = rect.width
		height = rect.height
		#print "x=%s y=%s width=%s height=%s"%(x,y,width,height)

		cr.new_sub_path()
		cr.arc(x + width - radius, y + radius, radius, -90 * degrees, 0 * degrees)
		cr.arc(x + width - radius, y + height - radius, radius, 0 * degrees, 90 * degrees)
		cr.arc(x + radius, y + height - radius, radius, 90 * degrees, 180 * degrees)
		cr.arc(x + radius, y + radius, radius, 180 * degrees, 270 * degrees)
		cr.close_path()

		#rect = self.get_allocation()
		#cr.rectangle(rect.x, rect.y, rect.width, rect.height)

		style = self.rc_get_style()
		color = style.lookup_color("DefaultBackgroundColor")
		cr.set_source_rgba (color.red / 65535.0, color.green / 65335.0, color.blue / 65535.0, 0.6);
		cr.fill()
		hildondesktop.HomePluginItem.do_expose_event(self,e)

	def do_realize(self):
		scn = self.get_screen()
		cm = scn.get_rgba_colormap()
		self.set_colormap(scn.get_rgba_colormap())
		self.set_app_paintable(True)
		hildondesktop.HomePluginItem.do_realize(self)
	#--------------------#
	

	#возвращает gtk картинку по имени сетевого интерфейса
	def pictureIface( self, iface ):
		prefix_path = "/opt/qnetman/pysrc/pictures/"
		#prefix_path = "/home/user/develop/qnetman/pysrc/pictures/"
		png = prefix_path + "unknown.png"
		if iface == "gprs0":
			png = prefix_path + "gprs.png"
		elif iface == "wlan0":
			png = prefix_path + "wifi.png"
		elif iface == "eth0":
			png = prefix_path + "eth.png"
		elif iface == "usb0":
			png = prefix_path + "usb.png"
		elif iface == "pan0":
			png = prefix_path + "pan.png"

		image_iface = gtk.Image()
		image_iface.set_from_file( png )

		return image_iface
	#--------------------#


	#обновление информации на виджете
	def updateMyWidget(self):
		num_ifaces = 0
		for iface in self.listShowIface:
			if ( (self.bufLabelTraff.has_key( iface + "_label_rx" )) and (self.bufLabelTraff.has_key( iface + "_label_tx" )) ):
				label_rx = self.bufLabelTraff[ iface + "_label_rx" ]
				label_tx = self.bufLabelTraff[ iface + "_label_tx" ]
				rx_curr = self.bufLabelTraff[ iface + "_rx_curr" ]
				tx_curr = self.bufLabelTraff[ iface + "_tx_curr" ]
				rx_prev = self.bufLabelTraff[ iface + "_rx_prev" ]
				tx_prev = self.bufLabelTraff[ iface + "_tx_prev" ]

				num_ifaces += 1

				rx, tx, ok = self.getTraff(iface)

#----- РЕЖИМ СЧЕТЧИКА
				if self.mode == MODE_COUNT:
					if( (rx_prev == 0) and (tx_prev == 0) and (ok==True) ):
						rx_prev = rx
						tx_prev = tx
						rx_curr = rx
						tx_curr = tx

					self.bufLabelTraff[ iface + "_rx_curr" ] = rx
					self.bufLabelTraff[ iface + "_tx_curr" ] = tx
					rx_curr = rx
					tx_curr = tx
					drx = rx_curr - rx_prev
					dtx = tx_curr - tx_prev
					#print iface, rx_curr, rx_prev, drx
					#print iface, tx_curr, tx_prev, dtx

					if drx < 0:
						drx = rx
						dtx = tx
					rx_count = self.countByteRX( iface ) + drx
					tx_count = self.countByteTX( iface ) + dtx
					rx = self.humanBytes( rx_count )
					tx = self.humanBytes( tx_count )
					if ok:
						label_rx.set_text( " %s "%rx )
						label_tx.set_text( " %s "%tx )
						if self.showIP:
							ip_addr = self.getip_iface( iface )
							self.bufLabelTraff[ iface + "_label_ip" ].set_text( ip_addr )
						
						self.saveByteRX( iface, rx_count )
						self.saveByteTX( iface, tx_count )
					else:
						label_rx.set_text( " %s "%rx )
						label_tx.set_text( " %s "%tx )
					
						if self.showIP:
							ip_addr = self.getip_iface( iface )
							self.bufLabelTraff[ iface + "_label_ip" ].set_text( "offline" )

					self.bufLabelTraff[ iface + "_rx_prev" ] = rx_curr
					self.bufLabelTraff[ iface + "_tx_prev" ] = tx_curr

#----- РЕЖИМ АКТИВНОСТИ ИНТЕРФЕЙСОВ
				elif self.mode == MODE_MONITOR:
					if ok:
						rx = self.humanBytes( rx )
						tx = self.humanBytes( tx )
						#label_rx.set_text("  RX: %s "%rx)
						#label_tx.set_text("  TX: %s "%tx)
						label_rx.set_text(" %s "%rx)
						label_tx.set_text(" %s "%tx)
					
						if self.showIP:
							ip_addr = self.getip_iface( iface )
							self.bufLabelTraff[ iface + "_label_ip" ].set_text( ip_addr )
					else:
						label_rx.set_text(" 0.00 kB ")
						label_tx.set_text(" 0.00 kB ")
					
						if self.showIP:
							ip_addr = self.getip_iface( iface )
							self.bufLabelTraff[ iface + "_label_ip" ].set_text( "offline" )
#-----
		if self.refresh_interval_seconds != 0:
			self.id_timeout = gobject.timeout_add_seconds( self.refresh_interval_seconds, self.updateMyWidget )
		#self.num_show_ifaces = num_ifaces
		
		#h = 50*self.num_show_ifaces
		h = 50*num_ifaces
		w = 310
		if self.showButtonRec:
			w += 64
		if self.showIP:
			w -= 40
		self.set_size_request( w, h )

		#print
	

	#--------------------#
	def getTraff(self, iface):
		gt = gettraff.GetTraff(iface)
		return gt.getCurrBytes()

	def humanBytes(self, bytes):
		bytes = int( bytes )
		strRet = ""
		if (bytes/1024) > 1048576:
			strRet = "%.2f GB"%( bytes/1048576.0/1024.0 )
		elif bytes > 1048576:
			strRet = "%.2f MB"%( bytes/1048576.0 )
		elif bytes > 1024:
			strRet = "%.2f kB"%( bytes/1024.0 )
		else:
			strRet = "%.2f B"%( bytes )
		return strRet


	#------- запись значения в байтах в gconf -------#
	def saveByteRX( self, iface, value ):
		key = "/%s_rx"%iface
		b = int( "%s"%value, 10 )
		self.myconfig.set_value_count( key, b )
	
	def saveByteTX( self, iface, value ):
		key = "/%s_tx"%iface
		b = int( "%s"%value, 10 )
		self.myconfig.set_value_count( key, b )

	def countByteRX( self, iface ):
		key = "/%s_rx"%iface
		value = self.myconfig.get_value_count( key )
		return value
	
	def countByteTX( self, iface ):
		key = "/%s_tx"%iface
		value = self.myconfig.get_value_count( key )
		return value

	def setDateReset( self, iface ):
		key = "/%s_date"%iface
		d = time.strftime( "%Y-%m-%d %H:%M:%S", time.localtime( time.time() ) ) 
		self.myconfig.set_value_count( key, d )
		return d
	
	def getDateReset( self, iface ):
		key = "/%s_date"%iface
		value = self.myconfig.get_value_count( key )
		return value


	#------- settings --------#
	def showDialogSelectedIface(self):
		#self.listShowIfaceTemp = list( self.listShowIface ) #nafih
		dialog = gtk.Dialog()

		def ifaceButton_changed(ifaceButton):
			iface = ifaceButton.get_label()
			if ifaceButton.get_active():
				try:
					indx = self.listShowIfaceTemp.index( iface )
				except ValueError:
					self.listShowIfaceTemp.append( iface )
				#print "show: %s %s"%(iface, len(self.listShowIfaceTemp))
			else:
				if len(self.listShowIfaceTemp) == 1:
					hildon.hildon_banner_show_information(self, "None", "You can not disable all network interfaces !")
					ifaceButton.set_active(True)
					return
				try:
					indx = self.listShowIfaceTemp.remove( iface )
				except ValueError:
					pass

		def resetButton_clicked( button ):
			t = button.get_title()
			iface = split(t, self.title_button_reset)[1]
			d = self.setDateReset( "%s"%iface )
			resetButton.set_value( "rx: 0 B tx: 0 B  date: %s"%(d) )
			#resetButton.queue_draw()
			self.saveByteRX( iface, 0 )
			self.saveByteTX( iface, 0 )
			hildon.hildon_banner_show_information(self, "None", "Counter is reset on %s"%iface)
			dialog.hide()

		dialog.set_title("Network interfaces")
		#dialog.add_button("OK", gtk.RESPONSE_OK)
		
		pan_area = hildon.PannableArea()
		vbox1 = gtk.VBox()
		vbox2 = gtk.VBox()
		hbox = gtk.HBox()

		listButtonIfaces = []
		for iface in self.listIface:

			ifaceButton = hildon.CheckButton( gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT )
			ifaceButton.set_label( iface )
			#img = self.pictureIface( iface )
			#ifaceButton.set_image( img )
			flIfaceChecked = False
			try:
				indx = self.listShowIfaceTemp.index( iface )
				ifaceButton.set_active(True)
				flIfaceChecked = True
			except ValueError:
				ifaceButton.set_active(False)
			ifaceButton.connect( "toggled", ifaceButton_changed )
			vbox1.add( ifaceButton )
			
			resetButton = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
			resetButton.set_title("Reset the counter of bytes on %s"%iface)
			rx_count = self.countByteRX( iface )
			tx_count = self.countByteTX( iface )
			rx = self.humanBytes( rx_count )
			tx = self.humanBytes( tx_count )
			d = self.getDateReset( iface )
			if d == 0:
				d = "undefined"
			resetButton.set_value( "rx: %s  tx: %s  date: %s"%(rx, tx, d) )
			resetButton.set_alignment(0, 0.8, 0.5, 1)
			resetButton.connect( "clicked", resetButton_clicked )
			#resetButton.set_sensitive( flIfaceChecked )
			vbox2.add( resetButton )

		hbox.add( vbox1 )
		hbox.add( vbox2 )

		pan_area.add_with_viewport(hbox)
		pan_area.set_size_request(-1, 300)

		dialog.vbox.add(pan_area)
		dialog.show_all()

		response = dialog.run()
		dialog.destroy()

	def show_settings(self, widget):
		self.refreshInterval_indx = 0
		self.netIface_indx = ""
		self.showIP_local = self.showIP
		self.showButtonRec_local = self.showButtonRec
		self.mode_local = self.mode

		def selectorTimeout_changed( selector, data ):
			self.refreshInterval_indx = selector.get_active(0)
		
		def selectorIface_changed( selector, data ):
			self.netIface_indx = selector.get_current_text()

		def showDlgSelIface(widget):
			self.showDialogSelectedIface()

		def show_ip_changed(widget):
			self.showIP_local = buttonShowIP.get_active()
			
		def show_rec_changed(widget):
			if self.widgetConnectedWithQNetManDaemon == False:
				self.widgetConnectedWithQNetManDaemon = self.initConnectionDBus()
			self.showButtonRec_local = buttonShowRec.get_active()
		
		def selectorMode_changed( selector, data ):
			mode = selector.get_active(0)
			if mode == 0:
				self.mode_local = MODE_MONITOR
			else:
				self.mode_local = MODE_COUNT

		dialog = gtk.Dialog()
		dialog.set_title("Settings")
		dialog.add_button("OK", gtk.RESPONSE_OK)
		dialog.add_button("About", gtk.RESPONSE_HELP)
		self.dialog = dialog

		# ---- opt refresh interval ---- #
		selectorTimeout = hildon.TouchSelector(text=True)
		selectorTimeout.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
		for ri in self.listRefreshInterval:
			if ri == 0:
				selectorTimeout.append_text("On click")
			else:
				selectorTimeout.append_text("%s seconds"%ri)
		selectorTimeout.connect("changed", selectorTimeout_changed)
        
		refreshInterval = hildon.PickerButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		refreshInterval.set_alignment(0.0, 0.5, 1.0, 1.0)
		refreshInterval.set_title("Refresh interval")
		refreshInterval.set_selector(selectorTimeout)
		refresh_interval_string_indx = self.listRefreshInterval.index( self.refresh_interval_seconds )
		refreshInterval.set_active( refresh_interval_string_indx )

		# ---- opt network interface ---- #
		nifButton = hildon.Button(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		nifButton.set_title("Network interfaces")
		nifButton.set_value("Select the network interface for display on the widget")
		nifButton.set_alignment(0, 0.8, 1, 1)
		nifButton.connect("clicked", showDlgSelIface)

		# ---- opt show ip ---- #
		buttonShowIP = hildon.CheckButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
		buttonShowIP.set_label( "Show ip address" )
		buttonShowIP.set_active( self.showIP_local )
		buttonShowIP.connect("toggled", show_ip_changed)
		#------------------------------#

		# ---- opt show button rec ---- #
		buttonShowRec = hildon.CheckButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT)
		buttonShowRec.set_label( "Show the record button" )
		buttonShowRec.set_active( self.showButtonRec_local )
		buttonShowRec.connect( "toggled", show_rec_changed )
		#------------------------------#

		# ---- opt mode ---- #
		selectorMode = hildon.TouchSelector(text=True)
		selectorMode.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
		for m in self.listModeWidget:
			selectorMode.append_text( m )
		selectorMode.connect("changed", selectorMode_changed)
		wdg_mode = hildon.PickerButton(gtk.HILDON_SIZE_AUTO_WIDTH | gtk.HILDON_SIZE_FINGER_HEIGHT, hildon.BUTTON_ARRANGEMENT_VERTICAL)
		wdg_mode.set_alignment(0.0, 0.5, 1.0, 1.0)
		wdg_mode.set_title("Mode widget")
		wdg_mode.set_selector(selectorMode)
		if self.mode_local == MODE_MONITOR:
			wdg_mode.set_active( 0 )
		elif self.mode_local == MODE_COUNT:
			wdg_mode.set_active( 1 )
		#------------------------------#

		pan_area = hildon.PannableArea()
		vbox = gtk.VBox()
		vbox.add(refreshInterval)
		vbox.add(nifButton)
		vbox.add(buttonShowIP)
		vbox.add(buttonShowRec)
		vbox.add(wdg_mode)

		pan_area.add_with_viewport(vbox)
		pan_area.set_size_request(-1, 280)

		dialog.vbox.add(pan_area)
		dialog.show_all()

		while 1:
			response = dialog.run()
			
			if (response != gtk.RESPONSE_HELP) and (response != gtk.RESPONSE_OK):
				break

			if response == gtk.RESPONSE_HELP:
				self.show_about()
				break
		
			if response == gtk.RESPONSE_OK:
				#remove event source (timeout_add_seconds)
				if self.id_timeout != None:
					r = gobject.source_remove( self.id_timeout )
					if r:
						self.id_timeout = None
	
				try:
					#refresh interval settings
					self.refresh_interval_seconds = self.listRefreshInterval[ self.refreshInterval_indx ]
					self.myconfig.set_refresh_interval( self.refresh_interval_seconds )
	
					#the list network interfaces settings
					self.listShowIface = list( self.listShowIfaceTemp )
					self.myconfig.set_show_iface( self.listShowIface )

					#show ip
					self.showIP = self.showIP_local
					self.myconfig.set_show_ip( self.showIP_local )
	
					#show rec
					self.showButtonRec = self.showButtonRec_local
					self.myconfig.set_show_rec( self.showButtonRec_local )

					#mode widget
					self.mode = self.mode_local
					self.myconfig.set_mode_widget( self.mode )
	
					#reinit the widget
					self.initHomescreenWidget()
   	     		
					#resize the widget
					x,y = self.size_request()
					self.resize(x,y)
	
					break
				except Exception, e:
					#print e
					hildon.hildon_banner_show_information(self, "None", "Invalid")

		dialog.destroy()


	def show_about(self):
		global VERSION
		dialog = gtk.Dialog()
		dialog.set_title("About")
		
		#pan_area = hildon.PannableArea()
		hbox = gtk.VBox()

		lbl = gtk.Label()
		lbl.set_markup("<big>QNetMan homescreen widget</big>")
		hbox.pack_start(lbl, True, True, 0)
		
		lbl_space = gtk.Label()
		lbl_space.set_markup("<big></big>")
		hbox.pack_start(lbl_space, True, True, 0)

		lbl_version = gtk.Label()
		lbl_version.set_markup("<small>Version: %s</small>"%VERSION)
		hbox.pack_start(lbl_version, True, True, 0)
		
		lbl_author = gtk.Label()
		lbl_author.set_markup("<small>Author: Anatoliy Kozlov</small>")
		hbox.pack_start(lbl_author, True, True, 0)
		#vbox.show_all()
		
		#pan_area.add_with_viewport(vbox)
		#pan_area.set_size_request(-1, 200)

		dialog.vbox.add(hbox)
		dialog.show_all()
		
		response = dialog.run()
		dialog.destroy()
	

	#слот, вызываемый при клике на кнопку записи
	def buttonRecord_clicked(self, widget):

		for iface in self.listShowIface:
			if widget == self.bufLabelTraff[ iface + "_button_rec" ]:
				try:
					st = self.qnetman_dbus_client.recStatus( iface )
					if st:
						self.qnetman_dbus_client.recStop( iface )
						self.bufLabelTraff[ iface+"_button_rec" ].set_icon( ICONSPATH + "widget_play.png" )
						hildon.hildon_banner_show_information(self, "None", "QNetMan: Recording is stopped")
					else:
						self.qnetman_dbus_client.recStart( iface )
						self.bufLabelTraff[ iface+"_button_rec" ].set_icon( ICONSPATH + "widget_stop.png" )
						hildon.hildon_banner_show_information(self, "None", "QNetMan: Recording is started")
				except:
					self.widgetConnectedWithQNetManDaemon = False
					hildon.hildon_banner_show_information(self, "None", "QNetMan: Failed to change the record status!\n Demon QNetMan running ?")
				break




hd_plugin_type = QNetManHomePlugin

if __name__ == "__main__":
	import gobject
	gobject.type_register(hd_plugin_type)
	obj = gobject.new(hd_plugin_type, plugin_id="plugin_id")
	obj.show_all()
	gtk.main()
