#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui
import OptionsWindow
from sys import path
import myconfig
from mydb import MyDB
from DialogOptionsIfaceExt import DialogOptionsIfaceExt

class OptionsWindowExt( QtGui.QMainWindow ):
	def __init__(self, parent, mydb, mydbus ):
		QtGui.QMainWindow.__init__(self, parent)
		
		self.mydbus = mydbus

		try:
			self.setAttribute( QtCore.Qt.WA_Maemo5StackedWindow )
			self.setAttribute( QtCore.Qt.WA_Maemo5ShowProgressIndicator )
		except Exception, e:
			pass
			#print "OptionsWindowExt::__init__(): Exception setAttribute(): ", e
		
		self.db = mydb

		self.ui = OptionsWindow.Ui_MainWindow()
		self.ui.setupUi( self )


		self.listFreqTraffDaemon = list()
		self.listFreqTraffDaemon.append(10)
		self.listFreqTraffDaemon.append(15)
		self.listFreqTraffDaemon.append(20)
		self.listFreqTraffDaemon.append(30)
		self.listFreqTraffDaemon.append(40)
		self.listFreqTraffDaemon.append(60)

		self.listFormatDT = list()
		self.listFormatDT.append('yyyy-MM-dd HH:mm:ss')
		self.listFormatDT.append('MM-dd-yyyy HH:mm:ss')
		self.listFormatDT.append('dd-MM-yyyy HH:mm:ss')
		self.listFormatDT.append('dd.MM.yyyy HH:mm:ss')
		self.listFormatDT.append('MM.dd.yyyy HH:mm:ss')
		self.listFormatDT.append('yyyy.MM.dd HH:mm:ss')
		self.listFormatDT.append('dd/MM/yyyy HH:mm:ss')
		self.listFormatDT.append('MM/dd/yyyy HH:mm:ss')
		self.listFormatDT.append('yyyy/mm/dd HH:mm:ss')

		self.listLimitSizeDB = list()
		self.listLimitSizeDB.append(1209600)   #2 weeks
		self.listLimitSizeDB.append(2592000)   #1 month
		self.listLimitSizeDB.append(5184000)   #2 month
		self.listLimitSizeDB.append(7776000)   #3 month
		self.listLimitSizeDB.append(10368000)  #4 month
		self.listLimitSizeDB.append(12960000)  #5
		self.listLimitSizeDB.append(15552000)  #6
		self.listLimitSizeDB.append(23328000)  #9
		self.listLimitSizeDB.append(31104000)  #12
		self.listLimitSizeDB.append(0)         #not limit

		self.actionForm()

	def actionForm(self):
		self.ui.pb_ifaces.clicked.connect( self.dlgOptionsIfaces )

		#QComboBox cB_getData
		freq_traff_daemon = self.db.optGetFreqTraffDaemon()
		indx = self.listFreqTraffDaemon.index( int(freq_traff_daemon) )
		self.ui.cB_getData.setCurrentIndex( indx )
		#self.ui.cB_getData.currentIndexChanged.connect( self.changeFreqTraffDaemon )
		QtCore.QObject.connect(self.ui.cB_getData, QtCore.SIGNAL("currentIndexChanged(int)"), self.changeFreqTraffDaemon )

		#QComboBox cB_formatDT
		formatDT = self.db.optGetDateTimeFormat()
		indx = self.listFormatDT.index( formatDT )
		self.ui.cB_formatDT.setCurrentIndex( indx )
		#self.ui.cB_formatDT.currentIndexChanged.connect( self.changeFormatDT )
		QtCore.QObject.connect(self.ui.cB_formatDT, QtCore.SIGNAL("currentIndexChanged(int)"), self.changeFormatDT )

		#QComboBox cB_limitDB
		limitDB = self.db.optGetLimitSizeDB()
		indx = self.listLimitSizeDB.index( int(limitDB) )
		self.ui.cB_limitDB.setCurrentIndex( indx )
		#self.ui.cB_limitDB.currentIndexChanged.connect( self.changeLimitSizeDB )
		QtCore.QObject.connect(self.ui.cB_limitDB, QtCore.SIGNAL("currentIndexChanged(int)"), self.changeLimitSizeDB )
		
		#кнопки цветов графиков
		rgbRX, rgbTX = self.db.optGetColor()
		self.colorRX = QtGui.QColor( rgbRX )
		self.colorTX = QtGui.QColor( rgbTX )
		r,g,b,a = self.colorRX.getRgb()
		self.ui.pb_colorRX.setStyleSheet( "QPushButton { background-color: #%02x%02x%02x;}"%(r,g,b) )
		r,g,b,a = self.colorTX.getRgb()
		self.ui.pb_colorTX.setStyleSheet( "QPushButton { background-color: #%02x%02x%02x;}"%(r,g,b) )
		
		self.ui.pb_colorRX.clicked.connect( self.changeColorRX )
		self.ui.pb_colorTX.clicked.connect( self.changeColorTX )

		self.ui.cB_root.stateChanged.connect( self.rootAccessOnOff )
		self.rootAccessCheck()


	def changeFreqTraffDaemon(self, indx_changed):
		sec = self.listFreqTraffDaemon[indx_changed]
		self.db.optSetFreqTraffDaemon( sec )
		self.mydbus.configUpdate()


	def changeFormatDT(self, indx_changed):
		frmt = self.listFormatDT[ indx_changed ]
		self.db.optSetDateTimeFormat( frmt )


	def changeLimitSizeDB(self, indx_changed):
		sec = self.listLimitSizeDB[ indx_changed ]
		self.db.optSetLimitSizeDB( sec )
		self.mydbus.limitDatabase( sec )


	def changeColorRX(self):
		cR = QtGui.QColorDialog.getColor( self.colorRX )
		if cR.isValid():
			self.colorRX = cR
			r,g,b,a = cR.getRgb()
			self.ui.pb_colorRX.setStyleSheet( "QPushButton { background-color: #%02x%02x%02x;}"%(r,g,b) )
			rgbRX = self.colorRX.name()
			rgbTX = self.colorTX.name()
			self.db.optSetColor( rgbRX, rgbTX )


	def changeColorTX(self):
		cT = QtGui.QColorDialog.getColor( self.colorTX )
		if cT.isValid():
			self.colorTX = cT
			r,g,b,a = cT.getRgb()
			self.ui.pb_colorTX.setStyleSheet( "QPushButton { background-color: #%02x%02x%02x;}"%(r,g,b) )
			rgbRX = self.colorRX.name()
			rgbTX = self.colorTX.name()
			self.db.optSetColor( rgbRX, rgbTX )
	

	
	def rootAccessOnOff(self, toggle):
		file = myconfig.qnetman_home + ".rootenabled"
		qf = QtCore.QFile( file )
		if toggle:
			qf.open( QtCore.QIODevice.WriteOnly )
			qf.close()
		else:
			qf.remove()

	def rootAccessCheck(self):
		file = myconfig.qnetman_home + ".rootenabled"
		if QtCore.QFile.exists( file ):
			self.ui.cB_root.setCheckState( QtCore.Qt.Checked )
			return True
		else:
			self.ui.cB_root.setCheckState( QtCore.Qt.Unchecked )
			return False

	#------------------------#
	def dlgOptionsIfaces(self):
		self.dlgOptIf = QtGui.QDialog()
		self.ui_optIf = DialogOptionsIfaceExt( self.dlgOptIf, self.db, self.mydbus )
		self.dlgOptIf.show()
		self.dlgOptIf.exec_()

