# -*- coding: utf-8 -*-

from PyQt4 import QtCore, QtGui

from ListSessions import Ui_ListSessions
from ViewSessionExt import ViewSessionExt
from WindowFilterOptionsExt import WindowFilterOptionsExt
from MyItemDelegate import MyItemDelegate
import DialogDBStatistics
import StatistData

from mydb import MyDB
import myconfig

from MyNotify import MyNotify

class ListSessionsExt( QtGui.QMainWindow ):
	def __init__(self, parent, mydb, qset):
		QtGui.QMainWindow.__init__( self, parent )
		self.parent = parent
		
		try:
			self.setAttribute( QtCore.Qt.WA_Maemo5StackedWindow )
			self.setAttribute( QtCore.Qt.WA_Maemo5ShowProgressIndicator )
		except Exception, e:
			pass
			#print "ListSessionsExt::__init__(): Exception setAttribute(): ",e

		self.ui = Ui_ListSessions()
		self.ui.setupUi( self )
		
		#self.db = MyDB( myconfig.file_db )
		self.db = mydb
		
		self.noti = MyNotify()

		self.qset = qset
		
		#хранит текущий выбраный пункт списка - сессию
		self.currentSelectedItem = None
		
		#параметры фильтра
		self.startTime_filter = None
		self.endTime_filter = None
		self.sessionType_filter = 0
		self.status_filter = qset.filterGetStatus()
		self.showWinFilter = True
		
		self.actionForm()

	def actionForm(self):
		self.lblLoading = QtGui.QLabel( self )
		self.lblLoading.setGeometry(QtCore.QRect(630, 30, 140, 30))
		self.lblLoading.setObjectName("lblLoading")
		self.lblLoading.setText(QtGui.QApplication.translate("ListSessionsExt", "Loading...", None, QtGui.QApplication.UnicodeUTF8))
		
		self.ui.listWidgetSessions.itemClicked.connect( self.clickedItem )
		self.ui.listWidgetSessions.itemChanged.connect( self.itemChanged )
		self.ui.pBVSelectedAll.clicked.connect( self.selectedAllItems )
		self.ui.pBDeleteItem.clicked.connect( self.removeItems )
		self.ui.pBViewItem.clicked.connect( self.viewSession )
		self.ui.pBFilter.toggled.connect( self.winFilter )
		
		QtCore.QObject.connect(self.ui.action_dbstat, QtCore.SIGNAL("triggered()"), self.DlgDBStatistics)
		QtCore.QObject.connect(self.ui.action_calculateTraffic, QtCore.SIGNAL("triggered()"), self.calcTraff)

		self.ui.listWidgetSessions.setAlternatingRowColors( True )
		
		plugin = MyItemDelegate( self, 1 )
		self.ui.listWidgetSessions.setItemDelegate( plugin )
		

#	def keyReleaseEvent(self, ev):
#		if ev.key() == 65:
#			for(i=0; i<sel.ui.listWidgetSessions.count(); i+=1):
#				self.ui.listWidgetSessions.item(i)
#		print "key=%s"%ev.key()


	#состояние пункта изменяется (установилась/снялась галка) (слот)
	def itemChanged(self):
		j = 0
		flSelected = False
		while j < self.ui.listWidgetSessions.count():
			#if self.ui.listWidgetSessions.item(j).checkState() == QtCore.Qt.Checked:
			if self.ui.listWidgetSessions.item(j).data(QtCore.Qt.UserRole+3) == 1:
				flSelected = True
				break
			j += 1
		#кнопка удаления будет неактивна, если нет выбранных пунктов
		if flSelected:
			self.ui.pBDeleteItem.setEnabled( True )
		else:
			self.ui.pBDeleteItem.setEnabled( False )


	#клик по пункту (слот)
	def clickedItem(self, item):
		self.ui.pBViewItem.setEnabled( True )
		self.currentSelectedItem = item
		if item.data(QtCore.Qt.UserRole+3) == 1:
			item.setData( QtCore.Qt.UserRole+3, 0 )
		else:
			item.setData( QtCore.Qt.UserRole+3, 1 )


	#удаляет выбранные пункты списка
	def removeItems(self):
		j = 0
		if self.ui.listWidgetSessions.count():
			txt1 = QtGui.QApplication.translate("ListSessionsExt", "Deleting sessions", None, QtGui.QApplication.UnicodeUTF8)
			txt2 = QtGui.QApplication.translate("ListSessionsExt", "Delete selected sessions ?", None, QtGui.QApplication.UnicodeUTF8)
			res = QtGui.QMessageBox.question(self, txt1, txt2, QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
			if res != QtGui.QMessageBox.Yes:
				return
		while j < self.ui.listWidgetSessions.count():
			item = self.ui.listWidgetSessions.item(j)
			if item.data(QtCore.Qt.UserRole+3) == 1:
				#удаляем из БД
				start_t = self.listSessionItems[j]["start"]
				stop_t = self.listSessionItems[j]["stop"]
				ok = self.db.cleanDBbyTime( start_t, stop_t )
				if ok == True:
					# удаляем комментарии к выделенным сессиям (foreign_keys не работает, сука) XXX
					self.db.delCommentSession( self.listSessionItems[j]["session_id"] )
					#удаляем из списка
					self.ui.listWidgetSessions.takeItem( j )
					del item
					#удаляем из буфера
					del(self.listSessionItems[j])
				else:
					txt1 = QtGui.QApplication.translate("ListSessionsExt", "Error", None, QtGui.QApplication.UnicodeUTF8)
					txt2 = QtGui.QApplication.translate("ListSessionsExt", "Sorry, an error in the database.", None, QtGui.QApplication.UnicodeUTF8)
					QtGui.QMessageBox.critical(self, txt1, txt2)
					break
				continue
			j += 1
		
		#если список остался пуст - кнопка просмотра запрещена
		if len(self.ui.listWidgetSessions.selectedItems()) == 0:
			self.ui.pBViewItem.setEnabled( False )
		self.itemChanged()


	#расставляет "галки" на всех пунктах списка
	def selectedAllItems(self):
		j = 0
		while j < self.ui.listWidgetSessions.count():
			#if self.ui.listWidgetSessions.item(j).checkState() == QtCore.Qt.Checked:
			if self.ui.listWidgetSessions.item(j).data(QtCore.Qt.UserRole+3) == 1:
				#self.ui.listWidgetSessions.item(j).setCheckState( QtCore.Qt.Unchecked )
				self.ui.listWidgetSessions.item(j).setData( QtCore.Qt.UserRole+3, 0 )
			else:
				#self.ui.listWidgetSessions.item(j).setCheckState( QtCore.Qt.Checked )
				self.ui.listWidgetSessions.item(j).setData( QtCore.Qt.UserRole+3, 1 )
			j += 1


	#добавляет в список сессий пункт сессии
	def addItemSession(self, textItem, typeS, timeS, traffS):
		item_pic = StatistData.pixmapIface_str( typeS )
		item = QtGui.QListWidgetItem()

		txt = QtGui.QApplication.translate("ListSessionsExt", "Session full time:", None, QtGui.QApplication.UnicodeUTF8)
		descr = "%s %s"%(txt, timeS)
		if traffS != "":
			descr += "   " + traffS
		item.setData( QtCore.Qt.StatusTipRole,textItem )
		item.setData( QtCore.Qt.UserRole+1, descr )
		item.setData( QtCore.Qt.UserRole+2, item_pic )
		item.setData( QtCore.Qt.UserRole+3, 0 )

		self.ui.listWidgetSessions.addItem( item )
		return item

	def activateFilter(self):
		#если фильтр вкл, вдавим кнопку фильтра :)
		if self.status_filter != 0:
			self.showWinFilter = False
			self.ui.pBFilter.setChecked( True )
		else:
			self.ui.pBFilter.setChecked( False )
			self.initItemsSession( self.startTime_filter, self.endTime_filter, self.sessionType_filter )


	def initItemsSession(self, startTime = None, endTime = None, filterType = 0):
		
		self.lblLoading.show()
		
		#параметры включеного фильтра
		self.startTime_filter = startTime
		self.endTime_filter = endTime
		self.sessionType_filter = filterType

		#список сессий из БД
		if filterType == 0:
			self.listSessionItems = self.db.getFullListSession( startTime, endTime )
		else:
			typeSess_id = filterType
			self.listSessionItems = self.db.getListSession( filterType, startTime, endTime )
		#очищаем виджет списка
		self.ui.listWidgetSessions.clear()
		#создаем пункты списка - сессии
		j = 0
		len_buff = len( self.listSessionItems )
		last_item = None
		while j < len_buff:
			strFormatDateTime = self.db.optGetDateTimeFormat()

			start = QtCore.QDateTime.fromString( self.listSessionItems[j]["start"], "yyyy-MM-dd HH:mm:ss")
			start = start.toString( strFormatDateTime )

			stop = QtCore.QDateTime.fromString( self.listSessionItems[j]["stop"], "yyyy-MM-dd HH:mm:ss")
			stop = stop.toString( strFormatDateTime )

			str = "%s - %s"%(start, stop)
			
			if filterType == 0:
				typeSess_id = self.listSessionItems[j]["type_session"]
			typeSess = self.db.getIfaceByType( typeSess_id )

			(h,m,s) = StatistData.sessionTime( self.listSessionItems[j]["start"], self.listSessionItems[j]["stop"] )
			longTimeSess = "%02d:%02d:%02d"%(h,m,s)

			strTraff = ""
			bufTraff = self.db.getTraffByTime( self.listSessionItems[j]["start"], self.listSessionItems[j]["stop"], typeSess_id )
			l = len(bufTraff)
			if l > 1:
				(rx, tx) = StatistData.traffSession( bufTraff )
				rx = StatistData.strHumanBytes( rx )
				tx = StatistData.strHumanBytes( tx )
				strTraff = "rx/tx: %s/%s"%( rx, tx )

			last_item = self.addItemSession( str, typeSess, longTimeSess, strTraff )
			j += 1

		#спускаемся к последнему пункту
		if len_buff > 0:
			self.ui.listWidgetSessions.setCurrentItem( last_item )
		
		if len(self.ui.listWidgetSessions.selectedItems()) == 0:
			self.ui.pBViewItem.setEnabled( False )
			self.itemChanged()
		
		self.lblLoading.hide()


	def viewSession(self):
		#номер текущего пункта
		row = self.ui.listWidgetSessions.row( self.currentSelectedItem )

		#длительность сессии в секундах
		(h,m,s) = StatistData.sessionTime( self.listSessionItems[row]["start"], self.listSessionItems[row]["stop"] )
		allSeconds = 3600*h + 60*m + s
		
		#получаем из БД трафик сессии
		buf = self.db.getTraffByTime( self.listSessionItems[row]["start"], self.listSessionItems[row]["stop"],self.listSessionItems[row]["type_session"])

		#проверяем наличие необходимого кол-ва данных, для постороения графика
		len_buf = len( buf )
		if len_buf <= 1:
			txt1 = QtGui.QApplication.translate("ListSessionsExt", "Warning", None, QtGui.QApplication.UnicodeUTF8)
			txt2 = QtGui.QApplication.translate("ListSessionsExt", "Session does not contain data", None, QtGui.QApplication.UnicodeUTF8)
			QtGui.QMessageBox.warning(self, txt1, txt2)
			return
		elif len_buf == 1:
			el0 = buf[0]
			buf[0]["rx"] = "0"
			buf[0]["tx"] = "0"
			buf[0]["timestamp"] = self.listSessionItems[row]["start"]
			el0["timestamp"] = self.listSessionItems[row]["stop"]
			buf[0]["type_session"] = el0["type_session"]
			buf[1] = el0
			
		self.mwViewSession = ViewSessionExt( self, self.db, self.qset, self.currentSelectedItem.text(), buf, self.listSessionItems[row]["session_id"] )
		self.mwViewSession.show()
		self.mwViewSession.setTimeSession( allSeconds, h, m, s )
		self.mwViewSession.showData()

	def winFilter(self, state):
		if state:
			self.mwFilterOptions = WindowFilterOptionsExt( self, self.ui, self.qset )
			if self.showWinFilter:
				self.mwFilterOptions.show()
			else:
				#смотрим данные о фильтре в настройках
				startTime_f = self.qset.filterGetStartTime()
				stopTime_f = self.qset.filterGetStopTime()
				iface_f = self.qset.filterGetIfaceType()
				#TODO:при релизе убрать эти две строки
				status_f = self.qset.filterGetStatus()
				self.initItemsSession(startTime_f, stopTime_f, iface_f)
		else:
			self.initItemsSession()
			self.qset.filterSetStatus(0)
		self.showWinFilter = True

	#--- диалог со статистикой БД ---
	def DlgDBStatistics(self):
		self.dlgDBStat = QtGui.QDialog()
		self.ui_dlgDBStat = DialogDBStatistics.Ui_DialogDBStat()
		self.ui_dlgDBStat.setupUi( self.dlgDBStat )

		self.ui_dlgDBStat.pB_Done.clicked.connect( self.dlgDBStat.hide )

		f_db = QtCore.QFileInfo( myconfig.file_db )
		if f_db.exists():
			#размер файла БД
			siz_db = f_db.size()
			if siz_db > 1048576:
				strSize = "%.2f MB"%( siz_db/1048576.0 )
			elif siz_db > 1024:
				strSize = "%.2f kB"%( siz_db/1024.0 )
			else:
				strSize = "%s B"%( siz_db )
			self.ui_dlgDBStat.lblFileSizeVal.setText( strSize )

			#число записей трафика
			numTr = self.db.statNumRecTraff()
			txt = QtGui.QApplication.translate("ListSessionsExt", "records", None, QtGui.QApplication.UnicodeUTF8)
			self.ui_dlgDBStat.lblTraffStatVal.setText( "%s %s"%(numTr, txt) )

			#число записей сессий
			numTr = self.db.statNumRecSess()
			self.ui_dlgDBStat.lblSesStatVal.setText( "%s %s"%(numTr, txt) )

			#дата первой и последней записи
			first, last = self.db.statDateRec()
			self.ui_dlgDBStat.lblFirstEntryVal.setText( "%s"%first )
			self.ui_dlgDBStat.lblLastEntryVal.setText( "%s"%last )

		self.dlgDBStat.show()

	
	def calcTraff(self):
		j = 0
		rx_summ = 0
		tx_summ = 0
		flSelected = False
		countSelectedSession = 0
		while j < self.ui.listWidgetSessions.count():
			item = self.ui.listWidgetSessions.item(j)
			if item.data(QtCore.Qt.UserRole+3) == 1:
				flSelected = True
				start_t = self.listSessionItems[j]["start"]
				stop_t = self.listSessionItems[j]["stop"]
				typeSess_id = self.listSessionItems[j]["type_session"]
				bufTraff = self.db.getTraffByTime( start_t, stop_t, typeSess_id )
				l = len(bufTraff)
				if l > 1:
					(rx, tx) = StatistData.traffSession( bufTraff )
					rx_summ += rx
					tx_summ += tx
					countSelectedSession += 1
			j += 1
		
		if flSelected == False:
			txt = QtGui.QApplication.translate("ListSessionsExt", "Select a session to calculate the traffic", None, QtGui.QApplication.UnicodeUTF8)
			self.noti.notify( txt )
			return
		
		summ_b = rx_summ + tx_summ
		txt1 = QtGui.QApplication.translate("ListSessionsExt", "Sessions:", None, QtGui.QApplication.UnicodeUTF8)
		txt2 = QtGui.QApplication.translate("ListSessionsExt", "RX bytes:", None, QtGui.QApplication.UnicodeUTF8)
		txt3 = QtGui.QApplication.translate("ListSessionsExt", "TX bytes:", None, QtGui.QApplication.UnicodeUTF8)
		txt4 = QtGui.QApplication.translate("ListSessionsExt", "Full traffic:", None, QtGui.QApplication.UnicodeUTF8)
		text  = "\t\t\t%s \t\t %s\n"%( txt1, countSelectedSession )
		text += "\t\t\t%s \t\t %s\n"%( txt2, StatistData.strHumanBytes( rx_summ ) )
		text += "\t\t\t%s \t\t %s\n"%( txt3, StatistData.strHumanBytes( tx_summ ) )
		text += "\t\t\t%s \t\t %s"%( txt4, StatistData.strHumanBytes( summ_b ))
		self.noti.notify_m("%s"%text)
	



