#!/usr/bin/env python
# -*- coding: utf-8 -*-

import sys
#from traceback import print_exc
import dbus
import dbus.mainloop.glib

import time

class QNMDBusClient:
	def __init__(self):
		self.bus = dbus.SessionBus()
		self.iface = None

	def connectDBus(self):
		retVal = True
		try:
			#Get the remote object
			remote_object = self.bus.get_object( "com.qnetman.Daemon", "/QNetManDBus" )
			#Get the remote interface for the remote object
			self.iface = dbus.Interface( remote_object, "com.qnetman.Daemon" )
		except dbus.DBusException, e:
			print "QNetManDBus::connectDBus(): Except: %s"%e
			#print_exc()
			retVal = False
		return retVal
	
	def connectAllSignalDaemon(self):
		self.iface.connect_to_signal("recordStoped", self.handlerSigRecStoped)
		self.iface.connect_to_signal("recordStoped", self.handlerSigRecStoped)


	def handlerSigRecStoped(self):
		pass
	
		
	def handlerSigRecStarted(self):
		pass
	

	def recStart(self, network_iface):
		r = False
		try:
			r = self.iface.startRecord( network_iface )
		except Exception, e:
			print "QNMDBusClient::recStart(): Except: %s"%e
		return r


	def recStop(self, network_iface):
		r = False
		try:
			r = self.iface.stopRecord( network_iface )
		except Exception, e:
			print "QNMDBusClient::recStop(): Except: %s"%e
		return r


	def recStatus(self, network_iface):
		#try:
		ret = self.iface.statusRecord( network_iface )
		#except Exception, e:
		#	print "QNMDBusClient::recStatus(): Except: %s"%e
		return ret

	def configUpdate(self):
		try:
			self.iface.configUpdate()
		except Exception, e:
			print "QNMDBusClient::configUpdate(): Except: %s"%e

	def limitDatabase( self, secondLimit ):
		try:
			self.iface.limitDatabase( "%s"%secondLimit )
		except Exception, e:
			print "QNMDBusClient::secondLimit(): Except: %s"%e
