#!/usr/bin/env python
# -*- coding: utf-8 -*-

from PySide import QtCore, QtGui
import OptionsWindow
from sys import path
import myconfig
from mydb import MyDB

class OptionsWindowExt( QtGui.QMainWindow ):
	def __init__(self, parent, mydbus ):
		QtGui.QMainWindow.__init__(self, parent)
		
		self.mydbus = mydbus

		try:
			self.setAttribute( QtCore.Qt.WA_Maemo5StackedWindow )
		except Exception, e:
			pass
			#print "OptionsWindowExt::__init__(): Exception setAttribute(): ", e
		
		self.db = MyDB( myconfig.file_db )

		self.ui = OptionsWindow.Ui_MainWindow()
		self.ui.setupUi( self )

		self.bufSupportedIface = {}
		self.bufSupportedIface[1] = "gprs0"
		self.bufSupportedIface[2] = "wlan0"
		self.bufSupportedIface[3] = "usb0"
		self.bufSupportedIface[4] = "pan0"
		self.bufSupportedIface[5] = "eth0"
		self.fl_gprs = False
		self.fl_wlan = False
		self.fl_usb = False
		self.fl_pan = False
		self.fl_eth = False

		self.listFreqTraffDaemon = list()
		self.listFreqTraffDaemon.append(10)
		self.listFreqTraffDaemon.append(15)
		self.listFreqTraffDaemon.append(20)
		self.listFreqTraffDaemon.append(30)
		self.listFreqTraffDaemon.append(40)
		self.listFreqTraffDaemon.append(60)

		self.listFormatDT = list()
		self.listFormatDT.append('yyyy-MM-dd HH:mm:ss')
		self.listFormatDT.append('MM-dd-yyyy HH:mm:ss')
		self.listFormatDT.append('dd-MM-yyyy HH:mm:ss')
		self.listFormatDT.append('dd.MM.yyyy HH:mm:ss')
		self.listFormatDT.append('MM.dd.yyyy HH:mm:ss')
		self.listFormatDT.append('yyyy.MM.dd HH:mm:ss')
		self.listFormatDT.append('dd/MM/yyyy HH:mm:ss')
		self.listFormatDT.append('MM/dd/yyyy HH:mm:ss')
		self.listFormatDT.append('yyyy/mm/dd HH:mm:ss')

		self.listLimitSizeDB = list()
		self.listLimitSizeDB.append(1209600)   #2 weeks
		self.listLimitSizeDB.append(2592000)   #1 month
		self.listLimitSizeDB.append(5184000)   #2 month
		self.listLimitSizeDB.append(7776000)   #3 month
		self.listLimitSizeDB.append(10368000)  #4 month
		self.listLimitSizeDB.append(12960000)  #5
		self.listLimitSizeDB.append(15552000)  #6
		self.listLimitSizeDB.append(23328000)  #9
		self.listLimitSizeDB.append(31104000)  #12
		self.listLimitSizeDB.append(0)         #not limit

		self.actionForm()

	def actionForm(self):
		#QComboBox cB_getData
		freq_traff_daemon = self.db.optGetFreqTraffDaemon()
		indx = self.listFreqTraffDaemon.index( int(freq_traff_daemon) )
		self.ui.cB_getData.setCurrentIndex( indx )
		#self.ui.cB_getData.currentIndexChanged.connect( self.changeFreqTraffDaemon )
		QtCore.QObject.connect(self.ui.cB_getData, QtCore.SIGNAL("currentIndexChanged(int)"), self.changeFreqTraffDaemon )

		#QComboBox cB_formatDT
		formatDT = self.db.optGetDateTimeFormat()
		indx = self.listFormatDT.index( formatDT )
		self.ui.cB_formatDT.setCurrentIndex( indx )
		#self.ui.cB_formatDT.currentIndexChanged.connect( self.changeFormatDT )
		QtCore.QObject.connect(self.ui.cB_formatDT, QtCore.SIGNAL("currentIndexChanged(int)"), self.changeFormatDT )

		#QComboBox cB_limitDB
		limitDB = self.db.optGetLimitSizeDB()
		indx = self.listLimitSizeDB.index( int(limitDB) )
		self.ui.cB_limitDB.setCurrentIndex( indx )
		#self.ui.cB_limitDB.currentIndexChanged.connect( self.changeLimitSizeDB )
		QtCore.QObject.connect(self.ui.cB_limitDB, QtCore.SIGNAL("currentIndexChanged(int)"), self.changeLimitSizeDB )
		
		#кнопки цветов графиков
		rgbRX, rgbTX = self.db.optGetColor()
		self.colorRX = QtGui.QColor( rgbRX )
		self.colorTX = QtGui.QColor( rgbTX )
		r,g,b,a = self.colorRX.getRgb()
		self.ui.pb_colorRX.setStyleSheet( "QPushButton { background-color: #%02x%02x%02x;}"%(r,g,b) )
		r,g,b,a = self.colorTX.getRgb()
		self.ui.pb_colorTX.setStyleSheet( "QPushButton { background-color: #%02x%02x%02x;}"%(r,g,b) )
		
		self.ui.pb_colorRX.clicked.connect( self.changeColorRX )
		self.ui.pb_colorTX.clicked.connect( self.changeColorTX )

		self.ui.pb_gprs0.toggled.connect( self.suppGPRS )
		self.ui.pb_wlan0.toggled.connect( self.suppWLAN )
		self.ui.pb_eth0.toggled.connect( self.suppETH )
		self.ui.pb_usb0.toggled.connect( self.suppUSB )
		self.ui.pb_pan0.toggled.connect( self.suppPAN )

		flIfaceOn = False
		listSupIface = self.db.optGetSupportIface()
		for i in listSupIface:
			if i["iface"] == 'gprs0':
				self.ui.pb_gprs0.setChecked( True )
				flIfaceOn = True
			elif i['iface'] == 'wlan0':
				self.ui.pb_wlan0.setChecked( True )
				flIfaceOn = True
			elif i['iface'] == 'usb0':
				self.ui.pb_usb0.setChecked( True )
				flIfaceOn = True
			elif i['iface'] == 'pan0':
				self.ui.pb_pan0.setChecked( True )
				flIfaceOn = True
			elif i['iface'] == 'eth0':
				self.ui.pb_eth0.setChecked( True )
				flIfaceOn = True
		
		#все интерфейсы выключены. Неободим хотя бы один. По умолчанию gprs0
		#if flIfaceOn == False:
		#	self.ui.pb_gprs0.setChecked( True )


	def changeFreqTraffDaemon(self, indx_changed):
		sec = self.listFreqTraffDaemon[indx_changed]
		self.db.optSetFreqTraffDaemon( sec )
		self.mydbus.configUpdate()


	def changeFormatDT(self, indx_changed):
		frmt = self.listFormatDT[ indx_changed ]
		self.db.optSetDateTimeFormat( frmt )


	def changeLimitSizeDB(self, indx_changed):
		sec = self.listLimitSizeDB[ indx_changed ]
		self.db.optSetLimitSizeDB( sec )
		self.mydbus.configUpdate()


	def changeColorRX(self):
		cR = QtGui.QColorDialog.getColor( self.colorRX )
		if cR.isValid():
			self.colorRX = cR
			r,g,b,a = cR.getRgb()
			self.ui.pb_colorRX.setStyleSheet( "QPushButton { background-color: #%02x%02x%02x;}"%(r,g,b) )
			rgbRX = self.colorRX.name()
			rgbTX = self.colorTX.name()
			self.db.optSetColor( rgbRX, rgbTX )


	def changeColorTX(self):
		cT = QtGui.QColorDialog.getColor( self.colorTX )
		if cT.isValid():
			self.colorTX = cT
			r,g,b,a = cT.getRgb()
			self.ui.pb_colorTX.setStyleSheet( "QPushButton { background-color: #%02x%02x%02x;}"%(r,g,b) )
			rgbRX = self.colorRX.name()
			rgbTX = self.colorTX.name()
			self.db.optSetColor( rgbRX, rgbTX )
	

	def suppGPRS(self, toggle):
		self.fl_gprs = toggle
		if self.offIface():
			self.ui.pb_gprs0.setChecked( True )
			return
		self.suppIfaceEnable( False )
		if toggle:
			self.db.optAddSupportIface('gprs0', 1)
		else:
			self.db.optDelSupportIface('gprs0', 1)
		self.mydbus.configUpdate()
		self.suppIfaceEnable( True )
	

	def suppWLAN(self, toggle):
		self.fl_wlan = toggle
		if self.offIface():
			self.ui.pb_wlan0.setChecked( True )
			return
		self.suppIfaceEnable( False )
		if toggle:
			self.db.optAddSupportIface('wlan0', 2)
		else:
			self.db.optDelSupportIface('wlan0', 2)
		self.mydbus.configUpdate()
		self.suppIfaceEnable( True )


	def suppUSB(self, toggle):
		self.fl_usb = toggle
		if self.offIface():
			self.ui.pb_usb0.setChecked( True )
			return
		self.suppIfaceEnable( False )
		if toggle:
			self.db.optAddSupportIface('usb0', 3)
		else:
			self.db.optDelSupportIface('usb0', 3)
		self.mydbus.configUpdate()
		self.suppIfaceEnable( True )


	def suppPAN(self, toggle):
		self.fl_pan = toggle
		if self.offIface():
			self.ui.pb_pan0.setChecked( True )
			return
		self.suppIfaceEnable( False )
		if toggle:
			self.db.optAddSupportIface('pan0', 4)
		else:
			self.db.optDelSupportIface('pan0', 4)
		self.mydbus.configUpdate()
		self.suppIfaceEnable( True )


	def suppETH(self, toggle):
		self.fl_eth = toggle
		if self.offIface():
			self.ui.pb_eth0.setChecked( True )
			return
		self.suppIfaceEnable( False )
		if toggle:
			self.db.optAddSupportIface('eth0', 5)
		else:
			self.db.optDelSupportIface('eth0', 5)
		self.mydbus.configUpdate()
		self.suppIfaceEnable( True )


	# на момент отправки сигнала по dbus, кнопочки блокируются 
	def suppIfaceEnable(self, enable):
		self.ui.pb_gprs0.setEnabled( enable )
		self.ui.pb_wlan0.setEnabled( enable )
		self.ui.pb_eth0.setEnabled( enable )
		self.ui.pb_usb0.setEnabled( enable )
		self.ui.pb_pan0.setEnabled( enable )

	
	def offIface(self):
		b = self.fl_gprs or self.fl_wlan or self.fl_pan or self.fl_usb or self.fl_eth
		if not b:
			txt1 = QtGui.QApplication.translate("OptionsWindowExt", "Warning", None, QtGui.QApplication.UnicodeUTF8)
			txt2 = QtGui.QApplication.translate("OptionsWindowExt", "Should be left on at least one network interface", None, QtGui.QApplication.UnicodeUTF8)
			QtGui.QMessageBox.information( self, txt1, txt2 )
		b = not b
		return b
