#!/usr/bin/env python
# -*- coding: utf-8 -*-

import gobject
import dbus
import dbus.service
import dbus.mainloop.glib
import signal
import time
from string import split
import os

#import gettraff
#import myconfig
from pysrc import gettraff
from pysrc import myconfig
from pysrc import mydb

from dbus.mainloop.glib import DBusGMainLoop
DBusGMainLoop(set_as_default=True)
 

config_TIMEOUT = 20
config_LIMITDB = 0

#------------------------------------------------------------------------------------------------#
# демон хранит список открытых сессий
# Например:
# bufOpenSession['gprs0'] = '2011-04-24 23:02:51' - хранится вермя начала записи сессии
# bufOpenSession['gprs0_keyread'] = True          - ключ разрешения на запись (внутренний ключ управления записью)
# bufOpenSession['gprs0_record'] = True           - разрешение на запись данных с интерфейса, вне зависимости от его состояния (внешний ключ управления записью (от внешних программ))
# bufOpenSession['wlan0'] = '2011-04-24 13:14:22'
# bufOpenSession['wlan0_keyread'] = False
# bufOpenSession['wlan0_record'] = False
# bufOpenSession['wlan0_period'] = 
bufOpenSession = {}


# буфер с поддерживаемыми интерфейсами
supportedIface = dict()
def getSupportedIface():
	global supportedIface
	global bufOpenSession
	countIface = my_db.optGetNumSupportIface()
	if countIface == 0:
		my_db.optAddSupportIface('gprs0', 1) #Если нет поддерживаемых сетевых интерфейсов(первый запуск), включим один по-умолчанию
		countIface = 1
	type = 1
	i = 0
	supportedIface.clear()
	while i < countIface:
		iface = my_db.getIfaceByType( type )
		if iface != None:
			supportedIface[ type ] = iface
			i += 1
			if bufOpenSession.has_key( iface ) == False:
				bufOpenSession[ iface ] = None
				bufOpenSession[ iface + "_keyread" ] = ifaceExist( iface )
				bufOpenSession[ iface + "_record" ] = my_db.isAutoRecEnable( iface )
		type += 1


#------------------------------------------------------------------------------------------------#
# обработчик выхода
def sighandler(signalnum, frame):
	print "Receive signal: %s"%signalnum
	loop.quit()


#------------------------------------------------------------------------------------------------#

PIDFILE = myconfig.qnetman_home + "qnetman.pid"
def startDaemon():
	global PIDFILE
	mypid = os.getpid()
	stopDaemon()
	try:
		pidfd = open(PIDFILE, "w")
		pidfd.write( "%s"%mypid )
		pidfd.close()
	except:
		print "daemonQNetMan: startDaemon(): Failed"


def stopDaemon():
	try:
		pidfd = open(PIDFILE, "r")
		pid_exist = pidfd.read()
		pidfd.close()
		pid_exist = (int)(pid_exist)
		os.kill( pid_exist, signal.SIGTERM )
		os.remove( PIDFILE )
	except:
		print "daemonQNetMan: stopDaemon(): Failed"

#------------------------------------------------------------------------------------------------#
# функция проверки сетевого интерфейса
def ifaceExist( iface ):
	addr = 0
	try:
		addr_fd = open('/sys/class/net/' + iface + '/address', 'r')
		addr = addr_fd.read()
	except:
		pass
	try:
		addr_fd.close()
	except:
		pass
	return addr


#------------------------------------------------------------------------------------------------#
# DBus обект для взаимодействия с QNetworkManager
class QNetManDBusServer(dbus.service.Object):
	def __init__(self, name, session):
		dbus.service.Object.__init__(self, name, session)


	#экспортный метод:
	@dbus.service.method("com.qnetman.Daemon", in_signature='', out_signature='')
	def configUpdate(self):
		print "QNetManDBusServer::configUpdate(): call"
		global config_TIMEOUT, config_LIMITDB, supportedIface

		TIMEOUT = my_db.optGetFreqTraffDaemon()
		config_TIMEOUT = (int)(TIMEOUT)
		print "QNetManDBusServer::configUpdate(): config_TIMEOUT=%s"%config_TIMEOUT
		
		config_LIMITDB = my_db.optGetLimitSizeDB()
		print "QNetManDBusServer::configUpdate(): config_LIMITDB=%s"%config_LIMITDB

		getSupportedIface()
		print "QNetManDBusServer::configUpdate(): supportedIface: ",supportedIface

		createLimitDB( config_LIMITDB )

	#экспортный метод: старт записи на указанном сетевом интерфейсе
	@dbus.service.method("com.qnetman.Daemon", in_signature='s', out_signature='b')
	def startRecord(self, iface):
		global bufOpenSession
		print "QNetManDBusServer::startRecord(%s)"%iface

		if bufOpenSession[ iface ] != None:
			print "QNetManDBusServer::startRecord(): record is already running: %s"%iface
			return False

		ret = False
		bufOpenSession[ iface ] = None                 # время начала сессии пока не известно
		bufOpenSession[ iface + "_record" ] = True     # внешнее разрешение на запись
		#проверяем наличие сетевого интерфейса
		if ifaceExist( iface ) != 0:
			#интерфейс существует, даем внутреннее разрешение на запись
			bufOpenSession[ iface + "_keyread" ] = True    # внутреннее разрешение на запись
			#"заводим" таймер на запись
			gobject.timeout_add_seconds(config_TIMEOUT, readTrafOnIface, iface)
			ret = True
		else:
			#интерфейс не существует, внутреннее разрешение будет получено, когда будет принято 
			bufOpenSession[ iface + "_keyread" ] = False
		#излучаем сигнал на DBus о начале (или о готовности) к записи данных
		self.recStarted( iface )
		return ret

	
	#экспортный метод: остановка записи на указанном сетевом интерфейсе
	@dbus.service.method("com.qnetman.Daemon", in_signature='s', out_signature='b')
	def stopRecord(self, iface):
		global bufOpenSession
		print "QNetManDBusServer::stopRecord(%s)"%iface
		if bufOpenSession[ iface ] == None:
			bufOpenSession[ iface + "_record" ] = False     # внешнее разрешение на запись
			print "QNetManDBusServer::startRecord(): record not running: %s"%iface
			return False
		bufOpenSession[ iface + "_record" ] = False     # внешнее разрешение на запись
		readTrafOnIface( iface )
		self.recStoped( iface )
		return True
	

	#экспортный метод: проверка: включена ли запись на сетевом интерфейсе
	@dbus.service.method("com.qnetman.Daemon", in_signature='s', out_signature='b')
	def statusRecord(self, iface):
		retVal = False
		if bufOpenSession[ iface + "_record" ] != None:
			retVal = bufOpenSession[ iface + "_record" ]
		print "QNetManDBusServer::statusRecord(%s) ==> %s"%( iface, retVal)
		return retVal


	#@dbus.service.signal("com.qnetman.Daemon", signature='')
	@dbus.service.signal("com.qnetman.Daemon")
	def recStoped(self, iface):
		print "emit: QNetManDBusServer::recStoped(%s)"%iface


	@dbus.service.signal("com.qnetman.Daemon")
	def recStarted(self, iface):
		print "emit: QNetManDBusServer::recStarted(%s)"%iface


#------------------------------------------------------------------------------------------------#
# вычисление предела БД
def createLimitDB( timeSecondLimit ):
	if timeSecondLimit == 0:
		return
	currTimeSec = time.time()
	#limit = (int)(config_LIMITDB)
	limit = (int)(timeSecondLimit)
	lastTimeDB = currTimeSec - limit
	lastTimeDB_kor = time.localtime( lastTimeDB )
	lastTimeDB_str = time.strftime( "%Y-%m-%d %H:%M:%S", lastTimeDB_kor )
	firstTimeDB_str = "1970-01-01 00:00:00"
	my_db.cleanDBbyTime( firstTimeDB_str, lastTimeDB_str )

#------------------------------------------------------------------------------------------------#
# чтение данных с сетевого интерфейса 
def readTrafOnIface(iface):
	global bufOpenSession

	type = my_db.getTypeByIface( iface )

	#проверка старта сессии
	try:
		timeStartSession = bufOpenSession[ iface ]
	except KeyError:
		timeStartSession = None
	
	try:
		keyReadSession = bufOpenSession[ iface+"_keyread" ]
	except KeyError:
		keyReadSession = False
	
	try:
		keyRecordSession = bufOpenSession[ iface+"_record" ]
	except KeyError:
		keyRecordSession = False
	
	#сессия не стартовала (timeStartSession = None) но есть разрешение на старт keyReadSession = True => стартуем новую сессию
	if keyReadSession and keyRecordSession and (timeStartSession == None):
		bufOpenSession[ iface ] = my_db.startSession( type ) #!!!! type
		bufOpenSession[ iface+"_keyread" ] = True
		print "start session: %s : %s"%( iface, timeStartSession )
	elif ((keyReadSession == False) and ( timeStartSession != None )) or ((keyRecordSession == False) and ( timeStartSession != None )):
		my_db.stopSession( timeStartSession, type )
		bufOpenSession[ iface ] = None
		print "stop session: %s : %s"%( iface, timeStartSession )
		return
	elif ((keyReadSession == False) and ( timeStartSession == None )) or ((keyRecordSession == False) and ( timeStartSession == None )):
		print "runing failed"
		return

	timeSampleTraff = time.localtime( time.time() )
	str_timeSampleTraff = time.strftime( "%Y-%m-%d %H:%M:%S" )
	mytraff = gettraff.GetTraff( iface )
	rx, tx, ok = mytraff.getCurrBytes()
	print "%s: iface=%s  rx=%s  tx=%s"%( str_timeSampleTraff, iface, rx, tx )
	my_db.writeTraff(rx, tx, type, str_timeSampleTraff)
	
	#"заводим" таймер снова
	gobject.timeout_add_seconds(config_TIMEOUT, readTrafOnIface, iface)




#------------------------------------------------------------------------------------------------#
# функция обработки сигнала по DBus о добавлении сетевого интерфейса
def addNetIface(iface):
	_iface = split(iface,'/')
	iface = "%s"%_iface[ len(_iface)-1 ]
	global bufOpenSession
	print "addNetIface(): add network interface: %s"%iface
	bufOpenSession[ iface + "_keyread" ] = True
	readTrafOnIface( iface )

# функция обработки сигнала по DBus об удалении сетевого интерфейса
def remNetIface(iface):
	_iface = split(iface,'/')
	iface = "%s"%_iface[ len(_iface)-1 ]
	global bufOpenSession
	print "remNetIface(): remove network interface: %s"%iface
	bufOpenSession[ iface + "_keyread" ] = False
	readTrafOnIface( iface )



#------------------------------------------------------------------------------------------------#


if __name__ == "__main__":

	startDaemon()

	#--- обработчики системных сигналов (на выход) ---#
	signal.signal(signal.SIGTERM, sighandler)
	signal.signal(signal.SIGINT, sighandler)
	
	
	#--- соединение с БД ---#
	my_db = mydb.MyDB()


	#--- получение спсика поддерживаемы сетевых интерфейсов ---#
	getSupportedIface()

	#--- регистрация обработчиков сигнала по DBus о создании/удалении в системе сетевых интерфейсов ---#
	system_bus = dbus.SystemBus( )
	for t_iface in supportedIface.keys():
		iface = supportedIface[ t_iface ]
		# Регистрация обработчиков сигнала по шине от ядра на добавление сетевого интерфейса iface
		system_bus.add_signal_receiver(remNetIface, "remove", "org.kernel.kevent", None, "/org/kernel/class/net/"+iface, path_keyword='iface')
		system_bus.add_signal_receiver(addNetIface, "add", "org.kernel.kevent", None, "/org/kernel/class/net/"+iface, path_keyword='iface')

	

	#--- Чтение настроек об автозаписи на сетевых интерфейсах ---#
	for t_iface in supportedIface.keys():
		iface = supportedIface[ t_iface ]
		auto_rec = my_db.isAutoRecEnable( t_iface )
		bufOpenSession[ iface ] = None
		bufOpenSession[ iface+"_keyread" ] = False
		if auto_rec == True:
			bufOpenSession[ iface+"_record" ] = True   # автозапись разрешена
		else:
			bufOpenSession[ iface+"_record" ] = False  # автозапись не разрешена


	#--- Готовим объект на шину dbus для взаимодействия с программой QNetworkManager ---#
	session_bus = dbus.SessionBus()
	# Экспорт сервиса на шину DBus с адресом com.qnetman.Daemon
	name = dbus.service.BusName("com.qnetman.Daemon", session_bus)
	# Экспорт объекта с указанием пути к объекту
	q = QNetManDBusServer(session_bus, '/QNetManDBus')


	#--- считываем конфигурацию ---#
	q.configUpdate()

	
	loop = gobject.MainLoop()
	try:
		print "daemonQNetMan: Daemon start"
		loop.run()
	except KeyboardInterrupt:
		print "daemonQNetMan: Error gobject.MainLoop()"
	
	#--- по выходу из демона останавливаем все запущенные сессии записей ---#
	for t_iface in supportedIface.keys():
		iface = supportedIface[ t_iface ]
		print bufOpenSession
		if bufOpenSession[ iface ] != None:
			my_db.stopSession( bufOpenSession[ iface ], t_iface )
			print "daemonQNetMan: stopSession( %s, %s )"%( bufOpenSession[ iface ], t_iface )
			bufOpenSession[ iface ] = None
	

	stopDaemon()
	

