import QtQuick 1.0
import "components"
import "scripts/createobject.js" as ObjectCreator

Page {
    id: root

    property Item infoPage: null
    property Item commentsPage: null
    property Item relatedPage: null

    function setVideo(videoObject) {
        infoPage = tabGroup.addTab(Qt.resolvedUrl("YTDescriptionPage.qml"), 0);
        infoPage.video = videoObject;
    }

    function loadComments() {
        commentsPage = tabGroup.addTab(Qt.resolvedUrl("YTCommentsPage.qml"), 1);
        commentsPage.setCommentsFeed(infoPage.video.videoId);
    }

    function loadRelated() {
        relatedPage = tabGroup.addTab(Qt.resolvedUrl("YTRelatedVideosPage.qml"), 2);
        relatedPage.setVideoFeed("http://gdata.youtube.com/feeds/api/videos/" + infoPage.video.videoId + "/related?v=2&max-results=30&alt=json");
    }

    title: tabGroup.currentTab === null ? "" : tabGroup.currentTab.title
    tools: tabGroup.currentTab === null ? null : tabGroup.currentTab.tools

    Connections {
        target: YouTube
        onAddedToFavourites: if (pageStack.currentPage == root) infoPage.setFavourite(true);
        onDeletedFromFavourites: if (pageStack.currentPage == root) infoPage.setFavourite(false);
    }

    TabGroup {
        id: tabGroup

        anchors { fill: parent; topMargin: titleArea.height + tabBar.height }
    }

    TabBar {
        id: tabBar

        anchors { left: parent.left; right: parent.right; top: parent.top; topMargin: titleArea.height }

        buttons: [
            TabButton {
                text: qsTr("Info")
                checked: tabGroup.currentTab == infoPage
                onClicked: tabGroup.setTab(0)
            },

            TabButton {
                text: (infoPage === null) || (!infoPage.video.comments) ? qsTr("Comments") : qsTr("Comments") + " (" + infoPage.video.comments.toString() + ")"
                checked: tabGroup.currentTab == commentsPage
                onClicked: if (commentsPage === null) loadComments(); else tabGroup.setTab(1);
            },

            TabButton {
                text: qsTr("Related")
                checked: tabGroup.currentTab == relatedPage
                onClicked: if (relatedPage === null) loadRelated(); else tabGroup.setTab(2);
            }
        ]
    }
}

