#include <QtGui/QApplication>
#include <QDeclarativeContext>
#include <QtDeclarative>
#include <QTranslator>
#include "qmlapplicationviewer.h"
#include "settings.h"
#include "utils.h"

int main(int argc, char *argv[])
{
    QApplication app(argc, argv);
    QmlApplicationViewer viewer;

    Settings settings;
    Utils ut;
    ut.setView(&viewer);

    QObject::connect(&app, SIGNAL(aboutToQuit()), &settings, SLOT(saveSettings()));
    QObject::connect(&ut, SIGNAL(windowMinimized()), &settings, SLOT(saveSettings()));
    QObject::connect(&settings, SIGNAL(orientationChanged(QString)), &viewer, SLOT(setScreenOrientation(QString)));
    settings.restoreSettings();

    QDeclarativeContext *context = viewer.rootContext();
    context->setContextProperty("Settings", &settings);
    context->setContextProperty("Utils", &ut);

    QString locale = settings.getLanguage();
    QTranslator translator;
    if (translator.load(QString("/opt/qmltube/qml/qmltube/i18n/qml_" + locale))) {
        app.installTranslator(&translator);
    }

    viewer.setWindowTitle(QString("Settings"));
    viewer.setMainQmlFile(QLatin1String("qml/qmltube/widgetsettings.qml"));
    viewer.showFullScreen();

    return app.exec();
}
