import Qt 4.7

Item {
    id: dialog

    property string title : qsTr("Add Comment")
    property string videoId
    property string service

    signal close

    function setService(name, id) {
        dialog.service = name;
        if (name != "YouTube") {
            dialog.title = qsTr("Share Via ") + name;
        }
        dialog.videoId = id;
    }

    width: 600
    height: 300

    Rectangle {
        id: background

        color: "black"
        radius: 10
        opacity: 0.5
        anchors.fill: dialog
        border.width: 2
        border.color: activeColor
    }

    Text {
        id: titleText

        anchors { horizontalCenter: dialog.horizontalCenter; top: dialog.top; topMargin: 10 }
        text: title
        font.pixelSize: smallFontSize
        color: "white"
    }

    Rectangle {
        id: rect

        anchors { fill: dialog; leftMargin: 10; rightMargin: 180; topMargin: 50; bottomMargin: 10 }
        color:  "white"
        border.width: 2
        border.color: activeColorLow
        radius: 5

        TextEdit {
            id: commentEdit

            anchors { fill: rect; margins: 2 }
            focus: true
            font.pixelSize: standardFontSize
            selectByMouse: true
            wrapMode: Text.WordWrap
            selectionColor: activeColorLow
        }
    }

    PushButton {
        id: confirmButton

        anchors { right: dialog.right; bottom: dialog.bottom; margins: 10 }
        icon: "ui-images/tick.png"

        onButtonClicked: {
            if (dialog.service == "Facebook") {
                Sharing.postToFacebook(dialog.videoId, commentEdit.text);
            }
            else if (dialog.service == "Twitter") {
            }
            else {
                YouTube.addComment(dialog.videoId, commentEdit.text);
            }
            close();
        }
    }

    MouseArea {
        z: -1
        anchors.fill: dialog
    }

    states: State {
        name: "portrait"
        PropertyChanges { target: dialog; width: 460 }
        PropertyChanges { target: rect; anchors { rightMargin: 10; bottomMargin: 100 } }
        AnchorChanges { target: confirmButton; anchors.left: dialog.left }
        PropertyChanges { target: confirmButton; width: 440 }
    }
}
