#ifndef MAINWINDOW_H
#define MAINWINDOW_H

//#include <QDebug>
#include <QMainWindow>

namespace Ui {
    class MainWindow;
}

class QWebView;
class MainWindow : public QMainWindow
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.maemo.qflash")

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::MainWindow *ui;
    void createTempFile();
    void openFileFromCurDir(int offset);

    QWebView *web;
    QString html,tempUrl,tmpFile,swfFile,defDir,curDir;
    QStringList swfList;
    int swfIndex;

public slots:
#ifdef Q_WS_MAEMO_5 // maemo dbus
    Q_SCRIPTABLE int top_application() { show(); return 0; }
    Q_SCRIPTABLE int mime_open(QString uri)
    {
     if(swfFile==uri) return 0;
     swfFile=uri;
     openFileFromCurDir(0);
     show();
     return 0;
    }
    Q_SCRIPTABLE int open_new_window(QString uri)
    {
     swfFile=uri;
     openFileFromCurDir(0);
     return 0;
    }
#endif

private slots:
    void on_aOpen_triggered();
    void on_aPrev_triggered();
    void on_aNext_triggered();
    void on_aAbout_triggered();
    void on_aFullscreen_triggered();

};

#endif // MAINWINDOW_H
