#include <QDebug>
#include <QtGui/QApplication>
#include <QSettings>

#include "mainwindow.h"

#ifdef Q_WS_MAEMO_5
#include <QtDBus>
#endif


int main(int argc, char *argv[])
{

#ifdef Q_WS_MAEMO_5
 if(argc>1 && (QString)argv[1]=="--default")
 {
  QString mimeType="application/x-shockwave-flash";
  QString desktopFile="hildon-qflash.desktop";

  qDebug() << "qFlash> Default for MIME: "+mimeType;

//  QSettings mime("/usr/share/applications/mimeinfo.cache",QSettings::IniFormat);
//  mime.beginGroup("MIME Cache");
//  mime.setValue(mimeType,desktopFile);

  QSettings defApp("/usr/share/applications/defaults.list",QSettings::IniFormat);
  defApp.beginGroup("Default Applications");
  defApp.setValue(mimeType,desktopFile);
  return 0;
 }
#endif


 QApplication a(argc, argv);
 MainWindow w;

#ifdef Q_WS_MAEMO_5

 if (!QDBusConnection::sessionBus().isConnected()) {
     qWarning("Cannot connect to the D-Bus session bus.");
     exit(1);
 }
 if (!QDBusConnection::sessionBus().registerService("org.maemo.qflash")) {
     qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
         message()));
     exit(2);
 }
 if (!QDBusConnection::sessionBus().registerObject("/org/maemo/qflash", &w,
         QDBusConnection::ExportScriptableSlots)) {
     qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
         message()));
     exit(3);
 }
#endif

#if defined(Q_WS_S60)
 w.showMaximized();
#else
 w.show();
#endif

 return a.exec();
}
