/*
 * QCPUFreq - a simple cpufreq GUI
 * Copyright (C) 2010 Daniel Klaffenbach <danielklaffenbach@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "helpwindow.h"
#include "ui_helpwindow.h"

#include <QFile>
#include <QLocale>
#include <QTextStream>
#include <QMessageBox>


HelpWindow::HelpWindow(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::HelpWindow)
{
    ui->setupUi(this);

    setHelpText();
}


HelpWindow::~HelpWindow()
{
    delete ui;
}


/**
  * Assigns the help text to the QTextEdit
  */
void HelpWindow::setHelpText()
{
    //get the current locale name for lacalized help messages
    QString locale = QLocale::system().name();
    QStringList tmp = locale.split("_");
    locale = tmp.first();

    //open help text
    QFile help( ":/txt/help_" + locale );

    //open the file
    if ( !help.exists() || !help.open( QIODevice::ReadOnly ) ) {
        //try to open the file in english language instead
        help.setFileName(":/txt/help_en");
        if ( !help.exists() || !help.open( QIODevice::ReadOnly ) ) {
            QMessageBox::critical(this, tr("QCPUFreq"), tr("Cannot open help file!"));
            return;
        }
    }

    //read the file
    QTextStream in( &help );
    QString txt;
    do {
	txt += in.readLine();
	txt += "\n";
    } while ( !in.atEnd() );

    ui->textBrowser->setText( txt );
}
