#ifndef BCPROCESS_H
#define BCPROCESS_H

#include <QProcess>
#include <QHash>

enum BuiltInVariables
{
    scale,
    ibase,
    obase,
    last
};

typedef QHash<BuiltInVariables, QString> Variables;

class BcProcess : public QProcess
{
    Q_OBJECT
public:
    explicit BcProcess(QObject *parent = 0);

    Variables getBuiltInVariables(); // Returns always the obase=10 representations
    QString getVariable(QString variable);
    void setVariable(QString variable, QString value);

signals:
    void outputReady(QString);
    void errorReady(QString);

public slots:
    void start();
    void quit();

protected slots:
    void readOutput();
    void readError();

protected:
    void saveState(bool ibase = true, bool obase = true);
    void restoreState(bool ibase = true, bool obase = true);

protected:
    bool quiet; // If true the output will not be presented to the user
    QString outputBuffer;
};

#endif // BCPROCESS_H
