import QtQuick 1.0


Rectangle {
    id: mainPage
    width: 480
    height: 800

    property bool isFnState: false
    property int memIndex: 1

    property int _SMALL_FONT_SIZE: 32
    property int _STANDARD_FONT_SIZE: 36
    property int _LARGE_FONT_SIZE: 38
    property int _BUTTON_SIZE: 96
    property int _ROW_SIZE: 80

    property int _RECTANGLE_RADIUS: 12
    property int _BORDER_SIZE: 2

    property color _BACKGROUND_COLOR: "black"
    property color _BORDER_COLOR: "light grey"
    property color _ACTIVATED_COLOR: "grey"
    property color _INPUT_COLOR: "white"
    property color _FN_COLOR: "brown"
    property color _TEXT_COLOR: "white"

    color: _BACKGROUND_COLOR

    ButtonZoneLeft {
        id: leftZone
    }

    ButtonZoneRight {
        id: rightZone
    }

    CalcResult {
        id: calcResultZone
        anchors.bottom: inputZone.top
    }

    InputZone {
        id: inputZone
        anchors.bottom: leftZone.top
    }

    state: (height/width > 1.0) ? "portrait" : "landscape"

    states: [
        State {
            name: "landscape"
            PropertyChanges { target: calcResultZone; anchors.left: leftZone.right }
            PropertyChanges { target: calcResultZone; anchors.right: rightZone.left }
            PropertyChanges { target: inputZone; anchors.left: leftZone.right }
            PropertyChanges { target: inputZone; anchors.right: rightZone.left }
            PropertyChanges { target: inputZone; anchors.bottom: parent.bottom }
        },
        State {
            name: "portrait"
            PropertyChanges { target: calcResultZone; anchors.left: parent.left }
            PropertyChanges { target: calcResultZone; anchors.right: parent.right }
            PropertyChanges { target: inputZone; anchors.left: parent.left }
            PropertyChanges { target: inputZone; anchors.right: parent.right }
            PropertyChanges { target: inputZone; anchors.bottom: leftZone.top }
        }
    ]
}



