#ifndef OPERAND_ADDITION_H
#define OPERAND_ADDITION_H

#include "../operand.h"
#include "vector"

namespace QalcuLib
{
    class Addition : public Operand
    {
    public:
        Addition(const std::vector<OperandPtr> &operands, const std::vector<bool> &isAdditive);

        virtual double compute();

    private:
        Addition();

    protected:
        std::vector<OperandPtr> m_operands;
        std::vector<bool>       m_isAdditive;
    };
}

#endif // OPERAND_ADDITION_H
