# -*- coding: utf-8 -*-
try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui

from config import Config


class Ui_Loading(QtGui.QWidget):
    def __init__(self):
        QtGui.QWidget.__init__(self)
        self.setObjectName("Ui_Loading")

        self.layout = QtGui.QVBoxLayout(self)

        self.image = QtGui.QLabel()
        self.layout.addWidget(self.image, 0, QtCore.Qt.AlignCenter)

        self.text = QtGui.QLabel()
        self.layout.addWidget(self.text, 0, QtCore.Qt.AlignCenter)

        self.loading = QtGui.QLabel()
        movie = QtGui.QMovie("data/loading-big.gif")
        self.loading.setMovie(movie)
        self.layout.addWidget(self.loading, 0, QtCore.Qt.AlignCenter)
        movie.start()
        
    def setPixmap(self, pixmap):
        self.image.setPixmap(pixmap)

    def setText(self, text):
        self.text.setText(text)
        