# -*- coding: utf-8 -*-
try:
    from PySide import QtCore, QtGui
except ImportError:
    from PyQt4 import QtCore, QtGui

class Ui_Icon(QtGui.QLabel):
    def __init__(self, iconfile, text = None, parent = None):
        QtGui.QLabel.__init__(self, parent)
        self.text = text
        self.icon = None
        self.icon = QtGui.QImage(iconfile)
        self.size = self.icon.size()
        self.setMinimumSize(self.size)
        self.textColor = QtGui.QColor(80, 80, 80)

        self.textX = 0
        self.textY = 0
        self.textW = self.size.width()
        self.textH = self.size.height()
        self.textAlignment = QtCore.Qt.AlignCenter

    def setText(self, text):
        self.text = text

    def setTextOffset(self, x = None, y = None, w = None, h = None, alignment = None):
        if x != None:
            self.textX = x
        if y != None:
            self.textY = y
        if w != None:
            self.textW = w
        if h != None:
            self.textH = h
        if alignment != None:
            self.textAlignment = alignment
        if (self.textX + self.textW) > self.size.width():
            self.textW = self.size.width() - self.textX
        if (self.textY + self.textH) > self.size.height():
            self.textH = self.size.height() - self.textY
        
    def paintEvent(self, event):
        painter = QtGui.QPainter(self)
        painter.fillRect(self.rect(), QtCore.Qt.transparent)
        painter.drawImage(0, 0, self.icon)
        painter.setPen(self.textColor)
        if self.text != None:
            painter.drawText(self.textX, self.textY, self.textW, self.textH, self.textAlignment, self.text)
        painter.end()
